;################# DEBUGING OPTIONS
;#define SetBreakpointWithY  
;#define DisableEnemyMove
;#define KI_TestMap
;#define DisableEnemyAttack
;#define PushPopControl
;#define ShowContrastStatus ;uppervalue = Contrast to Get to, 2ndvalue = Actual Contrast
;#define ShowPlayerAndEnemyCoord ;Zeigt koordinaten von Player und ersten enemybuffer entry
;################# ENGINE OPTIONS
;#define DeckeUndBoden  ;bringt DrawSlice dazu, texturen immer zu schreiben/berschreiben
;#define DeckeUndBodenJustClear
#define TextureMapping  ;should be rewritten

#define EnableSprite
;#define IgnoreSprite ;Nur gltig, wenn EnableSprite ausgeschaltet

;#define SpriteClearPixel
#define WeaponOR ;sonst and xor.. oder so

#define EnableKI
#define ShootExact ; bentigt KI routinen
#define ShowHit

#define DeveloperMode ;Cheats:  Math-Button -->  Full Ammo, Full Health, All Weapons
;###################
; DESIGN OPTIONS

;#define DeathAnimationTurnOut
;#define DeathAnimationScrollDown
;#define DeathAnimationMoveOut
#define DeathAnimationMeltOutDown
#define Intro
;#deine FlickerWholeScreen ;On = wholescreen-invertet Off=Only 3D-part inverted

;###################
; CONTROL OPTIONS
#define STRAFING

;###################
; VARIOUS OPTIONS
;#define GermanVersion


#include "keyval.inc"
;------------------------------------------------
; TI-83+ Ion Header
;------------------------------------------------
#ifdef TI83P
#include "ion.inc"

.org    progstart-2
.db     $BB,$6D
        ret
        jr      nc,start

MUL_HL = $4276

#endif

;------------------------------------------------
; TI-83+ MirageOS Header
;------------------------------------------------
#ifdef MIRAGE

#include "ti83p.inc"
#include "mirage.inc"


.org    $9D93
.db     $BB,$6D
_indicatorOff   =$4570
_indicatorOn    =$456D
_cleargbuf  =4BD0h
grbuf       =plotsscreen
graph_mem   =plotsscreen

_IonDetect               = iDetect
_IonFastCopy             = iFastCopy
_IonGetPixel             = iGetPix
_IonPutSprite            = iSprite
_IonRandom               = iRandom
vat                     = progPtr
        ret
MUL_HL = $4276

 .db     1
 .db $30,$00,$1C,$00,$92,$00,$72,$0C,$4E,$36,$42,$D5,$F3,$5D,$1E,$F6
 .db $1F,$4D,$F3,$76,$42,$D5,$4E,$36,$72,$4C,$92,$E0,$1C,$E0 ; ,$31,$F0

#endif

;------------------------------------------------
; TI-83 ASHELL Header
;------------------------------------------------
#ifdef TI83
#include "ion.inc"

#define TI83ION

#ifdef TI83ION
.org progstart
        ret
        jr      nc,start
#else
.org 9327h
    nop
    jr      start
    .dw     $0000
    .dw     TitleTxt
    .dw     Icon          ;Points to an 8x8 icon
    .dw     $0000         ;For future use ( *Libraries*? :)
#endif
MUL_HL = $4382

#endif
#DEFINE LCDINSTPORT 10h


;################# VARS
#ifdef MIRAGE
AktiviereKeyPad = directin
DispVText = setvputs
;Saveram: MirageOS:
; TempSwapArea:   82A3  -  83E6  ; 95 bis 8300; 230 bis ende
; SavesScreen:    86EC  -  89EC  ; 20 bis 8600; 748 bis ende
; AppBackUpScreen 9872  -  9B72  ;142 bis 9900; 626 bis ende
ScreenHeightArray = $9900   ;brauch 65 bytes                                in AppBackupScreen
CloseDoorBuffer = ScreenHeightArray+66 ; zur sicherheit
SpriteArray = CloseDoorBuffer + 25  ;536 brig. reicht fr 89 sprites.... mehr als genug
EnemyBuffer = SavesScreen ;768 = 85 enemys.

Blickwinkel = AppBackUpScreen
ColWorld                =         Blickwinkel+1   ;fein  ____ Y                 ;2
ColTable                =         ColWorld+1   ;grob  /                         ;3
RowWorld                =         ColTable+1   ;fein  ____ X                    ;4
RowTable                =         RowWorld+1   ;grob  /                         ;5
BlickwinkelMove             =         RowTable+1                                ;6
ColWorldMove                =         BlickwinkelMove+1                         ;7
ColTableMove                =         ColWorldMove+1                            ;8
RowWorldMove                =         ColTableMove+1                            ;9
RowTableMove                =         RowWorldMove+1                            ;10

PlayerEnemyBWVar            = RowTableMove+1                                    ;11
PlayerHealth    = PlayerEnemyBWVar+1                                            ;12
PlayerAmmo = PlayerHealth+1                                                     ;13

;HUD_Backup                  =PlayerAmmo+1 ;needs: 10*12 bytes = 120             ;133
#else
;Saveram: ION
; saferam1:       9872  -  9FDA  ;142 bis 9900; 626 bis ende
; saferam2:       858f  -  87A2  ; 71 bis 8600; 460 bis Ende
; saferam3:       8508  -  8588  
Blickwinkel             =         saferam2+1                                    ;1
ColWorld                =         Blickwinkel+1   ;fein  ____ Y                 ;2
ColTable                =         ColWorld+1   ;grob  /                         ;3
RowWorld                =         ColTable+1   ;fein  ____ X                    ;4
RowTable                =         RowWorld+1   ;grob  /                         ;5
BlickwinkelMove             =         RowTable+1                                ;6
ColWorldMove                =         BlickwinkelMove+1                         ;7
ColTableMove                =         ColWorldMove+1                            ;8
RowWorldMove                =         ColTableMove+1                            ;9
RowTableMove                =         RowWorldMove+1                            ;10

PlayerEnemyBWVar            = RowTableMove+1                                    ;11
PlayerHealth    = PlayerEnemyBWVar+1                                            ;12
PlayerAmmo = PlayerHealth+1                                                     ;13

CloseDoorBuffer             =  PlayerAmmo+1         ; braucht 25              ;38

ScreenHeightArray           = $8600
SpriteArray = ScreenHeightArray + 66 ;395 65sprites.. sollte noch reichen
EnemyBuffer = saferam1 ;768 = 85 enemys.

;HUD_Backup                  =saferam3 ;needs: 10*12 bytes = 120             ;120

#endif

SpritesYplus    = 0  ; = anzahl pixel, die die sprites nach unten versetzt werden. 

;################# KONST
TurnSpeedMinimum = 2
TurnSpeedIncrease = 2
TurnSpeedMaximum = 13

; TURN_SPEED      = 1 ;8 Not used anymore
MAX_SPRITE_HEIGHT = 48
MAX_SPRITE_WIDTH = 32     ; Table Pointer anpassen.  line 429 in WolfSPRd.asm
SCREEN_HEIGHT   = 54
SLICE_RATIO     = 48 ;original 32   ; 24 wre auch gut. vorallem speed und sprites sind gut sichtbar
MOVE_LIMIT      = 100
MOVE_VIEW       = 64

SCREENPOS   = 2 ;1-12, jeweils 8 pixel nach innen

FadeOutDelay = 7
DoorOpenTime = 30
DoorOpenSpeed = 40
DoorOpenSpeed2  = 15  ; Achtung: x * DoorOpenSpeed + DoorOpenSpeed2 MUSS = 255 sein!

WeaponFlickerTime   =   11
HealthFlickerTime   =   5
AmmoFlickerTime     =   5
KeyFlickerTime      =   17
Light1Value         =   4  ;_____ Light Value: wenn value minus, wird bildschirm heller. plus wird dnkler.
Light2Value         =   -3 ;//
Light3Value         =   -5 ;/ 

WeaponAmmoAdd       =   6

;MenuTextStartPosY = 27+1 
;MenuTextStartPosX = 15
;InfoTextStartY  = 10
;InfoTextStartX  = 1

PlayerMaxHealth = 100
PlayerStartAmmo = 20
StandartEnemyItem   = 37

;################# KI KONST
Hund_MinDistToAttack =350 ;sicher grsser als 200

ChanceForAttack = 15 ;zu 250

KI_TurnValue = 60 ; winkel indem gegner zickzack luft
TurnArea = 4   ; = in welchem winkel abschnitt, der enemy dreht. z.B: KI_TurnValue = 64  und TurnArea = 4 --> zwischen 28 und 32 wird gedreht.

KI_ZickZackWinkel = 48  ; 64 und grsser wre sinnlos. 64 wre hin und her, grsser, gbe einen rckzieher und wrde die KI_Var ausm lot bringen

KI_StandstillStart = 128
KI_FlightStart   =129
KI_AttackStart = 171
KI_DieStart = 250
KI_DieEnd   = 255
StartKIvar = 128 ; standart 128 fr stillstehn

AttackErstesBildDauer   = 6
AttackZweitesBildDauer  = 4
DieErstesBildDauer   = 2


EnemyBlickfeld = 96 ; 64 = 90 Grad
AnimationFrames = 3
;################ Abnhngige Konstante
WeaponPicBreite = 2

#ifdef WeaponOR
WeaponPicBytes = 32
#else
WeaponPicBytes = 64
#endif

DoorTile = 18

MapYMax = 64
MapXMax = 64

SpriteGrenze = 23  ; wenn 2^x, durch bit X,a  operation bei getmap ersetzen
SpriteGrenzePasNonAct = SpriteGrenze + 0;                  Passierbare nicht-actor sprites (Lampen, etc.)
SpriteGrenzeItems   = SpriteGrenzePasNonAct + 8;                  aufnehmbare nicht-actor sprites (Medipak, Ammo, Keys...) 
SpriteGrenzeNotPas  = SpriteGrenzeItems + 10;                  unpassierbare nicht-actor sprites (Ofen, Tische, Fsser
SpriteGrenzeEnemys  = SpriteGrenzeNotPas + 11;                  unpassierbare actor sprites (enemys))

SpriteLight1 = SpriteGrenze+2
SpriteLight2 = SpriteLight1 + 2
SpriteLight3 = SpriteLight2 + 2

SpriteBytes = 2 * 24

EnemyBufferBytes = 9

;Player
MaxHealth = 100
MaxAmmo = 99

;Item
Medipack1Value = 5
Medipack2Value = 10
Medipack3Value = 25
Ammopack1Value = 7
Ammopack2Value = 4 ;20 - now "used clip"

#ifdef TI83ION
TitleTxt:
    .db "Wolfenstein83 1.0",0
#endif

#ifndef TI83
TitleTxt:
    .db "Wolfenstein83 1.0",0
#endif
start:

    bcall(_indicatorOff)
    set textwrite,(iy+sgrflags)

    ld  a,(contrast) ;(8447h)       ; contrast
    add a,$18
    ld (StartContrast),a
    ld (ActualContrast),a
    ld (ContrastToGetTo),a
    ld a,$3D
    ld (ContrastChangeOP),a    ; glaub nicht ntig

    xor a
    ld (NewGameFlag),a
    ld (LvlNo),a   ;multi-levels found if not set to zero!
#ifdef MIRAGE
#ifdef Intro
#include "Wolf_Int.asm"
#endif
#endif
    
#include "Wolf_Men.asm"

TheNextLevel:
    ld hl,SaveText
    ld de,SCREEN_HEIGHT/2-8*256+8
    call DispVText
    call _IonFastCopy
SaveWait:
    ld a,0bfh ;Graph, Trace, Zoom, Window,=Y , 2nd, Mode, Del
    call AktiviereKeyPad
    cp kMode
    jr z,SaveAskEnd
    cp k2nd
    jr nz,SaveWait

    ld de,SaveState
    ld hl,PlayerWeapons
    ldi
    ld hl,WeaponSelected
    ldi
    ld hl,PlayerHealth
    ldi  ;Health
    ldi  ;Ammo
    ld hl,NextLevelSearchString
SaveNextLevelSearchStringLoop:
    ld a,(hl)
    ldi
    or a
    jr nz,SaveNextLevelSearchStringLoop
SaveAskEnd:
GameLoaded:
    ld hl,NextLevelSearchString
NewGame:
    ld (SearchString),hl
NewGame2:
    
#ifdef MIRAGE
    ld hl,SavesScreen
    ld bc,767

    call ClearBufferRoutine
    ld hl,ScreenHeightArray ;AppBackUpScreen+20
    ld bc,620 ;767-20
    call ClearBufferRoutine
    ld hl,TempSwapArea
    ld bc,322
    call ClearBufferRoutine
#else
    ld hl,saferam1
    ld bc,767
    call ClearBufferRoutine
    ld hl,saferam2
    ld bc,530 -30
    call ClearBufferRoutine
    ld hl,saferam3
    ld c,127
    call ClearBufferRoutine
#endif    
    
#ifdef PushPopControl
    ld (PushPopControlSP),sp
    pop hl
    push hl
    ld (PushPopControlValue),hl
#endif
    
    ld a,0
NewGameFlag = $-1
    or a
    jr nz,NoNewGame
    
    ld a,PlayerMaxHealth; testzwecke
    ld (PlayerHealth),a
    ld a,PlayerStartAmmo
    ld (PlayerAmmo),a   ; hier optimieren, durch hl
    ld a,8
    ld (PlayerWeapons),a
;    ld a,4 ;4,8,12
    rrca
    ld (WeaponSelected),a
    ld a,1
    ld (NewGameFlag),a
    ld (FlickerScreenCounter),a
    
    call LoadLevel
    jr LevelPackLoaded

NoNewGame: ; a = 1 !!

    ld ix,(SearchString)
    ld hl,(progptr)
    call _IonDetect
     ld de,SCREEN_HEIGHT/2-3*256+16
    call nz,NoFilesFoundExit
    
LevelPackLoaded:
    ld e,127
    ld d,(hl)
    ld (ColWorld),de
    inc hl ;x
    ld d,(hl)
    ld (RowWorld),de
    inc hl ;winkel
    ld a,(hl)
    ld (Blickwinkel),a ;POV

    inc hl
    ld de,NextLevelSearchString
CopyNextLevelSearchStringLoop:
    ld a,(hl)
    ldi
    or a
    jr nz,CopyNextLevelSearchStringLoop

    ; hl = ptr to compressed Map
    ld a,(hl)
    inc hl
    or a
    jr z,MapOKNoBossToCopy
    ld (BossDamadgeVar),a
;    inc hl
    ld de,EnemyBossSprites
    ld bc,12*48
    ldir
MapOKNoBossToCopy:
    ld de,MapBuffer
Decompress:
    ld a, (hl)          ; get the next byte
    cp $FF
    jr z,DecompressDone
    bit 7,a             ; is it a run?
    jr nz, RLERun   ; then we need to decode the run
    ldi                 ; copy the byte, and update counters
    jr Decompress       ; otherwise do next byte
RLERun:
    and %01111111
    ld (de),a ;make this the copy byte
    inc hl              ; move to the run count
    ld b,(hl)           ; get the run count
DispRLERunL:
    inc de
    ld (de),a
    djnz DispRLERunL  ; if we're not done, then loop
    inc de
    inc hl              ; Next 
    jr Decompress
DecompressDone:
    ld hl,plotsscreen + (SCREEN_HEIGHT*12)
    push hl
    ld c,14
    ld (hl),$FF
    call ClearBufferRoutineSpecial
    
    ld hl,StatusLeistePic
    ld c,64-SCREEN_HEIGHT*12 - 15 - 15
    ldir
    pop hl
    ld c,15
    ldir
    ld a,4
    ld (PlayerKeys),a
    ld a,(WeaponSelected)
    call DispStatusWeapon
    ld a,(PlayerHealth)
    call DrawHealth
    ld a,(PlayerAmmo)
    call DrawAmmo

 ld hl,CloseDoorBuffer
 ld (CloseDoorBufferPtr),hl

    di
RenderScreenKillTurnSpeed:
    ld a,TurnSpeedMinimum
    ld (Turn_SpeedVar),a

RenderScreen:
DrawScreen:

#ifdef DeckeUndBoden
#ifdef DeckeUndBodenJustClear
    exx
    ld hl,plotsscreen
    ld (hl),$FF
    ld de,plotsscreen+1
    ld bc,SCREEN_HEIGHT*12-1
    ldir
    exx
#else
    push de
    push bc
    ld hl,plotsscreen+SCREENPOS
    ld de,4

    ld a,%11111111
    ld c,SCREEN_HEIGHT
DrawScreenBoden1:
    ld b,64/8
DrawScreenBoden:
    ld (hl),a
    inc hl
    djnz DrawScreenBoden
    add hl,de
    dec c
    jr nz,DrawScreenBoden1

    pop bc
    pop de
#endif
#else
    exx
    ld hl,plotsscreen
    ld de,plotsscreen+1
    ld bc,12*SCREEN_HEIGHT-1
    ld (hl),0
    ldir
    exx
#endif
 ld a,%10000000
 ld (ColMask),a

 xor a
 ld (Col),a
 ld a,SCREENPOS ;2
 ld (ScrnCol),a

#ifdef EnableSprite
 ld hl,ScreenHeightArrayVar
 ld (hl),0
 ld hl,SpriteArray
 ld (SpriteArrayPointer),hl
 ld a,(Blickwinkel)
 add a,32  ; Dass blickwinkel am rand anfngt, denn. Player BW ist gerade aus
NewCol:
    call RayCast
    push iy
    call DrawSlice
    pop iy
    ld hl,ScreenHeightArrayVar
    inc (hl)
#else
 ld a,(Blickwinkel)
 add a,32   ; Dass blickwinkel am rand anfngt, denn. Player BW ist gerade aus 
NewCol 
 call RayCast
 push iy
 call DrawSlice
 pop iy
#endif
    ld hl,ColMask
    ld a,(hl)
    rrca
    ld (hl),a
 jr nc,SkipIncScrnCol
 ld hl,ScrnCol
 inc (hl)
SkipIncScrnCol:
 ld a,0
Ray = $-1
 dec a
 ld hl,Col
 inc (hl)
 bit 6,(hl)
 jr z,NewCol
;### RayCasting Done

#ifdef EnableSprite
#include "WolfSPRd.asm"
#endif

    ld a,0
FlickerScreenCounter = $-1
    dec a
    jr z,MainLoop
    ld (FlickerScreenCounter),a
    and %00000001
    jr z,MainLoop
ginverse: 
#ifdef FlickerWholeScreen
   ld bc,768 
#else
    ld bc,SCREEN_HEIGHT*12
#endif
   ld hl,plotsscreen 
ginverseL: 
   ld a,(hl) 
   cpl 
   ld (hl),a 
   inc hl 
   dec bc 
    ld a,b
    or c
   jr nz,ginverseL 
MainLoop:


#ifdef ShowContrastStatus
    ld de,0
    ld (PENCOL),de
    ld a,(ContrastToGetTo)
    call vDispA
    ld de,8*256+0
    ld (PENCOL),de
    ld a,(ActualContrast)
    call vDispA
#endif

#ifdef  ShowPlayerAndEnemyCoord
    ld de,0
    ld (PENCOL),de
    ld a,(ColTable)
    call vDispA
    ld de,8*256+0
    ld (PENCOL),de
    ld a,(RowTable)
    call vDispA
    ld de,16*256+0
    ld (PENCOL),de
    ld a,(EnemyBuffer+3)
    call vDispA
    ld de,24*256+0
    ld (PENCOL),de
    ld a,(EnemyBuffer+5)
    call vDispA
#endif

   call DispWeapon ;Draw Weapon 

#ifdef ShowHit
    ld a,0
ShowHitFlag = $-1
    or a
    jp z,ShowNoHit
    xor a
    ld (ShowHitFlag),a
    ld de,5
    add hl,de
ShowNoHit:
    ld ix,ShowHitSprite
    ld a,8 * (SCREENPOS+4) -4
    ld l,SCREEN_HEIGHT /2 -2
    ld b,5
    call _IonPutSprite
#endif

    call _IonFastCopy
    di

#ifdef EnableSprite
AnimationTimer:
    ld hl,AnimTimer
    ld a,0
AnimTimer = $-1
    inc a
    ld (hl),a
    cp AnimationFrames
    jr c,AnimationTimerStillOK
    ld (hl),0
    
    ld hl,AnimationAddValue
    ld a,(hl)
    xor 4*48
    ld (hl),a
AnimationTimerStillOK:
#endif

#include "Wolf_KI.asm"

PlayerPositionTest:  ;For Items, and Special effects
    ld hl,RowTable ;x
    ld c,(hl)
    ld hl,(ColWorld) ;--> l = y fein, h = y grob
    ld l,0
    ld b,l
    srl h
    rr l
    srl h
    rr l
    add hl,bc
    ld bc,MapBuffer ;-64
    add hl,bc
    ld a,(hl)
    
    cp SpriteGrenzeEnemys
;    jr nc,NoSpecialPosition    ; Player ist auf enemy... kommt glaub nie vor. mglicherweise rausnehmen.
    jp nc,NoSpecialPosition   ;######### CREATES PUSH-POP ERROR!!!!  hab jetzt vor push hl gesetzt. sollte also behoben sein.
        
    push hl ;PlayerPosition
    cp SpriteGrenze
    jr c,SetNormalContrast

    ld bc,Light1Value * 256 + 60;$053C
    cp SpriteLight1
    jr c,ChangeContrast
    ld b,Light2Value
    inc c
    cp SpriteLight2
    jr c,ChangeContrast
    ld b,Light3Value
    sub SpriteLight3
    jr c,ChangeContrast
    sub 2
;Items
    ld b,%00000010
    jr z,AddKey ;Key1
    dec b
    dec a
    jr z,AddKey ;Key2
    dec a
    ld b,Medipack1Value
    jr z,AddHealth
    dec a
    ld b,Medipack2Value
    jr z,AddHealth 
    dec a
    ld b,Medipack3Value
    jr z,AddHealth
    dec a
    ld b,Ammopack1Value
    jr z,AddAmmo 
    dec a
    ld b,Ammopack2Value
    jr z,AddAmmo
    ld b,8
    dec a
    jr z,AddWeapon ;Weapon1 Add Pistol
    ld b,12
    dec a
    jr z,AddWeapon ;Weapon2 Add MG
    ld b,16
    dec a  
    jr nz,ChangeContrast1 ;Weapon3 Add Minigun  ;dass HL gepopt wird                                  
    
AddWeapon:
    ld a,b
    ld (PlayerWeapons),a
    ld b,WeaponAmmoAdd
    call AmmoAddOrSub
    ld a,WeaponFlickerTime
    jr KillItemAtPosition

AddHealth:
    call HealthAdd
    jr z,ChangeContrast1 ;NoSpecialPosition <<--- verursacht PUSH-POP fehler
    ld a,HealthFlickerTime
    jr KillItemAtPosition

AddAmmo:
    call AmmoAddOrSub
    jr z,ChangeContrast1 ;NoSpecialPosition <<--- verursacht PUSH-POP fehler
    ld a,AmmoFlickerTime
    jr KillItemAtPosition

SetNormalContrast:
    ld c,$3D
    ld a,(ActualContrast)
    ld b,a
    ld a,(StartContrast)
    cp b
    jr c,ContrastChangeWasDecrement   ; 3D = dec , 3C = inc
    dec c
ContrastChangeWasDecrement:
    ld b,0

ChangeContrast:
    ld a,0
StartContrast = $-1
    add a,b
    cp 61d
    jr c,ChangeContrastOK ; zu hoch
    ld a,61
    cp 24d
    jr nc,ChangeContrastOK
    ld a,24
ChangeContrastOK:
    ld (ContrastToGetTo),a
    ld a,c
    ld (ContrastChangeOP),a

ChangeContrast1:
    pop hl
    jr NoSpecialPosition

AddKey:
    ld hl,PlayerKeys
    ld a,(hl)
    or b
    and %00000011
    ld (hl),a

    ld ix,Key1
    ld a,76
    ld l,SCREEN_HEIGHT+2
    dec b
    jr nz,KeySpriteGefunden
    ld l,SCREEN_HEIGHT+4
    ld a,86
    ld ix,Key2
KeySpriteGefunden:
    ld b,4
    call _IonPutSprite
    ld a,KeyFlickerTime
    jr KillItemAtPosition

KillItemAtPosition:
    pop hl
    ld (hl),0
    ld hl,FlickerScreenCounter
    add a,(hl)
    ld (hl),a
NoSpecialPosition:

    ld a,0
ContrastEnableFlag = $-1
    or a
    jr z,ContrastOK

    ld a,0
ActualContrast = $-1
    cp 0
ContrastToGetTo = $-1
    jr z,ContrastOK
    nop
ContrastChangeOP = $-1
    ld (ActualContrast),a
    or $C0
    out (LCDINSTPORT),a
ContrastOK:

CloseDoors:
    ld de,5
    ld hl,CloseDoorBuffer - 5
CloseDoorLoop:
CloseDoorNext:
    add hl,de
    ld a,(hl) ;timer
    or a 
    jr z,EndCloseDoor
    inc hl ;timer/add
    cp 128 ; --> door schliessen
    jr nc,CloseDoorChangeTex
    cp DoorOpenSpeed
    jr z,CloseDoorChangeTex
    dec hl ;timer
    dec (hl) 
    jr nz,CloseDoorNext
    ld (hl),-DoorOpenSpeed
    inc hl ;tex
    inc hl ;pos1
    ld b,(hl)
    inc hl ;pos2
    ld c,(hl)
    inc hl
    ld a,(hl);door
 ; hier mss ein check rein, der auf player position prft nicht ntig, fllt nhmlich nicht grossartig auf
    ld (bc),a
    jr EndCloseDoor
CloseDoorChangeTex:
    add a,(hl)
    ld (hl),a
    cp DoorOpenSpeed2
    jr z,CloseDoorKillEntry
    inc a  ; $FF + 1  = 0 
    jr nz,EndCloseDoor
    dec hl ;timer
    ld (hl),DoorOpenTime
    inc hl ;tex
    inc hl ;pos1
    ld b,(hl)
    inc hl ;pos 2
    ld c,(hl)
    ld (bc),a ; a = 0 ;passierbar machen
    jr EndCloseDoor
CloseDoorKillEntry:
 ;hl = texadd
    ld d,h
    ld e,l
    dec de ;timer
    inc hl ;pos1
    inc hl ;pos2
    inc hl ;door
    inc hl  ;next door
    ld c,0
CloseDoorKillEntryLoopAgain:
    ld b,5
CloseDoorKillEntryLoop:    ; geht sicher auch mit einem ldir...
    ld a,(hl)
    ld (de),a
    inc de
    inc hl
    inc c
    djnz CloseDoorKillEntryLoop
    ld a,(hl)
    or a
    jr nz,CloseDoorKillEntryLoopAgain
    ld (de),a  ; dadurch wird letzte Tre Ungltig. --> 
    ld hl,0
CloseDoorBufferPtr = $ - 2
    sbc hl,bc ;b schon 0
    ld (CloseDoorBufferPtr),hl

EndCloseDoor:


KeyLoop:
   ld a,0bfh ;Graph, Trace, Zoom, Window,=Y , 2nd, Mode, Del
    call AktiviereKeyPad
#ifdef SetBreakpointWithY
    cp kY
    jr nz,SetBreakpointWithYNotPressed
    ld hl,SetBreakpointWithYVar
    ld a,(hl)
    xor %00000001
    ld (hl),a
SetBreakpointWithYNotPressed:
#endif
    cp kDel   
    jp z,PlayerDeathAnimation
    ld hl,Shoot
    nop
ShootFlag = $-1
    cp k2nd
    jp z,Shoot
ShootEnableOrDisableVar = $-2
ShootDisabled:
    ld a,0efh   ;Group 5 KZero, KOne,KFour,KSeven,KComma,KSin,KMatrx,KX
    call AktiviereKeyPad
    cp kX
    call z,ChangeWeapon
ShootEnd:
    ld a,0feh             ;Enable group 1.   <- ^ ` ->
    call AktiviereKeyPad 
    cp $FF
    jp z,RenderScreenKillTurnSpeed

    ld hl,Blickwinkel
    ld de,BlickwinkelMove ; Copy Player X,Y, direction because the routine is for player & enemys

    ld bc,5
    push bc
    push hl
    push de
    ldir

Move
    ld b,a
  ld c,0
Turn_SpeedVar = $-1

TestForward:
 bit 3,b
 call z,PlayerRayMove

    push bc
    ld a,0dfh ;Sto, Ln, Log, X2, X-1, Math,Alpha
    call AktiviereKeyPad
    pop bc

#ifdef DeveloperMode
    cp KMath
    jr nz,NoCheat

    ld b,MaxHealth+5
    call HealthAdd
    ld b,MaxAmmo+1
    call AmmoAddOrSub
    ld a,16
    ld (PlayerWeapons),a
    ld a,3
    ld (PlayerKeys),a
NoCheat:
#endif

    cp KAlpha
    jr nz,NoStrafing
    res 5,b
NoStrafing:

TestLeft:
 ld a,(BlickwinkelMove)
 bit 1,b
 jr nz,TestRight
#ifdef STRAFING
 bit 5,b
 jr nz,SkipStrafingLeft
StrafingLeft:
 add a,64
 ld (BlickwinkelMove),a
 call PlayerRayMove
 set 5,b
 ld a,(BlickwinkelMove)
 sub 64
 sub c
SkipStrafingLeft:
#endif
 add a,c

TestRight:
 bit 2,b
 jr nz,TestBackward
#ifdef STRAFING
 bit 5,b
 jr nz,SkipStrafingRight
StrafingRight:
 sub 64
 ld (BlickwinkelMove),a
 call PlayerRayMove
 set 5,b
 ld a,(BlickwinkelMove)
 add a,64
 add a,c
SkipStrafingRight:
#endif
 sub c

TestBackward:
 add a,128
 ld (BlickwinkelMove),a
 bit 0,b
 call z,PlayerRayMove
 ld a,(BlickwinkelMove)
 sub 128
 ld (BlickwinkelMove),a

TestOther:
 bit 5,b
 jr nz,SavePlayerAfterMove

;=== OPEN A DOOR ===================================

OpenDoor:
 ld a,(ColTableMove)
 ld d,a
 ld a,(RowTableMove)
 ld e,a
 ld a,(BlickwinkelMove)
 cp 32
 jr nc,Sup32
 inc d
 jr DoorEnd
Sup32:
 cp 96
 jr nc,Sup96
 inc e
 jr DoorEnd
Sup96:
 cp 160
 jr nc,Sup160
 dec d
 jr DoorEnd
Sup160:
 cp 224
 jr nc,Sup224
 dec e
 jr DoorEnd
Sup224:
 inc d
DoorEnd:
 call ActorGetMap
 sub DoorTile         
 jr z,OpenTheDoor    ;SavePlayerAfterMove                                 ;####### jp z,RenderScreen
 dec a
 jr z,LevelFinished
 dec a
 jr z,OpenTheDoor

  xor 0
PlayerKeys = $-1
  jr z,OpenTheDoor
  dec a
  jr z,OpenTheDoor
  dec a

 jr nz,SavePlayerAfterMove 

OpenTheDoor:
 ld a,(hl)
 ex de,hl
 ex af,af'
 call GetDoorSpecialForOpenDoor
 or a
 jr nz,SavePlayerAfterMove ;Skipopen. it's already opening
 exx
 ex af,af'
 ld hl,(CloseDoorBufferPtr)
 ld (hl),DoorOpenSpeed ;Timer/DoorTexShiftAdd
 inc hl
 ld (hl),DoorOpenSpeed2
 inc hl
 ld (hl),d
 inc hl
 ld (hl),e
 inc hl
 ld (hl),a ;door typ
 inc hl
 ld (CloseDoorBufferPtr),hl

SavePlayerAfterMove:
    ld a,c
    add a,TurnSpeedIncrease
    cp TurnSpeedMaximum
    jr nc,FullTurnSpeed
    ld (Turn_SpeedVar),a
FullTurnSpeed:
    pop hl ; war anfangs de = blickwinkelmove
    pop de ; war anfangs hl= blickwinkel
    pop bc
    ldir
 jp RenderScreen

LevelFinished:
    pop hl
    pop de
    pop bc
    
 
#ifdef PushPopControl
    ld de,0
PushPopControlSP = $-2
    ld hl,0
    add hl,sp
    or a
    sbc hl,de
    jr z,PushPopControlSPOK
PushPopControlHoldOn:
    ex de,hl
    ld sp,hl
    ret
PushPopControlSPOK:
    ld de,0
PushPopControlValue = $-2
    pop hl
    push hl
    sbc hl,de
    jr z,PushPopControlValueOK
PushPopControlHoldOn2:
    pop hl
    push de
    ret

PushPopControlValueOK:
#endif
    
    ld hl,NextLevelSearchString
    ld a,(hl)
    inc a
    jr z,MapPackFinished


    ld de,TheNextLevel
    push de  ;--> following ret will jump to TheNextLevel instead of quit
    ld hl,LevelCompleteTxt
    jr DispEndLevelMessage ;Neu laden

MapPackFinished:
    ld de,SCREEN_HEIGHT/2-3 + 8*256+8
    ld hl,LevelSetCompleteTxt
    call DispVText
DispEndLevelMessage
    ld de,SCREEN_HEIGHT/2-3*256+16
    call DispVText
    call _IonFastCopy
LevelEndWait:
    ld a,0bfh
    call AktiviereKeyPad
    cp k2nd
    jr nz,LevelEndWait   
    
    call PlayerDeathAnimation
       
    ret ; quit or return to "TheNextLevel"

;=== MOVE ==========================================

MoveEnemy:
    call SetA_inMapForPlayerSet
    ld a,(hl)
    ld (MoveEnemyPlayerPos),a
    ld (hl),1  ;PlayerPosition Blockieren

    call SetA_inMap
    ld a,(ix+8)
    ld (hl),a
    call RayMove
    call SetA_inMap
    ld a,(hl)
    ld (ix+8),a
    ld (hl),0
RayMoveSprite = $-1

    call SetA_inMapForPlayerSet
    ld (hl),0
MoveEnemyPlayerPos = $-1
    ret

SetA_inMapForPlayerSet:
    ld a,(ColTable)
    ld h,a
    ld a,(RowTable)
    jr SetA_inMapForPlayerSet1
SetA_inMap:
    ld a,(ColTableMove)
    ld h,a
    ld a,(RowTableMove)
SetA_inMapForPlayerSet1:
    ld l,0
    ld b,l
    ld c,a
    srl h
    rr l
    srl h
    rr l
    add hl,bc
    ld bc,MapBuffer ;-64
    add hl,bc
    ret

PlayerRayMove:
RayMove:
 push bc

MoveY:
 ld a,(BlickwinkelMove)
 call Sin64
 ld hl,(RowWorldMove)
 add hl,de
 push hl

; ld a,(BlickwinkelMove)  ; nicht ntig. Sin64 killts nicht.
 and %10000000
 jr nz,MoveDown

MoveUp:
 ld bc,MOVE_LIMIT
 add hl,bc
 ld e,h

 ld a,(ColTableMove)
 ld d,a
 call ActorGetMap
 jr nz,MoveBlockUpY

 ld hl,(ColWorldMove)
 ld bc,MOVE_VIEW
 add hl,bc
 ld d,h
 call ActorGetMap
 jr nz,MoveBlockUpY

 ld hl,(ColWorldMove)
 ld bc,-MOVE_VIEW
 add hl,bc
 ld d,h
 call ActorGetMap
 jr z,DoMoveY

MoveBlockUpY:
 pop hl
 ld a,(RowTableMove)
 ld h,a
 ld l,-MOVE_LIMIT
 push hl
 jr DoMoveY

MoveDown:
 ld bc,-MOVE_LIMIT
 add hl,bc
 ld e,h

 ld a,(ColTableMove)
 ld d,a
 call ActorGetMap
 jr nz,MoveBlockDownY

 ld hl,(ColWorldMove)
 ld bc,MOVE_VIEW
 add hl,bc
 ld d,h
 call ActorGetMap
 jr nz,MoveBlockDownY

 ld hl,(ColWorldMove)
 ld bc,-MOVE_VIEW
 add hl,bc
 ld d,h
 call ActorGetMap
 jr z,DoMoveY

MoveBlockDownY:
 pop hl
 ld a,(RowTableMove)
 ld h,a
 ld l,MOVE_LIMIT
 push hl

DoMoveY:
 pop hl
 ld (RowWorldMove),hl

MoveX:
 ld a,(BlickwinkelMove)
 call Cos64
 ld hl,(ColWorldMove)
 add hl,de
 push hl

 ld a,(BlickwinkelMove)
 and %11000000
 cp %10000000
 jr z,MoveLeft
 cp %01000000
 jr z,MoveLeft

MoveRight:
 ld bc,MOVE_LIMIT
 add hl,bc
 ld d,h

 ld a,(RowTableMove)
 ld e,a
 call ActorGetMap
 jr nz,MoveBlockRightX

 ld hl,(RowWorldMove)
 ld bc,MOVE_VIEW
 add hl,bc
 ld e,h
 call ActorGetMap
 jr nz,MoveBlockRightX

 ld hl,(RowWorldMove)
 ld bc,-MOVE_VIEW
 add hl,bc
 ld e,h
 call ActorGetMap
 jr z,DoMoveX

MoveBlockRightX:
 pop hl
 ld a,(ColTableMove)
 ld h,a
 ld l,-MOVE_LIMIT
 push hl
 jr DoMoveX

MoveLeft:
 ld bc,-MOVE_LIMIT
 add hl,bc
 ld d,h

 ld a,(RowTableMove)
 ld e,a
 call ActorGetMap
 jr nz,MoveBlockLeftX

 ld hl,(RowWorldMove)
 ld bc,MOVE_VIEW
 add hl,bc
 ld e,h
 call ActorGetMap
 jr nz,MoveBlockLeftX

 ld hl,(RowWorldMove)
 ld bc,-MOVE_VIEW
 add hl,bc
 ld e,h
 call ActorGetMap
 jr z,DoMoveX

MoveBlockLeftX:
 pop hl
 ld a,(ColTableMove)
 ld h,a
 ld l,MOVE_LIMIT
 push hl

DoMoveX:
 pop hl
 ld (ColWorldMove),hl

 pop bc
 ret


Shoot:
    ld hl,WeaponSelected
    ld a,(hl)
    and %00000011
    jr nz,Shoot_OnlyAnimation

#ifdef ShootExact
Shoot_TryToHitEnemy:
    push hl
    ld ix,EnemyBuffer-EnemyBufferBytes
ShootCheckForEnemyHitLoop:
    ld de,EnemyBufferBytes
    add ix,de
    ld a,(ix)
    or a
    jr z,ShootNoHit
    call EnemyDist
    ex de,hl ; de = distanz
    call MultDEx255 ;
    call div_ratio
    sra a ;/2
;    inc a ; dass ja nicht = 0 wird. 
    add a,3 ;easyer to hit
    ld (ShootAbweichungsRate),a

    call PlayerEnemyBlickWinkel
    cp 0
ShootAbweichungsRate = $-1
    jr nc,ShootCheckForEnemyHitLoop

#else

    ld hl,SpriteArray
    push hl
    ld (SpriteArrayPointer),hl
    ld a,(Blickwinkel)
    call Raycast
    pop ix
    ld de,5
ShootChkLoop
    ld a,(ix)
    or a
    jr z,ShootNoHit
    add ix,de
    cp SpriteGrenzeEnemys
    jr c,ShootChkLoop
#endif
 ld hl,WeaponDamageTable-2
 ld a,(WeaponSelected)
 or a
 rra ;/2
 add a,l
 ld l,a ; hat den Nachteil, dass damagetable nicht an ner Grenze liegen darf!
 ld b,(hl)
 call _IonRandom ;saves hl und de
 inc hl
 add a,(hl)
 ld b,a
 
 ld a,(ix+7)
 sub b
 jr nc,ShootEnemyNotDead 
 ld (ix+6),KI_DieStart ;KI-var
ShootEnemyNotDead:
 ld (ix+7),a
#ifdef ShowHit
 ld (ShowHitFlag),a
#endif
ShootNoHit:
    ld b,-1
    call AmmoAddOrSub
   
    pop hl
Shoot_OnlyAnimation:
    ld b,$E9 ;jp (hl)
    ld a,(hl)
    inc a 
    cp 4
    jr z,ShootAnimSet1
    cp 8
    jr z,ShootAnimSet1
    cp 12
    jr z,ShootAnimSet1
    cp 16
    jr nz,ShootAnimSet
ShootAnimSet1:
    sub 4
    ld b,0 ;NOP
ShootAnimSet
    ld (WeaponSelected),a
    ld a,b
    ld (ShootFlag),a
    jp ShootEnd



ChangeWeapon:
    ld hl,WeaponSelected

    ld a,(hl)
    and %00000011
    ret nz
    ld a,(hl)
    add a,4

    cp 0
PlayerWeapons = $-1
    jr nz,ChangeWeaponOK ;weapon change not ok  ; max weapon mglich
    ld a,4
ChangeWeaponOK:


    ld (hl),a 
DispStatusWeapon:
    ld c,a  
    add a,a ;*2
    add a,c ;*3
    ld l,a
    ld h,0
    ld b,h
    ld c,11
    ld de,StatusLeisteWeaponsPic - 12
    add hl,de
    ex de,hl
    ld hl,SCREEN_HEIGHT+1+1*12 +plotsscreen
    ld a,6
DispStatusWeaponLoop:
    ex af,af'
    ld a,(de)
    ld (hl),a
    inc hl
    inc de
    ld a,(de)
    ld (hl),a
    inc de
    add hl,bc
    ex af,af'
    dec a
    jr nz,DispStatusWeaponLoop
    ret


#ifdef WeaponOR
DispWeapon:

    ld b,0
WeaponSelected = $-1
    ld de,WeaponPicBytes
    ld hl,WeaponPics -(4*WeaponPicBytes)
DWeaponSelectLoop:
    add hl,de
    djnz DWeaponSelectLoop

    ex de,hl
    
    ld hl,plotsscreen+(SCREEN_HEIGHT*12)-((WeaponPicBytes/2)*12)+(12/2-(WeaponPicBreite/2))
    ld bc,11
    ld a,16
DrawWeaponLoop:
    ex af,af'
    ex de,hl
    ld a,(de)
    or (hl)
    ld (de),a
    inc hl
    inc de
    ld a,(de)
    or (hl)
    ld (de),a
    inc hl
    ex de,hl
    add hl,bc
    ex af,af'
    dec a
    jp nz,DrawWeaponLoop
    ret


#else
DispWeapon:
    ld b,0
WeaponSelected = $-1
    ld de,WeaponPicBytes
    ld hl,WeaponPics-(4*WeaponPicBytes)
DWeaponSelectLoop:
    add hl,de
    djnz DWeaponSelectLoop
    ld b,16 ;e ;WeaponPicBytes
    push hl
    pop ix ;WeaponSprite
    ld hl,plotsscreen+(SCREEN_HEIGHT*12)-((WeaponPicBytes/2/2)*12)+(12/2-(WeaponPicBreite/2))
    ld de,11
DrawWeaponLoop:
    ld a,(hl)
    and (ix+32)
    or (ix)
    ld (hl),a
    inc hl
    inc ix
    ld a,(hl)
    and (ix+32)
    or (ix)
    ld (hl),a
    inc ix
    add hl,de

    djnz DrawWeaponLoop
    ret
#endif



HealthSub:
    ld hl,PlayerHealth
    ld a,(hl)
    sub b
    jp c,GameOverByHit
    jr HealthAOS_OK


HealthAdd:
    ld hl,PlayerHealth
    ld a,(hl)
    cp MaxHealth
    ret z
HealtNoMaxCheck:
    add a,b

    cp MaxHealth+1
    jr c,HealthAOS_OK
    ld a,MaxHealth
HealthAOS_OK:
    ld (hl),a
DrawHealth:
    ld hl,SCREEN_HEIGHT*12+plotsscreen+12+12+4
    ld de,11
    ld b,5
_DrawHealthEraseFirst:
    ld (hl),0
    inc hl
    ld (hl),%00000001
    add hl,de
    djnz _DrawHealthEraseFirst

    ld de,SCREEN_HEIGHT+1*256+35
    jr DrawAmmo1

AmmoAddOrSub:
    ld hl,PlayerAmmo
    ld a,(hl)
    add a,b
    cp MaxAmmo+1
    jr c,AmmoAOS_OK
    ld a,MaxAmmo
AmmoAOS_OK:
    ld (hl),a
    ld hl,Shoot
    or a
    jr nz,EnableShoot
    ld hl,ShootDisabled
EnableShoot:
    ld (ShootEnableOrDisableVar),hl
    
DrawAmmo:
    ld hl,SCREEN_HEIGHT*12+plotsscreen+12+12+7
    ld de,11
    ld b,5
_DrawAmmoEraseFirst:
    ld (hl),0
    inc hl
    ld (hl),0
    add hl,de
    djnz _DrawAmmoEraseFirst
    
    ld de,SCREEN_HEIGHT+1*256+60
DrawAmmo1:
    call vDispA
    inc a
    ret

#ifdef EnableSprite
GetMap:
    ld a,MapYMax-1  ;d = y
    cp d     ;e = x
    ret c
    ld a,MapXMax - 1
    cp e
    ret c
    ld h,d
    ld l,0
    ld b,l
    ld c,e
    srl h
    rr l
    srl h
    rr l
    add hl,bc
    ld bc,MapBuffer ;-64
    add hl,bc
    ld a,(hl)
    cp SpriteGrenze
    jr nc,GetMapSpriteFound
    or a
    ret
GetMapSpriteFound:
    cp SpriteLight3-2
    ret z    
    jr nc,GetMapSpriteNoLight
    cp SpriteLight1-2
    ret z
    cp SpriteLight2-2
    ret z
GetMapSpriteNoLight:
    ld (hl),0  ;delete Sprite
    ld b,h
    ld c,l

    ld hl,0 ;(SpriteArrayPointer) ;spr nr
SpriteArrayPointer = $-2
    ld (hl),a ;Tile
    inc hl
    ld (hl),b
    inc hl
    ld (hl),c
    inc hl
    ld (hl),d ;map position y
    inc hl
    ld (hl),e ;map position x
    inc hl
    ld (SpriteArrayPointer),hl
    xor a ;flag = 0
    ret


ActorGetMap:
    ld a,MapYMax-1  ;d = y
    cp d     ;e = x
    ret c
    ld a,MapXMax - 1
    cp e
    ret c
    ld h,d
    ld l,0
    ld b,l
    ld c,e
    srl h
    rr l
    srl h
    rr l
    add hl,bc
    ld bc,MapBuffer ;-64
    add hl,bc
    ld a,(hl)

    cp SpriteGrenze
    jr c,GetMapSpriteNotFound
    cp SpriteGrenzeNotPas
    jr nc,GetMapSpriteNotFound    ; Sollte es mglichmachen, dass durch passierbare dinge durchgelaufen werden kann.
    xor a
GetMapSpriteNotFound:
    or a
    ret

#else
ActorGetMap:
GetMap:
    ld a,MapYMax  ;d = y
    cp d     ;e = x
    ret c
    ld a,MapXMax - 1
    cp e
    ret c
    ld h,d
    ld l,0
    ld b,l
    ld c,e
    srl h
    rr l
    srl h
    rr l
    add hl,bc
    ld bc,MapBuffer-64
    add hl,bc
    ld a,(hl)
#ifdef IgnoreSprite 
    cp SpriteGrenze
    jr c,GetMapSpriteNotFound

    xor a
GetMapSpriteNotFound:
#endif

    or a
    ret
#endif

#ifndef MIRAGE
DispVText:
    ld (PENCOL),de
    bcall(_vputs)
    di
    ret
    
AktiviereKeyPad:
    ex af,af'
        ld      a,$FF                           ; Value used to reset keyport
        out     (1),a                           ; Reset keyport (sort of)
    ex af,af'
;        ld      a,b                             
        out     (1),a                           ; Open the group we wanna check
        in      a,(1)                           ; Get any keypresses
        ret
#endif

vDispA:
    ld h,0
    ld l,a
    ld (PENCOL),de
    ld de,op1+5
    xor a
    ld (de),a
vdhlRepeat:

    bcall(_divhlby10)
    add a,'0'
    dec de
    ld (de),a
    ld a,h
    or l
    jr nz,vdhlRepeat
    ex de,hl
    bcall(_vputs)
    di
    ret


GameOverByHit:
    pop hl  ; aus vorherigem call (Health add or sub)
PlayerDeathAnimation:
#ifdef MIRAGE
#ifdef DeathAnimationScrollDown
 ld hl,SCREEN_HEIGHT*12+plotsscreen -2
 ld de,SCREEN_HEIGHT*12+plotsscreen -1
 ld bc,SCREEN_HEIGHT*12-1
PDALoop:
 push bc
 push de
 push hl
 lddr
 call _IonFastCopy
 pop hl
 pop de
 pop bc
 dec bc
 ld a,b
 or c
 jr nz,PDALoop
#endif
#ifdef DeathAnimationTurnOut
    ld b,8
PlayerDeathAnimationLoop1:
    push bc
    ld hl,plotsscreen+SCREENPOS
    ld de,4
    ld b,SCREEN_HEIGHT
PlayerDeathAnimationLoop2:
    push bc
    ld b,8
PlayerDeathAnimationLoop3:
    srl (hl)
    set 7,(hl)
    inc hl
    djnz PlayerDeathAnimationLoop3
    pop bc
    add hl,de ;+4
    djnz PlayerDeathAnimationLoop2

    ld b,FadeOutDelay
PlayerDeathAnimationDLoop:
    push bc
    call _IonFastCopy
    pop bc
    djnz PlayerDeathAnimationDLoop

    pop bc
    djnz PlayerDeathAnimationLoop1
#endif
#ifdef DeathAnimationMoveOut
    ld a,96
PDALoopLeftRightBiggest:
    ld hl,plotsscreen
    ld de,13
    ld c,SCREEN_HEIGHT/2
PDALoopRightBig:
    ld b,11
    srl (hl)
PDALoopRight:
    inc hl
    rr (hl)
    djnz PDALoopRight
    add hl,de
    dec c
    jr nz,PDALoopRightBig
    ld hl,SCREEN_HEIGHT*12+plotsscreen-1
    ld c,SCREEN_HEIGHT/2
PDALoopLeftBig:
    ld b,11
    sla (hl)
PDALoopLeft:
    dec hl
    rl (hl)
    djnz PDALoopLeft
    or a
    sbc hl,de
    dec c
    jr nz,PDALoopLeftBig
    ex af,af'
    call _IonFastCopy
    ex af,af'
    dec a
    jr nz,PDALoopLeftRightBiggest
#endif
#ifdef DeathAnimationMeltOutDown
    ld hl,SCREEN_HEIGHT*12+plotsscreen - 12
    ld bc,0
    ld a,SCREEN_HEIGHT-1
    push hl
    push bc
PDALoop:
    pop bc
    ld de,12
    ld h,b
    ld l,c
    add hl,de
    ld b,h
    ld c,l
    pop hl
    push hl
    sbc hl,de
    pop de
    push hl
    push bc
    ldir   
    ex af,af'
    call _IonFastCopy
    call _IonFastCopy
    call _IonFastCopy
    ex af,af'
    dec a
    jr nz,PDALoop
    pop bc
    pop bc
#endif
#endif


ExitWithKeyStop:
    ld a,(StartContrast)
    or $C0
    out (LCDINSTPORT),a
    ret


ClearBufferRoutine:
    ld (hl),0
ClearBufferRoutineSpecial:
    push hl
    pop de
    inc de
    ldir
    ret

MultDEx255:
 ld a,255
Mult:       ; AHL = A x DE
 ld hl,0
 ld c,h

 or a
 rla
 jr nc,Mult1
 ld h,d
 ld l,e
Mult1:
 add hl,hl
 rla
 jr nc,Mult2
 add hl,de
 adc a,c
Mult2:
 add hl,hl
 rla
 jr nc,Mult3
 add hl,de
 adc a,c
Mult3:
 add hl,hl
 rla
 jr nc,Mult4
 add hl,de
 adc a,c
Mult4:
 add hl,hl
 rla
 jr nc,Mult5
 add hl,de
 adc a,c
Mult5:
 add hl,hl
 rla
 jr nc,Mult6
 add hl,de
 adc a,c
Mult6:
 add hl,hl
 rla
 jr nc,Mult7
 add hl,de
 adc a,c
Mult7:
 add hl,hl
 rla
 jr nc,MultEnd
 add hl,de
 adc a,c
MultEnd:
 ld e,h
 ld d,a
 ret



div_ratio:
div_hl_by_de:
   XOR   A                             ; negate divisor
   SUB   E
   LD    E, A
   SBC   A, A
   SUB   D
   LD    D, A

   LD    A, H                          ; A = top 8-bits of dividend
   LD    C, L                          ; C = low 8-bits of dividend
   LD    HL, 0                         ; DE = divisor, quotient = 0

   LD    B, 8                          ; 8 loops (half of 16 bits)
   RLA                                 ; 24-bit shift
_CDHLDE_divloop1:
   ADC   HL, HL
   ADD   HL, DE                        ; compare with divisor
   JR    C, _CDHLDE_noadd1             ; if divisor is smaller
   SBC   HL, DE                        ; restore result
_CDHLDE_noadd1:
   RLA                                 ; 24-bit shift
   DJNZ  _CDHLDE_divloop1

   LD    B, A                          ; C = top 8-bits of current result
   LD    A, C                          ; A = low 8-bits of dividend
   LD    C, B

   LD    B, 8                          ; 8 loops (half of 16 bits)
   RLA                                 ; 24-bit shift
_CDHLDE_divloop2:
   ADC   HL, HL
   ADD   HL, DE                        ; compare with divisor
   JR    C, _CDHLDE_noadd2             ; if divisor is smaller
   SBC   HL, DE                        ; restore result
_CDHLDE_noadd2:
   RLA                                 ; 24-bit shift
   DJNZ  _CDHLDE_divloop2

   EX    DE, HL                        ; DE = remainder
 ;  LD    H, C                          ; HL = quotient
 ;  LD    L, A                                                                         ;, hchstwahrscheinlich nicht gebraucht...
; c = h    a = l
   RET

#ifdef Exclude
div_ratio:
   XOR   A                             ; negate divisor
   SUB   E
   LD    E, A
   SBC   A, A
   SUB   D
   LD    D, A

   LD    HL, SLICE_RATIO ;0                         ; DE = divisor, quotient = 0

    ld a,h ;0
    ld c,h ;0

   LD    B, 8                          ; 8 loops (half of 16 bits)
   RLA                                 ; 24-bit shift
_CDHLDE_divloop22:
   ADC   HL, HL
   ADD   HL, DE                        ; compare with divisor
   JR    C, _CDHLDE_noadd22             ; if divisor is smaller
   SBC   HL, DE                        ; restore result
_CDHLDE_noadd22:
   RLA                                 ; 24-bit shift
   DJNZ  _CDHLDE_divloop22

   EX    DE, HL                        ; DE = remainder
 ;  LD    H, C                          ; HL = quotient
 ;  LD    L, A                                                                         ;, hchstwahrscheinlich nicht gebraucht...
; c = h    a = l
 ret
#endif




#include "WolfRayC.asm"


Cos64:              ; DE = 64 * COS(A)
 add a,64
Sin64:              ; DE = 64 * SIN(A)
 ld d,0
 ld e,a
 ld hl,Sin64Table
 add hl,de
 ld e,(hl)
 bit 7,e
 ret z
 ld d,-1
 ret

CosInv:             ; DE = 256 / COS(A)
 add a,64
SinInv:             ; DE = 256 / SIN(A)
 push hl
 ld d,0
 ld e,a
 sla e
 ld hl,SinInv256Table
 add hl,de
 ld e,(hl)
 inc hl
 ld d,(hl)
; pop hl
 pop bc
 ld a,b
;; ret
mul:       ; BCDE = HLxDE  ; war original routine
MUL_DEHL_T: ;CAHL = result
;   LD    A, H                          ; A = top 8 bits of multiplicand
;   LD    C, L                          ; C = bottom 8 bits of multiplicand
   LD    HL, 0                         ; DE = multiplier, result = 0

   LD    B, H

   ADD   A, A                          ; test bit (no need to do HL)
;   JR    NC, _CMDEHLT_noadd1           ; if shifted bit is set then
;   ADD   HL, DE                        ; add the multiplier
;   ADC   A, B                          ; increment high byte as needed
;_CMDEHLT_noadd1:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
;   JR    NC, _CMDEHLT_noadd2           ; if shifted bit is set then
   
;   ADD   HL, DE                        ; add the multiplier
;   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd2:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd3           ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd3:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd4           ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd4:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd5           ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd5:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd6           ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd6:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd7           ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd7:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd8           ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd8:

   LD    B, A                          ; C = top 8 bits of current result
   LD    A, C                          ; A = bottom 8 bits if multiplicand
   LD    C, B

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd9           ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd9:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd10          ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd10:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd11          ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd11:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd12          ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd12:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd13          ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd13:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd14          ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd14:

   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd15          ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd15:
   ADD   HL, HL                        ; 24-bit shift/test bit
   RLA
   JR    NC, _CMDEHLT_noadd16          ; if shifted bit is set then
   ADD   HL, DE                        ; add the multiplier
   ADC   A, B                          ; increment high byte as needed
_CMDEHLT_noadd16:

;   LD    D, A                          ; DEHL = result
;   LD    E, C

   ld l,h
   ld h,a

   RET

TanInv:             ; DE = 256 / TAN(A)
 add a,64
Tan:                ; DE = 256 * TAN(A)
 ld d,0
 ld e,a
 sla e
 ld hl,Tan256Table
 add hl,de
 ld e,(hl)
 inc hl
 ld d,(hl)
 ret

#include "WolfDtex.asm"
#ifndef MIRAGE
#include "IonRout.asm"
#endif
#include "Wolf_Tbl.asm"
#include "WolfTEX.asm"
#include "Wolf_Buf.asm"



.end
END