#include "ti83plus.inc"

#define Start_Program $9D93
#define Link_Off  $0C3
#define Link_Port 0
#define Link_On     $0C0        ;same for all z80 TI's

.org Start_Program  ;starts the program

Start:
 ld hl,Sound        ;loads the sound data
 di             ;disables interrupts
 ld e,(hl)          ;loads e with hl
 inc hl         ;increases hl
 ld d,(hl)          ;loads d with hl
 inc hl         ;increases hl
 ld b,128           ;stores b as 128
SLoop:
 ld c,19            ;stores c as 19
Loop:
 dec c          ;decreases c
 nop                ;nothing happens here (timing)
 nop                ;nothing happens here (timing)
 nop                ;nothing happens here (timing)
 jr nz,Loop         ;loops until c is 0
 rrc b          ;
 jr nc,Play         ;goes, if no carry, to Play
 inc hl         ;increases hl
 dec de         ;decreases de
 ld a,d         ;loads a with value from d
 or e               ;compares a with e using Boolean 'or'
 jr z,Done          ;if true, goes to Done
Play:
 ld a,(hl)          ;loads a with hl
 and b          ;compares with b using Boolean 'and'
 jr z,Play1         ;if true, go to Play1
 ld a,Link_On      ;load a with the 'Link_Off' value
 out (Link_Port),a  ;turn off the link port
 jr SLoop           ; go to SLoop
Play1:
 ld a,Link_Off      ;load a with the 'Link_On' value
 out (Link_Port),a  ;turn on the link port
 jr SLoop           ; go to SLoop
Done:
 di                 ;disables interrupts
 ret                ;returns from program
