;********************************************
;
; TEXT CENTERER - implementation
;
; Version 1.20
;
; by Adam Ziemba
;
; E-mail me at <infest997@musician.org>
; Visit my website at <http://www.citadel.tk>
;
;********************************************
; Please view <readme.txt> for documentation
;********************************************
#include "ti83plus.inc"
#include "mirage.inc"

.org $9D93
.db $BB,$6D
 ret
.db 3
Sprite:
;.db 16, 15
.db %00000000,%00000000
.db %11101110,%10101110
.db %01001000,%10100100
.db %01001100,%01000100
.db %01001000,%10100100
.db %01001110,%10100100
.db %00000000,%00000000
.db %11101110,%11001110
.db %10001100,%10100100
.db %11101110,%10100100
.db %00000000,%00000000
.db %01000001,%00000100
.db %11111001,%00111110
.db %01000001,%00000100
.db %00000000,%00000000
.dw exit
.db "Text Centerer - v1.2",0

window  = $9A00
lastChr = $9A02

; di
main:
; B_CALL _ClrLCDFull
; B_CALL _RunIndicOff
 set LwrCaseActive,(IY+appLwrCaseFlag)
 res appTextSave,(IY+appFlags)
 xor A
 ld B,A
 ld C,A
 inc A
 ld (lastChr),A
 ld HL,title
 set textInverse,(IY+textFlags)
 call SPut
 res textInverse,(IY+textFlags)
 ld A,$08
 ld HL,author
 call centertext
 ld HL,$005F    ; HL = window range (95 by default)
win_loop:
 push HL
 ld BC,$0B02
 call HLdisp
 ld BC,$0002
 ld HL,winDir
 call SPut
 B_CALL _GetKey
 pop HL
 sub kUp
 jp Z,winUp
 dec A
 jp Z,winDown
 dec A
 jr NZ,win_loop
 ld A,L
 ld (window),A
 ld BC,$0003
 ld HL,direct
 call SPut
 ld HL,_appBackUpScreen+1   ; Safe RAM location to store data
 ld B,$2D                   ; Maximum characters is 45
 ld DE,$0E03
;--------------------------------
; STRING INPUT
;--------------------------------
;Precondition:
;   HL  = points to where to save input
;   B   = max characters
;Postcondition:
;   HL  = is preserved
;   BC  = number of characters inputted
StringInput:
 push HL
 ld (_curRow),DE
 push DE
 set curAble,(IY+curFlags)
 ld C,B     ; C = Backup of max chars
 ld D,$00   ; D = How many chars after current cursor location last inpuuted char is
 ld (HL),D
 ld A,Lspace
 ld (_curUnder),A
 B_CALL _PutMap
siLoop:
 push HL
 push DE
 push BC
 B_CALL _GetKey
 pop BC
 pop DE
 pop HL
 cp kQuit
 jr Z,siQuit
 cp kDel
 jp Z,siLeft    ; Delete A character
 cp kClear
 jp Z,siClear   ; Clear entire prompt
 cp kEnter
 jp Z,siEnter
 cp kLeft
 jp Z,siLeft    ; Attempt to move left
 cp kSpace
 jp Z,siSpace   ; Non-regular character: space
 cp kComma
 jp Z,siComma   ; Non-regular character: comma
 cp kDecPnt
 jp Z,siDecPnt  ; Non-regular character: decimal point
 cp kAdd
 jp Z,siPlus    ; Non-regular character: plus
 cp kSub
 jp Z,siMinus   ; Non-regular character: minus
 cp kMul
 jp Z,siTimes   ; Non-regular character: times
 cp kDiv
 jp Z,siDivide  ; Non-regular character: divide
 cp kLParen
 jp Z,siLParen  ; Non-regular character: left parenth (
 cp kRParen
 jp Z,siRParen  ; Non-regular character: right parenth )
 cp kQuote
 jp Z,siQuote   ; Non-regular character: quote "
 cp kColon
 jp Z,siColon   ; Non-regular character: colon :
 cp kQuest
 jp Z,siQuestion; Non-regular character: question mark ?
 cp kStore
 jp Z,siInsChar ; Attempt to insert an unsupported character
 cp kExtendEcho2
 jr Z,siLwrLetter
 sub k0
 cp $0A
 jp C,siNumber  ; It's A number
 sub kCapA-k0
 cp 26
 jp C,siLetter  ; It's A letter
 jr NZ,siLoop
siLwrLetter:
 ld A,(_keyExtend)
 sub kLa
 cp 26
 jr NC,siLoop
 add A,La
 jp siLetCont
siQuit:
; pop DE
; pop HL
; jp exit       ; Don't need this in MirageOS!
 B_CALL _CursorOff
 call quittoshell
siDel:  ; Delete A character
 inc D
 dec D  ; Are we at the end of the string?
 jp Z,siLoop
 push DE
 push BC
 push HL
 ld B,D
 ld DE,(_curRow)
 push DE 
 ld D,H
 ld E,L
 inc DE 
 dec B              ; Are we deleting the last character?
 ld C,Lspace
 ld (HL),$00        ; Needs to be zero terminated, right?
 ld A,Lspace
 B_CALL _PutC
 ld A,C
 ld (_curUnder),A
 pop DE
 ld (_curRow),DE
 pop HL
 pop BC
 pop DE
 dec D
 jp siLoop
siClear:    ; Clear all characters
 ld A,C
 sub B
 add A,D
 or A       ; Nothing to clear?
 jp Z,siLoop
 ld E,D
 ld D,$00
 add HL,DE
 ld (HL),$00        ; Zero terminate current text
 pop DE
 ld (_curRow),DE    ; Restore original cursor location
 pop HL
 push BC
 B_CALL _StrLength  ; Get length of string
 inc C              ; Need to erase cursor too
 push HL
 push DE
siClearLoop:    ; Clear all previously entered text
 ld A,Lspace
 B_CALL _PutC
 dec C
 jr NZ,siClearLoop
 pop DE
 ld (_curRow),DE
 pop HL
 pop BC
 ld B,C         ; Restore backup of max # of chars
 jp StringInput 
siEnter:
 ld A,(_curUnder)
 B_CALL _PutMap ; Display character under cursor, so we don't get A black box
 ld HL,_curRow
 dec D
 inc D
 jr Z,siEnterLoopSkip
siEnterLoop:    ; Updates cursor position to end
 ld A,(_curCol)
 inc A
 and $0F
 ld (_curCol),A
 or A
 jr NZ,siEnterLoopCont
 inc (HL)
siEnterLoopCont:
 dec D
 jr NZ,siEnterLoop
siEnterLoopSkip:
 pop DE
 pop HL
 B_CALL _StrLength          ; Find string length
 inc BC                     ; Add one for zero terminator
 res curAble,(IY+curFlags)  ; Turn off cursor
 dec C
 ld A,C
 ld (_appBackUpScreen),A    ; Store # of chars as the leading byte of the string
 res shiftALock,(IY+shiftFlags)
 ld B,4
 ld HL,$0007
clr_loop:
 dec L
 call clearEOL
 djnz clr_loop          ; Clear the three rows containing the inputted text
 ld HL,_appBackUpScreen
 B_CALL _SStringLength  ; B = # of pixels needed to display the string using the small font
 ld A,(window)
 cp B
 jr NC,cont
 ld A,B
 ld BC,$0005
 ld HL,dimErr
 call SPut
 jr done
cont:
 ld C,B
 ld B,$00
 ld A,(window)
 ld L,A
 ld H,$00
 push HL
 xor A                  ; Reset the carry flag
 sbc HL,BC              ; HL = window - length
 ld A,$02
 B_CALL _DivHLByA       ; HL = (window - length) / 2
 push HL
 ld BC,$0004
 call HLdisp
 ld BC,$0004
 ld HL,PenX
 call SPut
 pop HL
 ld B,$2E
 ld C,L
 ld HL,_appBackUpScreen+1
 call VSPut
 pop HL
 ld H,$2E
 ld (_penCol),HL
 ld A,$7C
 B_CALL _VPutMap
done:
 B_CALL _GetKey
exit:
; B_CALL _ClrLCDFull
; B_CALL _HomeUp        ; Don't need this is MirageOS!
 B_CALL _CursorOff
 res donePrgm,(IY+doneFlags)
 call quittoshell
siNumber:       ; A number key was pressed
 add A,L0       ; Add number to '0' 
 jr siLetCont 
siLetter:       ; A letter key was pressed
 add A,LcapA    ; Add letter number to 'A'
siLetCont:
 dec B
 inc B          ; Have we displayed the maximum # of characters?
 jp Z,siLoop
 ld (HL),A
 B_CALL _PutC
 inc HL
 ld A,D
 dec D
 dec B
 or A
 ld A,(HL)
 ld (_curUnder),A   ; Reset _curUnder to next character
 jp NZ,siLoop
 inc D
 ld A,Lspace
 ld (_curUnder),A 
 ld (HL),$00
 jp siLoop
siInsChar:      ; Store was pressed
 push HL
 push BC
 push DE
 ld BC,(_curRow)
 push BC        ; Save cursor location
 B_CALL _CursorOff
 ld BC,$0007
 ld HL,insert
 call SPut
 ld A,(lastChr)
 ld D,A
ins_loop:
 ld BC,$0C07
 ld (_curRow),BC
 ld A,D
 push DE
 B_CALL _PutC
 B_CALL _GetKey
 pop DE
 sub $03
 jr Z,insUp
 dec A
 jr Z,insDown
 dec A
 jr NZ,ins_loop ; Go back to ins_loop if user doesn't press ENTER
 ld A,D
 ld (lastChr),A
 ld HL,$0007
 call clearEOL
 pop BC
 ld (_curRow),BC
 ld A,D
 B_CALL _CursorOn
 pop DE
 pop BC
 pop HL
 jr siLetCont
insUp:
 inc D
 jr Z,insUp     ; Don't let user insert 0 terminating character
 jr ins_loop
insDown:
 dec D
 jr Z,insDown   ; Don't let user insert 0 terminating character
 jr ins_loop
siSpace:        ; Space was pressed
 ld A,' '
 jr siLetCont
siQuote:
 ld A,Lquote
 jr siLetCont
siDecPnt:       ; Decimal point was pressed
 ld A,'.'
 jp siLetCont
winUp:
 ld A,L
 cp $5F
 jp Z,win_loop
 inc HL
 jp win_loop
winDown:
 ld A,L
 dec A
 jp Z,win_loop
 dec HL
 jp win_loop
clearEOL:
 ld (_curRow),HL
 B_CALL _EraseEOL
 ret
SPut:
 ld (_curRow),BC
 B_CALL _PutS
 ret
VSPut:
 ld (_penCol),BC
 B_CALL _VPutS
 ret
HLdisp:
 push HL
 ld (_curRow),BC
 ld H,$00
 B_CALL _DispHL
 pop HL
 ret
siPlus:         ; Plus was pressed
 ld A,'+'
 jp siLetCont
siMinus:        ; Minus was pressed
 ld A,'-'
 jp siLetCont
siTimes:        ; Times was pressed
 ld A,$2A
 jp siLetCont
siDivide:       ; Divide was pressed
 ld A,$2F
 jp siLetCont
siComma:        ; Comma was pressed
 ld A,','
 jp siLetCont
siLParen:       ; Left parenthesee was pressed
 ld A,LlParen
 jp siLetCont
siRParen:       ; Right parenthesee was pressed
 ld A,LrParen
 jp siLetCont
siColon:        ; Colon was pressed
 ld A,Lcolon
 jp siLetCont
siQuestion:     ; Question mark was pressed
 ld A,Lquestion
 jp siLetCont
siLeft:         ; Try to move left
 ld A,B
 cp C           ; Are we all the way to the left?
 jp Z,siLoop    ; If so, we can't go any further
 inc B
 ld A,D
 inc D          ; We've moved farther away from the end
 call siLDAHL
 B_CALL _PutMap
 dec HL
 ld A,(HL)
 ld (_curUnder),A   ; Update _curUnder
 ld A,(_curCol)
 dec A              ; Cursor location one to the left
 ld (_curCol),A
 jp p,siDel         ; Jumps if there was no overflow 
 ld A,$0F
 ld (_curCol),A
 ld A,(_curRow)
 dec A
 ld (_curRow),A
 jp siDel
siLDAHL:
; Loads A character from (HL) and
; converts it to Lspace if it is 0
 ld A,(HL)
 or A
 ret NZ
 ld A,Lspace
 ret

;--------------------------------
; STRINGS / CONSTANTS
;--------------------------------
title:  .db " Text  Centerer ",0
author: .db "v1.2 - by Adam Ziemba",0
direct: .db "Type the text:",0
winDir: .db "Window range=",0;
PenX:   .db "X=",0
insert: .db "Select char:",0
dimErr: .db "Out of range!",0

.end