@echo off
cls
:Start
echo     
echo      Ti83+ SDK v 1.2 
echo     
IF EXIST *.z80 Goto rename
IF EXIST %1.asm Goto Meny
Goto prompt

:Meny
cls
echo.
echo     --------------------
echo     File: %1.asm
echo     --------------------

echo     
echo                 *****    MAIN MENU     *****                
echo     
echo                                                             
echo        1. Assemble in binary format (Normal).               
echo                                                             
echo        2. Assemble in hex ascii (AsmPrgm format).           
echo                                                             
echo        3. Assemble in hex ascii (Flash app format).         
echo                                                             
echo        4. Assemble and create signed flash app.             
echo           (requires the TI Flash Debugger to be installed.) 
echo        5. Quit                                              
echo                                                             
echo     
echo      
echo.

CHOICE /N /C:12345 Enter your choice...
cls
IF ERRORLEVEL ==5 GOTO QUIT
IF ERRORLEVEL ==4 GOTO SIGNHEXAPP
IF ERRORLEVEL ==3 GOTO HEXAPP
IF ERRORLEVEL ==2 GOTO HEXASM
IF ERRORLEVEL ==1 GOTO BINASM
GOTO Meny

:BINASM
echo --- Assembling %1.asm in bin asm format ---
echo.
tasm -t80 -b -i %1.asm %1.bin
IF ERRORLEVEL 1 GOTO ERROR
devpac8x %1
del %1.bin
del %1.lst
move /Y %1.8xp 8xp_bin\%1.8xp
echo.
echo %1.8xp has been created in the binasm folder,
echo and you can send the file to your real ti83+ or emulator.
echo.
choice Re-assemble 
cls
if errorlevel 2 Goto Meny
Goto BINASM


:HEXASM
echo --- Assembling %1.asm in hex asm format ---
echo.
tasm -t80 -h -i %1.asm %1.hex
IF ERRORLEVEL 1 GOTO ERROR
convhex %1.hex
move  /Y %1.8xp 8xp_hex\%1.8xp
echo.
echo Success! %1.8xp has been created in the hexasm folder
echo Don't forget to remove the first four digits (BB6D) from the prgm!
echo.
del %1.hex
del %1.lst
choice Re-assemble 
cls
if errorlevel 2 Goto Meny
Goto HEXASM


:HEXAPP
echo --- Assembling %1.asm in hex app format ---
echo.
tasm -t80 -h -i %1.asm %1.hex
IF ERRORLEVEL 1 GOTO ERROR
del %1.lst
move /Y %1.hex hexapps\%1.hex
echo.
echo Success! %1.hex has been created in the hexapps folder.
echo You can now test your app with the Flash Debugger.
echo.
choice Re-assemble 
cls
if errorlevel 2 Goto Meny
Goto HEXAPP


:SIGNHEXAPP
echo --- Assembling and signing %1.asm in hex app format ---
echo.
tasm -t80 -h -i %1.asm %1.hex
IF ERRORLEVEL 1 GOTO ERROR
del %1.lst
IF NOT EXIST %TI83PLUSDIR%\UTILS\APPSIGN.BAT GOTO sdkfel
move %1.hex %TI83PLUSDIR%\UTILS\
start /W command /C sign.bat %1
move %TI83PLUSDIR%\UTILS\%1.8xk signed_apps\
echo.
echo Success! %1.8xk has been created in the signed_apps folder.
echo You can either transfer it to your calc using Graph Link
echo or load the file into the Flash Debugger.
echo.
choice Re-assemble 
cls
if errorlevel 2 Goto Meny
Goto SIGNHEXAPP

:sdkfel
echo.
echo Couldn't get the path to appsign.bat. Please try to re-install 
echo the Ti Flash Debugger.
echo.
pause
Goto Meny

:ERROR
If exist del %1.bin
if exist del %1.hex
del %1.lst
echo.
echo -------------------
echo There were errors!
echo -------------------
echo.
echo Your file couldn't be compiled due to the errors that are 
echo printed out above. Please try to correct it.
pause
Goto Meny


:Prompt
echo.
echo Error: You didn't specify a file or it didn't exist.
echo Type asm [filename] in the prompt below and press enter.
echo This will bring up a menu where you can choose the output format.
echo Filename must be entered without file extension. E.g asm default.
Goto SLUT

:Rename
echo.
echo Version 1.2 of the Cirrus Programming SDK uses *.asm 
echo file extension instead of *.z80.
choice Do you want to rename %1.z80 to %1.asm
cls
IF ERRORLEVEL 2 Goto Slut
ren %1.z80 %1.asm
echo Renamed.
Pause
Goto Slut



:QUIT
cls
echo.
echo    (C) David Lindstrm 2002, okvin@tiscali.se 
echo 	A member of the Cirrus Programming group
echo 	http://cirrus.tigalaxy.com
echo.
:SLUT
echo.
