;======================================================================
; Include File for the TI-83 Plus
; Last Updated 02/20/2002 
;
; Copyright (c) 1999, 2001 Texas Instruments: The Licensed Materials are
; copyrighted by TI. LICENSEE agrees that it will 
; not delete the copyright notice, trademarks or
; protective notices from any copy made by LICENSEE.
;
; Warranty: TI does not warrant that the Licensed Materials will
; be free from errors or will meet your specific requirements.
; The Licensed Materials are made available "AS IS" to LICENSEE.
;
; Limitations: TI MAKES NO WARRANTY OR CONDITION, EITHER EXPRESS
; OR IMPLIED, INCLUDING BUT NOT LIMITED TO ANY IMPLIED
; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE,
; REGARDING THE LICENSED MATERIALS.  IN NO EVENT SHALL
; TI OR ITS SUPPLIERS BE LIABLE FOR ANY INDIRECT, INCIDENTAL
; OR CONSEQUENTIAL DAMAGES, LOSS OF PROFITS, LOSS OF USE OR DATA, 
; OR INTERRUPTION OF BUSINESS, WHETHER THE ALLEGED DAMAGES ARE
; LABELED IN TORT, CONTRACT OR INDEMNITY.
;
;\\\\\\\\\\\\\\\\\\\\\\\\\\\
;MODIFIED FOR USE WITH TASM
;BY DAVID LINDSRM
;CIRRUS PROGRAMMING
;http://cirrus.tigalaxy.com
;///////////////////////////

;Some 'unofficial' rom calls
_homeup           = $4558


#define bcall(xxxx)     rst 28h         \ .dw xxxx
#define bjump(xxxx)	call 50h \ .dw xxxx
#define	bcallz(xxxx)	jr nz,$+5 \ rst 28h \ .dw xxxx
#define	bcallnz(xxxx)	jr	z,$+5 \ rst 28h \ .dw xxxx
#define	bcallc(xxxx)	jr	nc,$+5 \ rst 28h \ .dw xxxx
#define	bcallnc(xxxx)	jr	c,$+5	\ rst 28h \ .dw xxxx
#define equ .equ
#define EQU .equ
#define errhandon(label) ld hl,label \ call 59h
#define errhandoff() call 5Ch

;======================================================================
;           system variable equates
;======================================================================
;       entry points : rclsystok, stosystok
;
xsclt		equ  2
ysclt		equ  3
xmint		equ  0ah
xmaxt		equ  0bh
ymint		equ  0ch
ymaxt		equ  0dh
tmint		equ  0eh
tmaxt		equ  0fh
thetmint	equ  10h
thetmaxt	equ  11h
tblmint		equ  1ah
plotstartt	equ  1bh
nmaxt		equ  1dh
nmint		equ  1fh
tblstept	equ  21h
tstept		equ  22h
thetstept	equ  23h
deltaxt		equ  26h
deltayt		equ  27h
xfactt		equ  28h
yfactt		equ  29h
finnt		equ  2bh
finit		equ  2ch
finpvt		equ  2dh
finpmtt		equ  2eh
finfvt		equ  2fh
finpyt		equ  30h
fincyt		equ  31h
plotstept	equ  34h
xrest		equ  36h
;

;======================================================================
;           run indicators
;======================================================================
;
busypause	equ	10101010b
busynormal	equ	11110000b
;
;======================================================================
;           common subroutine rst numbers  
;======================================================================
;
rop1toop2	equ 08h
rfindsym	equ  10h
rpushrealo1	equ  18h
rmov9toop1	equ  20h
rfpadd		equ  30h
;

;symbolic_debug_start
;======================================================================
;           entry points  
;======================================================================
;
_abso1o2cp	equ 410eh
_abso1pabso2	equ 405ah
_acos		equ 40deh
_acosh		equ 40f0h
_acosrad	equ 40d2h
_adrlele	equ 462dh
_adrmele	equ 4609h
_adrmrow	equ 4606h
_alleq		equ 4876h
_allocfps	equ 43a5h
_allocfps1	equ 43a8h
_angle		equ 4102h
_ansname	equ 4b52h
_apdsetup	equ 4c93h
_appgetcalc	equ 4c78h
_appgetcbl	equ 4c75h
_appinit	equ 404bh
_arc_unarc	equ 4fd8h
_asin		equ 40e4h
_asinh		equ 40edh
_asinrad	equ 40dbh
_atan		equ 40e1h
_atan2		equ 40e7h
_atan2rad	equ 40d8h
_atanh		equ 40eah
_atanrad	equ 40d5h

_binopexec	equ 4663h
_bit_vertsplit	equ 4fa8h
_bufclr		equ 5074h
_bufcpy		equ 5071h

_cabs		equ 4e97h
_cadd		equ 4e88h
_canalphins	equ 4c69h
_cdiv		equ 4e94h
_cdivbyreal	equ 4ebbh
_cetox		equ 4ea9h
_cfrac		equ 4ec1h
_checksplitflag	equ 49f0h
_chk_batt_low	equ 50B3h
_chkfindsym	equ 42f1h
_cintgr		equ 4ec4h
_circcmd	equ 47d4h
_ckint		equ 4234h
_ckodd		equ 4237h
_ckop1c0	equ 4225h
_ckop1cplx	equ 40fch
_ckop1fp0	equ 4228h
_ckop1pos	equ 4258h
_ckop1real	equ 40ffh
_ckop2fp0	equ 422bh
_ckop2pos	equ 4255h
_ckop2real	equ 42dfh
_ckposint	equ 4231h
_ckvalidnum	equ 4270h
_cleanall	equ 4a50h
_clearrect	equ 4d5ch
_clearrow	equ 4cedh
_cline		equ 4798h
_clines		equ 479bh
_cln		equ 4ea0h
_clog		equ 4ea3h
_closeeditbuf	equ 48D3h
_closeeditbufnor	equ 476eh
_closeeditequ	equ 496Ch
_closeprog	equ 4a35h
_clrgraphref	equ 4a38h
_clrlcd		equ 4543h
_clrlcdfull	equ 4540h
_clrlp		equ 41d1h
_clrop1s	equ 425eh
_clrop2s	equ 425bh
_clrscrn	equ 4549h
_clrscrnfull	equ 4546h
_clrtxtshd	equ 454ch
_cmltbyreal	equ 4eb8h
_cmpsyms	equ 4a4ah
_cmult		equ 4e8eh
_conj		equ 4eb5h
_convdim	equ 4b43h
_convdim00	equ 4b46h
_convlctolr	equ 4a23h
_convlrtolc	equ 4a56h
_convop1	equ 4aefh
_cop1set0	equ 4105h
_cos		equ 40c0h
_cosh		equ 40cch
_cphlde		equ 400ch
_cpoint		equ 4dc8h
_cpoints	equ 47f5h
_cpop1op2	equ 4111h
_cpop4op3	equ 4108h
_cpyo1tofps1	equ 445ch
_cpyo1tofps2	equ 446bh
_cpyo1tofps3	equ 4477h
_cpyo1tofps4	equ 4489h
_cpyo1tofps5	equ 4483h
_cpyo1tofps6	equ 447dh
_cpyo1tofps7	equ 4480h
_cpyo1tofpst	equ 444ah
_cpyo2tofps1	equ 4459h
_cpyo2tofps2	equ 4462h
_cpyo2tofps3	equ 4474h
_cpyo2tofps4	equ 4486h
_cpyo2tofpst	equ 4444h
_cpyo3tofps1	equ 4453h
_cpyo3tofps2	equ 4465h
_cpyo3tofpst	equ 4441h
_cpyo5tofps1	equ 4456h
_cpyo5tofps3	equ 4471h
_cpyo6tofps2	equ 4468h
_cpyo6tofpst	equ 4447h
_cpystack	equ 4429h
_cpyto1fps1	equ 4432h
_cpyto1fps10	equ 43f3h
_cpyto1fps11	equ 43d8h
_cpyto1fps2	equ 443bh
_cpyto1fps3	equ 4408h
_cpyto1fps4	equ 440eh
_cpyto1fps5	equ 43deh
_cpyto1fps6	equ 43e4h
_cpyto1fps7	equ 43eah
_cpyto1fps8	equ 43edh
_cpyto1fps9	equ 43f6h
_cpyto1fpst	equ 4423h
_cpyto2fps1	equ 442fh
_cpyto2fps2	equ 4438h
_cpyto2fps3	equ 4402h
_cpyto2fps4	equ 43f9h
_cpyto2fps5	equ 43dbh
_cpyto2fps6	equ 43e1h
_cpyto2fps7	equ 43e7h
_cpyto2fps8	equ 43f0h
_cpyto2fpst	equ 4420h
_cpyto3fps1	equ 442ch
_cpyto3fps2	equ 4411h
_cpyto3fpst	equ 441dh
_cpyto4fpst	equ 441ah
_cpyto5fpst	equ 4414h
_cpyto6fps2	equ 43ffh
_cpyto6fps3	equ 43fch
_cpyto6fpst	equ 4417h
_cpytofps1	equ 445fh
_cpytofps2	equ 446eh
_cpytofps3	equ 447ah
_cpytofpst	equ 444dh
_cpytostack	equ 4450h
_create0equ	equ 432ah
_createappvar	equ 4e6ah
_createclist	equ 431bh
_createcplx	equ 430ch
_createequ	equ 4330h
_createpair	equ 4b0dh
_createpict	equ 4333h
_createprog	equ 4339h
_createprotprog	equ 4e6dh
_createreal	equ 430fh
_createrlist	equ 4315h
_creatermat	equ 4321h
_createstrng	equ 4327h
_crecip		equ 4e91h
_csqroot	equ 4e9dh
_csquare	equ 4e8bh
_csub		equ 4e85h
_ctenx		equ 4ea6h
_ctrunc		equ 4ebeh
_cube		equ 407bh
_cursoroff	equ 45beh
_cursoron	equ 45c4h
_cxrooty	equ 4each
_cytox		equ 4eb2h

_darkline	equ 47ddh
_darkpnt	equ 47f2h
_datasize	equ 436ch
_datasizea	equ 4369h
_deallocfps	equ 439fh
_deallocfps1	equ 43a2h
_deco1exp	equ 4267h
_dellistel	equ 4a2fh
_delmem		equ 4357h
_delres		equ 4a20h
_delvar		equ 4351h
_delvararc	equ 4fc6h
_delvarnoarc	equ 4fc9h
_disableapd	equ 4c84h
_disp		equ 4f45h
_dispdone	equ 45b5h
_dispeol	equ 45a6h
_disphl		equ 4507h
_displayimage	equ 4d9bh
_dispmenutitle	equ 5065h
_dispop1a	equ 4bf7h
_divhlby10	equ 400fh
_divhlbya	equ 4012h
_drawcirc2	equ 4c66h
_drawcmd	equ 48c1h
_drawrectborder	equ 4d7dh
_drawrectborderclear	equ 4d8ch
_dtor		equ 4075h

_editprog	equ 4a32h
_enableapd	equ 4c87h
_enoughmem	equ 42fdh
_eop1notreal	equ 4279h
_equ_or_newequ	equ 42c4h
_eraseeol	equ 4552h
_eraserectborder	equ 4d86h
_errargument	equ 44adh
_errbadguess	equ 44cbh
_errbreak	equ 44bfh
_errd_op1_0	equ 42d3h
_errd_op1_le_0	equ 42d0h
_errd_op1not_r	equ 42cah
_errd_op1notpos	equ 42c7h
_errd_op1notposint	equ 42cdh


_errdatatype	equ 44aah
_errdimension	equ 44b3h
_errdimmismatch	equ 44b0h
_errdivby0	equ 4498h
_errdomain	equ 449eh
_errincrement	equ 44a1h
_errinvalid	equ 44bch
_erriterations	equ 44c8h
_errlinkxmit	equ 44d4h
_errmemory	equ 44b9h
_errnon_real	equ 44a4h
_errnonreal	equ 4a8ch
_errnotenoughmem	equ 448ch
_erroverflow	equ 4495h
_errsignchange	equ 44c5h
_errsingularmat	equ 449bh
_errstat	equ 44c2h
_errstatplot	equ 44d1h
_errsyntax	equ 44a7h
_errtoltoosmall	equ 44ceh
_errundefined	equ 44b6h
_etox		equ 40b4h
_exch9		equ 43d5h
_exlp		equ 4222h
_exptohex	equ 424fh

_factorial	equ 4b85h
_fillrect	equ 4d62h
_fillrectpattern	equ 4d89h
_find_parse_formula	equ 4af2h
_findalphadn	equ 4a47h
_findalphaup	equ 4a44h
_findapp		equ 4c4eh
_findappdn		equ 4c4bh
_findappnumpages	equ 509bh
_findappup		equ 4c48h
_findsym	equ 42f4h
_fiveexec	equ 467eh
_fixtempcnt	equ 4a3bh
_flashtoram	equ 5017h
_forcefullscreen	equ 508fh
_formbase	equ 50aah
_formdcplx	equ 4996h
_formereal	equ 4990h
_formreal	equ 4999h
_fourexec	equ 467bh
_fpadd		equ 4072h
_fpdiv		equ 4099h
_fpmult		equ 4084h
_fprecip	equ 4096h
_fpsquare	equ 4081h
_fpsub		equ 406fh
_frac		equ 4093h

_get_tok_strng	EQU 4594h
_getbasever	equ 4c6fh
_getcsc		equ 4018h
_getkey		equ 4972h
_getltoop1	equ 4636h
_getmtoop1	equ 4615h
_getsysinfo equ 50ddh ; v.1.13+ only
_gettoklen	equ 4591h
_grbufclr	equ 4bd0h
_grbufcpy	equ 486ah
_grphcirc	equ 47d7h

_hltimes9	equ 40f9h
_horizcmd	equ 48a6h
_htimesl	equ 4276h

_ibounds	equ 4c60h
_iboundsfull	equ 4d98h
_iline		equ 47e0h
_inclstsize	equ 4a29h
_insertlist	equ 4a2ch
_insertmem	equ 42f7h
_int		equ 40a5h
_intgr		equ 405dh
_invcmd		equ 48c7h
_invertrect	equ 4d5fh
_invop1s	equ 408dh
_invop1sc	equ 408ah
_invop2s	equ 4090h
_invsub		equ 4063h
_ioffset	equ 4c63h
_ipoint		equ 47e3h
_isa2bytetok	equ 42A3h
_iseditempty	equ 492Dh

_jerror		equ 44d7h
_jerrorno	equ 4000h
_jforcecmdnochar	equ 4027h
_jforcegraphkey	equ 5005h
_jforcegraphnokey	equ 5002h

_keytostring	equ 45cah

_lcd_busy	equ 4051h
_lcd_driveron	equ 4978h
_ldhlind	equ 4009h
_linecmd	equ 48ach
_lnx		equ 40abh
_load_sfont	equ 4783h
_loadcindpaged	equ 501dh
_loaddeindpaged	equ 501ah
_loadpattern	equ 4cb1h
_logx		equ 40aeh

_max		equ 4057h
_memchk		equ 42e5h
_memclear	equ 4c30h
_memset		equ 4c33h
_min		equ 4054h
_minus1		equ 406ch
_mov10b		equ 415ch
_mov18b		equ 47dah
_mov7b		equ 4168h
_mov8b		equ 4165h
_mov9b		equ 415fh
_mov9op1op2	equ 417dh
_mov9op2cp	equ 410bh
_mov9toop1	equ 417ah
_mov9toop2	equ 4180h
_movfrop1	equ 4183h

_newline	equ 452eh
_nzif83plus	equ 50e0h  ; v. 1.13+ only

_onevar		equ 4ba3h
_op1exop2	equ 421fh
_op1exop3	equ 4219h
_op1exop4	equ 421ch
_op1exop5	equ 420dh
_op1exop6	equ 4210h
_op1exptodec	equ 4252h
_op1set0	equ 41bfh
_op1set1	equ 419bh
_op1set2	equ 41a7h
_op1set3	equ 41a1h
_op1set4	equ 419eh
_op1toop2	equ 412fh
_op1toop3	equ 4123h
_op1toop4	equ 4117h
_op1toop5	equ 4153h
_op1toop6	equ 4150h
_op2exop4	equ 4213h
_op2exop5	equ 4216h
_op2exop6	equ 4207h
_op2set0	equ 41bch
_op2set1	equ 41adh
_op2set2	equ 41aah
_op2set3	equ 4198h
_op2set4	equ 4195h
_op2set5	equ 418fh
_op2set60	equ 4ab0h
_op2set8	equ 418ch
_op2seta	equ 4192h
_op2toop1	equ 4156h
_op2toop3	equ 416eh
_op2toop4	equ 411ah
_op2toop5	equ 414ah
_op2toop6	equ 414dh
_op3set0	equ 41b9h
_op3set1	equ 4189h
_op3set2	equ 41a4h
_op3toop1	equ 413eh
_op3toop2	equ 4120h
_op3toop4	equ 4114h
_op3toop5	equ 4147h
_op4set0	equ 41b6h
_op4set1	equ 4186h
_op4toop1	equ 4138h
_op4toop2	equ 411dh
_op4toop3	equ 4171h
_op4toop5	equ 4144h
_op4toop6	equ 4177h
_op5exop6	equ 420ah
_op5set0	equ 41b3h
_op5toop1	equ 413bh
_op5toop2	equ 4126h
_op5toop3	equ 4174h
_op5toop4	equ 412ch
_op5toop6	equ 4129h
_op6toop1	equ 4135h
_op6toop2	equ 4132h
_op6toop5	equ 4141h
_outputexpr	equ 4bb2h

_pagedget	equ 5023h
_parseinp	equ 4a9bh
_pdspgrph	equ 48a3h
_pixeltest	equ 48b5h
_plus1		equ 4069h
_pointcmd	equ 48b2h
_pointon	equ 4c39h
_popmcplxo1	equ 436fh
_popop1		equ 437eh
_popop3		equ 437bh
_popop5		equ 4378h
_popreal	equ 4393h
_poprealo1	equ 4390h
_poprealo2	equ 438dh
_poprealo3	equ 438ah
_poprealo4	equ 4387h
_poprealo5	equ 4384h
_poprealo6	equ 4381h
_posno0int	equ 422eh
_ptor		equ 40f3h
_pushmcplxo1	equ 43cfh
_pushmcplxO3	equ 43C6h
_pushop1	equ 43c9h
_pushop3	equ 43c3h
_pushop5	equ 43c0h
_pushreal	equ 43bdh
_pushrealo1	equ 43bah
_pushrealo2	equ 43b7h
_pushrealo3	equ 43b4h
_pushrealo4	equ 43b1h
_pushrealo5	equ 43aeh
_pushrealo6	equ 43abh
_putaway	equ 4039h
_putc		equ 4504h
_putmap		equ 4501h
_putps		equ 4510h
_putpsb		equ 450dh
_puts		equ 450ah
_puttokstring	equ 4960h
_puttol		equ 4645h
_puttomat	equ 461eh

_randinit	equ 4b7fh
_random		equ 4b79h
_rcl_statvar	equ 42dch
_rclans		equ 4ad7h
_rclgdb2	equ 47d1h
_rcln		equ 4addh
_rclsystok	equ 4ae6h
_rclvarsym	equ 4ae3h
_rclx		equ 4ae0h
_rcly		equ 4adah
_rec1stbyte	equ 4efah
_rec1stbytenc	equ 4efdh
_recabyteio	equ 4f03h
_redimmat	equ 4a26h
_regraph	equ 488eh
_releasebuffer	equ 4771h
_reloadappentryvecs	equ 4c36h
_restoredisp	equ 4870h
_rname		equ 427fh
_rndguard	equ 409fh
_rnfx		equ 40a2h
_round		equ 40a8h
_rtod		equ 4078h
_rtop		equ 40f6h
_runindicoff	equ 4570h
_runindicon	equ 456dh

_savedisp	equ 4c7bh
_sendabyte	equ 4ee5h
_sendvarcmd	equ 4A14h
_setallplots	equ 4fcch
_setexspeed 	equ 50bfh ; v. 1.13+ only
_setfuncm	equ 4840h
_setnorm_vals	equ 49fch
_setparm	equ 4849h
_setpolm	equ 4846h
_setseqm	equ 4843h
_settblgraphdraw	equ 4c00h
_setuppagedptr	equ 5020h
_setxxop1	equ 478ch
_setxxop2	equ 478fh
_setxxxxop2	equ 4792h
_sfont_len	equ 4786h
_sin		equ 40bdh
_sincosrad	equ 40bah
_sinh		equ 40cfh
_sinhcosh	equ 40c6h
_sqroot		equ 409ch
_srchvlstdn	equ 4f12h
_srchvlstup	equ 4f0fh
_sstringlength	equ 4cb4h
_stmatel	equ 4ae9h
_stoans		equ 4abfh
_stogdb2	equ 47ceh
_ston		equ 4acbh
_stoother	equ 4ad4h
_stor		equ 4ac5h
_storand	equ 4b7ch
_stosystok	equ 4abch
_stot		equ 4aceh
_stotheta	equ 4ac2h
_stox		equ 4ad1h
_stoy		equ 4ac8h
_strcopy	equ 44e3h
_strlength	equ 4c3fh   

_tan		equ 40c3h
_tanh		equ 40c9h
_tanlnf		equ 48bbh
_tenx		equ 40b7h
_thetaname	equ 427ch
_threeexec	equ 4675h
_times2		equ 4066h
_timespt5	equ 407eh
_tname		equ 428eh
_tofrac		equ 4657h
_trunc		equ 4060h
_twovarset	equ 50D4h

_uclines	equ 4795h
_unlinecmd	equ 48afh
_unopexec	equ 4672h

_vertcmd	equ 48a9h
_vputmap	equ 455eh
_vputs		equ 4561h
_vputsn		equ 4564h
_vtowhlde	equ 47fbh


_xftoi		equ 4804h
_xitof		equ 47feh
_xname		equ 4288h
_xrooty		equ 479eh

_yftoi		equ 4801h
_yname		equ 428bh
_ytox		equ 47a1h

_zero16d	equ 41b0h
_zeroop		equ 41ceh
_zeroop1	equ 41c5h
_zeroop2	equ 41c8h
_zeroop3	equ 41cbh
_zmdecml	equ 484fh
_zmfit		equ 485bh
_zmint		equ 484ch
_zmprev		equ 4852h
_zmsquare	equ 485eh
_zmstats	equ 47a4h
_zmtrig		equ 4861h
_zmusr		equ 4855h
_zoodefault	equ 4867h
;
;======================================================================
;           system-defined ram variable address equates
;======================================================================
;

ramstart             equ  8000h
appdata              equ  8000h
ramcode              equ  8100h
ramcodeend           equ  822fh
baseappbrtab         equ  8230h
boottemp             equ  8251h
appsearchpage        equ  82a3h
tempswaparea         equ  82a5h
appid                equ  838dh
ramreturndata        equ  83edh
arcinfo              equ  83eeh
savedarcinfo         equ  8406h
appinfo              equ  8432h
appbank_jump         equ  843ch
apppage              equ  843eh
kbdscancode          equ  843fh
kbdkey               equ  8444h
kbdgetky             equ  8445h
keyextend            equ  8446h
contrast             equ  8447h
apdsubtimer          equ  8448h
apdtimer             equ  8449h
curtime              equ  844ah
currow               equ  844bh
curcol               equ  844ch
curoffset            equ  844dh
curunder             equ  844eh
cury                 equ  844fh
curtype              equ  8450h
curxrow              equ  8451h
prevddata            equ  8452h
lfont_record         equ  845ah
sfont_record         equ  8462h
tokvarptr            equ  846ah
toklen               equ  846ch
indicmem             equ  846eh
indiccounter         equ  8476h
indicbusy            equ  8477h
op1                  equ  8478h
op1m                 equ  847ah
op2                  equ  8483h
op2m                 equ  8485h
op2ext               equ  848ch
op3                  equ  848eh
op3m                 equ  8490h
op4                  equ  8499h
op4m                 equ  849bh
op5                  equ  84a4h
op5m                 equ  84a6h
op6                  equ  84afh
op6m                 equ  84b1h
op6ext               equ  84b8h
progtoedit           equ  84bfh
namebuff             equ  84c7h
equ_edit_save        equ  84d2h
imathptr1            equ  84d3h
imathptr2            equ  84d5h
imathptr3            equ  84d7h
imathptr4            equ  84d9h
imathptr5            equ  84dbh
chkdelptr1           equ  84ddh
chkdelptr2           equ  84dfh
insdelptr            equ  84e1h
updownptr            equ  84e3h
foutdat              equ  84e5h
asm_data_ptr1        equ  84ebh
asm_data_ptr2        equ  84edh
asm_sym_ptr1         equ  84efh
asm_sym_ptr2         equ  84f1h
asm_ram              equ  84f3h
asm_ind_call         equ  8507h
textshadow           equ  8508h
textshadcur          equ  8588h
textshadtop          equ  858ah
textshadalph         equ  858bh
textshadins          equ  858ch
cxmain               equ  858dh
cxpputaway           equ  858fh
cxputaway            equ  8591h
cxredisp             equ  8593h
cxerrorep            equ  8595h
cxsizewind           equ  8597h
cxpage               equ  8599h
cxcurapp             equ  859ah
cxprev               equ  859bh
monqh                equ  85aah
monqt                equ  85abh
monqueue             equ  85ach
onsp                 equ  85bch
promptrow            equ  85c0h
promptcol            equ  85c1h
promptins            equ  85c2h
promptshift          equ  85c3h
promptret            equ  85c4h
promptvalid          equ  85c6h
prompttop            equ  85c8h
promptcursor         equ  85cah
prompttail           equ  85cch
promptbtm            equ  85ceh
vartype              equ  85d0h
varcurrent           equ  85d1h
varclass             equ  85d9h
menuactive           equ  85dch
menuappdepth         equ  85ddh
menucurrent          equ  85deh
progcurrent          equ  85e8h
usermenusa           equ  85feh
ioprompt             equ  865fh
dimagewidth          equ  8660h
rectfillpheight      equ  8660h
rectfillpwidth       equ  8661h
rectfillpattern      equ  8662h
ioflag               equ  8670h
sndrecstate          equ  8672h
ioerrstate           equ  8673h
header               equ  8674h
iodata               equ  867dh
ionewdata            equ  8689h
bakheader            equ  868bh
pencol               equ  86d7h
penrow               equ  86d8h
rclqueue             equ  86d9h
rclqueueend          equ  86dbh
errno                equ  86ddh
errsp                equ  86deh
erroffset            equ  86e0h
savesscreen          equ  86ech
bstcounter           equ  89eeh
flags                equ  89f0h
statvars             equ  8a3ah
anovaf_vars          equ  8c17h
infvars              equ  8c4dh
curgstyle            equ  8d17h
curgy                equ  8d18h
curgx                equ  8d19h
curgy2               equ  8d1ah
curgx2               equ  8d1bh
freesavey            equ  8d1ch
freesavex            equ  8d1dh
xoffset              equ  8da1h
yoffset              equ  8da2h
lcdtallp             equ  8da3h
pixwidep             equ  8da4h
pixwide_m_1          equ  8da5h
pixwide_m_2          equ  8da6h
lastentryptr         equ  8da7h
lastentrystk         equ  8da9h
numlastentries       equ  8e29h
currlastentry        equ  8e2ah
curinc               equ  8e67h
uxmin                equ  8e7eh
uxmax                equ  8e87h
uxscl                equ  8e90h
uymin                equ  8e99h
uymax                equ  8ea2h
uyscl                equ  8eabh
uthetmin             equ  8eb4h
uthetmax             equ  8ebdh
uthetstep            equ  8ec6h
utmin                equ  8ecfh
utmax                equ  8ed8h
utstep               equ  8ee1h
uplotstart           equ  8eeah
unmax                equ  8ef3h
uu0                  equ  8efch
uv0                  equ  8f05h
unmin                equ  8f0eh
uu02                 equ  8f17h
uv02                 equ  8f20h
uw0                  equ  8f29h
uplotstep            equ  8f32h
uxres                equ  8f3bh
uw02                 equ  8f44h
xmin                 equ  8f50h
xmax                 equ  8f59h
xscl                 equ  8f62h
ymin                 equ  8f6bh
ymax                 equ  8f74h
yscl                 equ  8f7dh
thetamin             equ  8f86h
thetamax             equ  8f8fh
thetastep            equ  8f98h
tminpar              equ  8fa1h
tmaxpar              equ  8faah
tstep                equ  8fb3h
plotstart            equ  8fbch
nmax                 equ  8fc5h
u0                   equ  8fceh
v0                   equ  8fd7h
nmin                 equ  8fe0h
u02                  equ  8fe9h
v02                  equ  8ff2h
w0                   equ  8ffbh
plotstep             equ  9004h
xreso                equ  900dh
w02                  equ  9016h
un1                  equ  901fh
un2                  equ  9028h
vn1                  equ  9031h
vn2                  equ  903ah
wn1                  equ  9043h
wn2                  equ  904ch
fin_n                equ  9055h
fin_i                equ  905eh
fin_pv               equ  9067h
fin_pmt              equ  9070h
fin_fv               equ  9079h
fin_py               equ  9082h
fin_cy               equ  908bh
cal_n                equ  9094h
cal_i                equ  909dh
cal_pv               equ  90a6h
cal_pmt              equ  90afh
cal_fv               equ  90b8h
cal_py               equ  90c1h
smalleditram         equ  90d3h
xfact                equ  913fh
yfact                equ  9148h
xres_int             equ  9151h
deltax               equ  9152h
deltay               equ  915bh
shortx               equ  9164h
shorty               equ  916dh
lower                equ  9176h
upper                equ  917fh
xoutsym              equ  918ch
xoutdat              equ  918eh
youtsym              equ  9190h
youtdat              equ  9192h
inputsym             equ  9194h
inputdat             equ  9196h
prevdata             equ  9198h
tblmin               equ  92b3h
tblstep              equ  92bch
p1type		     EQU  92C9h
savx1list	     EQU  92CAh
savy1iist	     EQU  92CFh
savf1list	     EQU  92D4h
p1frqonoff	     EQU  92D9h
p2type		     EQU  92DAh
savx2list	     EQU  92DBh
savy2list	     EQU  92E0h
savf2list	     EQU  92E5h
p2frqonoff	     EQU  92EAh
p3type		     EQU  92EBh	
savx3list	     EQU  92ECh
savy3list	     EQU  92F1h
savf3list	     EQU  92F6h
p3frqonoff	     EQU  92FBh

plotsscreen          equ  9340h
seed1                equ  9640h
seed2                equ  9649h
cmdshadow            equ  966eh
cmdshadcur           equ  96eeh
cmdshadalph          equ  96f0h
cmdshadins           equ  96f1h
cmdcursor            equ  96f2h
edittop              equ  96f4h
editcursor           equ  96f6h
edittail             equ  96f8h
editbtm              equ  96fah
editsym              equ  9706h
editdat              equ  9708h
wintop               equ  97a5h
winbtm               equ  97a6h
winleftedge          equ  97a7h
winleft              equ  97a8h
winabove             equ  97aah
winrow               equ  97ach
wincol               equ  97aeh
fmtdigits            equ  97b0h
fmtstring            equ  97b1h
fmtconv              equ  97f2h
fmtleft              equ  9804h
fmtindex             equ  9806h
fmtmatsym            equ  9808h
fmtmatmem            equ  980ah
eqs                  equ  980ch
tsymptr1             equ  9818h
tsymptr2             equ  981ah
chkdelptr3           equ  981ch
chkdelptr4           equ  981eh
tempmem              equ  9820h
fpbase               equ  9822h
fps                  equ  9824h
opbase               equ  9826h
ops                  equ  9828h
ptempcnt             equ  982ah
cleantmp             equ  982ch
ptemp                equ  982eh
progptr              equ  9830h
newdataptr           equ  9832h
pagedcount           equ  9834h
pagedpn              equ  9835h
pagedgetptr          equ  9836h
pagedputptr          equ  9838h
pagedbuf             equ  983ah
apperr1              equ  984dh
apperr2              equ  985ah
flashbyte1           equ  9867h
flashbyte2           equ  9868h
freearcblock         equ  9869h
arcpage              equ  986bh
arcptr               equ  986ch
apprawkeyhandle      equ  9870h
appbackupscreen      equ  9872h
customheight         equ  9b72h
locallanguage        equ  9b73h
cursorhookptr        equ  9b7ch
rawkeyhookptr        equ  9b84h
getkeyhookptr        equ  9b88h
fonthookptr          equ  9b9ch
restartclr           equ  9bd0h
localtokstr          equ  9d65h
keyforstr            equ  9d76h
keytostrram          equ  9d77h
sedmonsp             equ  9d88h
bpsave               equ  9d8ah
usermem              equ  9d95h
symtable             equ  0fe66h

;symbolic_debug_end
;
;======================================================================
;		language localization equates
;======================================================================
lang_neutral                       equ   00h
lang_danish                        equ   06h
lang_dutch                         equ   13h
lang_english                       equ   09h
lang_finnish                       equ   0bh
lang_french                        equ   0ch
lang_german                        equ   07h
lang_hungarian                     equ   0eh
lang_italian                       equ   10h
lang_norwegian                     equ   14h
lang_polish                        equ   15h
lang_portuguese                    equ   16h
lang_spanish                       equ   0ah
lang_swedish                       equ   1dh

sublang_neutral                    equ   00h   ; language neutral
sublang_dutch                    equ   01h   ; dutch
sublang_english_us               equ   01h   ; english (usa)
sublang_french                   equ   01h   ; french
sublang_german                   equ   01h   ; german
sublang_italian                  equ   01h   ; italian
sublang_norwegian_bokmal         equ   01h   ; norwegian (bokmal)
sublang_portuguese               equ   02h   ; portuguese
sublang_spanish                  equ   01h   ; spanish (castilian)

;======================================================================
;           system and state flags
;======================================================================
;

trigflags	equ  0		;trigonometry mode settings
trigdeg 	equ    2	; 1=degrees, 0=radians

kbdflags	equ  0		;keyboard scan
kbdscr		equ    3	; 1=scan code ready
kbdkeypress	equ    4	; 1=key has been pressed

doneflags	equ  0		;display "done"
doneprgm	equ    5	; 1=display "done" after prgm

iodelflag	equ  0
indelete	equ    0	;1 = delete screen 

;----------------------------------------------------------------------
editflags	equ  1
editopen	equ    2	; 1=edit buffer is open

monflags	equ  1		;monitor flags
monabandon	equ    4	; 1=don't start any long process
				; in put away (#715)
;----------------------------------------------------------------------
plotflags	equ  2		;plot generation flags
plotloc 	equ    1	; 0=bkup & display, 1=display only
plotdisp	equ    2	; 1=plot is in display, 0=text in display


grfmodeflags	equ  2		;graph mode settings
grffuncm	equ    4	; 1=function graph
grfpolarm	equ    5	; 1=polar graph
grfparamm	equ    6	; 1=parametric graph
grfrecurm       equ    7        ; 1=recursion graph

graphflags	equ  3
graphdraw	equ    0	; 0=graph is valid, 1=redraw graph

grfdbflags	equ  4
grfdot		equ    0	; 0=line, 1=dot
grfsimul	equ    1	; 0=sequential, 1=simultaneous
grfgrid 	equ    2	; 0=no grid, 1=grid
grfpolar	equ    3	; 0=rectangular, 1=polar coordinates
grfnocoord	equ    4	; 0=display coordinates, 1=off
grfnoaxis	equ    5	; 0=axis, 1=no axis
grflabel	equ    6	; 0=off, 1=axis label

textflags	equ  5		;text output flags
texterasebelow	equ    1	; 1=erase line below small char
textscrolled	equ    2	; 1=screen scrolled
textinverse	equ    3	; 1=display inverse bit-map
textinsmode	equ    4	; 0=overstrike, 1=insert mode

parsflag2	equ  7		;parser flags
numop1		equ    0	; 1=result in op1, 0=no result

newdispf        equ  8		;derivative mode flags
preclrformode   equ    0	; 1=help blink on mode screen

apdflags	equ  8		;automatic power-down
apdable 	equ    2	; 1=apd enabled
apdrunning	equ    3	; 1=apd clock running


web_err_mask    equ  60h

onflags 	equ  9		;on key flags
onrunning	equ  3		; 1 = calculator is running
oninterrupt	equ    4	; 1=on key interrupt request

statflags	equ  9		;statistics flags
statsvalid	equ    6	; 1=stats are valid
statansdisp	equ  7		; 1=display stat results

fmtflags	equ  10		;numeric format flags
fmtexponent	equ    0	; 1=show exponent, 0=no exponent
fmteng		equ    1	; 1=engineering notion, 0=scientific
fmthex		equ    2	; 1=hexadecimal
fmtoct		equ    3	; 1=octal
fmtbin		equ    4	; 1=binary
;
nummode         equ  10
fmtreal         equ    5
fmtrect         equ    6
fmtpolar        equ    7

realmode        equ    5
rectmode        equ    6
polarmode       equ    7
;					;   if hex and oct both = 1
;					;   then bin=0 means >frac
;					;	 bin=1 means >dms
fmtbasemask     equ  00011100b		; mask to base flags
fmtbaseshift    equ  2			; offset to base flags
;
;       check if these are used by numform,
;
;               equ  6
;               equ  7

fmtoverride	equ  11		;copy of fmtflags with conversion override

fmteditflags	equ  12		;numeric editing flags
fmtedit 	equ    0	; 1=format number for editing

curflags	equ  12		;cursor
curable 	equ    2	; 1=cursor flash is enabled
curon		equ    3	; 1=cursor is showing
curlock 	equ    4	; 1=cursor is locked off

appflags	equ  13		;application flags
appwantintrpt	equ    0		; 1=want on key interrupts
apptextsave	equ    1		; 1=save characters in textshadow
appautoscroll	equ    2		; 1=auto-scroll text on last line
appmenus	equ    3		; 1=process keys that bring up menus
					; 0=check lock menu flag
applockmenus	equ    4		; 1=ignore menu keys
					; 0=switch to home screen and bring up menu
appcurgraphic	equ    5		; 1=graphic cursor
appcurword	equ    6		; 1=text cursor covers entire word
appexit 	equ    7		; 1=application handles [exit] key itself

appwantintrptf	equ	1<<appwantintrpt
apptextsavef	equ	1<<apptextsave
appautoscrollf	equ	1<<appautoscroll
appmenusf	equ	1<<appmenus
applockmenusf	equ	1<<applockmenus
appcurgraphicf	equ	1<<appcurgraphic
appcurwordf	equ	1<<appcurword
appexitf	equ	1<<appexit


seqflags        equ  15              ; sequential graph flags
webmode         equ    0             ; 0 = normal seq mode, 1 = web mode
webvert         equ    1             ;
sequv           equ    2             ; u vs v
seqvw           equ    3             ; v vs w
sequw           equ    4             ; u vs w


promptflags	equ  17		;prompt line flags
promptedit	equ    0	; 1=editing in prompt buffer

indicflags	equ  18		;indicator flags
indicrun	equ    0	; 1=run indicator on
indicinuse	equ    1	; indicator save area in use=1, free=0
indiconly	equ    2	; interrupt handler only checks run indicator

shiftflags	equ  18		;[2nd] and [alpha] flags
shift2nd	equ    3	; 1=[2nd] has been pressed
shiftalpha	equ    4	; 1=[alpha] has been pressed
shiftlwralph	equ    5	; 1=lower case, 0=upper case
shiftalock	equ    6	; 1=alpha lock has been pressed
shiftkeepalph	equ    7	; 1=cannot cancel alpha shift


tblflags        equ  19		;table flags.
autofill        equ    4	; 1=prompt, 0=fillauto
autocalc        equ    5	; 1=prompt, 0=calcauto
retable         equ    6	; 0=table is ok, 1=must recompute table.

sgrflags	equ  20
grfsplit        equ    0	; 1=split graph, 0=normal
vertsplit       equ    1	; 1=vertical (left-right) split
grfschanged     equ    2	; 1=graph just changed split <-> normal
grfsplitoverride equ   3	; 1 = ignore graph split flag if set
write_on_graph  equ    4	; 1 = text or equ writing to graph screen
g_style_active  equ    5	; 1 = graph styles are enabled, use them
cmp_mod_box     equ    6	; 1 = doing mod box plot computation
textwrite       equ    7
;

newindicflags   equ  21
extraindic      equ    0
saindic         equ    1

newflags2	    equ  22
norestores	    equ  5

smartflags      equ  23
;
;----------------------------------------------------------------------
; note: fix these equates if smartflags are moved                            
;----------------------------------------------------------------------
;
smarter_mask    equ  3
smarter_test    equ  1
smartgraph      equ  0
smartgraph_inv  equ  1                                                 

more_flags	EQU 26

no_del_stat	EQU 2
;----------------------------------------------------------------------
;           available for asm programming
;----------------------------------------------------------------------

asm_flag1       equ  33          ; asm coding
asm_flag2       equ  34          ; asm coding
asm_flag3       equ  35          ; asm coding

;----------------------------------------------------------------------
;
getsendflg	equ  36
comfailed	equ  1	      ; 1 = get/send communication failed
;
applwrcaseflag  equ  36
lwrcaseactive   equ  3
;
apiflg3		equ  42 
;
apiflg4		equ  43
fullscrndraw	equ    2	; draw into last row/col of screen

groupflags	equ  38
ingroup		equ  1		;1 = in group context


xapflag0        equ  46      ; external app flags
xapflag1        equ  47
xapflag2        equ  48
xapflag3        equ  49

fontflags	equ  50
fracdrawlfont	equ    2
fractalllfont	equ    3
customfont	equ    7  

plotflag3	equ  60  
bufferonly	equ    0
usefastcirc	equ    4

;
vartypemask	equ  1fh             
vargraphref	equ    6

;
;======================================================================
;           character font equates  
;======================================================================
;
; large font equates

lrecurn         equ     001h
lrecuru 	equ	002h
lrecurv 	equ	003h
lrecurw		equ	004h
lconvert	equ	005h
lsqup		equ	006h
lsqdown		equ	007h
lintegral	equ	008h
lcross		equ	009h
lboxicon 	equ     00ah
lcrossicon 	equ     00bh
ldoticon 	equ     00ch
lsubt   	equ     00dh		;small capital t for parametric mode.
lcuber  	equ     00eh		;slightly different 3 for cubed root.
lhexf		equ	00fh
lroot		equ	010h
linverse	equ	011h
lsquare		equ	012h
langle		equ	013h
ldegree		equ	014h
lradian		equ	015h
ltranspose	equ	016h
lle		equ	017h
lne		equ	018h
lge		equ	019h
lneg		equ	01ah
lexponent	equ	01bh
lstore		equ	01ch
lten		equ	01dh
luparrow	equ	01eh
ldownarrow	equ	01fh
lspace		equ	020h
lexclam		equ	021h
lquote		equ	022h
lpound		equ	023h
lfourth		equ     024h
lpercent	equ	025h
lampersand	equ	026h
lapostrophe	equ	027h
llparen		equ	028h
lrparen		equ	029h
lasterisk	equ	02ah
lplussign	equ	02bh
lcomma		equ	02ch
ldash		equ	02dh
lperiod		equ	02eh
lslash		equ	02fh
l0		equ	030h
l1		equ	031h
l2		equ	032h
l3		equ	033h
l4		equ	034h
l5		equ	035h
l6		equ	036h
l7		equ	037h
l8		equ	038h
l9		equ	039h
lcolon		equ	03ah
lsemicolon	equ	03bh
llt		equ	03ch
leq		equ	03dh
lgt		equ	03eh
lquestion	equ	03fh
latsign		equ	040h
lcapa	equ	041h
lcapb	equ	042h
lcapc	equ	043h
lcapd	equ	044h
lcape	equ	045h
lcapf	equ	046h
lcapg	equ	047h
lcaph	equ	048h
lcapi	equ	049h
lcapj	equ	04ah
lcapk	equ	04bh
lcapl	equ	04ch
lcapm	equ	04dh
lcapn	equ	04eh
lcapo	equ	04fh
lcapp	equ	050h
lcapq	equ	051h
lcapr	equ	052h
lcaps	equ	053h
lcapt	equ	054h
lcapu	equ	055h
lcapv	equ	056h
lcapw	equ	057h
lcapx	equ	058h
lcapy	equ	059h
lcapz	equ	05ah
ltheta  equ     05bh
lbackslash	equ	05ch
lrbrack		equ	05dh
lcaret		equ	05eh
lunderscore	equ	05fh
lbackquote	equ	060h
la	equ	061h
lb	equ	062h
lc	equ	063h
ld	equ	064h
le	equ	065h
lf	equ	066h
lg	equ	067h
lh	equ	068h
li	equ	069h
lj	equ	06ah
lk	equ	06bh
ll	equ	06ch
lm	equ	06dh
ln	equ	06eh
lo	equ	06fh
lp	equ	070h
lq	equ	071h
lr	equ	072h
ls	equ	073h
lt	equ	074h
lu	equ	075h
lv	equ	076h
lw	equ	077h
lx	equ	078h
ly	equ	079h
lz	equ	07ah
llbrace	equ	07bh
lbar	equ	07ch
lrbrace	equ	07dh
ltilde	equ	07eh
linveq	equ	07fh
lsub0	equ	080h
lsub1	equ	081h
lsub2	equ	082h
lsub3	equ	083h
lsub4	equ	084h
lsub5	equ	085h
lsub6	equ	086h
lsub7	equ	087h
lsub8	equ	088h
lsub9	equ	089h
lcapaacute	equ	08ah
lcapagrave	equ	08bh
lcapacaret	equ	08ch
lcapadier	equ	08dh
laacute		equ	08eh
lagrave		equ	08fh
lacaret		equ	090h
ladier		equ	091h
lcapeacute	equ	092h
lcapegrave	equ	093h
lcapecaret	equ	094h
lcapedier	equ	095h
leacute		equ	096h
legrave		equ	097h
lecaret		equ	098h
ledier		equ	099h
lcapiacute	equ	09ah
lcapigrave	equ	09bh
lcapicaret	equ	09ch
lcapidier	equ	09dh
liacute		equ	09eh
ligrave		equ	09fh
licaret		equ	0a0h
lidier		equ	0a1h
lcapoacute	equ	0a2h
lcapograve	equ	0a3h
lcapocaret	equ	0a4h
lcapodier	equ	0a5h
loacute		equ	0a6h
lograve		equ	0a7h
locaret		equ	0a8h
lodier		equ	0a9h
lcapuacute	equ	0aah
lcapugrave	equ	0abh
lcapucaret	equ	0ach
lcapudier	equ	0adh
luacute		equ	0aeh
lugrave		equ	0afh
lucaret		equ	0b0h
ludier		equ	0b1h
lcapcced	equ	0b2h
lcced		equ	0b3h
lcapntilde	equ	0b4h
lntilde		equ	0b5h
laccent		equ	0b6h
lgrave		equ	0b7h
ldieresis	equ	0b8h
lquesdown	equ	0b9h
lexclamdown	equ	0bah
lalpha		equ	0bbh
lbeta		equ	0bch
lgamma		equ	0bdh
lcapdelta	equ	0beh
ldelta		equ	0bfh
lepsilon	equ	0c0h
llbrack 	equ     0c1h
llambda		equ	0c2h
lmu		equ	0c3h
lpi		equ	0c4h
lrho		equ	0c5h
lcapsigma	equ	0c6h
lsigma		equ	0c7h
ltau		equ	0c8h
lphi		equ	0c9h
lcapomega	equ	0cah
lxmean		equ	0cbh
lymean		equ	0cch
lsupx		equ	0cdh
lellipsis	equ	0ceh
lleft		equ	0cfh
lblock		equ	0d0h
lper		equ	0d1h
lhyphen		equ	0d2h
larea		equ	0d3h
ltemp		equ	0d4h
lcube		equ	0d5h
lenter		equ	0d6h
limagi		equ	0d7h
lphat		equ	0d8h
lchi		equ	0d9h
lstatf		equ     0dah
llne		equ	0dbh
llistl		equ	0dch
lfinann 	equ	0ddh
l2_r_paren 	equ	0deh
lblockarrow     equ     0dfh
lcuro   	equ     0e0h
lcuro2  	equ     0e1h
lcurocapa       equ     0e2h
lcuroa  	equ     0e3h
lcuri   	equ     0e4h
lcuri2  	equ     0e5h
lcuricapa       equ     0e6h
lcuria  	equ     0e7h
lgline          equ     0e8h    ; = 0
lgthick         equ     0e9h    ; = 1
lgabove         equ     0eah    ; = 2
lgbelow         equ     0ebh    ; = 3
lgpath          equ     0ech    ; = 4
lganimate       equ     0edh    ; = 5
lgdot           equ     0eeh    ; = 6
lupblk          equ     0efh    ;up arrow and block in solver
ldnblk          equ     0f0h    ;down arrow and block in solver
lcurfull        equ     0f1h    ;note: must be last char (putmap checks)
;
; small font equates
;
srecurn         equ     001h
srecuru		equ	002h
srecurv		equ	003h
srecurw		equ	004h
sconvert	equ	005h
sfourspaces 	equ 	006h
ssqdown		equ	007h
sintegral	equ	008h
scross		equ	009h
sboxicon 	equ	00ah
scrossicon 	equ	00bh
sdoticon 	equ    	00ch
ssubt   	equ     00dh
scuber  	equ     00eh
shexf		equ	00fh
sroot		equ	010h
sinverse	equ	011h
ssquare		equ	012h
sangle		equ	013h
sdegree		equ	014h
sradian		equ	015h
stranspose	equ	016h
sle		equ	017h
sne		equ	018h
sge		equ	019h
sneg		equ	01ah
sexponent	equ	01bh
sstore		equ	01ch
sten		equ	01dh
suparrow	equ	01eh
sdownarrow	equ	01fh
sspace		equ	020h
sexclam		equ	021h
squote		equ	022h
spound		equ	023h
sdollar		equ	024h
spercent	equ	025h
sampersand	equ	026h
sapostrophe	equ	027h
slparen		equ	028h
srparen		equ	029h
sasterisk	equ	02ah
splussign	equ	02bh
scomma		equ	02ch
sdash		equ	02dh
speriod		equ	02eh
sslash		equ	02fh
s0		equ	030h
s1		equ	031h
s2		equ	032h
s3		equ	033h
s4		equ	034h
s5		equ	035h
s6		equ	036h
s7		equ	037h
s8		equ	038h
s9		equ	039h
scolon		equ	03ah
ssemicolon	equ	03bh
slt		equ	03ch
seq		equ	03dh
sgt		equ	03eh
squestion	equ	03fh
satsign		equ	040h
scapa		equ	041h
scapb		equ	042h
scapc		equ	043h
scapd		equ	044h
scape		equ	045h
scapf		equ	046h
scapg		equ	047h
scaph		equ	048h
scapi		equ	049h
scapj		equ	04ah
scapk		equ	04bh
scapl		equ	04ch
scapm		equ	04dh
scapn		equ	04eh
scapo		equ	04fh
scapp		equ	050h
scapq		equ	051h
scapr		equ	052h
scaps		equ	053h
scapt		equ	054h
scapu		equ	055h
scapv		equ	056h
scapw		equ	057h
scapx		equ	058h
scapy		equ	059h
scapz		equ	05ah
stheta  	equ     05bh
sbackslash	equ	05ch
srbrack		equ	05dh
scaret		equ	05eh
sunderscore	equ	05fh
sbackquote	equ	060h
smalla		equ	061h
smallb		equ	062h
smallc		equ	063h
smalld		equ	064h
smalle		equ	065h
smallf		equ	066h
smallg		equ	067h
smallh		equ	068h
smalli		equ	069h
smallj		equ	06ah
smallk		equ	06bh
smalll		equ	06ch
smallm		equ	06dh
smalln		equ	06eh
smallo		equ	06fh
smallp		equ	070h
smallq		equ	071h
smallr		equ	072h
smalls		equ	073h
smallt		equ	074h
smallu		equ	075h
smallv		equ	076h
smallw		equ	077h
smallx		equ	078h
smally		equ	079h
smallz		equ	07ah
slbrace		equ	07bh
sbar		equ	07ch
srbrace		equ	07dh
stilde		equ	07eh
sinveq		equ	07fh
ssub0		equ	080h
ssub1		equ	081h
ssub2		equ	082h
ssub3		equ	083h
ssub4		equ	084h
ssub5		equ	085h
ssub6		equ	086h
ssub7		equ	087h
ssub8		equ	088h
ssub9		equ	089h
scapaacute	equ	08ah
scapagrave	equ	08bh
scapacaret	equ	08ch
scapadier	equ	08dh
saacute		equ	08eh
sagrave		equ	08fh
sacaret		equ	090h
sadier		equ	091h
scapegrave	equ	092h
scapeacute	equ	093h
scapecaret	equ	094h
scapedier	equ	095h
seacute		equ	096h
segrave		equ	097h
secaret		equ	098h
sedier		equ	099h
scapiacute	equ	09ah
scapigrave	equ	09bh
scapicaret	equ	09ch
scapidier	equ	09dh
siacute		equ	09eh
sigrave		equ	09fh
sicaret		equ	0a0h
sidier		equ	0a1h
scapoacute	equ	0a2h
scapograve	equ	0a3h
scapocaret	equ	0a4h
scapodier	equ	0a5h
soacute		equ	0a6h
sograve		equ	0a7h
socaret		equ	0a8h
sodier		equ	0a9h
scapuacute	equ	0aah
scapugrave	equ	0abh
scapucaret	equ	0ach
scapudier	equ	0adh
suacute		equ	0aeh
sugrave		equ	0afh
sucaret		equ	0b0h
sudier		equ	0b1h
scapcced	equ	0b2h
scced		equ	0b3h
scapntilde	equ	0b4h
sntilde		equ	0b5h
saccent		equ	0b6h
sgrave		equ	0b7h
sdieresis	equ	0b8h
squesdown	equ	0b9h
sexclamdown	equ	0bah
salpha		equ	0bbh
sbeta		equ	0bch
sgamma		equ	0bdh
scapdelta	equ	0beh
sdelta		equ	0bfh
sepsilon	equ	0c0h
slbrack 	equ     0c1h
slambda		equ	0c2h
smu		equ	0c3h
spi		equ	0c4h
srho		equ	0c5h
scapsigma	equ	0c6h
ssigma		equ	0c7h
stau		equ	0c8h
sphi		equ	0c9h
scapomega	equ	0cah
sxmean		equ	0cbh
symean		equ	0cch
ssupx		equ	0cdh
sellipsis	equ	0ceh
sleft		equ	0cfh
sblock		equ	0d0h
sper		equ	0d1h
shyphen		equ	0d2h
sarea		equ	0d3h
stemp		equ	0d4h
scube		equ	0d5h
senter		equ	0d6h
simagi		equ	0d7h
sphat		equ	0d8h
schi		equ	0d9h
sstatf  	equ     0dah
slne		equ	0dbh
slistl		equ	0dch
sfinann 	equ	0ddh
s2_r_paren 	equ	0deh
snarrowcape     equ     0dfh
slistlock 	equ	0e0h
sscatter1 	equ	0e1h                    
sscatter2 	equ	0e2h                    
sxyline1  	equ	0e3h                    
sxyline2  	equ	0e4h
sboxplot1 	equ	0e5h
sboxplot2 	equ	0e6h
shist1    	equ	0e7h
shist2    	equ	0e8h
smodbox1  	equ	0e9h
smodbox2  	equ	0eah
snormal1  	equ	0ebh
snormal2  	equ	0ech
;
;======================================================================
;           keypress equates
;======================================================================
;           keyboard key names
;
;
kright          equ       001h
kleft           equ       002h
kup             equ       003h
kdown           equ       004h
kenter          equ       005h
kalphaenter     equ       006h
kalphaup        equ       007h
kalphadown      equ       008h
kclear          equ       009h
kdel            equ       00ah
kins            equ       00bh
krecall         equ       00ch
klastent        equ       00dh
kbol            equ       00eh
keol            equ       00fh
;
kselall         equ       010h
kunselall       equ       011h
kltoti82        equ       012h
kbackup         equ       013h
krecieve        equ       014h
klnkquit        equ       015h
ktrans          equ       016h
krename         equ       017h
koverw          equ       018h
komit           equ       019h
kcont           equ       01ah
ksendid         equ       01bh
ksendsw         equ       01ch
kyes            equ       01dh
knoway          equ       01eh
kvsendtype      equ       01fh
koverwall       equ       020h
;
kno             equ       025h
kkreset         equ       026h
kapp            equ       027h
;
kdoug           equ       028h
klistflag       equ       029h
menustart       equ       02bh
;
kareyousure     equ       02bh
kappsmenu       equ       02ch
kprgm           equ       02dh
kzoom           equ       02eh
kdraw           equ       02fh
ksplot          equ       030h
kstat           equ       031h
kmath           equ       032h
ktest           equ       033h
kchar           equ       034h
kvars           equ       035h
kmem            equ       036h
kmatrix         equ       037h
kdist           equ       038h
kangle          equ       039h
klist           equ       03ah
kcalc           equ       03bh
kfin            equ       03ch
;
menuend         equ       kfin
;
kcatalog        equ       03eh
kinputdone      equ       03fh
koff            equ       kinputdone
;
kquit           equ       040h
appstart        equ       kquit

;
klinkio         equ       041h
kmatrixed       equ       042h
kstated         equ       043h
kgraph          equ       044h
kmode           equ       045h
kprgmed         equ       046h        ; program edit
kprgmcr         equ       047h        ; program create
kwindow         equ       048h        ; range editor
kyequ           equ       049h        ; equation editor
ktable          equ       04ah        ; table editor
ktblset         equ       04bh        ; table set
kchkram         equ       04ch        ; check ram
kdelmem         equ       04dh        ; delete mem
kresetmem       equ       04eh        ; reset mem
kresetdef	equ	  04fh        ; reset default
kprgminput      equ       050h        ; program input
kzfacted        equ       051h        ; zoom factor editor
kerror          equ       052h        ; error
ksolvetvm       equ       053h        ; tvm solver
ksolveroot	equ	  054h        ; solve editor
kstatp          equ       055h        ; stat plot
kinfstat 	equ	  056h	      ; inferential statistic
kformat         equ       057h        ; format
kextapps        equ       058h        ; external applications.     new
knewapps        equ       059h        ; new apps for cerberus.
;
append          equ       knewapps
;
echostart1      equ       05ah
;
ktrace          equ       05ah
kzfit           equ       05bh
kzin            equ       05ch
kzout           equ       05dh
kzprev          equ       05eh
kbox            equ       05fh
kdecml          equ       060h
ksetzm          equ       061h
ksquar          equ       062h
kstd            equ       063h
ktrig           equ       064h
kusrzm          equ       065h
kzsto           equ       066h
kzint           equ       067h
kzstat          equ       068h
;
echostart2      equ       069h
;
kselect         equ       069h
kcircl          equ       06ah
kcldrw          equ       06bh
kline           equ       06ch
kpen            equ       06dh
kptchg          equ       06eh
kptoff          equ       06fh
kpton           equ       070h
kvert           equ       071h
khoriz          equ       072h
ktext           equ       073h
ktanln          equ       074h
;
keval           equ       075h
kinters         equ       076h
kdydx           equ       077h
kfnintg         equ       078h
krootg          equ       079h
kdydt           equ       07ah
kdxdt           equ       07bh
kdrdo           equ       07ch
kgfmin          equ       07dh
kgfmax          equ       07eh
;
;
echostart       equ       07fh
;
klistname       equ       07fh
kadd            equ       080h
ksub            equ       081h
kmul            equ       082h
kdiv            equ       083h
kexpon          equ       084h
klparen         equ       085h
krparen         equ       086h
klbrack         equ       087h
krbrack         equ       088h
kshade          equ       089h
kstore          equ       08ah
kcomma          equ       08bh
kchs            equ       08ch
kdecpnt         equ       08dh
k0              equ       08eh
k1              equ       08fh
k2              equ       090h
k3              equ       091h
k4              equ       092h
k5              equ       093h
k6              equ       094h
k7              equ       095h
k8              equ       096h
k9              equ       097h
kee             equ       098h
kspace          equ       099h
kcapa           equ       09ah
kcapb           equ       09bh
kcapc           equ       09ch
kcapd           equ       09dh
kcape           equ       09eh
kcapf           equ       09fh
kcapg           equ       0a0h
kcaph           equ       0a1h
kcapi           equ       0a2h
kcapj           equ       0a3h
kcapk           equ       0a4h
kcapl           equ       0a5h
kcapm           equ       0a6h
kcapn           equ       0a7h
kcapo           equ       0a8h
kcapp           equ       0a9h
kcapq           equ       0aah
kcapr           equ       0abh
kcaps           equ       0ach
kcapt           equ       0adh
kcapu           equ       0aeh
kcapv           equ       0afh
kcapw           equ       0b0h
kcapx           equ       0b1h
kcapy           equ       0b2h
kcapz           equ       0b3h
kvarx           equ       0b4h
kpi             equ       0b5h
kinv            equ       0b6h
ksin            equ       0b7h
kasin           equ       0b8h
kcos            equ       0b9h
kacos           equ       0bah
ktan            equ       0bbh
katan           equ       0bch
ksquare         equ       0bdh
ksqrt           equ       0beh
kln             equ       0bfh
kexp            equ       0c0h
klog            equ       0c1h
kalog           equ       0c2h
ktoabc          equ       0c3h
;
kclrtbl         equ       0c4h
;
kans            equ       0c5h
kcolon          equ       0c6h
;
knderiv         equ       0c7h
kfnint          equ       0c8h
kroot           equ       0c9h
;
kquest          equ       0cah
kquote          equ       0cbh
ktheta          equ       0cch
kif             equ       0cdh
kthen           equ       0ceh
kelse           equ       0cfh
kfor            equ       0d0h
kwhile          equ       0d1h
krepeat         equ       0d2h
kend            equ       0d3h
kpause          equ       0d4h
klbl            equ       0d5h
kgoto           equ       0d6h
kisg            equ       0d7h
kdsl            equ       0d8h
kmenu           equ       0d9h
kexec           equ       0dah
kreturn         equ       0dbh
kstop           equ       0dch
kinput          equ       0ddh
kprompt         equ       0deh
kdisp           equ       0dfh
kdispg          equ       0e0h
kdispt          equ       0e1h
koutput         equ       0e2h
kgetkey         equ       0e3h
kclrhome        equ       0e4h
kprtscr         equ       0e5h
ksinh           equ       0e6h
kcosh           equ       0e7h
ktanh           equ       0e8h
kasinh          equ       0e9h
kacosh          equ       0eah
katanh          equ       0ebh
klbrace         equ       0ech
krbrace         equ       0edh
ki              equ       0eeh
kconstea        equ       0efh
kplot3          equ       0f0h
kfmin           equ       0f1h
kfmax           equ       0f2h
kl1a            equ       0f3h
kl2a            equ       0f4h
kl3a            equ       0f5h
kl4a            equ       0f6h
kl5a            equ       0f7h
kl6a            equ       0f8h
kuna            equ       0f9h
kvna            equ       0fah
kwna            equ       0fbh
;
;======================================================================
;       this key means that it is a 2 byte keycode
;       there are 2 of these keys; be careful with usage
;======================================================================
;
kextendecho2    equ       0fch
;
;======================================================================;
;       this key means that the key press is one that echos
;       into a buffer, and it is a 2 byte key code, go look at
;       (extecho) for the key value 
;======================================================================
;
kextendecho     equ       0feh
;

ke1bt           equ       0

kdrawinv        equ       ke1bt
kdrawf          equ       ke1bt+1
kpixelon        equ       ke1bt+2
kpixeloff       equ       ke1bt+3
kpxltest        equ       ke1bt+4
krcgdb          equ       ke1bt+5
krcpic          equ       ke1bt+6
kstgdb          equ       ke1bt+7
kstpic          equ       ke1bt+8
kabs            equ       ke1bt+9
ktequ           equ       ke1bt+10    ; ==
ktnoteq         equ       ke1bt+11    ; <>
ktgt            equ       ke1bt+12    ; >
ktgte           equ       ke1bt+13    ; > =
ktlt            equ       ke1bt+14    ; <
ktlte           equ       ke1bt+15    ; < =

kand            equ       ke1bt+16
kor             equ       ke1bt+17
kxor            equ       ke1bt+18
knot            equ       ke1bt+19

klr1            equ       ke1bt+20

kxroot          equ       ke1bt+21
kcube           equ       ke1bt+22
kcbrt           equ       ke1bt+23    ; cube root
ktodec          equ       ke1bt+24
;
kcubicr         equ       ke1bt+25
kquartr         equ       ke1bt+26
;
kplot1          equ       ke1bt+27
kplot2          equ       ke1bt+28
;

kround          equ       ke1bt+29
kipart          equ       ke1bt+30
kfpart          equ       ke1bt+31
kint            equ       ke1bt+32

krand           equ       ke1bt+33
knpr            equ       ke1bt+34
kncr            equ       ke1bt+35
kxfactorial     equ       ke1bt+36

krad            equ       ke1bt+37
kdegr           equ       ke1bt+38    ; degrees conv
kapost          equ       ke1bt+39
ktodms          equ       ke1bt+40
krtopo          equ       ke1bt+41    ; r
krtopr          equ       ke1bt+42
kptorx          equ       ke1bt+43
kptory          equ       ke1bt+44

krowswap        equ       ke1bt+45
krowplus        equ       ke1bt+46
ktimrow         equ       ke1bt+47
ktrowp          equ       ke1bt+48

ksorta          equ       ke1bt+49
ksortd          equ       ke1bt+50
kseq            equ       ke1bt+51

kmin            equ       ke1bt+52
kmax            equ       ke1bt+53
kmean           equ       ke1bt+54
kmedian         equ       ke1bt+55
ksum            equ       ke1bt+56
kprod           equ       ke1bt+57

kdet            equ       ke1bt+58
ktransp         equ       ke1bt+59
kdim            equ       ke1bt+60
kfill           equ       ke1bt+61
kident          equ       ke1bt+62
krandm          equ       ke1bt+63
kaug            equ       ke1bt+64

konevar         equ       ke1bt+65
ktwovar         equ       ke1bt+66
klr             equ       ke1bt+67
klrexp          equ       ke1bt+68
klrln           equ       ke1bt+69
klrpwr          equ       ke1bt+70
kmedmed         equ       ke1bt+71
kquad           equ       ke1bt+72
kclrlst         equ       ke1bt+73
khist           equ       ke1bt+74
kxyline         equ       ke1bt+75
kscatter        equ       ke1bt+76

kmrad           equ       ke1bt+77
kmdeg           equ       ke1bt+78
kmnormf         equ       ke1bt+79
kmsci           equ       ke1bt+80
kmeng           equ       ke1bt+81
kmfloat         equ       ke1bt+82

kfix            equ       ke1bt+83
kspliton        equ       ke1bt+84
kfullscreen     equ       ke1bt+85
kstndrd         equ       ke1bt+86
kparam          equ       ke1bt+87
kpolar          equ       ke1bt+88
kseqg           equ       ke1bt+89
kafillon        equ       ke1bt+90
kafilloff       equ       ke1bt+91
kacalcon        equ       ke1bt+92
kacalcoff       equ       ke1bt+93
kfnon           equ       ke1bt+94
kfnoff          equ       ke1bt+95

kplotson        equ       ke1bt+96
kplotsoff       equ       ke1bt+97

kpixelchg       equ       ke1bt+98

ksendmbl        equ       ke1bt+99
krecvmbl        equ       ke1bt+100

kboxplot        equ       ke1bt+101
kboxicon        equ       ke1bt+102
kcrossicon      equ       ke1bt+103
kdoticon        equ       ke1bt+104

ke2bt           equ       ke1bt+105

kseqential      equ       ke2bt
ksimulg         equ       ke2bt+1
kpolarg         equ       ke2bt+2
krectg          equ       ke2bt+3
kcoordon        equ       ke2bt+4
kcoordoff       equ       ke2bt+5
kdrawline       equ       ke2bt+6
kdrawdot        equ       ke2bt+7
kaxison         equ       ke2bt+8
kaxisoff        equ       ke2bt+9
kgridon         equ       ke2bt+10
kgridoff        equ       ke2bt+11
klblon          equ       ke2bt+12
klbloff         equ       ke2bt+13

kl1             equ       ke2bt+14
kl2             equ       ke2bt+15
kl3             equ       ke2bt+16
kl4             equ       ke2bt+17
kl5             equ       ke2bt+18
kl6             equ       ke2bt+19

;
;======================================================================
;           these keys are layed on top of existing keys to
;           enable localization in the inferential stats editor
;======================================================================
;
kinfdata        equ       kl1
kinfstats       equ       kl1+1
kinfyes         equ       kl1+2
kinfno          equ       kl1+3
kinfcalc        equ       kl1+4
kinfdraw        equ       kl1+5
kinfalt1ne      equ       kl1+6
kinfalt1lt      equ       kl1+7
kinfalt1gt      equ       kl1+8
kinfalt2ne      equ       kl1+9
kinfalt2lt      equ       kl1+10
kinfalt2gt      equ       kl1+11
kinfalt3ne      equ       kl1+12
kinfalt3lt      equ       kl1+13
kinfalt3gt      equ       kl1+14
kinfalt4ne      equ       kl1+15
kinfalt4lt      equ       kl1+16
kinfalt4gt      equ       kl1+17
kinfalt5ne      equ       kl1+18
kinfalt5lt      equ       kl1+19
kinfalt5gt      equ       kl1+20
kinfalt6ne      equ       kl1+21
kinfalt6lt      equ       kl1+22
kinfalt6gt      equ       kl1+23
;
;
kmata           equ       ke2bt+20
kmatb           equ       ke2bt+21
kmatc           equ       ke2bt+22
kmatd           equ       ke2bt+23
kmate           equ       ke2bt+24

kxmin           equ       ke2bt+25
kxmax           equ       ke2bt+26
kxscl           equ       ke2bt+27
kymin           equ       ke2bt+28
kymax           equ       ke2bt+29
kyscl           equ       ke2bt+30
ktmin           equ       ke2bt+31
ktmax           equ       ke2bt+32
ktstep          equ       ke2bt+33
komin           equ       ke2bt+34
komax           equ       ke2bt+35
kostep          equ       ke2bt+36
ku0             equ       ke2bt+37
kv0             equ       ke2bt+38
knmin           equ       ke2bt+39
knmax           equ       ke2bt+40
kdeltay         equ       ke2bt+41
kdeltax         equ       ke2bt+42

kzxmin          equ       ke2bt+43
kzxmax          equ       ke2bt+44
kzxscl          equ       ke2bt+45
kzymin          equ       ke2bt+46
kzymax          equ       ke2bt+47
kzyscl          equ       ke2bt+48
kztmin          equ       ke2bt+49
kztmax          equ       ke2bt+50
kztstep         equ       ke2bt+51
kzomin          equ       ke2bt+52
kzomax          equ       ke2bt+53
kzostep         equ       ke2bt+54
kzu0            equ       ke2bt+55
kzv0            equ       ke2bt+56
kznmin          equ       ke2bt+57
kznmax          equ       ke2bt+58

kdellast        equ       ke2bt+59
ksinreg         equ       ke2bt+60
kconste         equ       ke2bt+61

kpic1           equ       ke2bt+62
kpic2           equ       ke2bt+63
kpic3           equ       ke2bt+64

kdelvar         equ       ke2bt+65
kgetcalc        equ       ke2bt+66
krealm          equ       ke2bt+67
kpolarm         equ       ke2bt+68
krectm          equ       ke2bt+69
kuv             equ       ke2bt+70    ; u vs v
kvw             equ       ke2bt+71    ; v vs w
kuw             equ       ke2bt+72    ; u vs w
kfinpmtend      equ       ke2bt+73
kfinpmtbeg      equ       ke2bt+74
;
kgraphstyle     equ       ke2bt+75
;
kexpron         equ       ke2bt+76
kexproff        equ       ke2bt+77
kstata          equ       ke2bt+78
kstatb          equ       ke2bt+79
kstatc          equ       ke2bt+80
kcorr           equ       ke2bt+81
kstatd          equ       ke2bt+82
kstate          equ       ke2bt+83
kregeq          equ       ke2bt+84
kminx           equ       ke2bt+85
kq1             equ       ke2bt+86
kmd             equ       ke2bt+87
kq3             equ       ke2bt+88
kmaxx           equ       ke2bt+89
kstatx1         equ       ke2bt+90
kstaty1         equ       ke2bt+91
kstatx2         equ       ke2bt+92
kstaty2         equ       ke2bt+93
kstatx3         equ       ke2bt+94
kstaty3         equ       ke2bt+95
ktblmin         equ       ke2bt+96
ktblstep        equ       ke2bt+97
ksetuplst       equ       ke2bt+98
kclralllst      equ       ke2bt+99
klogistic       equ       ke2bt+100
kztest          equ       ke2bt+101
kttest          equ       ke2bt+102
k2sampztest     equ       ke2bt+103
k2sampttest     equ       ke2bt+104
k1propztest     equ       ke2bt+105
k2propztest     equ       ke2bt+106
kchitest        equ       ke2bt+107
k2sampftest     equ       ke2bt+108
kzintval        equ       ke2bt+109
ktintval        equ       ke2bt+110
k2samptint      equ       ke2bt+111
k2sampzint      equ       ke2bt+112
k1propzint      equ       ke2bt+113
k2propzint      equ       ke2bt+114
kdnormal        equ       ke2bt+115
kinvnorm        equ       ke2bt+116
kdt             equ       ke2bt+117
kchi            equ       ke2bt+118
kdf             equ       ke2bt+119
kbinpdf         equ       ke2bt+120
kbincdf         equ       ke2bt+121
kpoipdf         equ       ke2bt+122
kpoicdf         equ       ke2bt+123
kun             equ       ke2bt+124
kvn             equ       ke2bt+125
kwn             equ       ke2bt+126
krecn           equ       ke2bt+127
kplotstart      equ       ke2bt+128
kzplotstart     equ       ke2bt+129   ; recursion n
kxfact          equ       ke2bt+130   ; plotstart
kyfact          equ       ke2bt+131   ; zplotstart
kanova          equ       ke2bt+132   ; xfact
kmaxy           equ       ke2bt+133   ; yfact
kwebon          equ       ke2bt+134   ; miny
kweboff         equ       ke2bt+135   ; maxy
ktblinput       equ       ke2bt+136   ; web on
kgeopdf         equ       ke2bt+137   ; web off
kgeocdf         equ       ke2bt+138   ; web off
kshadenorm      equ       ke2bt+139
kshadet         equ       ke2bt+140
kshadechi       equ       ke2bt+141
kshadef         equ       ke2bt+142
kplotstep       equ       ke2bt+143
kzplotstep      equ       ke2bt+144
klinregttest    equ       ke2bt+145
kmgt		equ	  ke2bt+146   ; vert split
kselecta        equ       ke2bt+147
kzfita          equ       ke2bt+148
ke2bt_end       equ       kzfita
;
;
;======================================================================
;           more 2 byte keys 
;======================================================================

ke2bt2		equ       0

kgdb1		equ       ke2bt2
kgdb2		equ       ke2bt2+1
kgdb3		equ       ke2bt2+2
ky1		equ       ke2bt2+3
ky2		equ       ke2bt2+4
ky3		equ       ke2bt2+5
ky4		equ       ke2bt2+6
ky5		equ       ke2bt2+7
ky6		equ       ke2bt2+8
ky7		equ       ke2bt2+9
ky8		equ       ke2bt2+10
ky9		equ       ke2bt2+11
ky0		equ       ke2bt2+12
kx1t		equ       ke2bt2+13
ky1t		equ       ke2bt2+14
kx2t		equ       ke2bt2+15
ky2t		equ       ke2bt2+16
kx3t		equ       ke2bt2+17
ky3t		equ       ke2bt2+18
kx4t		equ       ke2bt2+19
ky4t		equ       ke2bt2+20
kx5t		equ       ke2bt2+21
ky5t		equ       ke2bt2+22
kx6t		equ       ke2bt2+23
ky6t		equ       ke2bt2+24
kr1		equ       ke2bt2+25
kr2		equ       ke2bt2+26
kr3		equ       ke2bt2+27
kr4		equ       ke2bt2+28
kr5		equ       ke2bt2+29
kr6		equ       ke2bt2+30
kgdb4		equ       ke2bt2+31
kgdb5		equ       ke2bt2+32
kgdb6		equ       ke2bt2+33
kpic4		equ       ke2bt2+34
kpic5		equ       ke2bt2+35
kpic6		equ       ke2bt2+36
kgdb7		equ       ke2bt2+37
kgdb8		equ       ke2bt2+38
kgdb9		equ       ke2bt2+39
kgdb0		equ       ke2bt2+40
kpic7		equ       ke2bt2+41
kpic8		equ       ke2bt2+42
kpic9		equ       ke2bt2+43
kpic0		equ       ke2bt2+44
kstatn		equ       ke2bt2+45
kxmean		equ       ke2bt2+46
kconj		equ       ke2bt2+47
kreal		equ       ke2bt2+48
kfangle		equ       ke2bt2+49
klcm		equ       ke2bt2+50
kgcd		equ       ke2bt2+51
krandint	equ       ke2bt2+52
krandnorm	equ       ke2bt2+53
ktopolar	equ       ke2bt2+54
ktorect		equ       ke2bt2+55
kymean		equ       ke2bt2+56
kstdx		equ       ke2bt2+57
kstdx1		equ       ke2bt2+58
kw0		equ       ke2bt2+59
kmatf		equ       ke2bt2+60
kmatg		equ       ke2bt2+61
kmatrh		equ       ke2bt2+62
kmati		equ       ke2bt2+63
kmatj		equ       ke2bt2+64
kymean1		equ       ke2bt2+65
kstdy		equ       ke2bt2+66
kstdy1		equ       ke2bt2+67
kmattolst	equ       ke2bt2+68
klsttomat	equ       ke2bt2+69
kcumsum		equ       ke2bt2+70
kdeltalst	equ       ke2bt2+71
kstddev		equ       ke2bt2+72
kvariance	equ       ke2bt2+73
klength		equ       ke2bt2+74
kequtostrng	equ       ke2bt2+75
kstrngtoequ	equ       ke2bt2+76
kexpr		equ       ke2bt2+77
ksubstrng	equ       ke2bt2+78
kinstrng	equ       ke2bt2+79
kstr1		equ       ke2bt2+80
kstr2		equ       ke2bt2+81
kstr3		equ       ke2bt2+82
kstr4           equ       ke2bt2+83
kstr5           equ       ke2bt2+84
kstr6           equ       ke2bt2+85
kstr7           equ       ke2bt2+86
kstr8           equ       ke2bt2+87
kstr9           equ       ke2bt2+88
kstr0           equ       ke2bt2+89
kfinn           equ       ke2bt2+90
kfini           equ       ke2bt2+91
kfinpv          equ       ke2bt2+92
kfinpmt         equ       ke2bt2+93
kfinfv          equ       ke2bt2+94
kfinpy          equ       ke2bt2+95
kfincy          equ       ke2bt2+96
kfinfpmt        equ       ke2bt2+97
kfinfi          equ       ke2bt2+98
kfinfpv         equ       ke2bt2+99
kfinfn          equ       ke2bt2+100
kfinffv         equ       ke2bt2+101
kfinnpv         equ       ke2bt2+102
kfinirr         equ       ke2bt2+103
kfinbal         equ       ke2bt2+104
kfinprn         equ       ke2bt2+105
kfinint         equ       ke2bt2+106
ksumx           equ       ke2bt2+107
ksumx2          equ       ke2bt2+108
kfintonom       equ       ke2bt2+109
kfintoeff       equ       ke2bt2+110
kfindbd         equ       ke2bt2+111
kstatvp         equ       ke2bt2+112
kstatz          equ       ke2bt2+113
kstatt          equ       ke2bt2+114
kstatchi        equ       ke2bt2+115
kstatf          equ       ke2bt2+116
kstatdf         equ       ke2bt2+117
kstatphat       equ       ke2bt2+118
kstatphat1      equ       ke2bt2+119
kstatphat2      equ       ke2bt2+120
kstatmeanx1     equ       ke2bt2+121
kstatmeanx2     equ       ke2bt2+122
kstatstdx1      equ       ke2bt2+123
kstatstdx2      equ       ke2bt2+124
kstatstdxp      equ       ke2bt2+125
kstatn1         equ       ke2bt2+126
kstatn2         equ       ke2bt2+127
kstatlower      equ       ke2bt2+128
kstatupper      equ       ke2bt2+129
kuw0            equ       ke2bt2+130
kimag           equ       ke2bt2+131
ksumy           equ       ke2bt2+132
kxres           equ       ke2bt2+133
kstat_s         equ       ke2bt2+134
ksumy2          equ       ke2bt2+135
ksumxy          equ       ke2bt2+136
kuxres          equ       ke2bt2+137
kmodbox		equ       ke2bt2+138
knormprob	equ       ke2bt2+139
knormalpdf      equ       ke2bt2+140
ktpdf           equ       ke2bt2+141
kchipdf         equ       ke2bt2+142
kfpdf           equ       ke2bt2+143
kminy           equ       ke2bt2+144   ; miny
krandbin        equ       ke2bt2+145
kref            equ       ke2bt2+146
krref           equ       ke2bt2+147
klrsqr          equ       ke2bt2+148
kbrsqr          equ       ke2bt2+149
kdiagon         equ       ke2bt2+150
kdiagoff        equ       ke2bt2+151
kun1            equ       ke2bt2+152   ; for rcl use when gotten from 82
kvn1            equ       ke2bt2+153   ; for rcl use when gotten from 82
;
k83_00end       equ	kvn1            ;end of original keys...
karchive        equ     k83_00end + 1
kunarchive      equ     k83_00end + 2
kasm            equ     k83_00end + 3   ; asm(
kasmprgm        equ     k83_00end + 4   ; asmprgm
kasmcomp        equ     k83_00end + 5   ; asmcomp(
;
kcapaacute	equ       k83_00end + 6
kcapagrave	equ       k83_00end + 7
kcapacaret	equ       k83_00end + 8
kcapadier	equ       k83_00end + 9
kaacute		equ       k83_00end + 10
kagrave		equ       k83_00end + 11
kacaret		equ       k83_00end + 12
kadier		equ       k83_00end + 13
kcapeacute	equ       k83_00end + 14
kcapegrave	equ       k83_00end + 15
kcapecaret	equ       k83_00end + 16
kcapedier	equ       k83_00end + 17
keacute		equ       k83_00end + 18
kegrave		equ       k83_00end + 19
kecaret		equ       k83_00end + 20
kedier		equ       k83_00end + 21
kcapiacute	equ       k83_00end + 22
kcapigrave	equ       k83_00end + 23
kcapicaret	equ       k83_00end + 24
kcapidier	equ       k83_00end + 25
kiacute		equ       k83_00end + 26
kigrave		equ       k83_00end + 27
kicaret		equ       k83_00end + 28
kidier		equ       k83_00end + 29
kcapoacute	equ       k83_00end + 30
kcapograve	equ       k83_00end + 31
kcapocaret	equ       k83_00end + 32
kcapodier	equ       k83_00end + 33
koacute		equ       k83_00end + 34
kograve		equ       k83_00end + 35
kocaret		equ       k83_00end + 36
kodier		equ       k83_00end + 37
kcapuacute	equ       k83_00end + 38
kcapugrave	equ       k83_00end + 39
kcapucaret	equ       k83_00end + 40
kcapudier	equ       k83_00end + 41
kuacute		equ       k83_00end + 42
kugrave		equ       k83_00end + 43
kucaret		equ       k83_00end + 44
kudier		equ       k83_00end + 45
kcapcced	equ       k83_00end + 46
kcced		equ       k83_00end + 47
kcapntilde	equ       k83_00end + 48
kntilde		equ       k83_00end + 49
kaccent		equ       k83_00end + 50
kgrave		equ       k83_00end + 51
kdieresis	equ       k83_00end + 52
kquesdown	equ       k83_00end + 53
kexclamdown     equ       k83_00end + 54
kalpha          equ       k83_00end + 55
kbeta           equ      k83_00end +  56
kgamma          equ      k83_00end +  57
kcapdelta       equ      k83_00end +  58
kdelta          equ      k83_00end +  59
kepsilon        equ      k83_00end +  60
klambda         equ      k83_00end +  61
kmu             equ      k83_00end +  62
kpi2            equ      k83_00end +  63
krho            equ      k83_00end +  64
kcapsigma       equ      k83_00end +  65
ksigma          equ      k83_00end +  66
ktau            equ      k83_00end +  67
kphi            equ      k83_00end +  68
kcapomega       equ      k83_00end +  69
kphat           equ      k83_00end +  70
kchi2           equ      k83_00end +  71
kstatf2         equ      k83_00end +  72
kla		equ     k83_00end + 73
klb		equ     k83_00end + 74
klc		equ     k83_00end + 75
kld		equ     k83_00end + 76
kle		equ     k83_00end + 77
klf		equ     k83_00end + 78
klg		equ     k83_00end + 79
klh		equ     k83_00end + 80
kli		equ     k83_00end + 81
klj		equ     k83_00end + 82
klk		equ     k83_00end + 83
kll		equ     k83_00end + 84
klm		equ     k83_00end + 85
klsmalln	equ    k83_00end +  86
klo		equ    k83_00end +  87
klp		equ    k83_00end +  88
klq		equ    k83_00end +  89
klsmallr	equ    k83_00end +  90
kls		equ    k83_00end +  91
klt		equ    k83_00end +  92
klu		equ    k83_00end +  93
klv		equ    k83_00end +  94
klw		equ    k83_00end +  95
klx		equ    k83_00end +  96
kly		equ    k83_00end +  97
klz		equ    k83_00end +  98
kgarbagec	equ  k83_00end +  99 ; garbagecollect
;
ke2bt2_end	equ     kgarbagec
;
;======================================================================
;           ti-83 plus context equates
;======================================================================
;
cxcmd           equ     kquit                   ;home screen
cxmatedit       equ     kmatrixed               ;matrix editor
cxprgmedit      equ     kprgmed                 ;program editor
cxequedit       equ     kyequ                   ;equation editor
cxgrrange       equ     kwindow                 ;graph range editor
cxgrzfact       equ     kzfacted                ;graph zoom factors editor
cxgraph         equ     kgraph                  ;graph mode
cxstatedit      equ     kstated                 ;statistics list editor
cxprgminput     equ     kprgminput              ;programmed input
cxerror         equ     kerror                  ;error handler
cxlinkio        equ     klinkio                 ;link i/o interface
cxmem           equ     kresetmem               ;reset memory
cxdefmem        equ     kresetdef               ;reset default
cxramapp        equ     kchkram                 ;ram usage screen
cxmode          equ     kmode                   ;mode settings screen
cxerase         equ     kdelmem                 ;memory erase
cxprgmcreate    equ     kprgmcr                 ;program create
cxtableeditor   equ     ktable                  ;table editor
cxtableset      equ     ktblset                 ;table set up
cxstatplot      equ     kstatp                  ;stat plots
cxinfstat	equ	kinfstat		;inferential statistic
cxformat        equ     kformat                 ;format context
cxsolvetvm      equ     ksolvetvm               ;solve tvm
cxsolveroot     equ     ksolveroot              ;solve root
lastoldapp      equ     kextapps                ;external applications
cxextapps       equ     kextapps
cxnewapps       equ     knewapps                ;new cerberus applications
cxgroup         equ     cxnewapps+0             ;1st new app.
cxungroup       equ     cxnewapps+1             ;2nd new app.
lastnewapp      equ     cxungroup               ;last new app for this ver

;
;======================================================================
;           scan code equates
;======================================================================;
skdown          equ	01h
skleft          equ	02h
skright         equ	03h
skup            equ	04h
skenter         equ	09h
skadd           equ	0ah
sksub           equ	0bh
skmul           equ	0ch
skdiv           equ	0dh
skpower         equ	0eh
skclear         equ	0fh
skchs           equ	11h
sk3             equ	12h
sk6             equ	13h
sk9             equ	14h
skrparen        equ	15h
sktan           equ	16h
skvars          equ	17h
skdecpnt        equ	19h
sk2             equ	1ah
sk5             equ	1bh
sk8             equ	1ch
sklparen        equ	1dh
skcos           equ	1eh
skprgm          equ	1fh
skstat          equ	20h
sk0             equ	21h
sk1             equ	22h
sk4             equ	23h
sk7             equ	24h
skcomma         equ	25h
sksin           equ	26h
skmatrix        equ	27h
skgraphvar      equ	28h
skstore         equ	2ah
skln            equ	2bh
sklog           equ	2ch
sksquare        equ	2dh
skrecip         equ	2eh
skmath          equ	2fh
skalpha         equ	30h
skgraph         equ	31h
sktrace         equ	32h
skzoom          equ	33h
skwindow        equ	34h
skyequ          equ	35h
sk2nd           equ	36h
skmode          equ	37h
skdel           equ	38h
;
;======================================================================
;           tokens
;======================================================================
;
eosstart        equ       0
;
;
;   display conversions come immediately before 'tstore'
;
dconv   equ     01h
;
ttodms          equ       dconv       ; 01h
ttodec          equ       dconv+1     ; 02h
ttoabc          equ       dconv+2     ; 03h    > a b/c
;
tstore          equ       dconv+3     ; 04h lstore                01
;
tboxplot        equ       05h
;
bracks          equ       06h
;
tlbrack         equ       bracks      ; 06h '['
trbrack         equ       bracks+1    ; 07h ']'
tlbrace         equ       bracks+2    ; 08h '{'
trbrace         equ       bracks+3    ; 09h '}'
;
tpost1          equ       bracks+4
;
tfromrad        equ       tpost1       ; 0ah lradian
tfromdeg        equ       tpost1+1     ; 0bh ldegree
trecip          equ       tpost1+2     ; 0ch linverse
tsqr            equ       tpost1+3     ; 0dh lsquare
ttrnspos        equ       tpost1+4     ; 0eh ltranspose
tcube           equ       tpost1+5     ; 0fh '^3'
;
tlparen         equ       10h         ; 10h '('
trparen         equ       11h         ; 11h ')'
;
;
imun            equ       12h
;
tround          equ       imun        ; 12h 'round'
tpxtst          equ       imun+1      ; 13h 'pxl-test'
taug            equ       imun+2      ; 14h 'aug'
trowswap        equ       imun+3      ; 15h 'rswap'
trowplus        equ       imun+4      ; 16h 'radd'
tmrow           equ       imun+5      ; 17h 'multr'
tmrowplus       equ       imun+6      ; 18h 'mradd'
tmax            equ       imun+7      ; 19h 'max'
tmin            equ       imun+8      ; 1ah 'min'
trtopr          equ       imun+9      ; 1bh 'r>pr
trtopo          equ       imun+10     ; 1ch 'r>po
tptorx          equ       imun+11     ; 1dh 'p>rx
tptory          equ       imun+12     ; 1eh 'p>ry
tmedian         equ       imun+13     ; 1fh 'median
trandm          equ       imun+14     ; 20h 'randm'
tmean           equ       imun+15     ; 21h
troot           equ       imun+16     ; 22h 'root'
tseries         equ       imun+17     ; 23h 'seq'
tfnint          equ       imun+18     ; 24h 'fnint'
tnderiv         equ       imun+19     ; 25h 'fnir'
tevalf          equ       imun+20     ; 26h
tfmin           equ       imun+21     ; 27h
tfmax           equ       imun+22     ; 28h
;
teosel          equ       imun+23
;
tspace          equ       teosel       ; 29h   ' '
tstring         equ       teosel+1     ; 2ah  '"'
tcomma          equ       teosel+2     ; 2bh  ','
;
;
tii             equ       2ch         ; i
;
;======================================================================
;           postfix functions
;======================================================================
;
tpost           equ       2dh
;
tfact           equ       tpost       ; 2dh '!'
;
tcubicr         equ       2eh
tquartr         equ       2fh

;======================================================================
;           number tokens 
;======================================================================
;
nums            equ       30h
;
t0              equ       nums        ; 30h
t1              equ       nums+1      ; 31h
t2              equ       nums+2      ; 32h
t3              equ       nums+3      ; 33h
t4              equ       nums+4      ; 34h
t5              equ       nums+5      ; 35h
t6              equ       nums+6      ; 36h
t7              equ       nums+7      ; 37h
t8              equ       nums+8      ; 38h
t9              equ       nums+9      ; 39h
tdecpt          equ       nums+10     ; 3ah
tee             equ       nums+11     ; 3bh
;
;======================================================================
;            binary op
;======================================================================
;
tor             equ       3ch         ; 3ch  '_or_'
txor            equ       3dh         ; 3dh
;
tcolon          equ       3eh         ; 3eh ':'
tenter          equ       3fh         ; 3fh  lenter
;
tand            equ       40h         ; 40h  '_and_'       
;
;======================================================================
;            letter tokens   
;======================================================================

;
let             equ       41h
;
ta              equ       let         ; 41h
tb              equ       let+1       ; 42h
tc              equ       let+2       ; 43h
td              equ       let+3       ; 44h
te              equ       let+4       ; 45h
tf              equ       let+5       ; 46h
tg              equ       let+6       ; 47h
th              equ       let+7       ; 48h
ti              equ       let+8       ; 49h
tj              equ       let+9       ; 4ah
tk              equ       let+10      ; 4bh
tl              equ       let+11      ; 4ch
tm              equ       let+12      ; 4dh
tn              equ       let+13      ; 4eh
to              equ       let+14      ; 4fh
tp              equ       let+15      ; 50h
tq              equ       let+16      ; 51h
tr              equ       let+17      ; 52h
ts              equ       let+18      ; 53h
tt              equ       let+19      ; 54h
tu              equ       let+20      ; 55h
tv              equ       let+21      ; 56h
tw              equ       let+22      ; 57h
tx              equ       let+23      ; 58h
ty              equ       let+24      ; 59h
tz              equ       let+25      ; 5ah
ttheta          equ       let+26      ; 5bh
;
;======================================================================
;   these var tokens are 1st of a double token 
;======================================================================

;
vtoks   equ     let+27    ;
;
;       user matrix token, 2nd token needed for name
;
tvarmat         equ       vtoks       ; 5ch
;
;       user list token, 2nd token needed for name
;
tvarlst         equ       vtoks+1     ; 5dh
;
;       user equation token, 2nd token needed for name
;
tvarequ         equ       vtoks+2     ; 5eh
tprog           equ       vtoks+3     ; 5fh
;
;       user pict token, 2nd token needed for name
;
tvarpict        equ       vtoks+4     ; 60h
;
;       user gdb token, 2nd token needed for name
;
tvargdb         equ       vtoks+5     ; 61h
tvarout         equ       vtoks+6     ; 62h
tvarsys         equ       vtoks+7     ; 63h
;
;
;======================================================================
;            mode setting commands
;======================================================================

;
modesa          equ       vtoks+8     ; 64h
;
trad            equ       modesa      ; 64h 'radian'
tdeg            equ       modesa+1    ; 65h 'degree'
tnormf          equ       modesa+2    ; 66h 'normal'
tsci            equ       modesa+3    ; 67h 'sci'
teng            equ       modesa+4    ; 68h 'eng'
tfloat          equ       modesa+5    ; 69h 'float'
;
cmps            equ       6ah
;
teq             equ       cmps        ; 6ah '=='
tlt             equ       cmps+1      ; 6bh '<'
tgt             equ       cmps+2      ; 6ch '>'
tle             equ       cmps+3      ; 6dh lle
tge             equ       cmps+4      ; 6eh lge
tne             equ       cmps+5      ; 6fh lne
;
;======================================================================
;            binary op
;======================================================================
;
tadd            equ       70h         ; 70h '+'
tsub            equ       71h         ; 71h '-'
tans            equ       72h         ; 72h
;
;======================================================================
;            mode setting commands
;======================================================================
;
modes           equ       73h
;
tfix            equ       modes       ; 73h 'fix_'
tspliton        equ       modes+1     ; 74h
tfullscreen     equ       modes+2     ; 75h
tstndrd         equ       modes+3     ; 76h 'func'
tparam          equ       modes+4     ; 77h 'param'
tpolar          equ       modes+5     ; 78h 'pol'
tseqg           equ       modes+6     ; 79h
tafillon        equ       modes+7     ; 7ah 'auto fill on
tafilloff       equ       modes+8     ; 7bh
tacalcon        equ       modes+9     ; 7ch
tacalcoff       equ       modes+10    ; 7dh 'autofill off
;
;       graph format tokens are 2 byte tokens
;
tgformat        equ       modes+11    ; 7eh
;
tboxicon        equ       7fh
tcrossicon      equ       80h
tdoticon        equ       81h
;
;======================================================================
;            (more) binary op
;======================================================================
;
tmul            equ       82h         ; 82h  '*'
tdiv            equ       83h         ; 83h  '/'
;
;======================================================================
;            some graph commands
;======================================================================
;
grcmds          equ       84h
;
ttrace          equ       grcmds      ; 84h 'trace'
tcldrw          equ       grcmds+1    ; 85h 'cldrw'
tzoomstd        equ       grcmds+2    ; 86h 'zstd'
tzoomtrg        equ       grcmds+3    ; 87h 'ztrg'
tzoombox        equ       grcmds+4    ; 88h 'zbox'
tzoomin         equ       grcmds+5    ; 89h 'zin'
tzoomout        equ       grcmds+6    ; 8ah 'zout'
tzoomsqr        equ       grcmds+7    ; 8bh 'zsqr'
tzoomint        equ       grcmds+8    ; 8ch 'zint'
tzoomprev       equ       grcmds+9    ; 8dh 'zprev'
tzoomdec        equ       grcmds+10   ; 8eh 'zdecm'
tzoomstat       equ       grcmds+11   ; 8fh 'zstat
tusrzm          equ       grcmds+12   ; 90h 'zrcl'
tprtscrn        equ       grcmds+13   ; 91h 'prtscrn'
tzoomsto        equ       grcmds+14   ; 92h  zoom store
ttext           equ       grcmds+15   ; 93h
;
;======================================================================
;           binary op  (combination & permutation)
;======================================================================
;
tnpr            equ       grcmds+16   ; 94h '_npr_'
tncr            equ       grcmds+17   ; 95h '_ncr_'
;
;======================================================================
;           more graph commands
;======================================================================
;
tyon            equ       grcmds+18   ; 96h 'fnon_'
tyoff           equ       grcmds+19   ; 97h 'fnoff_'
tstpic          equ       grcmds+20   ; 98h 'stpic_'
trcpic          equ       grcmds+21   ; 99h 'rcpic_'
tstodb          equ       grcmds+22   ; 9ah 'stgdb_'
trcldb          equ       grcmds+23   ; 9bh 'rcgdb_'
tline           equ       grcmds+24   ; 9ch 'line'
tvert           equ       grcmds+25   ; 9dh 'vert_'
tpton           equ       grcmds+26   ; 9eh 'pton'
tptoff          equ       grcmds+27   ; 9fh 'ptoff'
;
;======================================================================
;           token a0 cannot be an eos function
;           since low mult=a0 already
;======================================================================
;
tptchg          equ       grcmds+28   ; a0h 'ptchg'
tpxon           equ       grcmds+29   ; a1h
tpxoff          equ       grcmds+30   ; a2h
tpxchg          equ       grcmds+31   ; a3h
tshade          equ       grcmds+32   ; a4h 'shade'
tcircl          equ       grcmds+33   ; a5h 'circl'
thorz           equ       grcmds+34   ; a6h 'horizontal'
ttanln          equ       grcmds+35   ; a7h 'tanln'
tdrinv          equ       grcmds+36   ; a8h 'drinv_'
tdrawf          equ       grcmds+37   ; a9h 'drawf_'
;
tvarstrng       equ       0aah
;
;======================================================================
;           functions with no arguments                                    
;======================================================================
;
noarg   equ     0abh
;
trand           equ       noarg       ; abh 'rand'
tpi             equ       noarg+1     ; ach  lpi
tgetkey         equ       noarg+2     ; adh 'getky'
;
;
tapost          equ       tgetkey+1   ; apostrophy
tquest          equ       tapost+1    ; question mark
;
;
unary   equ     tquest+1              ; b0h
;
tchs            equ       unary       ; b0h
tint            equ       unary+1     ; b1h
tabs            equ       unary+2     ; b2h
tdet            equ       unary+3     ; b3h
tident          equ       unary+4     ; b4h
tdim            equ       unary+5     ; b5h
tsum            equ       unary+6     ; b6h
tprod           equ       unary+7     ; b7h
tnot            equ       unary+8     ; b8h
tipart          equ       unary+9     ; b9h
tfpart          equ       unary+10    ; bah
;
;
;======================================================================
;           new 2 byte tokens
;======================================================================
;
t2bytetok       equ       0bbh         ;
;
;
unarylr equ     unary+12
;
tsqrt           equ       unarylr     ; bch
tcubrt          equ       unarylr+1   ; bdh
tln             equ       unarylr+2   ; beh
texp            equ       unarylr+3   ; bfh
tlog            equ       unarylr+4   ; c0h
talog           equ       unarylr+5   ; c1h
tsin            equ       unarylr+6   ; c2h
tasin           equ       unarylr+7   ; c3h
tcos            equ       unarylr+8   ; c4h
tacos           equ       unarylr+9   ; c5h
ttan            equ       unarylr+10  ; c6h
tatan           equ       unarylr+11  ; c7h
tsinh           equ       unarylr+12  ; c8h
tasinh          equ       unarylr+13  ; c9h
tcosh           equ       unarylr+14  ; cah
tacosh          equ       unarylr+15  ; cbh
ttanh           equ       unarylr+16  ; cch
tatanh          equ       unarylr+17  ; cdh
; 
;======================================================================
;           some programming commands                                      
;======================================================================
;
progtok equ     unarylr+18
;
tif             equ       progtok     ; ceh
tthen           equ       progtok+1   ; cfh
telse           equ       progtok+2   ; d0h
twhile          equ       progtok+3   ; d1h
trepeat         equ       progtok+4   ; d2h
tfor            equ       progtok+5   ; d3h
tend            equ       progtok+6   ; d4h
treturn         equ       progtok+7   ; d5h
tlbl            equ       progtok+8   ; d6h   'lbl_'
tgoto           equ       progtok+9   ; d7h   'goto_'
tpause          equ       progtok+10  ; d8h   'pause_'
tstop           equ       progtok+11  ; d9h   'stop'
tisg            equ       progtok+12  ; dah   'is>'
tdsl            equ       progtok+13  ; dbh   'ds<'
tinput          equ       progtok+14  ; dch   'input_'
tprompt         equ       progtok+15  ; ddh   'prompt_'
tdisp           equ       progtok+16  ; deh   'disp_'
tdispg          equ       progtok+17  ; dfh   'dispg'
;
toutput         equ       progtok+18  ; e0h    'outpt'
tcllcd          equ       progtok+19  ; e1h    'cllcd'
tconst          equ       progtok+20  ; e2h    'fill'
tsorta          equ       progtok+21  ; e3h    'sorta_'
tsortd          equ       progtok+22  ; e4h    'sortd_'
tdisptab        equ       progtok+23  ; e5h    'disp table
tmenu           equ       progtok+24  ; e6h    'menu'
tsendmbl        equ       progtok+25  ; e7h    'send'
tgetmbl         equ       progtok+26  ; e8h    'get'
;
;======================================================================
;           stat plot commands                                             
;======================================================================
;
statpcmd        equ       progtok+27
;
tploton         equ       statpcmd    ; e9h     ' plotson'
tplotoff        equ       statpcmd+1   ; eah     ' plotsoff
;
tlistname       equ       0ebh        ; list designator
;
tplot1          equ       0ech
tplot2          equ       0edh
tplot3          equ       0eeh
;
tunused01       equ       0efh        ;        available?
;
tpower          equ       0f0h        ;        '^'
txroot          equ       0f1h        ;        lsupx,lroot

statcmd         equ       0f2h
;
tonevar         equ       statcmd     ; f2h    'onevar_'
ttwovar         equ       statcmd+1   ; f3h
tlr             equ       statcmd+2   ; f4h    'linr(a+bx
tlrexp          equ       statcmd+3   ; f5h    'expr_'
tlrln           equ       statcmd+4   ; f6h    'lnr_'
tlrpwr          equ       statcmd+5   ; f7h    'pwrr_'
tmedmed         equ       statcmd+6   ; f8h
tquad           equ       statcmd+7   ; f9h
tclrlst         equ       statcmd+8   ; fah    'clear list
tclrtbl         equ       statcmd+9   ; fbh    clear table
thist           equ       statcmd+10  ; fch    'hist_'
txyline         equ       statcmd+11  ; fdh    'xyline_'
tscatter        equ       statcmd+12  ; feh    'scatter_'
tlr1            equ       statcmd+13  ; ffh    'linr(ax+b

;       
;======================================================================
;           2nd half of graph format tokens
;======================================================================
;           format settings commands
;
gfmt            equ       0
;
tseq            equ       gfmt        ; 'seqg'
tsimulg         equ       gfmt+1      ; 'simulg'
tpolarg         equ       gfmt+2      ; 'polargc'
trectg          equ       gfmt+3      ; 'rectgc'
tcoordon        equ       gfmt+4      ; 'coordon'
tcoordoff       equ       gfmt+5      ; 'coordoff'
tdrawline       equ       gfmt+6      ; 'drawline'
tdrawdot        equ       gfmt+7      ; 'drawdot'
taxison         equ       gfmt+8      ; 'axeson'
taxisoff        equ       gfmt+9      ; 'axesoff'
tgridon         equ       gfmt+10     ; 'gridon'
tgridoff        equ       gfmt+11     ; 'gridoff'
tlblon          equ       gfmt+12     ; 'labelon'
tlbloff         equ       gfmt+13     ; 'labeloff'
twebon          equ       gfmt+14     ; 'webon'
tweboff         equ       gfmt+15     ; 'weboff'
tuv             equ       gfmt+16     ; u vs v
tvw             equ       gfmt+17     ; v vs w
tuw             equ       gfmt+18     ; u vs w
;
;======================================================================
;           2nd half of user matrix tokens                                 
;======================================================================
;
tmata           equ       00h         ; mat a
tmatb           equ       01h         ; mat b
tmatc           equ       02h         ; mat c
tmatd           equ       03h         ; mat d
tmate           equ       04h         ; mat e
tmatf           equ       05h         ; mat f
tmatg           equ       06h         ; mat g
tmath           equ       07h         ; mat h
tmati           equ       08h         ; mat i
tmatj           equ       09h         ; mat j
;      
;======================================================================
;           2nd half of user list tokens
;======================================================================
;
tl1             equ       00h         ; list 1
tl2             equ       01h         ; list 2
tl3             equ       02h         ; list 3
tl4             equ       03h         ; list 4
tl5             equ       04h         ; list 5
tl6             equ       05h         ; list 6

;
;======================================================================
;           2nd half of user equation tokens
;======================================================================
;
;       "y" equations have bit 4 set
;
ty1             equ       10h         ; y1
ty2             equ       11h         ; y2
ty3             equ       12h         ; y3
ty4             equ       13h         ; y4
ty5             equ       14h         ; y5
ty6             equ       15h         ; y6
ty7             equ       16h         ; y7
ty8             equ       17h         ; y8
ty9             equ       18h         ; y9
ty0             equ       19h         ; y0
;
;       param equations have bit 5 set
;
tx1t            equ       20h         ; x1t
ty1t            equ       21h         ; y1t
tx2t            equ       22h         ; x2t
ty2t            equ       23h         ; y2t
tx3t            equ       24h         ; x3t
ty3t            equ       25h         ; y3t
tx4t            equ       26h         ; x4t
ty4t            equ       27h         ; y4t
tx5t            equ       28h         ; x5t
ty5t            equ       29h         ; y5t
tx6t            equ       2ah         ; x6t
ty6t            equ       2bh         ; y6t
;
;       polar equations have bit 6 set
;
tr1             equ       40h         ; r1
tr2             equ       41h         ; r2
tr3             equ       42h         ; r3
tr4             equ       43h         ; r4
tr5             equ       44h         ; r5
tr6             equ       45h         ; r6
;
;       recursion equations have bit 7 set
;
tun             equ       80h         ; un
tvn             equ       81h         ; vn
twn             equ       82h         ; wn
;
;======================================================================
;           2nd half of user picture tokens                                
;======================================================================
;
tpic1           equ       00h         ; pic1
tpic2           equ       01h         ; pic2
tpic3           equ       02h         ; pic3
tpic4           equ       03h         ; pic4
tpic5           equ       04h         ; pic5
tpic6           equ       05h         ; pic6
tpic7           equ       06h         ; pic7
tpic8           equ       07h         ; pic8
tpic9           equ       08h         ; pic9
tpic0           equ       09h         ; pic0
; 
;======================================================================
;           2nd half of user graph database tokens                         
;======================================================================
;
tgdb1           equ       00h         ; gdb1
tgdb2           equ       01h         ; gdb2
tgdb3           equ       02h         ; gdb3
tgdb4           equ       03h         ; gdb4
tgdb5           equ       04h         ; gdb5
tgdb6           equ       05h         ; gdb6
tgdb7           equ       06h         ; gdb7
tgdb8           equ       07h         ; gdb8
tgdb9           equ       08h         ; gdb9
tgdb0           equ       09h         ; gdb0
;  
;======================================================================
;           2nd half of string vars                                        
;======================================================================
;
tstr1           equ       00h
tstr2           equ       01h
tstr3           equ       02h
tstr4           equ       03h
tstr5           equ       04h
tstr6           equ       05h
tstr7           equ       06h
tstr8           equ       07h
tstr9           equ       08h
tstr0           equ       09h

; 
;======================================================================
;           2nd half of system output only variables                       
;======================================================================
;
;
;   open        equ       00h
;
tregeq          equ       01h         ; regression equation
;
tstatn          equ       02h         ; statistics n
;
txmean          equ       03h         ; x mean
tsumx           equ       04h         ; sum(x)
tsumxsqr        equ       05h         ; sum(x^2)
tstdx           equ       06h         ; standard dev x
tstdpx          equ       07h         ; standard dev pop x
tminx           equ       08h         ; min x value
tmaxx           equ       09h         ; max x value
;
tminy           equ       0ah         ; min y value
tmaxy           equ       0bh         ; max y value
tymean          equ       0ch         ; y mean
tsumy           equ       0dh         ; sum(y)
tsumysqr        equ       0eh         ; sum(y^2)
tstdy           equ       0fh         ; standard dev y
tstdpy          equ       10h         ; standard dev pop y
;
tsumxy          equ       11h         ; sum(xy)
tcorr           equ       12h         ; correlation
tmedx           equ       13h         ; med(x)
tq1             equ       14h         ; 1st quadrant of x
tq3             equ       15h         ; 3rd quadrant of x
tquada          equ       16h         ; 1st term of quad poly reg/ y-int
tquadb          equ       17h         ; 2nd term of quad poly reg/ slope
tquadc          equ       18h         ; 3rd term of quad poly reg
tcubed          equ       19h         ; 4th term of cubic poly reg
tquarte         equ       1ah         ; 5th term of quart poly reg
tmedx1          equ       1bh         ; x1 for med-med
tmedx2          equ       1ch         ; x2 for med-med
tmedx3          equ       1dh         ; x3 for med-med
tmedy1          equ       1eh         ; y1 for med-med
tmedy2          equ       1fh         ; y2 for med-med
tmedy3          equ       20h         ; y3 for med-med
;
trecurn		equ       21h		; recursion n
tstatp          equ       22h
tstatz          equ       23h
tstatt          equ       24h
tstatchi        equ       25h
tstatf          equ       26h
tstatdf         equ       27h
tstatphat       equ       28h
tstatphat1      equ       29h
tstatphat2      equ       2ah
tstatmeanx1     equ       2bh
tstatstdx1      equ       2ch
tstatn1         equ       2dh
tstatmeanx2     equ       2eh
tstatstdx2      equ       2fh
tstatn2         equ       30h
tstatstdxp      equ       31h
tstatlower      equ       32h
tstatupper      equ       33h
tstat_s         equ       34h
tlrsqr          equ       35h         ; r^2
tbrsqr          equ       36h         ; r^2
;
;======================================================================
;       these next tokens are only used to access the data
;       they are display only and the user cannot access them at all
;======================================================================
;
tf_df    equ     37h       ; anofav factor df
tf_ss    equ     38h       ; anofav factor ss
tf_ms    equ     39h       ; anofav factor ms
te_df    equ     3ah       ; anofav error df
te_ss    equ     3bh       ; anofav error ss
te_ms    equ     3ch       ; anofav error ms
;
;
;======================================================================
;           2nd half of system input/output variables
;======================================================================
;      system variable equates
;
tuxscl       equ  0
tuyscl       equ  1
txscl        equ  2
tyscl        equ  3
trecuru0     equ  4        ; u 1st initial cond
trecurv0     equ  5        ; v 1st initial cond
tun1         equ  6        ; u(n-1)    ; not used
tvn1         equ  7        ; v(n-1)    ; not used
turecuru0    equ  8        ;
turecurv0    equ  9        ;
;
txmin        equ  0ah
txmax        equ  0bh
tymin        equ  0ch
tymax        equ  0dh
ttmin        equ  0eh
ttmax        equ  0fh
tthetamin    equ  10h
tthetamax    equ  11h
tuxmin       equ  12h
tuxmax       equ  13h
tuymin       equ  14h
tuymax       equ  15h
tuthetmin    equ  16h
tuthetmax    equ  17h
tutmin       equ  18h
tutmax       equ  19h
ttblmin      equ  1ah
tplotstart   equ  1bh
tuplotstart  equ  1ch
tnmax        equ  1dh
tunmax       equ  1eh
tnmin        equ  1fh
tunmin       equ  20h
;
ttblstep	equ  21h
ttstep		equ  22h
tthetastep	equ  23h
tutstep		equ  24h
tuthetstep	equ  25h
;
tdeltax		equ  26h
tdeltay		equ  27h
;
txfact		equ  28h
tyfact		equ  29h
;
ttblinput       equ       2ah
;
tfinn           equ       2bh
tfini           equ       2ch
tfinpv          equ       2dh
tfinpmt         equ       2eh
tfinfv          equ       2fh
tfinpy          equ       30h
tfincy          equ       31h
;
trecurw0        equ       32h         ; w0(1)
turecurw0       equ       33h
;
tplotstep       equ       34h
tuplotstep      equ       35h
;
txres           equ       36h
tuxres          equ       37h
;
trecuru02       equ       38h         ; u0(2)
turecuru02      equ       39h
trecurv02       equ       3ch         ; v0(2)
turecurv02      equ       3dh
trecurw02       equ       3eh         ; w0(2)
turecurw02      equ       3fh
;
;======================================================================
;           2nd byte of t2bytetok tokens
;======================================================================
;
tfinnpv         equ       00h         ;
tfinirr         equ       01h         ;
tfinbal         equ       02h         ;
tfinprn         equ       03h         ;
tfinint         equ       04h         ;
tfintonom       equ       05h         ;
tfintoeff       equ       06h         ;
tfindbd         equ       07h         ;
tlcm            equ       08h         ;
tgcd            equ       09h         ;
trandint        equ       0ah         ;
trandbin        equ       0bh         ;
tsubstrng       equ       0ch         ;
tstddev         equ       0dh         ;
tvariance       equ       0eh         ;
tinstrng        equ       0fh         ;
tdnormal        equ       10h         ;
tinvnorm        equ       11h         ;
tdt             equ       12h         ;
tchi            equ       13h         ;
tdf             equ       14h         ;
tbinpdf         equ       15h         ;
tbincdf         equ       16h         ;
tpoipdf         equ       17h         ;
tpoicdf         equ       18h         ;
tgeopdf         equ       19h         ;
tgeocdf         equ       1ah         ;
tnormalpdf      equ       1bh         ;
ttpdf           equ       1ch         ;
tchipdf         equ       1dh         ;
tfpdf           equ       1eh         ;
trandnorm       equ       1fh         ;
tfinfpmt        equ       20h         ;
tfinfi          equ       21h         ;
tfinfpv         equ       22h         ;
tfinfn          equ       23h         ;
tfinffv         equ       24h         ;
tconj           equ       25h         ;
treal           equ       26h         ;
timag           equ       27h         ;
tangle          equ       28h         ;
tcumsum         equ       29h         ;
texpr           equ       2ah         ;
tlength         equ       2bh         ;
tdeltalst       equ       2ch         ;
tref            equ       2dh         ;
trref           equ       2eh         ;
ttorect         equ       2fh         ;
ttopolar        equ       30h         ;
tconste         equ       31h         ;
tsinreg         equ       32h         ;
tlogistic       equ       33h         ;
tlinregttest    equ       34h         ;
tshadenorm      equ       35h         ;
tshadet         equ       36h         ;
tshadechi       equ       37h         ;
tshadef         equ       38h         ;
tmattolst       equ       39h         ;
tlsttomat       equ       3ah         ;
tztest          equ       3bh         ;
tttest          equ       3ch         ;
t2sampztest     equ       3dh         ;
t1propztest     equ       3eh         ;
t2propztest     equ       3fh         ;
tchitest        equ       40h         ;
tzintval        equ       41h         ;
t2sampzint      equ       42h         ;
t1propzint      equ       43h         ;
t2propzint      equ       44h         ;
tgraphstyle     equ       45h         ;
t2sampttest     equ       46h         ;
t2sampftest     equ       47h         ;
ttintval        equ       48h         ;
t2samptint      equ       49h         ;
tsetuplst       equ       4ah         ;
tfinpmtend      equ       4bh         ;
tfinpmtbeg      equ       4ch         ;
trealm          equ       4dh         ;
tpolarm         equ       4eh         ;
trectm          equ       4fh         ;
texpron         equ       50h         ;
texproff        equ       51h         ;
tclralllst      equ       52h         ;
tgetcalc        equ       53h         ;
tdelvar         equ       54h         ;
tequtostrng     equ       55h         ;
tstrngtoequ     equ       56h         ;
tdellast        equ       57h         ;
tselect         equ       58h         ;
tanova          equ       59h         ;
tmodbox         equ       5ah         ;
tnormprob       equ       5bh         ;
;
;
tmgt            equ       64h         ; vertical split
tzfit           equ       65h         ; zoom fit
tdiag_on        equ       66h         ; dianostic display on
tdiag_off       equ       67h         ; dianostic display off
tokend2v0       equ       67h         ;end of 2byte tokens for version 0.
tarchive        equ       68h         ;archive
tunarchive      equ       69h         ;unarchive
tasm		equ	  6ah
tasmcomp	equ	  6bh	      ; asm compile
tasmprgm	equ	  6ch	      ; signifies a program is asm
tasmcmp 	equ	  6dh	      ; asm program is compiled
;
tlcapaacute     equ       6eh
tlcapagrave     equ       6fh
tlcapacaret     equ       70h
tlcapadier      equ       71h
tlaacute        equ       72h
tlagrave        equ       73h
tlacaret        equ       74h
tladier         equ       75h
tlcapeacute     equ       76h
tlcapegrave     equ       77h
tlcapecaret     equ       78h
tlcapedier      equ       79h
tleacute        equ       7ah
tlegrave        equ       7bh
tlecaret        equ       7ch
tledier         equ       7dh
;
tlcapigrave     equ       7fh
tlcapicaret     equ       80h
tlcapidier      equ       81h
tliacute        equ       82h
tligrave        equ       83h
tlicaret        equ       84h
tlidier         equ       85h
tlcapoacute     equ       86h
tlcapograve     equ       87h
tlcapocaret     equ       88h
tlcapodier      equ       89h
tloacute        equ       8ah
tlograve        equ       8bh
tlocaret        equ       8ch
tlodier         equ       8dh
tlcapuacute     equ       8eh
tlcapugrave     equ       8fh
tlcapucaret     equ       90h
tlcapudier      equ       91h
tluacute        equ       92h
tlugrave        equ       93h
tlucaret        equ       94h
tludier         equ       95h
tlcapcced       equ       96h
tlcced          equ       97h
tlcapntilde     equ       98h
tlntilde        equ       99h
tlaccent        equ       9ah
tlgrave         equ       9bh
tldieresis      equ       9ch
tlquesdown      equ       9dh
tlexclamdown    equ       9eh
tlalpha         equ       9fh
tlbeta          equ      0a0h
tlgamma         equ      0a1h
tlcapdelta      equ      0a2h
tldelta         equ      0a3h
tlepsilon       equ      0a4h
tllambda        equ      0a5h
tlmu            equ      0a6h
tlpi            equ      0a7h
tlrho           equ      0a8h
tlcapsigma      equ      0a9h
;
;
tlphi           equ      0abh
tlcapomega      equ      0ach
tlphat          equ      0adh
tlchi           equ      0aeh
tlstatf         equ      0afh
;

tla      equ     0b0h
tlb      equ     0b1h
tlc      equ     0b2h
tld      equ     0b3h
tlsmalle equ     0b4h
tlf      equ     0b5h
tlsmallg equ     0b6h
tlh      equ     0b7h
tli      equ     0b8h
tlj      equ     0b9h
tlk      equ     0bah
;

tll      equ     0bch
tlm      equ     0bdh
;tln      equ     0beh
tlo      equ     0bfh
tlp      equ     0c0h
tlq      equ     0c1h
tlsmallr equ     0c2h
tls      equ     0c3h
tlsmallt equ     0c4h
tlu      equ     0c5h
tlv      equ     0c6h
tlw      equ     0c7h
tlx      equ     0c8h
tly      equ     0c9h
tlz      equ     0cah
tlsigma         equ      0cbh
tltau           equ      0cch
tlcapiacute     equ      0cdh
;
;
tgarbagec equ    0ceh
lasttoken       equ      0ceh         ;tlast token in this version...
;
;======================================================================
;           data type equates                                                    
;======================================================================
;
realobj         equ       0
listobj         equ       1
matobj          equ       2
equobj          equ       3
strngobj        equ       4
progobj         equ       5
protprogobj     equ       6
pictobj         equ       7
gdbobj          equ       8
unknownobj      equ       9
unknownequobj   equ       0ah
newequobj       equ       0bh
cplxobj         equ       0ch
clistobj        equ       0dh
undefobj        equ       0eh
windowobj       equ       0fh
zstoobj         equ       10h
tblrngobj       equ       11h
lcdobj          equ       12h
backupobj       equ       13h
appobj		equ	  14h		;application, only used in menus/link
appvarobj	equ	  15h		;application variable
tempprogobj     equ       16h           ;program, home deletes when finished
groupobj        equ       17h           ;group.
; 
;======================================================================
;	    parser equates
;======================================================================
oprand      equ              trand
opprod      equ              tprod
opsum       equ              tsum
opadd       equ              tadd
opsub       equ              tsub
opmult      equ              tmul
opdiv       equ              tdiv
oppower     equ              tpower
opxroot     equ              txroot
opeq        equ              teq
opneq       equ              tne
opround2    equ              tround
opaug       equ              taug
opmax       equ              tmax
opmin       equ              tmin
opand       equ              tand
opor        equ              tor
opxor       equ              txor
opncr       equ              tncr
opnpr       equ              tnpr
oplt        equ              tlt
ople        equ              tle
opgt        equ              tgt
opge        equ              tge
;
oplog       equ              tlog
optenx      equ              talog
opln        equ              tln
opetox      equ              texp
opnot       equ              tnot
opsin       equ              tsin
opasin      equ              tasin
opcos       equ              tcos
opacos      equ              tacos
optan       equ              ttan
opatan      equ              tatan
opsinh      equ              tsinh
opasinh     equ              tasinh
opcosh      equ              tcosh
opacosh     equ              tacosh
optanh      equ              ttanh
opatanh     equ              tatanh
opinverse   equ              trecip
opdet       equ              tdet
opsqroot    equ              tsqrt
opsquare    equ              tsqr
opnegate    equ              tchs
opipart     equ              tipart
opfpart     equ              tfpart
opintgr     equ              tint
opfact      equ              tfact
opabs       equ              tabs
opident     equ              tident
optranspose equ              ttrnspos
opsorta     equ              tsorta
opsortd     equ              tsortd
optodec     equ              ttodec
optofrac    equ              ttoabc
opradd      equ              trowplus
oprmlt      equ              tmrow
oprswap     equ              trowswap
opmltradd   equ              tmrowplus
oprand1     equ              trandm
opsolve     equ              troot
opderiv81   equ              tnderiv
opquad      equ              tfnint
opseq       equ              tseries
opdim       equ              tdim
oprad       equ              tfromrad
opdeg       equ              tfromdeg
oprtopr     equ              trtopr
oprtopo     equ              trtopo
opptorx     equ              tptorx
opptory     equ              tptory
opcube      equ              tcube
opcbrt      equ              tcubrt
opfmin      equ              tfmin
opfmax      equ              tfmax
opnpv           equ       tif         ; immediate unary
opirr           equ       tif+1       ; immediate unary
opbal           equ       tif+2       ; immediate unary
opprn           equ       tif+3       ; immediate unary
opintr          equ       tif+4       ; immediate unary
optonom         equ       tif+5       ; immediate unary
optoeff         equ       tif+6       ; immediate unary
opfindbd           equ       tif+7       ; immediate unary
oplcm           equ       tif+8       ; immediate unary
opgcd           equ       tif+9       ; immediate unary
oprandint       equ       tif+10      ; immediate unary
oprandbin        equ      tif+11      ; immediate unary
opsubstr        equ       tif+12      ; immediate unary
opstdev         equ       tif+13      ; immediate unary
opvariance      equ       tif+14      ; immediate unary
opinstr         equ       tif+15      ; immediate unary
opnormal        equ       tif+16      ; immediate unary
opinormal       equ       tif+17      ; immediate unary
opdt            equ       tif+18      ; immediate unary
opchi           equ       tif+19      ; immediate unary
opdf            equ       tif+20      ; immediate unary
opbinpdf        equ       tif+21      ; immediate unary
opbincdf        equ       tif+22      ; immediate unary
oppoipdf        equ       tif+23      ; immediate unary
oppoicdf        equ       tif+24      ; immediate unary
opgeopdf        equ       tif+25      ; immediate unary
opgeocdf        equ       tif+26      ; immediate unary
opnormalpdf     equ       tif+27      ; immediate unary
optpdf          equ       tif+28      ; immediate unary
opchipdf        equ       tif+29      ; immediate unary
opfpdf          equ       tif+30      ; immediate unary
oprandnrm       equ       tif+31      ; immediate unary
opconj           equ       tzoomin
opreal           equ       tzoomin	   +1
opimag           equ       tzoomin	   +2
opangle          equ       tzoomin	   +3
opcumsum         equ       tzoomin	   +4
opexpr           equ       tzoomin	   +5
oplength         equ       tzoomin	   +6
opdeltalst       equ       tzoomin	   +7
opref            equ       tzoomin	   +8
oprref           equ       tzoomin	   +9
opconst          equ       tzoomin	   +10

; 
;======================================================================
;           i/o equates                                                          
;======================================================================
;
d0d1_bits	equ  03h
d0ld1l		equ  03h
d0ld1h		equ  01h
d0hd1l		equ  02h
d0hd1h		equ  00h
bport		equ  0			; 4-bit link port (i/o) 
;
;======================================================================
;	interrupt equates
;======================================================================
;
iall	equ 1011b
intrptenport	equ 3 ; interrupt enable (in/out) 
;
;======================================================================
;	Memory paging equates
;======================================================================
;
mempageaport	equ 6 ; memory page A (in/out)
;
;======================================================================
;	lcd driver equates
;======================================================================
lcdinstport	equ 10h
lcddataport equ 11h
;
;======================================================================
;           device codes                                                       
;======================================================================
;
;
ti82dev		equ  82h
pc82dev		equ  02h
mac82dev	equ  12h
;
link83fdev	equ  23h
;
ti83dev		equ  83h
pc83dev		equ  03h
mac83dev	equ  13h
;
ti85dev		equ  95h      ; diff then real 85 so me talk
pc85dev		equ  05h
mac85dev	equ  15h
;
ti73dev		equ  74h      ; device x3 is always an 83
pc73dev		equ  07h
mac73dev	equ  17h
;
ti83fdev	equ  73h
link73fdev	equ  23h
pc83fdev	equ  23h
;
;======================================================================
;           system error codes                                                  
;======================================================================
;
e_editf		equ	7		;allow re-entering application
e_edit		equ	1<<e_editf
e_mask		equ	7fh

e_overflow	equ	1+e_edit
e_divby0	equ	2+e_edit
e_singularmat	equ	3+e_edit
e_domain	equ	4+e_edit
e_increment	equ	5+e_edit
e_break		equ	6+e_edit
e_nonreal       equ     7+e_edit
e_syntax        equ     8+e_edit
e_datatype      equ     9+e_edit
e_argument      equ     10+e_edit
e_dimmismatch   equ     11+e_edit
e_dimension     equ     12+e_edit
e_undefined     equ     13+e_edit
e_memory        equ     14+e_edit
e_invalid       equ     15+e_edit
e_illegalnest   equ     16+e_edit
e_bound         equ     17+e_edit
e_graphrange    equ     18+e_edit
e_zoom          equ     19+e_edit
e_label         equ     20
e_stat          equ     21
e_solver        equ     22+e_edit
e_singularity   equ     23+e_edit
e_signchange    equ     24+e_edit
e_iterations    equ     25+e_edit
e_badguess      equ     26+e_edit
e_statplot      equ     27
e_toltoosmall   equ     28+e_edit
e_reserved      equ     29+e_edit
e_mode          equ     30+e_edit
e_lnkerr        equ     31+e_edit
e_lnkmemerr     equ     32+e_edit
e_lnktranserr   equ     33+e_edit
e_lnkduperr     equ     34+e_edit
e_lnkmemfull    equ     35+e_edit
e_unknown       equ     36+e_edit

e_scale         equ     37+e_edit
e_idnotfound    equ     38
e_nomode        equ     39+e_edit
e_validation    equ     40
e_length        equ     41+e_edit
e_application   equ     42+e_edit
e_apperr1       equ     43+e_edit
e_apperr2       equ     44+e_edit
e_expiredapp	equ	45
e_badaddr	equ	46
e_archived      equ     47+e_edit
e_version       equ     48
e_archfull      equ     49
e_variable      equ     50+e_edit
e_duplicate     equ     51+e_edit
higerrnum       equ     51


; obsolete error numbers34              ;first link error
e_linkiochksum	equ	34
e_linkiotimeout	equ	35
e_linkiobusy	equ	36
e_linkiover	equ	37

;
;======================================================================
;           equates to ram locations for stat vars 
;======================================================================
;
;
fplen	equ	9		;length of a floating-point number.
statn   equ     statvars
xmean   equ     statn      + fplen
sumx    equ     xmean      + fplen
sumxsqr equ     sumx       + fplen
stdx    equ     sumxsqr    + fplen
stdpx   equ     stdx       + fplen
minx    equ     stdpx      + fplen
maxx    equ     minx       + fplen
miny    equ     maxx       + fplen
maxy    equ     miny       + fplen
ymean   equ     maxy       + fplen
sumy    equ     ymean      + fplen
sumysqr equ     sumy       + fplen
stdy    equ     sumysqr    + fplen
stdpy   equ     stdy       + fplen
sumxy   equ     stdpy      + fplen
corr    equ     sumxy      + fplen
medx    equ     corr       + fplen
q1      equ     medx       + fplen
q3      equ     q1         + fplen
quada   equ     q3         + fplen
quadb   equ     quada      + fplen
quadc   equ     quadb      + fplen
cubed   equ     quadc      + fplen
quarte  equ     cubed      + fplen
medx1   equ     quarte     + fplen
medx2   equ     medx1      + fplen
medx3   equ     medx2      + fplen
medy1   equ     medx3      + fplen
medy2   equ     medy1      + fplen
medy3   equ     medy2      + fplen
pstat   equ     medy3      + 2*fplen
zstat   equ     pstat      + fplen
tstat   equ     zstat      + fplen
chistat equ     tstat      + fplen
fstat   equ     chistat    + fplen
df      equ     fstat      + fplen
phat    equ     df         + fplen
phat1   equ     phat       + fplen
phat2   equ     phat1      + fplen
meanx1  equ     phat2      + fplen
stdx1   equ     meanx1     + fplen
statn1  equ     stdx1      + fplen
meanx2  equ     statn1     + fplen
stdx2   equ     meanx2     + fplen
statn2  equ     stdx2      + fplen
stdxp2  equ     statn2     + fplen
slower  equ     stdxp2     + fplen
supper  equ     slower     + fplen
sstat   equ     supper     + fplen

f_df	equ     anovaf_vars
f_ss	equ     f_df + fplen
f_ms	equ     f_ss + fplen
e_df	equ     f_ms + fplen
e_ss	equ     e_df + fplen
e_ms	equ     e_ss + fplen
