; Omnicalc v1.00
; (C) 2002 Michael Vincent.
;
;This library is free software; you can redistribute it and/or
;modify it under the terms of the GNU Lesser General Public
;License as published by the Free Software Foundation; either
;version 2.1 of the License, or (at your option) any later version.
;
;This library is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;Lesser General Public License for more details.
;
;You should have received a copy of the GNU Lesser General Public
;License along with this library; if not, write to the Free Software
;Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
;

; Omnicalc v1.0
; Michael Vincent - michael@detacheds.com
;
; Copyright (C) 2001, by Michael Vincent. All rights reserved.
; Developed for Detached Solutions - www.detacheds.com
; Project started 6-06-01.
; Rewrite started 12-21-01.

;Forecast 3.00
;Michael Peterson September, 2003

 NOLIST
 INCLUDE "ti83plus.inc"
 INCLUDE "michael.inc"
 LIST
 INCLUDE "equates.inc"
 GLOBALS ON
 INCLUDE "header.inc"
 include "Forecast.asm"
 	jp TotalAppStart
TotalAppStart:
	ld hl,Appvar
	rst 20h
	B_CALL ChkFindSym
	jr nc,StartApp
	ld hl,14
	B_CALL CreateAppVar
	ex de,hl
	inc hl
	inc hl
	ld b,14
CreateAppVar_Loop:
	ld (hl),0
	inc hl
	djnz CreateAppVar_Loop
	jr StartApp2
StartApp:
	ld a,b
	or a
	jr z,StartApp2
	B_CALL Arc_Unarc
StartApp2:
	ld hl,CatalogAppVar
	rst 20h
	B_CALL ChkFindSym
	jr nc,StartApp3
	ld hl,16
	B_CALL CreateAppVar
	ld b,16
	ex de,hl
	inc hl
	inc hl
StartApp_Clear:
	ld (hl),0
	inc hl
	djnz StartApp_Clear
StartApp3:
	call GetRealSettings
	bit 0,(hl)
	call nz,InstallHooks2
	B_CALL ForceFullScreen
MainMenu:
	B_CALL ClrLCDFull
	ld hl,Splash_Title
	ld de,9872h
	ld bc,400
	ldir
	ld hl,9872h
	ld de,1*256+0
	;ld de,1*256+7
	B_CALL DisplayImage
	ld hl,27*256+29
	ld (pencol),hl
	ld hl,Intro_Version
	call vputstr
	ld hl,Splash_W
	ld de,9872h
	ld bc,3
	ldir
	ld hl,9872h
	ld de,55*256+5
	;B_CALL DisplayImage
	xor a
	ld (counter),a
	call GetRealSettings
	bit 0,(hl)
	call nz,InstallHooks2
	;B_CALL ClrScrnFull
	;B_CALL GrBufClr
	ld hl,40*256+0
	ld de,62*256+94
	B_CALL ClearRect
	ld hl,0
	ld de,7*256+95
	;B_CALL FillRect
	ld bc,0*256+7
	ld de,93*256+7
	B_CALL DarkLine
	set textInverse,(iy+textFlags)
	ld hl,30
	ld (pencol),hl
	;ld hl,Title_MainMenu
	;call vputstr
	res textInverse,(iy+textFlags)
	ld hl,Menu_Main
	call DisplayMenu
	ld hl,57*256
	ld (pencol),hl
	ld hl,MainScreenInstalled
	call vputstr
	call GetRealSettings
	ld a,(hl)
	ld hl,YesNo
	and 1
	add a,a
	add a,a
	ld d,0
	ld e,a
	add hl,de
	call vputstr
MainMenuLoop:
	B_CALL GetKey
	cp 3
	call z,MenuMoveUp
	cp 4
	call z,MenuMoveDown
	cp 5
	jr z,MainMenuSelected
	cp 9
	jr z,exitapp
	cp 40h
	jr z,exitapp
	cp 8Fh
	jp z,Forecast
	cp 90h
	jp z,InstallRemove
	cp 91h
	jp z,exitapp
	cp 92h
	jr nz,MainMenuLoop
exitapp:
	B_CALL ReloadAppEntryVecs
	B_CALL SetTblGraphDraw
	B_JUMP JForceCmdNoChar
MainMenuSelected:
	ld a,(currentmenu)
	dec a
	jp z,Forecast
	dec a
	jp z,InstallRemove
	dec a
	jp z,exitapp
	dec a
	jr z,exitapp
InstallRemove:
	;B_CALL GrBufClr
	;B_CALL ClrScrnFull
	ld hl,57*256
	ld (pencol),hl
	ld hl,MainScreenInstalled
	call vputstr
	B_CALL GetBaseVer
	ld h,a
	ld l,b
	ld de,010Dh
	or a
	sbc hl,de
	jr c,OldBaseVersion
	call GetRealSettings
	bit 0,(hl)
	jp nz,Settings_Uninstall
	call DisplayMessageBox
	bit GetKeyHook,(iy+Hooks1)
	jp nz,Install_Hooks_Already
	bit TokenHook,(iy+Hooks2)
	jr nz,Install_Hooks_Already
	bit ParserHook,(iy+Hooks3)
	jr nz,Install_Hooks_Already
	bit cxMainHook,(iy+Hooks1)
	jr nz,Install_Hooks_Already
	bit GetcscHook,(iy+Hooks1)
	jr nz,Install_Hooks_Already
	bit FontHook,(iy+Hooks2)
	jr nz,Install_Hooks_Already
	ld hl,14*256+17
	ld (pencol),hl
	ld hl,Settings_Installed
	call vputstr
	ld de,21*256+17
	ld (penCol),de
	call vputstr
	ld de,28*256+17
	ld (pencol),de
	call vputstr
	call InstallHooks
	call GetRealSettings
	set 0,(hl)
	res onInterrupt,(iy+onFlags)
	B_CALL GetKey
	cp 40h
	jp z,exitapp
	jp MainMenu
OldBaseVersion:
	call DisplayMessageBox
	ld hl,14*256+17
	ld (pencol),hl
	ld hl,OldBaseVersion_Text
	call vputstr
	ld de,20*256+17
	ld (pencol),de
	call vputstr
	ld de,30*256+27
	ld (pencol),de
	call vputstr
	B_CALL GetKey
	jp exitapp
Install_Hooks_Already:
	call DrawYesNo
	ld hl,14*256+17
	ld (pencol),hl	
	ld hl,Settings_Already
	call vputstr
	ld de,21*256+17
	ld (pencol),de
	call vputstr
	ld de,57*256+4
	ld (pencol),de
	call vputstr
	ld a,25
	ld (pencol),a
	call vputstr
Settings_Overwriteloop:
	B_CALL GetKey
	cp 40h
	jp z,exitapp
	cp 48h
	jp z,MainMenu
	cp 49h
	jr nz,Settings_Overwriteloop
	call DisableHooks
	call GetRealSettings
	res 0,(hl)
	jp InstallRemove
DrawYesNo:
	ld hl,57*256+0
	ld de,62*256+27
	B_CALL ClearRect
	ld bc,0
	ld de,5
	B_CALL DarkLine
	ld bc,19*256
	ld de,19*256+5
	B_CALL DarkLine
	ld bc,38*256
	ld de,38*256+5
	B_CALL DarkLine
	ld bc,2*256+7
	ld de,17*256+7
	B_CALL DarkLine
	ld bc,21*256+7
	ld de,36*256+7
	B_CALL DarkLine
	ld d,2
	ld bc,1*256+6
	B_CALL ipoint
	ld bc,18*256+6
	B_CALL ipoint
	ld bc,20*256+6
	B_CALL ipoint
	ld bc,37*256+6
	B_CALL ipoint
	ret
Settings_Uninstall:
	call DisableHooks
	call DisplayMessageBox
	call DrawYesNo
	ld hl,Uninstall_Prompt
	ld de,14*256+17
	ld (pencol),de
	call vputstr
	ld de,21*256+17
	ld (pencol),de
	call vputstr
	ld de,57*256+4
	ld (pencol),de
	call vputstr
	ld a,25
	ld (pencol),a
	call vputstr
Settings_Uninstall_YesNo:
	ei
	halt
	B_CALL GetCSC
	cp skWindow
	jp z,Settings_Uninstall_Done
	cp skYEqu
	jr nz,Settings_Uninstall_YesNo
	;Now begin the uninstall
	;Now check for wandering tokens
	;Search BASIC programs
	;String variables (answer variable included)
	;Equation variables
	;Past entries first
	B_CALL RunIndicOn
	ld a,(numLastEntries)
	ld b,a
	ld hl,lastEntryStk
Uninstall_Entries_Loop:
	push bc
	call Uninstall_ReplaceTokens
	pop bc
	djnz Uninstall_Entries_Loop
	;Now for programs
	ld hl,(progPtr)
Uninstall_BASIC_Loop:
	ld bc,(pTemp)
	or a
	sbc hl,bc
	jr z,Uninstall_BASIC_Done
	jr c,Uninstall_BASIC_Done
	add hl,bc
	ld a,(hl)
	and 1Fh
	cp 5
	jr nz,Uninstall_BASIC_NotProgram
	ld de,-5
	add hl,de
	;HL points to page byte
	ld a,(hl)
	or a
	jr nz,Uninstall_BASIC_NotProgramPage
	inc hl
	ld d,(hl)
	inc hl
	ld e,(hl)
	push hl
	ex de,hl
	;HL points to data start, size bytes
	call Uninstall_ReplaceTokens
	pop hl
	dec hl
	dec hl
Uninstall_BASIC_NotProgramPage:
	ld de,5
	add hl,de
Uninstall_BASIC_NotProgram:
	ld de,-6
	add hl,de
	ld d,0
	ld e,(hl)
	inc e
	or a
	sbc hl,de
	jr Uninstall_BASIC_Loop
Uninstall_BASIC_Done:
	;Now do equations and strings
	ld hl,symTable
Uninstall_Other_Loop:
	ld bc,(progPtr)
	or a
	sbc hl,bc
	jp c,Settings_Uninstall_Done
	jp z,Settings_Uninstall_Done
	add hl,bc
	ld a,(hl)
	and 1Fh
	cp StrngObj
	jr z,Uninstall_Other_Go
	cp EquObj
	jr z,Uninstall_Other_Go
	cp NewEquObj
	jr z,Uninstall_Other_Go
	ld de,-9
	add hl,de
	jr Uninstall_Other_Loop
Uninstall_Other_Go:
	dec hl
	dec hl
	dec hl
	ld e,(hl)
	dec hl
	ld d,(hl)
	ld bc,-5
	add hl,bc
	push hl
	ex de,hl
	call Uninstall_ReplaceTokens
	pop hl
	jr Uninstall_Other_Loop
Uninstall_ReplaceTokens:
	;Input:
	;HL - start of data, size bytes
	ld c,(hl)
	inc hl
	ld b,(hl)
	inc hl
	ld a,b
	or c
	ret z
Uninstall_ReplaceTokens_Loop:
	ld a,0BBh
	cpir
	;Z if found, NZ otherwise
	ret nz
	;Found a match. HL points to the byte for the next cpir, BC is bytes remaining.
	ld a,b
	or c
	ret z
	;We are not at the end of the variable.
	ld a,(hl)
	cp 0CFh
	jr c,Uninstall_ReplaceTokens_LoopPrepare
	ld (hl),9Dh
Uninstall_ReplaceTokens_LoopPrepare:
	ld a,b
	or c
	ret z
	dec bc
	inc hl
	jr Uninstall_ReplaceTokens_Loop
Settings_Uninstall_Done:
	B_CALL RunIndicOff
	;ld hl,plotSScreen
	;B_CALL SaveDisp
	ld hl,57*256
	ld (pencol),hl
	ld hl,MainScreenInstalled
	call vputstr
	call DisplayMessageBox
	ld hl,14*256+17
	ld (pencol),hl
	ld hl,Settings_Uninstalled
	call vputstr
	ld de,21*256+17
	ld (pencol),de
	call vputstr
	ld de,28*256+17
	ld (pencol),de
	call vputstr
	call GetRealSettings
	res 0,(hl)
	res onInterrupt,(iy+onFlags)
	B_CALL GetKey
	cp 40h
	jp z,exitapp
	;ld d,63
	;ld hl,plotSScreen
	;B_CALL RestoreDisp
	jp MainMenu
Uninstall_Prompt:
	DB "Rename illegal",0
	DB "tokens?",0
	DB "YES",0
	DB "NO",0
Settings_Uninstalled:
	DB "Forecast",0
	DB "unit converter",0
	DB "deactivated",0
Settings_Installed:
	DB "Forecast",0
	DB "unit converter",0
	DB "activated!",0
Settings_Already:
	DB "Hooks already exist",0
	DB "Overwrite?",0
	DB "YES",0
	DB "NO",0
OldBaseVersion_Text:
	DB "ROM 1.13 or higher",0
	DB "is required.",0
	DB "Press any key",0
MainScreenInstalled:
	DB "Unit Converter active?",6,0
YesNo:
	DB "No",0,0
	DB "Yes",0
DisableHooks:
	res GetcscHook,(iy+Hooks1)		;RawKeyHook (_getkey)
	res TokenHook,(iy+Hooks2)		;Token hook
	res ParserHook,(iy+Hooks3)		;Parser hook
	res cxMainHook,(iy+Hooks1)		;cxMain hook
	res GetKeyHook,(iy+Hooks1)		;GetKeyHook (_getcsc)
	res FontHook,(iy+Hooks2)		;Font hook
	ret
DisplayMessageBox:
	ld L,15
	ld h,14
	ld e,82
	ld d,39
	B_CALL ClearRect
	ld bc,16*256+50
	ld de,80*256+50
	B_CALL DarkLine
	ld bc,15*256+25
	ld de,81*256+25
	B_CALL DarkLine
	ld bc,16*256+24
	ld de,82*256+24
	B_CALL DarkLine
	ld de,81*256+49
	ld bc,81*256+25
	B_CALL DarkLine
	inc b
	inc d
	B_CALL DarkLine
	ld bc,15*256+49
	ld de,15*256+26
	B_CALL DarkLine
	ret
GetRealSettings:
	ld hl,Appvar
	rst 20h
	B_CALL ChkFindSym
	ld a,b
	or a
	jr nz,GetRealSettings_Archived
	jp c,GetRealSettings_NoExist
	ex de,hl
	inc hl
	inc hl
	ret
GetRealSettings_NoExist:
	ld hl,14
	B_CALL CreateAppVar
	ex de,hl
	inc hl
	inc hl
	ld b,14
GetRealSettings_NoExistLoop:
	ld (hl),0
	inc hl
	djnz GetRealSettings_NoExistLoop
	ret
GetRealSettings_Archived:
	B_CALL arc_unarc
	B_CALL ChkFindSym
	ex de,hl
	inc hl
	inc hl
	ret
InstallHooks:
	;set our non appvar byte
	xor a
	ld (rawKeyHookPtr+3),a
	;and our recursive parser thing
	ld (parserHookPtr+3),a
InstallHooks2:
	;First is _getkey hook.
	ld hl,Hook_Key
	in a,(6)
	B_CALL SetGetKeyHook
	;Token hook
	ld hl,Hook_Token
	in a,(6)
	B_CALL SetTokenHook
	;Parser hook
	ld hl,Hook_Parser
	in a,(6)
	B_CALL SetParserHook
	;Getcsc hook
	ld hl,csc_Hook
	in a,(6)
	B_CALL SetGetcscHook
	ld hl,cxMain_Hook
	in a,(6)
	B_CALL SetcxMainHook
;InstallHooks_SkipcxMain:
	call GetRealSettings
	bit 7,(hl)
	jr z,InstallHooks_NoLower
	set lwrCaseActive,(iy+appLwrCaseFlag)
	jr InstallHooks_SkipLowercase
InstallHooks_NoLower:
	res lwrCaseActive,(iy+appLwrCaseFlag)
InstallHooks_SkipLowercase:
	inc hl
	inc hl
	ld (hl),10
	inc hl
	bit 0,(hl)
	ret z
	ret
DisplayMenu:
	;Input - HL points to menu structure
	ld a,(hl)	;Get number of menus
	ld (menulimit),a
	ld b,a
	inc hl
	ld de,33*256
	ld (pencol),de
DisplayMenuLoop:
	push bc
	call vputstr
	xor a
	ld (pencol),a
	ld a,(penrow)
	add a,8
	ld (penrow),a
	pop bc
	djnz DisplayMenuLoop
	ld a,1
	ld (currentmenu),a
	jr MenuItemSet
MenuMoveDown:
	ld a,(menulimit)
	ld b,a
	ld a,(currentmenu)
	cp b
	ret z
	call MenuItemClear
	ld hl,currentmenu
	inc (hl)
	jr MenuItemSet
MenuMoveUp:
	ld a,(currentmenu)
	cp 1
	ret z
	call MenuItemClear
	ld hl,currentmenu
	dec (hl)
	jr MenuItemSet
MenuItemSet:
	;Input - (currentmenu) is current item
	set textInverse,(iy+textFlags)
	xor a
	ld (pencol),a
	ld a,(currentmenu)
	ld b,a
	;ld a,2
	ld a,25
MenuItemAddLoop:
	add a,8
	djnz MenuItemAddLoop
	ld (penrow),a
	ld a,(currentmenu)
	dec a
	ld b,a
	add a,a
	add a,b
	ld d,0
	ld e,a
	ld hl,Menu_Data
	add hl,de
	ld a,(hl)
	B_CALL VPutMap
	inc hl
	ld a,(hl)
	B_CALL VPutMap
	inc hl
	ld a,(hl)
	B_CALL VPutMap
	ld h,1
	call MenuUnderline
	res textInverse,(iy+textFlags)
	ret
MenuUnderline:
	ld a,(penrow)
	add a,6
	ld b,a
	ld a,63
	sub b
	ld c,a
	ld e,a
	ld b,0
	ld d,6
	B_CALL ILine
	ret
MenuItemClear:
	;Input - (currentmenu) is current item
	xor a
	ld (pencol),a
	ld a,(currentmenu)
	ld b,a
	;ld a,2
	ld a,25
MenuItemAddLoop2:
	add a,8
	djnz MenuItemAddLoop2
	ld (penrow),a
	ld a,(currentmenu)
	dec a
	ld b,a
	add a,a
	add a,b
	ld d,0
	ld e,a
	ld hl,Menu_Data
	add hl,de
	ld a,(hl)
	B_CALL vputmap
	inc hl
	ld a,(hl)
	B_CALL vputmap
	inc hl
	ld a,(hl)
	B_CALL vputmap
	ld h,0
	call MenuUnderline
	ret
Title_MainMenu:
	DB "MAIN  MENU",0
Menu_Main:
	DB 3
	DB " 1:   Forecast",0
	DB " 2:   Unit Converter",0
	DB " 3:   Quit",0
Appvar:
	DB AppVarObj,"Forecast"
CatalogAppVar:
	DB AppVarObj,"UCcustom",0
;MirageOS:
;	DB AppVarObj,"MirageOS"
;MirageOSApp:
;	DB AppObj,"MirageOS"
Intro_Press:
	DB "PRESS ENTER",0
Menu_Data:
	DB " 1: 2: 3: 4: 5: 6: 7:"
Splash_Title:
	db 27,94
	db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000
	db 000h,03Fh,03Fh,0CFh,0F7h,0F9h,0FEh,01Eh,003h,0F9h,0FCh,000
	db 000h,07Fh,07Fh,0DFh,0F7h,0F3h,0FEh,03Fh,007h,0FBh,0FCh,000
	db 000h,07Eh,071h,0DEh,077h,083h,0C6h,07Fh,08Fh,0F3h,0F8h,000
	db 000h,070h,061h,0DCh,077h,003h,086h,0F3h,0DEh,000h,0F0h,000
	db 000h,070h,061h,0DCh,077h,003h,084h,0E1h,0DCh,000h,0F0h,000
	db 000h,070h,061h,0DCh,077h,003h,080h,0E1h,0DCh,000h,0F0h,000
	db 000h,070h,061h,0DCh,077h,003h,080h,0E1h,0DCh,000h,0F0h,000
	db 000h,070h,061h,0DCh,077h,003h,080h,0E1h,0DEh,000h,0F0h,000
	db 000h,07Ch,061h,0DFh,0E7h,0E3h,080h,0E1h,0CFh,0F0h,0F0h,000
	db 000h,07Ch,061h,0DFh,0C7h,0E3h,080h,0E1h,0C7h,0F8h,0F0h,000
	db 000h,078h,061h,0DFh,0E7h,0C3h,080h,0FFh,0C3h,0F8h,0F0h,000
	db 000h,070h,061h,0DEh,077h,003h,080h,0FFh,0C0h,078h,0F0h,000
	db 000h,070h,061h,0DCh,077h,003h,080h,0F1h,0C0h,038h,0F0h,000
	db 000h,070h,061h,0DCh,077h,003h,080h,0E1h,0C0h,038h,0F0h,000
	db 000h,070h,061h,0DCh,077h,003h,080h,0E1h,0C0h,038h,0F0h,000
	db 000h,070h,061h,0DCh,077h,003h,080h,0E1h,0C0h,038h,0F0h,000
	db 000h,070h,061h,0DCh,077h,003h,082h,0E1h,0C0h,038h,0F0h,000
	db 000h,070h,061h,0DCh,077h,003h,086h,0E1h,0C0h,078h,0F0h,000
	db 000h,070h,063h,0DCh,077h,003h,08Eh,0E1h,0DFh,0F8h,0F0h,000
	db 000h,070h,07Fh,0DCh,077h,0FBh,0FEh,0E1h,0DFh,0F0h,0F0h,000
	db 000h,060h,07Fh,098h,067h,0F1h,0FCh,0C1h,09Fh,0E0h,0F0h,000
	db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,0F0h,000
	db 000h,000h,000h,000h,000h,000h,000h,000h,000h,001h,0F0h,000
	db 000h,07Fh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0F0h,000
	db 000h,07Fh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0E0h,000
	db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000


Splash002:
	DB 21,81
	DB 0,0,0,0,0,0,0,0,6,0,0
	DB 0,0,0,0,0,0,0,0,14,0,0
	DB 0,0,0,0,0,0,0,0,14,0,0
	DB 7,224,0,0,0,0,0,0,6,0,0
	DB 31,240,0,0,0,3,0,0,6,0,0
	DB 60,120,0,0,0,3,0,0,6,0,0
	DB 112,28,0,0,0,0,0,0,6,0,0
	DB 96,28,64,0,24,7,0,31,6,0,0
	DB 192,12,254,124,59,135,7,223,134,15,128
	DB 192,12,255,254,63,199,31,193,134,63,128
	DB 192,12,227,142,56,231,56,1,134,48,0
	DB 192,12,195,6,48,230,48,1,198,96,0
	DB 192,28,195,6,48,102,32,15,198,96,0
	DB 192,24,195,6,48,102,32,29,134,96,0
	DB 224,56,195,14,48,198,48,49,134,96,0
	DB 240,112,195,12,48,199,56,51,142,112,0
	DB 127,224,195,28,48,199,31,255,142,63,128
	DB 31,128,195,28,49,199,15,221,206,31,128
	DB 0,0,0,28,1,192,0,1,192,0,0
	DB 0,0,0,0,0,0,0,1,128,0,0
	DB 0,0,0,0,0,0,0,0,0,0,0
Splash_DS:
	;DB 5,86
	DB 37,94
; Width:96 Height:37 (444 bytes)
	db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000
	db 001h,0DCh,000h,000h,000h,000h,000h,000h,000h,000h,00Eh,0E0
	db 007h,0FFh,000h,000h,000h,000h,000h,000h,000h,000h,03Fh,0F8
	db 00Fh,0FFh,080h,000h,000h,000h,000h,000h,000h,000h,07Fh,0FC
	db 01Fh,0FFh,0C0h,000h,000h,000h,000h,000h,000h,000h,0FFh,0FE
	db 01Fh,0FFh,0C0h,000h,000h,000h,000h,000h,000h,000h,0FFh,0FE
	db 03Fh,0FFh,0E0h,000h,000h,000h,000h,000h,000h,001h,0FFh,0FF
	db 03Fh,0FFh,0E0h,000h,000h,000h,000h,000h,000h,001h,0FFh,0FF
	db 07Fh,0FFh,0F0h,000h,000h,000h,000h,000h,000h,003h,0FFh,0FF
	db 07Fh,0FFh,0F0h,000h,000h,000h,000h,000h,000h,003h,0FFh,0FF
	db 07Fh,0FFh,0F0h,000h,000h,000h,000h,000h,000h,003h,0FFh,0FF
	db 03Fh,0FFh,0E0h,000h,000h,000h,000h,000h,000h,001h,0FFh,0FF
	db 03Fh,0FFh,0E0h,000h,000h,000h,000h,000h,000h,001h,0FFh,0FF
	db 03Fh,0FFh,0E0h,000h,000h,000h,000h,000h,000h,001h,0FFh,0FF
	db 01Fh,0FFh,0C0h,000h,000h,000h,000h,000h,000h,000h,0FFh,0FE
	db 000h,040h,000h,000h,000h,000h,000h,000h,000h,000h,002h,000
	db 000h,020h,000h,000h,000h,000h,000h,000h,000h,000h,001h,000
	db 000h,010h,000h,000h,0FCh,000h,003h,0F0h,000h,000h,000h,080
	db 000h,008h,000h,000h,0FEh,000h,007h,0F8h,000h,000h,000h,040
	db 000h,004h,000h,000h,0FFh,000h,00Fh,0FCh,000h,000h,000h,020
	db 000h,008h,000h,000h,007h,080h,00Eh,01Ch,000h,000h,000h,040
	db 000h,010h,000h,000h,003h,080h,00Ch,00Ch,000h,000h,000h,080
	db 000h,020h,000h,000h,001h,080h,00Ch,00Ch,000h,000h,001h,000
	db 000h,040h,000h,000h,001h,080h,00Ch,00Ch,000h,000h,002h,000
	db 000h,080h,000h,000h,001h,080h,00Ch,00Ch,000h,000h,004h,000
	db 001h,000h,000h,000h,003h,080h,00Ch,00Ch,000h,000h,008h,000
	db 000h,000h,000h,000h,03Fh,000h,00Ch,00Ch,000h,000h,000h,000
	db 000h,000h,000h,000h,03Fh,000h,00Ch,00Ch,000h,000h,000h,000
	db 000h,000h,000h,000h,003h,080h,00Ch,00Ch,000h,000h,000h,000
	db 000h,000h,000h,000h,001h,080h,00Ch,00Ch,000h,000h,000h,000
	db 000h,000h,000h,000h,001h,080h,00Ch,00Ch,000h,000h,000h,000
	db 000h,000h,000h,000h,003h,080h,00Ch,00Ch,000h,000h,000h,000
	db 000h,000h,000h,000h,007h,080h,00Ch,00Ch,000h,000h,000h,000
	db 000h,000h,000h,000h,0FFh,007h,00Eh,01Ch,000h,000h,000h,000
	db 000h,000h,000h,000h,0FEh,007h,007h,0F8h,000h,000h,000h,000
	db 000h,000h,000h,000h,0FCh,007h,003h,0F0h,000h,000h,000h,000
	db 000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000h,000

Splash_W:
	DB 1,8
	DB 10001000b
putstr:
	ld a,(hl)
	inc hl
	or a
	ret z
	B_CALL PutC
	jr putstr
vputstr:
	push af
	push de
	push ix
vputstr10:
	ld a,(hl)
	inc hl
	or a
	jr z,vputstr20
	B_CALL vputmap
	jr nc,vputstr10
vputstr20:
	pop ix
	pop de
	pop af
	ret
Pause:
	push af
Pause_Loop:
	B_CALL GetCSC
	ld (tempkey),a
	or a
	jr nz,Pause_Exit
	ei
	halt
	djnz Pause_Loop
Pause_Exit:
	pop af
	ret
getString:
	ld a,b
	or a
	ret z
getStringLoop:
	push bc
	xor a
	ld bc,-1
	cpir
	pop bc
	djnz getStringLoop
	ret
Vputs_Centered:
	ld c,0
	push hl
Vputs_Centered_Loop:
	push hl
	ld a,(hl)
	ld h,0
	ld l,a
	add hl,hl
	add hl,hl
	add hl,hl
	push bc
	B_CALL SFont_Len
	ld l,b
	pop bc
	ld a,c
	add a,l
	ld c,a
	pop hl
	inc hl
	ld a,(hl)
	or a
	jr nz,Vputs_Centered_Loop
	pop hl
	ld a,48
	sra c
	sub c
	ld (pencol),a
	ld de,(pencol)
	push de	;save cursor location
	push hl
	;HL now is start of string, and ready to display!
	call Display_EvenOffset_String
	ld b,35
	call Pause
	pop hl
	pop de
	ld (pencol),de
	push hl
	ld a,(hl)
	ld h,0
	ld l,a
	add hl,hl
	add hl,hl
	add hl,hl
	B_CALL SFont_Len
	ld a,(pencol)
	add a,b
	ld (pencol),a
	pop hl
	inc hl
Display_EvenOffset_String:
	ld a,(hl)
	or a
	ret z
	B_CALL VPutMap
	inc hl
	ld a,(hl)
	or a
	ret z
	push hl
	ld h,0
	ld l,a
	add hl,hl
	add hl,hl
	add hl,hl
	B_CALL SFont_Len
	ld a,(pencol)
	add a,b
	ld (pencol),a
	pop hl
	inc hl
	jr Display_EvenOffset_String
	INCLUDE "hooks.asm"
Intro_Version:
	DB "Version 3.00",0
CompareStrings:
	;HL, DE strings for B bytes
	;There is an undocumented B_CALL but this is ~2000 cycles faster
	ld a,(de)
	cp (hl)
	ret nz
	inc hl
	inc de
	djnz CompareStrings
	xor a
	ret
lcd_delay:
	push af
	call LCD_BUSY_QUICK
	pop af
	ret
