; Forecast v3.00
; (C) 2003 Michael Peterson.
;
;This library is free software; you can redistribute it and/or
;modify it under the terms of the GNU Lesser General Public
;License as published by the Free Software Foundation; either
;version 2.1 of the License, or (at your option) any later version.
;
;This library is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;Lesser General Public License for more details.
;
;You should have received a copy of the GNU Lesser General Public
;License along with this library; if not, write to the Free Software
;Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
;
cxMain_Hook:
	add a,e
	or a
	jp z,cxMain_BaseDisplay
	cp 3
	jp z,cxMain_BackupRAM
	cp 1
	jp nz,cxMain_Exit
	ld a,b
	cp kClear
	jp z,cxMain_Clear
	cp 86h	;right parenthesis
	jp nz,cxMain_Exit1
	push bc
	call GetRealSettings
	bit 1,(hl)
	jp z,cxMain_NoParen
	res indicrun,(iy+indicflags)
	ld hl,textshadow
	ld a,(currow)
	or a
	jr z,cxMain_RowWasZero
	ld b,a
	ld de,16
cxMain_Row16:
	add hl,de
	djnz cxMain_Row16
cxMain_RowWasZero:
	ld a,(curcol)
	ld d,0
	ld e,a
	add hl,de
	ex de,hl
	ld hl,textshadow
	ld c,1
	ld (hlsave),de
	res evilQuotes,(iy+parens)
	res evilQuotes+1,(iy+parens)
cxMain_Search:
	dec de
	ex de,hl
	or a
	sbc hl,de
	jr c,cxMain_SearchDone
	add hl,de
	ex de,hl
	ld a,(de)
	cp 20h
	jp z,cxMain_NotValidMaybe
	cp lquote
	call z,cxMain_Search_Quote
	bit evilQuotes,(iy+parens)
	jr nz,cxMain_Search
	cp ':'
	jp z,cxMain_ColonQuoteSearch
	cp Lstore
	jp z,cxMain_NotValid
	cp ')'
	jr nz,cxMain_SkipInc
	inc c
cxMain_SkipInc:
	cp '('
	jr nz,cxMain_Search
	dec c
	ld a,c
	or a
	jr nz,cxMain_Search
	push de
	ld a,')'
	set preClrForMode,(iy+newDispF)
	set textInverse,(iy+textFlags)
	B_CALL PutMap
	pop de
	ld hl,(currow)
	push hl
	ex de,hl
	ld de,textshadow
	or a
	sbc hl,de
	ld a,l
	and 15
	ld (curcol),a
	ld a,l
	rrca
	rrca
	rrca
	rrca
	and 7
	ld (currow),a
	ld a,'('
	B_CALL PutMap
	ld b,60
	call Pause
	ld a,(tempkey)
	or a
	jr z,cxMain_PauseOK
	ld (kbdscancode),a
cxMain_PauseOK:
	ld a,'('
	res textInverse,(iy+textFlags)
	res preClrForMode,(iy+newDispF)
	B_CALL PutMap
	pop hl
	ld (currow),hl
	jr Hook_cxMain_Exit
cxMain_SearchDone:
	ld hl,(editCursor)
	ld de,(editTop)
	or a
	sbc hl,de
	ld de,128
	or a
	sbc hl,de
	jr nc,Hook_cxMain_Exit
cxMain_NotValidMaybe:
	ld a,(iy+parens)
	and 00000011b
	jp pe,cxMain_NotValid
	jr Hook_cxMain_Exit
cxMain_NotValid:
	pop bc
	xor a
	inc a
	ret
cxMain_ColonQuoteSearch:
	bit evilQuotes,(iy+parens)
	jr nz,cxMain_NotValid
cxMain_ColonQuoteSearch_Loop:
	dec de
	ex de,hl
	or a
	sbc hl,de
	jr c,cxMain_NotValid
	add hl,de
	ex de,hl
	ld a,(de)
	cp 20h
	jp z,cxMain_NotValid
	cp lquote
	jr z,Hook_cxMain_Exit
	jr cxMain_ColonQuoteSearch_Loop
cxMain_Search_Quote:
	ld a,(iy+parens)
	xor 1
	ld (iy+parens),a
	ret
Hook_cxMain_Exit:
	pop bc
	ld a,1
	xor a
	ret
cxMain_NoParen:
	pop bc
cxMain_Exit1:
	ld a,1
cxMain_Exit:
	cp a
	ret
cxMain_Exit3:
	ld a,3
	cp a
	ret
cxMain_Clear:
	;89-like Clear functionality
	ld hl,(editBtm)
	ld de,(editTail)
	or a
	sbc hl,de
	jr z,cxMain_Clear_Exit	;Cursor is at end of line, let OS handle it
	;Now we have the cursor in the middle. Time to wipe everything after the cursor
	;B_CALL BufLeft
	ld de,(editTail)
	ld a,e
	ld (editBtm),a
	ld a,d
	ld (editBtm+1),a
	B_CALL EraseEOW
	B_CALL DispEOW
	ld b,kClear
	xor a
	inc a
	ret
cxMain_Clear_Exit:
	ld b,kClear
	ld a,1
	cp a
	ret
cxMain_BackupRAM:
	ld a,b
	cp 40h
	jr nz,cxMain_Exit3
	in a,(2)
	and 80h
	jr z,cxMain_Exit3
	call GetRealSettings
	bit 4,(hl)
	jr z,cxMain_Exit3
	;Calculator turning off, let's backup RAM.
	di
	ld a,1
	out (20h),a
	ld (86ECh),sp
	;ld hl,9872h
	;call SaveDisplay
	ld hl,cxMain_BackupRAM_Checksum
	ld de,8000h
	ld bc,16
	ldir
	;Now copy upper checksum
	ld hl,0C000h
	ld bc,4000h
	ld ix,0
cxMain_BackupRAM_ChecksumL:
	ld e,(hl)
	ld d,0
	add ix,de
	inc hl
	dec bc
	ld a,b
	or c
	jr nz,cxMain_BackupRAM_ChecksumL
	ld (8050h),ix
	ld a,87h
	out (7),a
	ld hl,0C000h
	ld de,08000h
	ld bc,04000h
	ldir
	;Now to copy lower page
	ld hl,8000h
	ld bc,4000h
cxMain_BackupRAM_Loop:
	ld a,81h
	out (7),a
	ld e,(hl)
	ld a,86h
	out (7),a
	ld (hl),e
	inc hl
	dec bc
	ld a,b
	or c
	jr nz,cxMain_BackupRAM_Loop
	ld a,81h
	out (7),a
	ei
	ret
cxMain_BackupRAM_Checksum:
	DB "OmnicalcBackupOK"
cxMain_BaseDisplay:
	ld hl,OP1
	ld de,9872h
	ld bc,9
	ldir
	call GetRealSettings
	push hl
	ld hl,9872h
	ld de,OP1
	ld bc,9
	ldir
	pop hl
	bit 6,(hl)
	ret z
	inc hl
	inc hl
	ld a,(hl)
	ld (newbase),a
	cp 10
	jp z,cxMain_BaseDisplay_OSHandle
	;We are good.
	;OP1 contains result.
	ld a,(OP1)
	cp RealObj
	jp nz,cxMain_BaseDisplay_OSHandle
	B_CALL CkPosInt
	jp nz,cxMain_BaseDisplay_OSHandle
	ld hl,cxMain_65536
	ld de,OP2
	ld bc,9
	ldir
	B_CALL CpOP1OP2
	jp nc,cxMain_BaseDisplay_OSHandle
	;Good to go.
	call BinaryOP1
cxMain_BaseOutput_EntryPoint:
	;HL is number
	ld (oldnum),hl
	;Now start converting
	xor a
	ld (strlen),a
	ld ix,tempstring
cxMain_BaseDisplay_Build
	ld a,(newbase)
	ld hl,(oldnum)
	call DivideHLByA
	ld (oldnum),hl
	ld e,a
	ld a,h
	or l
	jr z,cxMain_BaseDisplay_Done
	;Now turn A into digit.
	ld b,0
	ld c,e
	ld hl,cxMain_BaseDisplay_Table
	add hl,bc
	ld a,(hl)
	ld (ix),a
	inc ix
	ld hl,strlen
	inc (hl)
	jr cxMain_BaseDisplay_Build
cxMain_BaseDisplay_Done:
	ld b,0
	ld c,e
	ld hl,cxMain_BaseDisplay_Table
	add hl,bc
	ld a,(hl)
	ld (ix),a
	inc ix
	ld hl,strlen
	inc (hl)
	ld a,(strlen)
	or a
	jp z,cxMain_BaseDisplay_Zero
	res appendbase,(iy+baseflags)
	ld a,(newbase)
	ld hl,cxMain_BaseDisplay_Bases
	ld bc,6
	cpir
	call z,cxMain_BaseAppend
	B_CALL ZeroOP1
	ld a,StrngObj
	ld (OP1),a
	ld a,24h
	ld (OP1+1),a
	ld hl,(pTempCnt)
	inc hl
	ld (pTempCnt),hl
	dec hl
	ld ix,OP1
	ld (ix+2),l
	ld (ix+3),h
	ld a,(strlen)
	ld h,0
	ld l,a
	bit appendbase,(iy+baseflags)
	jr z,cxMain_BaseDisplay_Create
	inc hl
	inc hl
cxMain_BaseDisplay_Create:
	ld a,(strlen)
	cp 16
	jr nc,cxMain_BaseDisplay_Create2
	ld b,a
	ld a,16
	sub b
	ld b,0
	ld c,a
	bit appendbase,(iy+baseflags)
	jr z,cxMain_BaseDisplay_Create_Go
	dec c
	dec a
cxMain_BaseDisplay_Create_Go:
	add hl,bc
	push af
	B_CALL CreateStrng
	inc de
	inc de
	pop bc
	ld a,b
	or a
	jr z,cxMain_BaseDisplay_CreateGo
cxMain_BaseDisplay_Fill:
	ld a,tSpace
	ld (de),a
	inc de
	djnz cxMain_BaseDisplay_Fill
	jr cxMain_BaseDisplay_CreateGo
cxMain_BaseDisplay_Create2:
	bit appendbase,(iy+baseflags)
	jr z,cxMain_BaseDisplay_Create2_2
	res appendbase,(iy+baseflags)
	dec hl
	dec hl
cxMain_BaseDisplay_Create2_2:
	B_CALL CreateStrng
	inc de
	inc de
cxMain_BaseDisplay_CreateGo:
	ld hl,tempstring
	ld a,(strlen)
	dec a
	ld c,a
	ld b,0
	add hl,bc
	ld b,a
	inc b
cxMain_BaseDisplay_InvertCopy:
	ld a,(hl)
	ld (de),a
	dec hl
	inc de
	djnz cxMain_BaseDisplay_InvertCopy
	;Now for base append
	bit appendbase,(iy+baseflags)
	jr z,cxMain_BaseDisplay_AllFinished
	ld a,(newbase)
	ld hl,cxMain_BaseDisplay_Bases
	ld bc,6
	cpir
	ld bc,5
	add hl,bc
	ld a,0BBh
	ld (de),a
	inc de
	ld a,(hl)
	ld (de),a
cxMain_BaseDisplay_AllFinished:
	B_CALL OP4ToOP1
	xor a
	ret
cxMain_BaseDisplay_Zero:
	B_CALL OP1Set0
	xor a
	ret
cxMain_BaseDisplay_Bases:
	DB 2,3,5,8,10,16
	DB tLb,tLsmallt,tLq,tLo,tLd,tLh
cxMain_BaseDisplay_Table:
	DB t0,t1,t2,t3,t4,t5,t6,t7,t8,t9
	DB tA,tB,tC,tD,tE,tF,tG,tH,tI,tJ
	DB tK,tL,tM,tN,tO,tP,tQ,tR,tS,tT
	DB tU,tV,tW,tX,tY,tZ
cxMain_BaseAppend:
	set appendbase,(iy+baseflags)
	ret
BinaryOP1:
	;Input - OP1 (must be 0-65535)
	;Output - HL
	ld a,(OP1+1)
	sub 80h
	ld ix,cxMain_BaseDisplay_ConvertTable
	ld b,a
	add a,a
	add a,a
	ld c,a
	add a,a
	add a,c
	add a,b
	ld b,0
	ld c,a
	add ix,bc
	ld hl,0
	ld de,OP1+2
	;DE is BCD pointer
	;HL is sum so far
	;IX is pointer to table
	ld b,(ix)
	inc ix
BinaryOP1_Loop:
	push bc
	ld c,(ix)
	inc ix
	ld b,(ix)
	inc ix
	ld a,b
	or c
	jr z,BinaryOP1_Loop_Over
	;BC is base...A is multiply
	ld a,(de)
	and 11110000b
	rrca
	rrca
	rrca
	rrca	
	or a
	jr z,BinaryOP1_Loop_Over
BinaryOP1_Loop_Add:
	add hl,bc
	dec a
	jr nz,BinaryOP1_Loop_Add
BinaryOP1_Loop_Over:
	ld c,(ix)
	inc ix
	ld b,(ix)
	inc ix
	inc de
	ld a,b
	or c
	jr z,BinaryOP1_Loop_Over2
	dec de
	ld a,(de)
	inc de
	and 00001111b
	or a
	jr z,BinaryOP1_Loop_Over2
BinaryOP1_Loop_Add2:
	add hl,bc
	dec a
	jr nz,BinaryOP1_Loop_Add2
BinaryOP1_Loop_Over2:
	pop bc
	djnz BinaryOP1_Loop
	ret
cxMain_BaseDisplay_ConvertTable:
	;Mantissa 80h (x)
	DB 1
	DW 1,0,0,0,0,0
	;Mantissa 81h (xx)
	DB 1
	DW 10,1,0,0,0,0
	;Mantissa 82h (xxx)
	DB 2
	DW 100,10,1,0,0,0
	;Mantissa 83h (xxxx)
	DB 2
	DW 1000,100,10,1,0,0
	;Mantissa 84h (xxxxx)
	DB 3
	DW 10000,1000,100,10,1,0
DivideHLByA:
	ld bc,-1
	ld d,0
	ld e,a
DivideHLByA_Loop:
	inc bc
	or a
	sbc hl,de
	jr nc,DivideHLByA_Loop
	add hl,de
	;HL is remainder.
	;BC is the division number
	ld a,l
	ld h,b
	ld l,c
	;A is remainder
	;HL is the part that could not be divided
	ret
cxMain_BaseDisplay_OSHandle:
	xor a
	ret
cxMain_65536:
	DB 00h,84h,65h,53h,60h,00h,00h,00h,00h

