; Forecast v3.00
; (C) 2003 Michael Peterson.
;
;This library is free software; you can redistribute it and/or
;modify it under the terms of the GNU Lesser General Public
;License as published by the Free Software Foundation; either
;version 2.1 of the License, or (at your option) any later version.
;
;This library is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;Lesser General Public License for more details.
;
;You should have received a copy of the GNU Lesser General Public
;License along with this library; if not, write to the Free Software
;Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
;
Hook_Key:
	;Key hook for _getkey
	add a,e
	ld e,a
	cp kAppsMenu
	call z,Hook_Key_Apps
	ld a,e
	cp 91h
	call z,Hook_Key_Prgm_Second
	cp k5
	call z,Hook_Key_Custom_Second
	cp kPrgm
	jp nz,Hook_Key_Other
	ld a,(menucurrent)
	cp 03h
	jp z,Hook_Key_Prgm
	cp 2Ah
	jp z,Hook_Key_Prgm
	ld a,kPrgm
	ret
Hook_Key_Apps:
	in a,(4)
	bit 3,a
	jr nz,Hook_Key_Apps_AppsReturn
	;On+Apps pressed. Now check for MirageOS
	ld hl,MirageOS
	rst 20h
	B_CALL FindApp
	jr c,Hook_Key_Apps_AppsReturn
	;Run MirageOS
	ld hl,MirageOS+1
	ld de,progToEdit
	ld bc,8
	ldir
	B_CALL CloseEditEqu
	B_CALL ExecuteApp
MirageOS:
	DB AppObj,"MirageOS"
Hook_Key_Apps_AppsReturn:
	ld a,kAppsMenu
	ld e,a
	ret
SaveDisplay:
	ld b,64
	ld a,07h
	out (10h),a
	ld a,80h-1
Slayerloop1:
	push bc
	ld b,0Ch
	inc a
	ld (OP1),a
	call lcddelay
	out (10h),a
	call lcddelay
	ld a,20h
	out (10h),a
	call lcddelay
	in a,(11h)
Slayerloop2:
	call lcddelay
	in a,(11h)
	ld (hl),a
	inc hl
	djnz Slayerloop2
	pop bc
	ld a,(OP1)
	djnz Slayerloop1
	ld a,05h
	call lcddelay
	out (10h),a
	ret
CopyLayer:
	ld b,64
	ld a,07h
	out (10h),a
	ld a,80h-1
layerloop1:
	push bc
	ld b,0Ch
	inc a
	ld (OP1),a
	call lcddelay
	out (10h),a
	call lcddelay
	ld a,20h
	out (10h),a
layerloop2:
	ld a,(hl)
	call lcddelay
	out (11h),a
	inc hl
	djnz layerloop2
	pop bc
	ld a,(OP1)
	djnz layerloop1
	ld a,5
	call lcddelay
	out (10h),a
	ret
lcddelay:
	push af
lcddelayloop:
	in a,(2)
	and 2
	jr z,lcddelayloop
	pop af
	ret
CopyRAMPageD_To_E:
	;Assumes interrupts disabled
	;D is source page
	;E is destination page
	ld hl,8000h
	ld bc,4000h
CopyRAMPageD_To_E_Loop:
	ld a,d
	out (7),a
	ld a,(hl)
	ex af,af'
	ld a,e
	out (7),a
	ex af,af'
	ld (hl),a
	inc hl
	dec bc
	ld a,b
	or c
	jr nz,CopyRAMPageD_To_E_Loop
	ret
Hook_Key_Other:
	cp kLog
	jp z,Hook_Key_Base
	cp kMath
	jp z,Hook_Key_Math
	;cp kVars
	;jp z,Hook_Key_Vars
	;cp 0Dh
	;jp z,Hook_Key_Entry
	cp kLinkIO
	jp z,Hook_Key_Link
	;cp kDel
	;jp z,Hook_Key_MemoryDel
	;cp 0ACh
	;jp z,Hook_Key_CheckForModeScreen
	ld c,a
	ld a,(menucurrent)
	;cp 0Ch	;Memory menu
	;jp z,Hook_Key_MemoryMenu
	;cp 45h
	;jr z,Hook_Key_Catalog
Hook_Key_CRet:
	ld a,c
Hook_Key_MemoryReturnOK:
	or a
	ret
Hook_Key_Prgm_Second:
	ld a,(tokenHookPtr+3)
	dec a
	jr nz,Hook_Key_Prgm_Second_No
	pop af
	ld a,2
	ld (tokenHookPtr+3),a
	ld a,kReal
	ld (keyExtend),a
	ld a,0FCh
	or a
	ret
Hook_Key_Prgm_Second_No:
	ld a,91h
	or a
	ret
Hook_Key_Prgm_FirstTime:
Hook_Key_Prgm:
 call		Menu
 cp		0ffh
 ret		nz
 ld		a,e
 ld		(rawKeyHookPtr+3),a
_LoadMenuNumL equ 45e2h
 B_CALL	LoadMenuNumL
 ld		a,1
 ld		(tokenHookPtr+3),a
 ld		a,kreal
 ld		(keyExtend),a
 ld		a,0FCh
	ld a,12h
	ld (kbdscancode),a
	;ld a,kClear
	;or a
	res cmdVirgin,(iy+cmdFlags)
 ret
Menu:
 ld		hl,FunctionsMenu
 res		indicrun,(iy+indicflags)
 res		apptextsave,(iy+appflags)
 ld		a,(hl)
 ld		(menucurrent+3),a
 xor		a
 ld		(menucurrent+1),a
 ld		(menucurrent+2),a
 inc		hl
 push		hl
 ld		c,0	
Disp_My_Menu:
 ld		hl,0
 ld		(currow),hl
 pop		hl
 push		hl
 ld		b,0
Disp_My_Menu2:
 ld		a,(menucurrent+1)
 cp		b
 jr		nz,Disp_My_Menu3
 set		textinverse,(iy+textflags)
Disp_My_Menu3:
 call		puts
 inc		hl
 res		textinverse,(iy+textflags)
 ld		a,lspace
 B_CALL	putc
 ld		a,(menucurrent+1)
 cp		b
 push		bc
 push		hl
 call		z,Disp_My_Menu4
 pop		hl
 inc		hl
 inc		hl
 pop		bc
 ld		a,(menucurrent+3)
 inc		b
 cp		b
 jr		nz,Disp_My_Menu2
Halt_Menu:
 push		de
 B_CALL	getkey
 pop		de
 cp		kright
 jr		z,Menu_Go_Right
 cp		kleft
 jp		z,Menu_Go_Left
 cp		kup
 jp		z,Menu_Go_Up
 cp		kdown
 jp		z,Menu_Go_Down
 cp		k0
 jr		nz,notkeyzero
 cp		kee
 jr		z,notNumOrLett
 cp		kspace
 jr		z,notNumOrLett
 ld		a,k9+1
notkeyzero:
 cp		k0
 jr		c,notNumOrLett
 cp		kcapz+1
 jr		nc,notNumOrLett
 cp		kcapa
 jr		c,notLett
 dec		a	;to correct for kspace
notLett: ;now we need to check to see if a item named this exists....
 pop		hl
 push		hl
 sub		k0
 push		af	;save menu item attempted to be selected by the user
 ld		a,(menucurrent+1)
 inc		a
 ld		b,a
getPullDown:
 inc		hl
 call		find0
 inc		hl
 dec		b
 jr		nz,getPullDown
gotPullDown:
 ld		a,(hl)
 dec		hl
 ld		l,(hl)
 ld		h,a
 pop		af	;attempted depth
 ld		b,a
 dec		a
 cp		(hl)
 jr		nc,notValidNumOrLett

getMenusToken:
 call		find0
 dec		b
 jr		nz,getMenusToken
 ld		e,(hl)
 jr		menuEnter
notNumOrLett:
 cp		kenter
 jr		z,menuEnter
 call		keychecker
 jr		z,exitcustmenu
notValidNumOrLett:
 jr		Halt_Menu
menuEnter:
 pop		hl
 ld		a,0ffh
 ret
exitcustmenu:
 pop		hl
 ret
keychecker:
 push		bc
 ld		hl,Menu_SpecialKeys
 ld		c,(hl)
 inc		hl
 ld		b,0
 cpir
 pop		bc
 ret
Menu_Go_Right:
 xor		a
 ld		(menucurrent+2),a
 ld		c,a
 ld		a,(menucurrent+1)
 inc		a
 ld		(menucurrent+1),a
 ld		b,a
 ld		a,(menucurrent+3)
 cp		b
 jp		nz,Disp_My_Menu
 xor		a
 ld		(menucurrent+1),a
 jp		Disp_My_Menu
Menu_Go_Left:
 xor		a
 ld		(menucurrent+2),a
 ld		c,a
 ld		a,(menucurrent+1)
 dec		a
 ld		(menucurrent+1),a
 cp		0ffh
 jp		nz,Disp_My_Menu
 ld		a,(menucurrent+3)
 dec		a
 ld		(menucurrent+1),a
 jp		Disp_My_Menu
Menu_Go_Up:
 ld		a,(menucurrent+2)
 dec		a
 ld		(menucurrent+2),a
 cp		c
 jr		nc,Menu_Go_Up2
 dec		c
Menu_Go_Up2:
 cp		0ffh
 jp		nz,Disp_My_Menu
 ld		a,(menucurrent+4)
 dec		a
 ld		(menucurrent+2),a
 ld		c,0
 sub		8
 jr		c,Menu_Go_Up3
 inc		a
 inc		a
 ld		c,a
Menu_Go_Up3:
 jp		Disp_My_Menu
Menu_Go_Down:
 ld		a,(menucurrent+2)
 inc		a
 ld		(menucurrent+2),a
 ld		b,a
 sub		c
 cp		7
 jr		c,Menu_Go_Down2
 inc		c
Menu_Go_Down2:
 ld		a,(menucurrent+4)
 cp		b
 jp		nz,Disp_My_Menu
 xor		a
 ld		(menucurrent+2),a
 ld		c,a
 jp		Disp_My_Menu
Disp_My_Menu4:
 push		de
 pop		ix
 ld		e,(hl)
 inc		hl
 ld		d,(hl)
 ex		de,hl
 ld		de,(currow)
 push		de
 ld		de,1
 ld		(currow),de
 push		ix
 pop		de
 ld		d,0
 ld		b,(hl)		;depth of current menu
 ld		a,b
 ld		(menucurrent+4),a
 inc		hl
 ld		a,c	;depth of window
 or		a
 jr		z,displayDown
 push		bc
findtopchoice:
 call		find0
 inc		hl ;skip 2nd token byte
 dec		c
 jr		nz,findtopchoice
 pop		bc
 ld		b,7
 jr		displayDown2
displayDown:
 ld		a,(menucurrent+4)
 cp		8
 jr		c,displayDown2
 ld		b,7
displayDown2:
; B_CALL	newline
;
 ld		a,(curcol)
 or		a
 jr		z,nonewln
 call		newline
nonewln:
;
 ld		a,(menucurrent+2)
 sub		c
 sub		d
 jr		nz,displaydown3
 set		textinverse,(iy+textflags)
 ld		a,(hl)
 inc		hl
 B_CALL	putc
 ld		a,(hl)
 inc		hl
 B_CALL	putc
 res		textinverse,(iy+textflags)
displaydown3:
 call		puts
 inc		hl ;skip 0
 ld		a,(menucurrent+2)
 sub		c
 sub		d
 jr		nz,dontgettoken
 ld		e,(hl)
dontgettoken:
 inc		hl ;skip 2nd token byte
 inc		d
 djnz		displayDown2
;
 call		newline
filldown:
 ld		a,(currow)
 cp		8
 jr		z,dontfill
 call		newline
 jr		filldown
dontfill:
;
 pop		hl
 ld		(currow),hl
 ret
find0:
 ld		a,(hl)
 inc		hl
 or		a
 jr		nz,find0
 ret
puts:
 ld		a,(hl)
 or		a
 ret		z
 B_CALL	putc
 inc		hl
 jr		puts

newline:
 push		hl
 push		de
 push		bc
newline2:
 ld		a,lspace
 B_CALL	putc
 ld		a,(curcol)
 or		a
 jr		nz,newline2
 pop		bc
 pop		de
 pop		hl
 ret

Menu_SpecialKeys:
	DB 29
	DB kClear,kAppsMenu,kPrgm,kZoom,kDraw,kSPlot,kStat,kMath
	DB kTest,kChar,kVars,kMem,kMatrix,kDist,kAngle,kList,kCalc
	DB kCatalog,kgraph,kMode,kWindow,kYequ,kTable,kTblSet
	DB	kStatP,kFormat,kTrace,kQuit

FunctionsMenu:
 db	5		;wide
 db	"Le",0
 dw	lengthMenu
 db	"Ar",0
 dw	areaMenu
 db	"Vo",0
 dw	volMenu
 db "Ma",0
 dw massmenu
 db "Tmp",0
 dw pressuremenu

lengthMenu:
 db	9
 db	"1:km",05h,"mi(",0,0E3h
 db	"2:mi",05h,"km(",0,0E3h+1
 db	"3:mi",05h,"ft(",0,0E3h+2
 db	"4:ft",05h,"mi(",0,0E3h+3
 db	"5:m",05h,"ft(",0,0E3h+4
 db	"6:ft",05h,"m(",0,0E3h+5
 db	"7:cm",05h,"in(",0,0E3h+6
 db	"8:in",05h,"cm(",0,0E3h+7
 db	"9:1",0D4h,"lat",05h,"km(",0,0E3h+8
areaMenu:
 db	4
 db	"1:cm",lsquare,05h,"in",lsquare,"(",0,0E3h+9
 db	"2:in",lsquare,05h,"cm",lsquare,"(",0,0E3h+10
 db	"3:m",lsquare,05h,"ft",lsquare,"(",0,0E3h+11
 db	"4:ft",lsquare,05h,"m",lsquare,"(",0,0E3h+12
volMenu:
 db	6
 db	"1:cm",lcube,05h,"in",lcube,"(",0,0E3h+13
 db	"2:in",lcube,05h,"cm",lcube,"(",0,0E3h+14
 db	"3:liter",05h,"cm",lcube,"(",0,0E3h+15
 db	"4:cm",lcube,05h,"liter(",0,0E3h+16
 db	"5:liter",05h,"gal(",0,0E3h+17
 db	"6:gal",05h,"liter(",0,0E3h+18
massmenu:
 db 4
 db	"1:g",05h,"lb(",0,0E3h+19
 db	"2:lb",05h,"g(",0,0E3h+20
 db	"3:g",05h,"oz(",0,0E3h+21
 db	"4:oz",05h,"g(",0,0E3h+22

pressuremenu:
 db 4
 db	"1:",0D4h,"C",05h,0D4h,"F(",0,0E3h+23
 db	"2:",0D4h,"F",05h,0D4h,"C(",0,0E3h+24
 db	"3:",0D4h,"F",05h,"K(",0,0E3h+25
 db	"4:K",05h,0D4h,"F(",0,0E3h+26


Hook_Key_Link:
	ld hl,(progPtr)
Hook_Key_Link_SearchLoop:
	ld bc,(pTemp)
	or a
	sbc hl,bc
	jr c,Hook_Key_Link_Done
	jr z,Hook_Key_Link_Done
	add hl,bc
	ld a,(hl)
	cp 5
	jr nz,Hook_Key_Link_NextVariable
	dec hl
	dec hl
	ld (hl),0
	inc hl
	inc hl
Hook_Key_Link_NextVariable:
	ld de,-6
	add hl,de
	ld d,0
	ld e,(hl)
	inc e
	or a
	sbc hl,de
	jr Hook_Key_Link_SearchLoop
Hook_Key_Link_Done:
	ld a,kLinkIO
	or a
	ret
;Hook_Key_Entry
;	ld a,(cxCurApp)
;	cp 40h
;	jp nz,Hook_Key_Entry_Keep
;	ld a,(menucurrent)
;	or a
;	jp nz,Hook_Key_Entry_Keep
;	call GetRealSettings
;	bit 3,(hl)
;	jp z,Hook_Key_Entry_Keep
;	;Now check if Rcl mode active
;	ld hl,textshadow+70h
;	ld de,Hook_Key_Entry_Rcl
;	ld b,4
;	call CompareStrings
;	jp z,Hook_Key_Entry_Keep
;	;We are good...
;	ld hl,9872h
;	B_CALL SaveDisp
;	res indicrun,(iy+indicflags)
;	res apptextsave,(iy+appflags)
;	B_CALL CursorOff
;	ld hl,Entries_Program
;	rst 20h
;	B_CALL ChkFindSym
;	ex de,hl
;	ld c,(hl)
;	inc hl
;	ld b,(hl)
;	ld a,b
;	or c
;	jp z,Hook_Key_Entry_Cancel
;	dec hl
;	inc bc
;	inc bc
;	ld de,entrieslist
;	ldir
;	ld a,(numLastEntries)
;	inc a
;	ld (numentries),a
;	;Copy entries over
;	ld a,(numLastEntries)
;	or a
;	jr z,Entries_SkipFirstCopy
;	ld b,a
;	ld hl,lastEntryStk
;	;DE is where to copy
;Entries_FirstCopy:
;	push bc
;	ld c,(hl)
;	inc hl
;	ld b,(hl)
;	inc bc
;	inc bc
;	dec hl
;	ldir
;	pop bc
;	djnz Entries_FirstCopy
;Entries_SkipFirstCopy:
;	ld hl,(currow)
;	ld (originalcur),hl
;	res appTextSave,(iy+appFlags)
;	B_CALL ClrLCDFull
;	ld hl,0
;	ld (currow),hl
;	ld hl,Entries_Title
;	set textInverse,(iy+textFlags)
;	call putstr
;	res textInverse,(iy+textFlags)
;	ld a,(numentries)
;	ld b,a
;	dec a
;	ld (enditem),a
;	xor a
;	ld (curitem),a
;	ld (menutop),a
;	inc a
;	ld (itemrow),a
;	ld a,b
;	cp 8
;	jr c,Entries_InitialMenuOK
;	ld b,7
;Entries_InitialMenuOK:
;	ld hl,0*256+1
;	ld (currow),hl
;	ld hl,entrieslist
;	ld de,Entries_List
;Entries_InitialMenu:
;	push bc
;	push hl
;	ex de,hl
;	ld a,(currow)
;	ld b,a
;	ld a,(itemrow)
;	cp b
;	jr nz,Entries_InitialMenu_SkipHighlight
;	set textInverse,(iy+textFlags)
;Entries_InitialMenu_SkipHighlight:
;	ld a,(hl)
;	B_CALL PutC
;	inc hl
;	ld a,(hl)
;	B_CALL PutC
;	res textInverse,(iy+textFlags)
;	inc hl
;	ex de,hl
;	pop hl
;	ld c,(hl)
;	inc hl
;	ld b,(hl)
;	inc hl
;	;BC is length, HL start of entry
;	push de
;	call Entries_DisplayEntry
;	pop de
;	xor a
;	ld (curcol),a
;	ld a,(currow)
;	inc a
;	ld (currow),a
;	pop bc
;	djnz Entries_InitialMenu
;	ld a,(numentries)
;	cp 8
;	jr c,Entries_InitialMenu_SkipArrow
;	ld hl,1*256+7
;	ld (currow),hl
;	ld a,LdownArrow
;	B_CALL PutMap
;Entries_InitialMenu_SkipArrow:
;Entries_Loop:
;	B_CALL GetKey
;	cp kDown
;	jp z,Entries_MoveDown
;	cp kUp
;	jp z,Entries_MoveUp
;	cp kEnter
;	jr z,Entries_Enter
;	cp kClear
;	jp z,Entries_Exit
;	cp 40h
;	jp z,Entries_Exit
;	cp k0
;	jr z,Entries_0
;	cp k1
;	jr c,Entries_Loop
;	cp k9+1
;	jr nc,Entries_NotNumeric
;	sub k1
;	ld b,a
;	ld a,(enditem)
;	cp b
;	jr c,Entries_Loop
;	ld a,b
;	ld (curitem),a
;	jr Entries_Enter
;Entries_NotNumeric:
;	cp 9Ah
;	jr c,Entries_Loop
;	cp 0B4h
;	jr nc,Entries_Loop
;	sub 9Ah-10
;	ld b,a
;	ld a,(enditem)
;	cp b
;	jr c,Entries_Loop
;	ld a,b
;	ld (curitem),a
;	jr Entries_Enter
;Entries_0:
;	sub k0-9
;	ld (curitem),a
;Entries_Enter:
;	ld hl,9872h
;	ld b,64
;	B_CALL RestoreDisp
;	ld de,(originalcur)
;	ld (currow),de
;Entries_Enter_MoveBack:
;	ld hl,(editTop)
;	ld de,(editCursor)
;	or a
;	sbc hl,de
;	jp z,Entries_Enter_Ready
;	B_CALL CursorLeft
;	jr Entries_Enter_MoveBack
;Entries_Enter_Ready:
;	;reset
;	ld hl,(editTop)
;	ld (editCursor),hl
;	ld hl,(editBtm)
;	ld (editTail),hl
;	;now insert
;	ld a,(curitem)
;	call GetEntry
;	;HL is entry
;	ld c,(hl)
;	inc hl
;	ld b,(hl)
;	inc hl
;Entries_Enter_Insert_Loop:
;	push bc
;	ld a,(hl)
;	B_CALL IsA2ByteTok
;	jr z,Entries_Enter_Insert_Two
;	ld d,0
;	ld e,(hl)
;	push hl
;	B_CALL BufInsert
;	pop hl
;	inc hl
;	pop bc
;	dec bc
;	ld a,b
;	or c
;	jr nz,Entries_Enter_Insert_Loop
;	jr Entries_Enter_Display
;Entries_Enter_Insert_Two:
;	ld d,(hl)
;	inc hl
;	ld e,(hl)
;	push hl
;	B_CALL BufInsert
;	pop hl
;	inc hl
;	pop bc
;	dec bc
;	dec bc
;	ld a,b
;	or c
;	jr nz,Entries_Enter_Insert_Loop
;Entries_Enter_Display:
;	set apptextsave,(iy+appflags)
;	;ld de,(editTop)
;	;ld hl,(editCursor)
;	;B_CALL DispForward
;	B_CALL EraseEOW
;Entries_Enter_Display_Loop:
;	B_CALL BufLeft
;	jr nz,Entries_Enter_Display_Loop
;	res cmdVirgin,(iy+cmdFlags)
;	res AnsScroll,(iy+ansFlags)
;Entries_Enter_Display_Loop2:
;	B_CALL CursorDown
;	ld hl,(editBtm)
;	ld de,(editTail)
;	or a
;	sbc hl,de
;	jr nz,Entries_Enter_Display_Loop2
;	jp Hook_Key_Entry_Cancel
;	;Display (editTail) to (editCursor) and exit
;Entries_Exit:
;	ld hl,9872h
;	ld b,64
;	B_CALL RestoreDisp
;	ld de,(originalcur)
;	ld (currow),de
;	jp Hook_Key_Entry_Cancel
;Entries_MoveUp:
;	ld a,(enditem)
;	or a
;	jp z,Entries_Loop
;	ld a,(itemrow)
;	dec a
;	jr z,Entries_MoveUp_Scroll
;	ld a,(curitem)
;	or a
;	jr z,Entries_MoveUp_Bottom
;	call Entries_UnselectCurrent
;	ld hl,curitem
;	dec (hl)
;	ld hl,itemrow
;	dec (hl)
;	call Entries_SelectCurrent
;	jp Entries_Loop
;Entries_MoveUp_Scroll:
;	ld a,(curitem)
;	or a
;	jr z,Entries_MoveUp_Bottom
;	ld hl,menutop
;	dec (hl)
;	ld hl,curitem
;	dec (hl)
;	call Entries_DisplayMenu
;	call Entries_SelectCurrent
;	jp Entries_Loop
;Entries_MoveUp_Bottom:
;	ld a,(enditem)
;	ld (curitem),a
;	ld b,6
;	sub b
;	ld (menutop),a
;	ld a,(enditem)
;	cp 7
;	jr nc,Entries_MoveUp_BottomSkip
;	xor a
;	ld (menutop),a
;Entries_MoveUp_BottomSkip:
;	ld a,7
;	ld (itemrow),a
;	ld a,(enditem)
;	cp 7
;	jr nc,Entries_MoveUp_BottomSkip2
;	inc a
;	ld (itemrow),a
;Entries_MoveUp_BottomSkip2:
;	call Entries_DisplayMenu
;	call Entries_SelectCurrent
;	jp Entries_Loop
;Entries_MoveDown:
;	ld a,(enditem)
;	or a
;	jp z,Entries_Loop
;	ld a,(itemrow)
;	cp 7
;	jr nc,Entries_MoveDown_Scroll
;	ld a,(enditem)
;	ld b,a
;  	ld a,(curitem)
;	cp b
;	jr z,Entries_MoveDown_Top
;	call Entries_UnselectCurrent
;	ld hl,curitem
;	inc (hl)
;	ld hl,itemrow
;	inc (hl)
;	call Entries_SelectCurrent
;	jp Entries_Loop
;Entries_MoveDown_Scroll:
;	ld a,(enditem)
;	ld b,a
;	ld a,(curitem)
;	cp b
;	jr z,Entries_MoveDown_Top
;	ld hl,menutop
;	inc (hl)
;	ld hl,curitem
;	inc (hl)
;	call Entries_DisplayMenu
;	call Entries_SelectCurrent
;	jp Entries_Loop
;Entries_MoveDown_Top:
;	call Entries_UnselectCurrent
;	xor a
;	ld (menutop),a
;	ld (curitem),a
;	inc a
;	ld (itemrow),a
;	call Entries_DisplayMenu
;	call Entries_SelectCurrent
;	jp Entries_Loop
;Entries_DisplayMenu:
;	ld bc,0*256+1
;	ld (currow),bc
;	ld a,(menutop)
;	call GetEntry
;	;HL points to first menu
;	push hl
;	ld a,(menutop)
;	ld b,a
;	ld a,(enditem)
;	sub b
;	ld b,a
;	cp 6
;	jr c,Entries_DisplayMenu_Ready
;	ld b,7
;Entries_DisplayMenu_Ready:
;	ld hl,Entries_List
;	ld a,(menutop)
;	add a,a
;	ld d,0
;	ld e,a
;	add hl,de
;	ex de,hl
;	pop hl
;Entries_DisplayMenu_Loop:
;	push bc
;	push hl
;	ex de,hl
;	ld a,(hl)
;	B_CALL PutC
;	inc hl
;	ld a,(menutop)
;	or a
;	jr z,Entries_DisplayMenu_Loop_AtTop
;	ld a,(currow)
;	dec a
;	jr nz,Entries_DisplayMenu_Loop_AtTop
;	ld a,LupArrow
;	jr Entries_DisplayMenu_Loop_ColonOK
;Entries_DisplayMenu_Loop_DownArrow:
;	ld a,(enditem)
;	ld b,a
;	ld a,(menutop)
;	add a,6
;	cp b
;	jr nc,Entries_DisplayMenu_Loop_ColonOK
;	ld a,LdownArrow
;	jr Entries_DisplayMenu_Loop_ColonOK
;Entries_DisplayMenu_Loop_AtTop:
;	ld a,(currow)
;	cp 7
;	jr z,Entries_DisplayMenu_Loop_DownArrow
;	ld a,(hl)
;Entries_DisplayMenu_Loop_ColonOK:
;	B_CALL PutC
;	inc hl
;	ex de,hl
;	pop hl
;	ld c,(hl)
;	inc hl
;	ld b,(hl)
;	inc hl
;	push de
;	call Entries_DisplayEntry
;	pop de
;	xor a
;	ld (curcol),a
;	ld a,(currow)
;	inc a
;	ld (currow),a
;	pop bc
;	djnz Entries_DisplayMenu_Loop
;	ret
;Entries_DisplayEntry:
;	;Inputs - BC length, HL entry
;	push hl
;	add hl,bc
;	ld (temphl),hl
;	pop hl
;Entries_DisplayEntry_Loop:
;	ld a,(hl)
;	B_CALL IsA2ByteTok
;	jr z,Entries_DisplayEntry_LoopTwo
;	dec bc
;	push bc
;	push hl
;	B_CALL Get_Tok_Strng
;	ld b,a
;	ld a,(curcol)
;	add a,b
;	cp 17
;	jr nc,Entries_DisplayEntry_TooLong
;	ld hl,OP3
;Entries_DisplayEntry_Disp:	
;	ld a,(hl)
;	inc hl
;	B_CALL PutMap
;	ld a,(curcol)
;	inc a
;	ld (curcol),a
;	djnz Entries_DisplayEntry_Disp
;	pop hl
;	inc hl
;	pop bc
;	ld a,b
;	or c
;	jr nz,Entries_DisplayEntry_Loop
;	B_CALL EraseEOL
;	ret
;Entries_DisplayEntry_LoopTwo:
;	dec bc
;	dec bc
;	push bc
;	push hl
;	B_CALL Get_Tok_Strng
;	ld b,a
;	ld a,(curcol)
;	add a,b
;	cp 17
;	jr nc,Entries_DisplayEntry_TooLong
;	ld hl,OP3
;Entries_DisplayEntry_DispTwo:
;	ld a,(hl)
;	inc hl
;	B_CALL PutMap
;	ld a,(curcol)
;	inc a
;	ld (curcol),a
;	djnz Entries_DisplayEntry_DispTwo
;	pop hl
;	inc hl
;	inc hl
;	pop bc
;	ld a,b
;	or c
;	jr nz,Entries_DisplayEntry_Loop
;	B_CALL EraseEOL
;	ret
;Entries_DisplayEntry_TooLong:
;	ld a,15
;	ld (curcol),a
;	ld a,0CEh
;	B_CALL PutMap
;	pop hl
;	pop bc
;	ld hl,(temphl)
;	ret
;GetEntry:
;	ld b,a
;	ld hl,entrieslist
;	or a
;	ret z
;GetEntryLoop:
;	push bc
;	ld c,(hl)
;	inc hl
;	ld b,(hl)
;	inc hl
;	add hl,bc
;	pop bc
;	djnz GetEntryLoop
;	ret
;Entries_SelectCurrent:
;	ld a,(curitem)
;	add a,a
;	ld hl,Entries_List
;	ld b,0
;	ld c,a
;	add hl,bc
;	ld a,(itemrow)
;	ld (currow),a
;	xor a
;	ld (curcol),a
;	ld a,(hl)
;	set textInverse,(iy+textFlags)
;	B_CALL PutC
;	inc hl
;	ld a,(itemrow)
;	cp 7
;	jr nz,Entries_SelectCurrent_OK
;	ld a,(enditem)
;	ld b,a
;	ld a,(curitem)
;	cp b
;	jr c,Entries_SelectCurrent_DownArrow
;Entries_SelectCurrent_OK:
;	ld a,(itemrow)
;	dec a
;	jr nz,Entries_SelectCurrent_OK2
;	ld a,(menutop)
;	or a
;	jr z,Entries_SelectCurrent_OK2
;	ld a,LupArrow
;	B_CALL PutC
;	res textInverse,(iy+textFlags)
;	ret
;Entries_SelectCurrent_OK2:
;	ld a,(hl)
;	B_CALL PutC
;	res textInverse,(iy+textFlags)
;	ret
;Entries_SelectCurrent_DownArrow:
;	ld a,LdownArrow
;	B_CALL PutC
;	res textInverse,(iy+textFlags)
;	ret
;Entries_UnselectCurrent:
;	ld a,(curitem)
;	add a,a
;	ld hl,Entries_List
;	ld b,0
;	ld c,a
;	add hl,bc
SymbolicApp:
	DB AppObj,"Symbolic"
OmnicalcApp:
	DB AppObj,"Omnicalc"
Hook_Key_Math:
	ld a,(menucurrent)
	cp 2Fh
	jr z,Hook_Key_Math_OK
	cp 08h
	jr z,Hook_Key_Math_OK
Hook_Key_Math_Exit_Good:
	ld a,kMath
	or a
	ret
Hook_Key_Math_OK:
	ld hl,SymbolicApp
	rst 20h
	B_CALL FindApp
	jr c,Hook_Key_Math_Exit_Good
	;Symbolic exists, lets go
	push af
	ld hl,SymbolicMenu_Loader
	ld de,9872h
	ld bc,SymbolicMenu_Loader_End-SymbolicMenu_Loader
	ldir
	pop bc
	call 9872h
	;B contains return code
	ld a,b
	cp 0FFh
	jr z,SymbolicMenu_Good
	or a
	ret
SymbolicMenu_Good:
	ld a,e
	ld (rawkeyhookptr+3),a
	ld a,1
	ld (tokenHookPtr+3),a
	ld a,12h
	ld (kbdscancode),a
	ld a,kClear
	or a
	res cmdVirgin,(iy+cmdFlags)
	ret
SymbolicMenu_Loader:
	in a,(6)
	push af
	ld a,b
	out (6),a
	ld hl,(40ACh)
	ld a,h
	or l
	jr z,SymbolicMenu_Loader_Point
	ld de,SymbolicMenu_Loader_Point-SymbolicMenu_Loader+9872h
	push de
	jp (hl)
SymbolicMenu_Loader_Point:
	ld b,a
	pop af
	out (6),a
	ret
SymbolicMenu_Loader_End:

Hook_Key_Custom_Second:
	ld a,(tokenHookPtr+3)
	dec a
	jr nz,Custom_Key_Second_No
	ld (tokenHookPtr+3),a
	ld a,(ramCode)
	cp 0FCh
	jr nc,Custom_Key_Second_Two
	pop bc
	or a
	ret
Custom_Key_Second_Two:
	ld a,(ramCode+1)
	ld (keyExtend),a
	ld a,(ramCode)
	cp 0FFh
	call z,Custom_Key_Second_Dec
	cp 0FDh
	call z,Custom_Key_Second_Dec
	pop bc
	or a
	ret
Custom_Key_Second_Dec:
	dec a
	ret
Custom_Key_Second_No:
	ld a,k5
	or a
	ret
CreateCustomAppVar:
	ld de,(iMathPtr1)
	push de
	B_CALL CloseEditEqu
	ld hl,16
	B_CALL CreateAppVar
	pop de
	B_CALL EditProg
	set editOpen,(iy+editFlags)
	ld hl,(iMathPtr1)
	inc hl
	inc hl
	ld (editTop),hl
	ld hl,(iMathPtr2)
	ld (editCursor),hl
	ex de,hl
	ld hl,(iMathPtr3)
	B_CALL CpHLDE
	jr nc,SetupEditProgSwapSkip2
	ex de,hl
SetupEditProgSwapSkip2:
	ld (editBtm),hl
	ld (editTail),hl
	ld hl,CatalogAppVar
	rst 20h
	B_CALL ChkFindSym
	ret
Hook_Key_Base:
	in a,(4)
	bit 3,a
	jr nz,Hook_Key_Base_Ret
	call GetRealSettings
	bit 6,(hl)
	jr z,Hook_Key_Base_Ret
	;Get two digit base
Hook_Key_Base_Loop:
	B_CALL GetCSC
	or a
	jr z,Hook_Key_Base_Loop
	ld hl,Hook_Key_Base_Table1
	ld bc,4
	cpir
	jr nz,Hook_Key_Base_RetNo
	;Found first base
	ld de,3
	add hl,de
	ld a,(hl)
	ld (newbase),a
Hook_Key_Base_Loop2:
	B_CALL GetCSC
	or a
	jr z,Hook_Key_Base_Loop2
	ld hl,Hook_Key_Base_Table2
	ld bc,10
	cpir
	jr nz,Hook_Key_Base_RetNo
	ld de,9
	add hl,de
	ld a,(hl)
	ld b,a
	ld a,(newbase)
	add a,b
	ld (newbase),a
	cp 37
	jr nc,Hook_Key_Base_RetNo
	cp 2
	jr c,Hook_Key_Base_RetNo
	call GetRealSettings
	inc hl
	inc hl
	ld a,(newbase)
	ld (hl),a
	xor a
	ret
Hook_Key_Base_Table1:
	DB sk0,sk1,sk2,sk3
	DB 0,10,20,30
Hook_Key_Base_Table2:
	DB sk0,sk1,sk2,sk3,sk4,sk5,sk6,sk7,sk8,sk9
	DB 0,1,2,3,4,5,6,7,8,9
Hook_Key_Base_Ret:
	ld a,kLog
	or a
	ret
Hook_Key_Base_RetNo:
	xor a
	ret
