; Forecast v3.00
; (C) 2003 Michael Peterson.
;
;This library is free software; you can redistribute it and/or
;modify it under the terms of the GNU Lesser General Public
;License as published by the Free Software Foundation; either
;version 2.1 of the License, or (at your option) any later version.
;
;This library is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
;Lesser General Public License for more details.
;
;You should have received a copy of the GNU Lesser General Public
;License along with this library; if not, write to the Free Software
;Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
;
Hook_Parser:
	add a,e
	push af
	in a,(2)
	and 80h
	jp z,Hook_Parser_NotSE
	rlca
	out (20h),a
Hook_Parser_NotSE:
	pop af
	;now check for preparser or parser
	or a
	jp z,PreParser
	;dec a
	;jr nz,Hook_Parser_NotState
	xor a
	ld (parserHookPtr+3),a
	push hl
	ld hl,8A8Ah
	or a
	sbc hl,bc
	pop hl
	jp nz,Parse_NotReal
	ld a,l
	or a
	ret z
	dec a
	ret z
	;Now find which token and appropriate parser
	;HL is number of arguments
	push hl
	B_CALL PushRealO1		;Now we can jumble OP1 without losing an argument
	pop hl
	push hl
	ld d,h
	ld e,l
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,de
	;HL now points to fps-HL
	push hl
	ex de,hl
	ld hl,(fps)
	or a
	sbc hl,de
	push hl
	;HL now if FPS where ## is
	rst 20h	;Store ## in OP1
	pop de	;DE to copy to.
	pop bc	;BC fps-HL, copy length
	ldir		;HL was setup by rst 20h
	ld hl,(fps)
	ld de,9
	or a
	sbc hl,de
	ld (fps),hl
	;Check to make sure we have a valid ##
	B_CALL CkPosInt
	jr z,Parser_Number_Ok
	pop hl
	B_JUMP ErrArgument
Parser_Number_Ok:
	B_CALL ConvOP1
	ld a,e
	;sub 13
	cp 20
	jp c,Parser_Symbolic_Token
	sub 20
	ld e,a
	ld d,0
	ld hl,Parser_JumpTable
	sla e
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	pop de
	ld a,e	;A = number of arguments
	dec a
	jp (hl)
	;FPS contains arguments from last to first
Parse_kmmi:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,kmmi
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_mikm:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,mikm
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_mift:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,mift
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_ftmi:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,ftmi
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_mft:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,mft
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_ftm:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,ftm
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_cmin:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,cmin
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_incm:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,incm
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_latkm:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,latkm
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_cmin2:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,cmin2
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_incm2:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,incm2
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_mft2:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,mft2
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_ftm2:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,ftm2
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_cmin3:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,cmin3
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_incm3:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,incm3
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_lcm3:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,lcm3
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_cm3l:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,cm3l
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_lgal:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,lgal
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_gall:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,gall
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_glb:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,glb
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_lbg:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,lbg
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_goz:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,goz
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_ozg:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,ozg
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_cf:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,cf
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	ld hl,num32
	B_CALL Mov9ToOP2
	B_CALL fpadd
	jp Parse_Token_ExitGood
Parse_fc:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,num32
	B_CALL Mov9ToOP2
	B_CALL FPSub
	ld hl,fc
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	jp Parse_Token_ExitGood
Parse_fk:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,num32
	B_CALL Mov9ToOP2
	B_CALL FPSub
	ld hl,fc
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	ld hl,num273
	B_CALL Mov9ToOP2
	B_CALL	fpadd
	jp Parse_Token_ExitGood
Parse_kf:
	res 0,(iy+asm_Flag1)
	res 1,(iy+asm_Flag1)
	cp 1
	jp nz,Parse_Error_Argument
	B_CALL PopRealO1
	ld hl,num273
	B_CALL Mov9ToOP2
	B_CALL	fpsub
	ld hl,cf
	B_CALL Mov9ToOP2
	B_CALL	fpmult
	ld hl,num32
	B_CALL Mov9ToOP2
	B_CALL fpadd
	jp Parse_Token_ExitGood
Parse_Negative1:
	DB 80h,80h,10h,00h,00h,00h,00h,00h,00h
Parse_Token_ExitGood:
	xor a
	inc a
	ret
Parse_NotReal:
	xor a
	ret
Hook_Parser_NotState:
	cp a
	ret
Parser_JumpTable:
	DW Parse_kmmi
	DW Parse_mikm
	DW Parse_mift
	DW Parse_ftmi
	DW Parse_mft
	DW Parse_ftm
	DW Parse_cmin
	DW Parse_incm
	DW Parse_latkm
	DW Parse_cmin2
	DW Parse_incm2
	DW Parse_mft2
	DW Parse_ftm2
	DW Parse_cmin3
	DW Parse_incm3
	DW Parse_lcm3
	DW Parse_cm3l
	DW Parse_lgal
	DW Parse_gall
	DW Parse_glb
	DW Parse_lbg
	DW Parse_goz
	DW Parse_ozg
	DW Parse_cf
	DW Parse_fc
	DW Parse_fk
	DW Parse_kf
Parse_Error_Range:
	B_JUMP ErrDomain
Parse_Error_DataType:
	B_JUMP ErrDataType
Parse_Error_Domain:
	B_JUMP ErrDomain
Parse_Error_Break:
	B_JUMP ErrBreak
Parse_Error_Syntax:
	B_JUMP ErrSyntax
Parse_Error_Argument:
	B_JUMP ErrArgument
Parse_Error_Undefined:
	B_JUMP ErrUndefined
PreParser:
	ld a,(parserHookPtr+3)
	dec a
	jp z,PreParser_Recursive
	;OP1 is variable being parsed
	;We must change all tokens CFh and above to real(token-CF,arguments)
	ld hl,OP1
	ld de,op1backup
	ld bc,9
	ldir
	B_CALL ChkFindSym
	jp c,Hook_Parser_NotState
	xor a
	ld (parserHookPtr+3),a
	ex de,hl
	ld (sizebytes),hl
	ld c,(hl)
	inc hl
	ld b,(hl)	;Get size
	ld a,b
	or c
	ret z
	inc hl
	push hl
	add hl,bc
	ld (bufferend),hl
	pop hl
	;(bufferend)-1 is last token
	ld bc,0
	ld (sizechange),bc
	res inQuotes,(iy+parseFlags)
PreParser_Replace_Loop:
	ld a,(hl)
	cp tString
	call z,PreParser_QuoteFound
	cp tEnter
	call z,PreParser_ResetQuote
	bit inQuotes,(iy+parseFlags)
	jr nz,PreParser_Replace_NextToken
	cp 0BBh
	jr nz,PreParser_Replace_NextToken
	inc hl
	ld a,(hl)
	cp 0CFh
	jr c,PreParser_Replace_NextToken
	ld (hl),tReal
	push af
	;We found a BB,CF or greater token...
	inc hl
	ex de,hl
	;DE = insertion address
	ld hl,3
	B_CALL InsertMem
	ld bc,(sizechange)
	inc bc
	inc bc
	inc bc
	ld (sizechange),bc
	ld bc,(bufferend)
	inc bc
	inc bc
	inc bc
	ld (bufferend),bc
	ex de,hl
	;HL now points to 3 bytes to store the "##,"
	pop af
	sub 0CFh
	ld c,-1
PreParser_Get10:
	inc c
	sub 10
	jr nc,PreParser_Get10
	add a,10
	;C is number of 10s, A is remainder
	push af
	ld a,t0
	add a,c
	ld (hl),a
	pop af
	;Now second number
	inc hl
	add a,t0
	ld (hl),a
	;Comma time
	inc hl
	ld (hl),tComma
	;Done...Continue for more tokens
	ld a,1
	ld (parserHookPtr+3),a
PreParser_Replace_NextToken:
	inc hl
	push hl
	ld de,(bufferend)
	or a
	sbc hl,de
	pop hl
	jr nz,PreParser_Replace_Loop
	;Update size bytes now
	ld hl,(sizebytes)
	ld c,(hl)
	inc hl
	ld b,(hl)
	push hl
	ld hl,(sizechange)
	add hl,bc
	ex hl,de
	pop hl
	ld (hl),d
	dec hl
	ld (hl),e
	ld a,(parserHookPtr+3)
	or a
	ret z
	B_CALL PushRealO1
	AppOnErr ParsingErrorOccured
	B_CALL ParseInp
	AppOffErr
	;Change real(##,arguments) to token(arguments)
	call PreParser_Restore
	xor a
	inc a
	ret
PreParser_QuoteFound:
	;Toggle flag
	push af
	ld a,(iy+parseFlags)
	xor 00000001b
	ld (iy+parseFlags),a
	pop af
	ret
PreParser_ResetQuote:
	res inQuotes,(iy+parseFlags)
	ret
ParsingErrorOccured:
	push af
	call PreParser_Restore
	pop af
	B_JUMP JError
PreParser_Recursive:
	xor a
	ld (parserHookPtr+3),a
	ret
PreParser_Restore:
	ld hl,OP1
	ld de,op1backup2
	ld bc,9
	ldir
	B_CALL PopRealO1
	B_CALL ChkFindSym
	ex de,hl
	ld (sizebytes),hl
	ld c,(hl)
	inc hl
	ld b,(hl)	;Get size
	inc hl
	push hl
	add hl,bc
	ld (bufferend),hl
	pop hl
	;(bufferend)-1 is last token
	ld bc,0
	ld (sizechange),bc
PreParser_Restore_Loop:
	ld a,(hl)
	cp 0BBh
	jr nz,PreParser_Restore_NextToken
	inc hl
	ld a,(hl)
	cp tReal
	jr nz,PreParser_Restore_NextToken
	;We found a Real token
	;Now check if it has "##," after it.
	inc hl
	ld a,(hl)
	cp t0
	jr c,PreParser_Restore_NextToken
	cp t9+1
	jr nc,PreParser_Restore_NextToken
	;Next # check
	inc hl
	ld a,(hl)
	cp t0
	jr c,PreParser_Restore_NextToken
	cp t9+1
	jr nc,PreParser_Restore_NextToken
	inc hl
	ld a,(hl)
	cp tComma
	jr nz,PreParser_Restore_NextToken
	;We have a real(##,arguments)
	dec hl
	dec hl
	ld a,(hl)
	sub t0
	or a
	jr z,PreParser_Restore_Add10_Skip
	ld b,a
	xor a
PreParser_Restore_Add10:
	add a,10
	djnz PreParser_Restore_Add10
PreParser_Restore_Add10_Skip:
	inc hl
	ld c,a
	ld a,(hl)
	sub t0
	add a,c
	dec hl
	ld (oldtoken),a
	ld de,3
	push hl
	B_CALL DelMem
	pop hl
	dec hl
	ld a,(oldtoken)
	add a,0CFh
	ld (hl),a
	ld bc,(sizechange)
	dec bc
	dec bc
	dec bc
	ld (sizechange),bc
	ld bc,(bufferend)
	dec bc
	dec bc
	dec bc
	ld (bufferend),bc
	;Done...Continue for more tokens
PreParser_Restore_NextToken:
	inc hl
	push hl
	ld de,(bufferend)
	or a
	sbc hl,de
	pop hl
	jr c,PreParser_Restore_Loop
	;Update size bytes now
	ld hl,(sizebytes)
	ld c,(hl)
	inc hl
	ld b,(hl)
	push hl
	ld hl,(sizechange)
	add hl,bc
	ex hl,de
	pop hl
	ld (hl),d
	dec hl
	ld (hl),e
	ld hl,op1backup2
	rst 20h
	ret
Parse_Exit:
	pop hl
Parse_Exit2:
	xor a
	ret
;---------= Large Sprite =---------
; Draws a Large sprite.
;Input:	ix->sprite
;	a=x
;	l=y
;	b=height	(in pixels)
;	c=width		(in bytes, e.g. 2 would be 16)
;Output: nothing
; All registers are destroyed except bc', de', hl'
;
largeSprite:
	di
	ex af,af'
	ld a,c
	push af
	ex af,af'
	ld e,l
	ld h,0
	ld d,h
	add hl,de
	add hl,de
	add hl,hl
	add hl,hl
	ld e,a
	and 07h
	ld c,a
	srl e
	srl e
	srl e
	add hl,de
	ld de,plotsscreen
	add hl,de
lsl0:
 push hl
lsl1:
	ld d,(ix)
	ld e,0
	ld a,c
	or a
	jr z,lsl3
lsl2:
	srl d
	rr e
	dec a
	jr nz,lsl2
lsl3:
	ld a,(hl)
	xor d
	ld (hl),a
	inc hl
	ld a,(hl)
	xor e
	ld (hl),a
	inc ix
	ex af,af'
	dec a
	push af
	ex af,af'
	pop af
	jr nz,lsl1
	pop hl
	pop af
	push af
	ex af,af'
	ld de,0Ch
	add hl,de
	djnz lsl0
	pop af
	ei
	ret
	;---------= Large Sprite =---------
; Draws a Large sprite.
;Input:	ix->sprite
;	a=x
;	l=y
;	b=height	(in pixels)
;	c=width		(in bytes, e.g. 2 would be 16)
;Output: nothing
; All registers are destroyed except bc', de', hl'
;
largeSpriteOR:
	di
	ex af,af'
	ld a,c
	push af
	ex af,af'
	ld e,l
	ld h,0
	ld d,h
	add hl,de
	add hl,de
	add hl,hl
	add hl,hl
	ld e,a
	and 07h
	ld c,a
	srl e
	srl e
	srl e
	add hl,de
	ld de,plotsscreen
	add hl,de
lsl0OR:
 push hl
lsl1OR:
	ld d,(ix)
	ld e,0
	ld a,c
	or a
	jr z,lsl3OR
lsl2OR:
	srl d
	rr e
	dec a
	jr nz,lsl2OR
lsl3OR:
	ld a,(hl)
	or d
	ld (hl),a
	inc hl
	ld a,(hl)
	or e
	ld (hl),a
	inc ix
	ex af,af'
	dec a
	push af
	ex af,af'
	pop af
	jr nz,lsl1OR
	pop hl
	pop af
	push af
	ex af,af'
	ld de,0Ch
	add hl,de
	djnz lsl0OR
	pop af
	ei
	ret
Parser_Symbolic_Token:
	push af
	ld hl,SymbolicApp
	rst 20h
	B_CALL FindApp
	jr c,Parser_Symbolic_Token_NotFound
	ld b,a
	pop af
	ld c,a
	push bc
	ld hl,Parser_Symbolic_Jumper
	ld de,9872h
	ld bc,Parser_Symbolic_Jumper_End-Parser_Symbolic_Jumper
	ldir
	pop bc
	jp 9872h
Parser_Symbolic_Token_NotFound:
	pop af
	jp Parse_Error_Undefined
Parser_Symbolic_Jumper:
	;B is symbolic's ROM page
	;C is token value
	ld a,b
	out (6),a
	ld hl,4082h
	ld d,0
	ld e,c
	sla e
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	;HL is where to jump to...
	in a,(2)
	and 80h
	jr nz,Parser_Symbolic_Jumper_SE
	jp (hl)
Parser_Symbolic_Jumper_SE:
	xor a
	out (20h),a
	jp (hl)
Parser_Symbolic_Jumper_End:

Parser_Omnicalc_Token:
	push af
	ld hl,OmnicalcApp
	rst 20h
	B_CALL FindApp
	jr c,Parser_Omnicalc_Token_NotFound
	ld b,a
	pop af
	ld c,a
	push bc
	ld hl,Parser_Omnicalc_Jumper
	ld de,9872h
	ld bc,Parser_Omnicalc_Jumper_End-Parser_Omnicalc_Jumper
	ldir
	pop bc
	jp 9872h
Parser_Omnicalc_Token_NotFound:
	pop af
	jp Parse_Error_Undefined
Parser_Omnicalc_Jumper:
	;B is symbolic's ROM page
	;C is token value
	ld a,b
	out (6),a
	ld hl,4082h
	ld d,0
	ld e,c
	sla e
	add hl,de
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	;HL is where to jump to...
	in a,(2)
	and 80h
	jr nz,Parser_Omnicalc_Jumper_SE
	jp (hl)
Parser_Omnicalc_Jumper_SE:
	xor a
	out (20h),a
	jp (hl)
Parser_Omnicalc_Jumper_End:
