; -------------------- getScaledSize --------------------
; Calculates the scaled size of a sprite.
;
; Version: 1.0
; Author: Badja <http://move.to/badja> <badja@alphalink.com.au>
; Date: 21 December 1999
; Size: 19 bytes
;
; Input:
;    B = height of unscaled sprite
;    C = width of unscaled sprite (in pixels)
;   HL = scale factor ($0000 to $0100 <=> 0% to 100%)
;        eg: $0080 is 50%
;
; Output:
;    A = height of scaled sprite
;    H = width of scaled sprite
;
; Destroys:
;    AF, BC, DE, HL


#ifdef TI83P
_SSG_HTimesL = $4276
#else
_SSG_HTimesL = $4382
#endif

getScaledSize:
	bit	0,h
	jr	nz,_SSG_noScale
	ld	a,l
	ld	h,b
	bcall(_SSG_HTimesL)
	ld	l,a
	ld	a,h
	ld	h,c
	bcall(_SSG_HTimesL)
	ret	
_SSG_noScale:
	ld	a,b
	ld	h,c
	ret
