; -------------------- putScaledSprite --------------------
; Draws a scaled sprite to the graph buffer.
;
; Version: 1.0
; Author: Badja <http://move.to/badja> <badja@alphalink.com.au>
; Date: 21 December 1999
; Size: 176 bytes (181 bytes if XORing the sprite)
;
; Input:
;   IX -> sprite
;    A = x-coordinate
;    L = y-coordinate
;    B = height of unscaled sprite
;    C = width of unscaled sprite (in bytes, so divide by 8)
;   HL = scale factor ($0000 to $0100 <=> 0% to 100%)
;        eg: $0080 is 50%
;
; Output:
;   The sprite is ORed to the graph buffer. To XOR the sprite
;   instead, add the following line near the top of your program:
;   #define _SS_XOR
;
; Destroys:
;   AF, BC, DE, HL, IX


putScaledSprite:
	ld	(_SS_SetScale1+1),hl
	ld	(_SS_SetScale2+1),hl

	ld	d,0
	ld	h,d
	ld	l,e
	add	hl,de
	add	hl,de
	add	hl,hl
	add	hl,hl
	ld	de,plotsscreen
	add	hl,de
	ld	d,0
	ld	e,a
	srl	e
	srl	e
	srl	e
	add	hl,de
	and	%00000111
	ld	(_SS_SetPreShift+2),a
	ld	d,a
	ld	a,8
	sub	d

	ld	(_SS_SetBitsLeft+1),a
	ex	de,hl

	ld	a,c
	ld	(_SS_SetByteWidth+1),a
	sla	a
	sla	a
	sla	a
	ld	(_SS_SetPixelWidth+1),a

	ld	c,0
	ld	hl,0
	jr	_SS_SkipAdd1

_SS_SpriteLoop:
	push	de
_SS_SetScale1:
	ld	de,$0000	; scale factor (self-modified)
	add	hl,de
	pop	de
	ld	a,h
	cp	c
	jr	nz,_SS_DoRow
	push	de
_SS_SetByteWidth:
	ld	de,$0000	; D = byte width of sprite data (self-modified)
	add	ix,de
	pop	de
	jr	_SS_SkipRow
_SS_DoRow:
	ld	c,h
_SS_SkipAdd1:
	push	bc
	push	hl
	push	de

	ld	hl,0
_SS_SetPreShift:
	ld	bc,$0000	; B = # bits before start of row (self-modified)
	ld	a,b
	jr	z,_SS_SetBitsLeft
	ld	a,(de)
_SS_PreShift:
	rlca
	djnz	_SS_PreShift
	ld	(de),a
_SS_SetBitsLeft:
	ld	b,$00		; # bits to copy into first byte (self-modified)

_SS_SetPixelWidth:
	ld	a,$00		; pixel width of sprite data (self-modified)
	push	af
	jr	_SS_SkipAdd2
_SS_RowLoop:
	push	de
_SS_SetScale2:
	ld	de,$0000	; scale factor (self-modified)
	add	hl,de
	pop	de
	ld	a,h
	cp	c
	jr	z,_SS_SkipPixel
	ld	c,h
_SS_SkipAdd2:
	ld	a,(de)
	rlc	(ix)
	jr	nc,_SS_LeaveBit
#ifdef _SS_XOR
	bit	7,a
	jr	z,_SS_LeaveCarry
	ccf
_SS_LeaveCarry:
#endif
	rla
	jr	_SS_DoneBit
_SS_LeaveBit:
	rlca
_SS_DoneBit:
	ld	(de),a
	djnz	_SS_DoneByte
	ld	b,8
	inc	de
	jr	_SS_DoneByte
_SS_SkipPixel:
	rlc	(ix)
_SS_DoneByte:
	pop	af
	dec	a
	push	af
	jr	z,_SS_DoneRow
	and	%00000111
	jr	nz,_SS_RowLoop
	inc	ix
	jr	_SS_RowLoop
_SS_DoneRow:
	inc	ix
	bit	3,b
	jr	nz,_SS_RowComplete
	ld	a,(de)
_SS_PostShift:
	rlca
	djnz	_SS_PostShift
	ld	(de),a
	inc	de
_SS_RowComplete:
	pop	af
	pop	de
	ld	hl,12
	add	hl,de
	ex	de,hl
	pop	hl
	pop	bc

_SS_SkipRow:
	djnz	_SS_SpriteLoop
	ret
