;SOUND PLAYER - Plays a converted wav file out of the link port!
;(c) Ben Ryves 2002 and 2003.
;www.calc83plus.tk
;===============================================================
;Usage - first, load channel into 'a'. For example, to play from
;left side only, type: "ld a,SOUND_LEFT". (other values are:
;"SOUND_MIDDLE" and "SOUND_RIGHT"). Then put in "ld hl,WAV" where
;'WAV' is the location of the WAV file. Then call 'SOUND_PLAY'.
;For example, to play sound 'VanSucka' from the right, code:
;
; ld a,SOUND_RIGHT
; ld hl,VanSucka
; call SOUND_PLAY
;
;================================================================
;Simple, eh?

SOUND_LEFT	equ	-1
SOUND_MIDDLE	equ	0
SOUND_RIGHT	equ	1

SOUND_PLAY:
	ld a,(hl)
	ld b,a
	inc hl
	ld a,(hl)
	ld d,a
	ld e,b
	inc hl

	ld (sound.pos),hl
	add hl,de
	ld (sound.end),hl

	cp 0
	jp z,channel.centre
	cp 1
	jp z,channel.right
	cp -1
	jp z,channel.left

channel.centre:
	ld a,D0HD1H
	jp setchannel
channel.left:
	ld a,D0HD1L
	jp setchannel
channel.right:
	ld a,D0LD1H

setchannel:
	ld hl,out_high+1
	ld (hl),a


SoundLoop:
	ld hl,(sound.pos)
	ld a,(hl)
	inc hl
	ld (sound.pos),hl

	ld b,a

	call play_byte

	ld hl,(sound.pos)
	ld de,(sound.end)
	bcall(_cphlde)
	ret z
	jp SoundLoop
	ret

out_high:
	ld a,D0HD1H
	out (BPORT),a
	ld a,0
	cp 0
	ret

out_low:
	ld a,D0LD1L
	out (BPORT),a
	ret

play_byte:
	bit 7,b \ call sethighlow
	bit 7,b \ call sethighlow
	bit 6,b \ call sethighlow
	bit 6,b \ call sethighlow
	bit 5,b \ call sethighlow
	bit 5,b \ call sethighlow
	bit 4,b \ call sethighlow
	bit 4,b \ call sethighlow
	bit 3,b \ call sethighlow
	bit 3,b \ call sethighlow
	bit 2,b \ call sethighlow
	bit 2,b \ call sethighlow
	bit 1,b \ call sethighlow
	bit 1,b \ call sethighlow
	bit 0,b \ call sethighlow
	bit 0,b \ call sethighlow

	ret

sethighlow:
	call z,out_high
	call nz,out_low
	ret

sound.pos:
	.word 0

sound.end:
	.word 0

;Dude, that's it!

.end
