; BLACKJACK 4.1 (ion) by Geoff Lywood
; Last modified 10/17/01 10:59PM

#include	"ti83plus.inc"			;General TI-83 Plus include file
#include	"mirage.inc"			;MirageOS include file

ionFastCopy =iFastCopy
ionLargeSprite =ilsprite
ionPutSprite =iSprite
ionRandom =irandom


;-->Memory equates
vs		=saferam1	;variable start
buffer		=vs
length		=buffer+2
maxlength	=length+1
firstloc	=maxlength+1
selected	=firstloc+2
selected2	=selected+1
yloc		=selected2+1
buffer2		=yloc+1	;max(money,limit)
mostrecent	=buffer2+2
cardslist	=mostrecent+3
cardstotal	=cardslist+52
dealnum		=cardstotal+2
splitnum	=dealnum+1
mynum		=splitnum+1

;note: multiples of 8
dealtotal	=mynum+1
dealcards	=dealtotal+1
dealyloc	=dealcards+6

splittotal	=dealyloc+1
splitcards	=splittotal+1
splityloc	=splitcards+6

mytotal		=splityloc+1
mycards		=mytotal+1
myyloc		=mycards+6

dealbup		=myyloc+1
ve		=dealbup+3	;variable end


;-->Flag equates

;-iy+asm_flag1-
quitonly	.equ	0
;1 is used with no equate,
;	-forces redraw of entire new game screen
;	-lets you quit during inputval
busted	.equ	2
s_busted	.equ	3
hass	.equ	4	;already split
SplitAble	.equ	5
DDAble	.equ	6
nodisp	.equ	7

;-iy+asm_flag2-
insplit	.equ	0
anykey	.equ	1
dostand	.equ	2
d_busted	.equ	3

;-mybits (in bj41t.asm)-
norestore	.equ	1
ddm2	.equ	2	;double-down >2 cards
ddos	.equ	3	;double-down on splits


	.org	$9d93				;Origin (set back two to account for AsmPrgm)
	.db	$BB,$6D				;Compiled AsmPrgm token
	ret					;So TIOS wont run the program
	.db	3				;Identifier as MirageOS program
	.db	%00000000,%00000000
	.db	%00111000,%01111000		;15x15 button
	.db	%00100100,%00010000
	.db	%00111000,%00010000
	.db	%00100100,%01010000
	.db	%00111000,%00110000
	.db	%00000000,%00000000
	.db	%01111100,%01111100
	.db	%10000010,%10000010
	.db	%10010010,%10101010
	.db	%10101010,%10110010
	.db	%10111010,%10110010
	.db	%10101010,%10101010
	.db	%10000010,%10000010
	.db	%01111100,%01111100
	.dw	reset_cursor
	.db	"BLACKJACK!",0			;Zero terminated description
						;Program code starts here

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       HERE BEGINS THE CODE         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
start:
	bcall(_clrgbuf)
	res plotloc,(iy+plotflags)
	res AnyKey,(iy+asm_flag2)
	ld ix,picStart
	xor a
	ld l,9
	ld b,10
	ld c,12
	call ionlargesprite
	ld a,26
	ld l,28
	ld b,26
	ld c,3
	push bc
	push hl
	ld ix,CLgsprite1
	call ionLargeSprite
	pop hl
	pop bc
	ld a,52
	ld ix,CLgSprite2
	call ionLargeSprite
	call ionfastcopy
	call waitkey
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;      CLEAR BOTTOM OF SCREEN        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld hl,plotSScreen+(20*12)
	ld de,plotSScreen+(20*12)+1
	ld bc,768-(20*12)-1
	ldir
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;          THE MAIN MENU             ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld hl,tblMainMenu
	ld de,22*256+20
	set 7,(iy+20)
	call menu
	call ionFastCopy
MainMenu:
;	bcall(_getkey)
	call keys
	jr c,mainmenu
	cp 5
	jr nc,mainmenu
	or a
	jr z,mainmenu
	ld l,a
	ld h,3
	bcall(_htimesl)
	ld de,tblMainMenuk-3
	add hl,de
	jp (hl)
tblMainMenuk
	jp NewGame
	jp Restore
	jp help
	ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;         CREATE A NEW GAME          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
NewGame:
	set 1,(iy+asm_flag1)
	set 7,(iy+20)
	ld ix,selected
	ld (ix+00),1
	ld (ix+01),1
NewGame2:
	ld a,(selected)
	cp 5
	jr z,NewGameC
	bit 1,(iy+asm_flag1)
	jr z,Newgame3
	bcall(_clrgbuf)
	ld hl,tblNewGame
	ld de,9*256+1
	call menu
Newgame3:
	call RedrawRight
	res 1,(iy+asm_flag1)
	jr NewGameKb
NewGameC:
	bcall(_clrgbuf)
	ld hl,20*256+24
	ld (pencol),hl
	ld hl,customtext
	bcall(_vputs)
	ld de,36*256+22
	ld (pencol),de
	bcall(_vputs)
	ld de,43*256+16
	ld (pencol),de
	bcall(_vputs)
	set 1,(iy+asm_flag1)
NewGameKb:
	ld hl,tblNewGameTop
	call menuacross
	call square
NewGameK:
	call ionFastCopy
	call keys
	jr c,NewGameKa
	cp 10
	jr z,StartGame
	cp 12
	ret z
	cp 6
	jr nc,newGameK
	or a
	jr z,newGameK
	ld (selected),a
	jr newgame2
newgameKa:
	call getarrows
	cp 0fdh
	jr z,newgameleft
	cp 0fbh
	jr nz,newgameK
newGameRight:
	ld a,(selected)
	inc a
	cp 6
	jr nz,newgameload
	ld a,1
	jr newgameload
newgameleft:
	ld a,(selected)
	dec a
	jr nz,newgameload
	ld a,5
newgameload:
	ld (selected),a
	jp newgame2
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;         SET UP SOME VARS           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
StartGame:
	ld ix,mybits
	res norestore,(ix+00)
	ld a,(selected)
	cp 5
	jr z,SetupCustom
	sla a
	sla a
	sla a
	ld e,a
	ld d,0
	ld hl,tblVariables-8
	add hl,de
	ld de,curVars
	ldi
	xor a
	ld (de),a
	inc de
	ldi
	ld (de),a
	inc de
	ld bc,3
	ldir
	ld a,(hl)
	or a
	jr z,Bitskip1
	set ddm2,(ix+00)
	jr Bitskip2
BitSkip1:
	res ddm2,(ix+00)
BitSkip2:
	inc hl
	ld a,(hl)
	or a
	jr z,bitskip3
	set ddos,(ix+00)
	jr bitskip4
BitSkip3:
	res ddos,(ix+00)
BitSkip4:
	inc hl
	ldi
	jp GetBet

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       CUSTOM TABLE DESIGNER        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SetupCustom:
	res 7,(iy+20)
	res 1,(iy+asm_flag1)
	set plotLoc,(iy+plotflags)
tryagain:
	bcall(_clrlcdf)
	bcall(_clrgbuf)
	ld hl,winStartMoney
	call Window
	call chkdezero
	jr z,tryagain
	ld (totalmoney),de
	bcall(_clrlcdf)
	ld hl,winTableLimit
	call window
	ld (tablelimit),de
setup_custom_loop1:
	bcall(_clrlcdf)
	ld hl,winDealerStop
	call window
	ld hl,2*256+22
	call between
	jr c,setup_custom_loop1
	ld (DealerStop),a
setup_custom_loop2:
	bcall(_clrlcdf)
	ld hl,winDoubleMin
	call window
	ld hl,2*256+22
	call between
	jr c,setup_custom_loop2
	push af
setup_custom_loop3:
	bcall(_clrlcdf)
	ld hl,winDoubleMax
	call window
	ld hl,2*256+22
	call between
	jr c,setup_custom_loop3
	pop af	;max=e min=a
	ld l,e
	ld c,e
	ld e,a
	inc l
	ld h,2
	call between
	jr c,setup_custom_loop2
	ld h,c
	ld l,a
	ld (doublemin),hl
	bcall(_clrlcdf)
	ld hl,winDDM2
	call window
	ld hl,mybits
	set DDm2,(hl)
	ld a,(selected)
	or a
	jr z,custom_skip1
	res DDm2,(hl)
custom_skip1:
	bcall(_clrlcdf)
	ld hl,winDDOS
	call window
	ld hl,mybits
	set DDOS,(hl)
	ld a,(selected)
	or a
	jr z,custom_skip2
	res DDOS,(hl)
custom_skip2:
	bcall(_clrlcdf)
	ld hl,winNumDecks
	call window
	ld hl,1*256+51
	call between
	jr c,custom_skip2
	ld (numdecks),a
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;             BET SCREEN             ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
GetBet:
	ld ix,mybits
	call resetcardslist
	ld de,0
	ld (curbetlast),de
	xor a
	ld (length),a
GetBetagain:
	ld hl,mybits
	bit norestore,(hl)
	jr z,getbetagain1
getbetagain2:
	bcall(_clrlcdf)
	ld hl,strOutOfMoney
	ld de,2*256+3
	ld (currow),de
	set textinverse,(iy+textflags)
	bcall(_puts)
	res textinverse,(iy+textflags)
	set anyKey,(iy+asm_flag2)
	call drawbottom
	call waitkey
	ret
getbetagain1:
	ld de,(TotalMoney)
	call chkdezero
	jr z,getbetagain2
	set 1,(iy+asm_flag1)
	set 7,(iy+20)
	res plotLoc,(iy+plotflags)
	set quitonly,(iy+asm_flag1)
	bcall(_clrlcdf)
	bcall(_clrgbuf)
	call drawbottom
	call ionFastCopy
	res 7,(iy+20)
	set plotLoc,(iy+plotflags)
	ld hl,winGetBet
	call window
	ld a,3
	ld (yloc),a
	call incpencol
	call incpencol
	ld hl,strGetBet
	bcall(_vputs)
	push hl
	ld hl,(totalmoney)
	call disp_align_right
	pop hl
	call incpencol
	bcall(_vputs)
	ld de,(tablelimit)
	ld hl,(totalmoney)
	ld (buffer2),hl
	bcall(_cphlde)
	jr c,Getbetskip1
	call chkdezero
	jr z,getbetskip1
	ld (buffer2),de
GetbetSkip1:
	ld hl,(buffer2)
	call disp_align_right
getbet_loop1:
	ld hl,5*256+5
	ld (currow),hl
	ld (firstloc),hl
	push hl
	ld hl,spaces
	bcall(_puts)
	pop hl
	ld (currow),hl
	ld de,(curbetlast)
	ld (buffer),de
	ld b,0
	call chkdezero
	jr z,getbet_skip2
	ex de,hl
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,6
	bcall(_formereal)
	ld hl,op3
	call myputs
getbet_skip2:
	ld a,b
	ld (length),a
	ld a,4
	ld (maxlength),a
getbet_loop2:
	call inputval_again
	jr z,getbet_loop2
return:
	ld hl,(buffer2)
	bcall(_cphlde)
	jr nc,valid
notvalid:
	ld hl,5*256+5
	ld a,4
	call inputval
	jr z,notvalid
	jr return
valid:
	call chkdezero
	jr z,notvalid
	ld (curbet),de
	ld (curbetlast),de
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       START OF GAMEPLAY            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;----> first three cards/gui
	bcall(_clrlcdf)
	bcall(_clrgbuf)
	call initialize
	set textwrite,(iy+20)
	res plotloc,(iy+plotflags)
	ld hl,winDealer
	call window
	ld hl,winYou
	call window
	res nodisp,(iy+asm_flag1)
	call getcard
	ld e,3
	call storeanddisp
	call getcard
	set nodisp,(iy+asm_flag1)
	ld e,1
	call storeanddisp
	res nodisp,(iy+asm_flag1)
	call getcard
	ld e,3
	call storeanddisp
	ld a,(mytotal)
	cp 21
	res hass,(iy+asm_flag1)
	jr nz,nextmove
BLACKJACK:
	call ionFastCopy
	ld hl,27*256+(96/2)-(40/2)
	ld de,37*256+(96/2)+(40/2)
	bcall(_drawrectborderc)
	res 7,(iy+20)
	ld hl,strBJ
	ld de,29*256+(96/2)-(40/2)+2
	ld (pencol),de
	bcall(_vputs)
	set 7,(iy+20)
	ld hl,(totalmoney)
	ld de,(curbet)
	push de
	call addmoney
	pop de
	or a
	rr d
	rr e
	call addmoney
	set anykey,(iy+asm_flag2)
	res 7,(iy+20)
	call drawbottom
	set 7,(iy+20)
	res anyKey,(iy+asm_flag2)
	call waitkey
	jp getbetagain

;----> user input
nextmove:
	call dispmytotal
	set dostand,(iy+asm_flag2)
	ld a,(mynum)
	cp 6
	jp z,stand
	res dostand,(iy+asm_flag2)
	call chkmytotal
	jp nc,stand
	res insplit,(iy+asm_flag2)
	call setupbottom
	call drawbottom
inputbadkey:
	call waitkey
	sub 31h
	ret z
	dec a
	jr z,split
	dec a
	jp z,doubledown
	set dostand,(iy+asm_flag2)
	dec a
	jp z,stand
	dec a
	jr nz,inputbadkey

;----> HIT
hit:
	call getcard
	ld e,3
	call storeanddisp
	jr nextmove

;----> SPLIT
split:
	bit splitAble,(iy+asm_flag1)
	jr nz,inputbadkey
	ld hl,winSplit
	call window
	set insplit,(iy+asm_flag2)
	set hass,(iy+asm_flag1)
	ld a,(mycards+1)
	ld hl,mycards
	ld b,(hl)
	dec hl
	ld (hl),b
	ld hl,mostrecent+2
	ld c,(hl)
	ld hl,(mostrecent)
	ld e,2
	call storeanddisp
	call getcard
	ld e,2
	call storeanddisp
	ld hl,16*256+64+5
	ld de,52*256+94
	bcall(_clearrect)
	ld hl,(curbet)
	ld (curbet2),hl
s_nextmove:
	call dispsplitt
	set dostand,(iy+asm_flag2)
	ld a,(splitnum)
	cp 6
	jr z,s_stand
	res dostand,(iy+Asm_flag2)
	call chksplittotal
	jr nc,s_stand
	call setupbottom
	call drawbottom
s_inputbadkey:
	call waitkey
	sub 31h
	ret z
	dec a
	dec a
	jr z,s_dd
	set dostand,(iy+asm_flag2)
	dec a
	jr z,s_stand
	dec a
	jr z,s_hit
	jr s_inputbadkey
s_hit:
	call getcard
	ld e,2
	call storeanddisp
	jr s_nextmove
s_dd:
	bit ddAble,(iy+asm_flag1)
	jr nz,s_inputbadkey
	call getcard
	ld e,2
	call storeanddisp
	set dostand,(iy+asm_flag2)
	ld hl,(curbet2)
	add hl,hl
	ld (curbet2),hl
	;jr s_stand
s_stand:
	ld e,2
	call chksplittotal
	jr c,s_nobust
s_stand_loop1:
	call chksplittotal
	jr c,s_bustbutaces
	ld hl,splitcards
	ld a,11
	ld bc,6
	cpir
	dec hl
	cp (hl)
	jr nz,s_no_aces
	ld a,1
	ld (hl),a
	ld hl,splittotal
	ld a,(hl)
	sub 10
	ld (hl),a
	dec e
	jr nz,s_stand_loop1
s_bustbutaces:
	bit dostand,(iy+asm_flag2)
	jp z,s_nextmove
	jr s_nobust
s_no_aces:
	ld de,4*256+32+24
	ld hl,strBust
	call menu
	set s_busted,(iy+asm_flag1)
s_nobust:
	call dispsplitt
	res insplit,(iy+asm_flag2)
	ld a,10
	ld (myyloc),a
	ld a,1
	ld (mynum),a
	call getcard
	ld e,3
	call storeanddisp
	jp nextmove
doubledown:
	bit ddAble,(iy+asm_flag1)
	jp nz,inputbadkey
	call getcard
	ld e,3
	call storeanddisp
	set dostand,(iy+asm_flag2)
	ld hl,(curbet)
	add hl,hl
	ld (curbet),hl
	;jr stand
stand:
	ld e,2
	call chkmytotal
	jr c,nobust
stand_loop1:
	call chkmytotal
	jr c,bustbutaces
	ld hl,mycards
	ld a,11
	ld bc,6
	cpir
	dec hl
	cp (hl)
	jr nz,no_aces
	ld a,1
	ld (hl),a
	ld hl,mytotal
	ld a,(hl)
	sub 10
	ld (hl),a
	dec e
	jr nz,stand_loop1
bustbutaces:
	bit dostand,(iy+asm_flag2)
	jp z,nextmove
	jr nobust
no_aces:
	ld de,4*256+64+25
	ld hl,strBust
	call menu
	set busted,(iy+asm_flag1)
nobust:
	call dispmytotal
	bit busted,(iy+asm_flag1)
	jr z,dealer
	bit hass,(iy+asm_flag1)
	jp z,compare
	bit s_busted,(iy+asm_flag1)
	jr z,dealer
	jp compare

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;            DEALER PLAYS            ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
dealer:
	call getcard
	ld e,1
	call storeanddisp
dealer_loop1:
	ld a,(dealtotal)
	ld hl,dealerstop
	cp (hl)
	jr nc,dealerdone
	ld a,(dealnum)
	cp 6
	jr z,dealerdone
	call getcard
	ld e,1
	call storeanddisp
	jr dealer_loop1
dealerdone:
	ld a,(dealtotal)
	cp 22
	jr c,dealernobust
	ld hl,dealcards
	ld a,11
	ld bc,6
	cpir
	dec hl
	cp (hl)
	jr nz,dealerbust
	ld a,1
	ld (hl),a
	ld a,(dealtotal)
	sub 10
	ld (dealtotal),a
	jr dealer_loop1
dealerbust:
	set d_busted,(iy+asm_flag2)
dealernobust:
	ld hl,46*256+21
	ld (pencol),hl
	ld a,(dealtotal)
	bcall(_setxxop1)
	ld a,2
	bcall(_dispop1a)
	ld hl,9*256+1
	ld de,14*256+25
	bcall(_clearrect)
	ld hl,8*256+4
	ld (pencol),hl
	ld hl,(dealbup)
	ld b,2
	bcall(_vputsn)
	ld a,(dealbup+2)
	ld c,a
	add a,c
	add a,c
	sla a
	ld c,a
	ld b,0
	ld ix,suitsprites
	add ix,bc
	ld b,6
	ld hl,(pencol)
	ld a,l
	ld l,h
	call ionPutsprite
	bit d_busted,(iy+asm_flag2)
	jr z,compare
	ld de,4*256+24
	ld hl,strbust
	call menu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;           COMPARE THE HANDS        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
compare:
	bit hass,(iy+asm_flag1)
	jr z,compare_skip1
	bit s_busted,(iy+asm_flag1)
	jr nz,compare_s_bust
	bit d_busted,(iy+asm_flag2)
	jr nz,compare_s_win
	ld a,(splittotal)
	ld b,a
	ld a,(dealtotal)
	cp b
	jr z,compare_s_push
	jr nc,compare_s_lose
compare_s_win:
	ld de,(curbet2)
	call addmoney
	ld hl,strWin
	ld de,4*256+32+24
	call menu
	jr compare_skip1
compare_s_push:
	ld hl,strPush
	ld de,4*256+32+24
	call menu
	jr compare_skip1
compare_s_lose:
	ld hl,strLose
	ld de,4*256+32+24
	call menu
compare_s_bust:
	ld de,(curbet2)
	call subtractmoney
compare_skip1:
	bit busted,(iy+asm_flag1)
	jr nz,compare_bust
	bit d_busted,(iy+asm_flag2)
	jr nz,compare_win
	ld a,(mytotal)
	ld b,a
	ld a,(dealtotal)
	cp b
	jr z,compare_push
	jr nc,compare_lose
compare_win:
	ld de,(curbet)
	call addmoney
	ld hl,strWin
	ld de,4*256+64+25
	call menu
	jr compare_skip2
compare_push:
	ld hl,strPush
	ld de,4*256+64+25
	call menu
	jr compare_skip2
compare_lose:
	ld hl,strLose
	ld de,4*256+64+25
	call menu
compare_bust:
	ld de,(curbet)
	call subtractmoney
compare_skip2:

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;  DISPLAY "PRESS ANY KEY" AND LOOP  ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
stophand:
	set AnyKey,(iy+asm_flag2)
	call drawbottom
	call ionFastCopy
	res AnyKey,(iy+asm_flag2)
	call waitkey
	jp getbetagain


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;       RESTORE PREVIOUS GAME        ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Restore:
	ld hl,mybits
	bit norestore,(hl)
	jp nz,mainmenu
	ld de,(totalmoney)
	call chkdezero
	jp z,mainmenu
	jp getbet
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;         THE HELP SCREENS           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Help:
	res 7,(iy+20)
	ld hl,tblHelpText
	ld b,7
Help_loop:
	push bc
	push hl
	bcall(_clrlcdf)
	ld de,-5*256+1
	pop hl
	call menu
	push hl
Help_kloop:
	call waitkey
	cp 36h
	jr nz,Help_kloop
	pop hl
	pop bc
	djnz Help_loop
	call ionFastCopy
	jp mainmenu

reset_cursor:
	bcall(_cursoroff)
	ret


#include "bj41c.asm"
#include "bj41t.asm"

.end