; included calls file for BLACKJACK!


;---->waits for a keypress
waitkey:
	ei
	halt
	bcall(_getcsc)
	or a
	jr z,waitkey
	ret

;---->looks in tblKeys to find numeric
;     value for common keypresses.
;Inputs: none
;Outputs: a=value
;		0-9 if number
;		10  if enter
;		11  if delete
;		12  if clear
;		13  if Graph
;Destroys: all but (de?)
;Requires: waitkey
keys:
	call waitkey
	ld hl,tblKeys
	ld bc,14
	cpir
	dec hl
	cp (hl)
	jr nz,keys_notfound
	ld a,13
	sbc a,c
	or a
	ret
keys_notfound:
	scf
	ret

;---->Multiple lines of text,small font
;Inputs: hl -> table of strings (below)
;	 de =  location on screen
;		6 pixels above first line
;
;	 table: .db num_of_lines
;		.db "first string",0
;		.db "second string",0
;
;Outputs: display/buffer changes.
;Destroyed: All
menu:
	ld a,(hl)
	inc hl
menu_loop1:
	ex de,hl
	ld bc,6*256+0
	add hl,bc
	ld (pencol),hl
	ex de,hl
	bcall(_vputs)
	dec a
	jr nz,menu_loop1
	ret

;----> This is a bit of code I made up
; It displays multiple lines of text,
; just like the menu routine, only
; centered on the screen. It was never
; actally used in the program.
; Tip 4 Ultraedit: highlight it all and
; right click it. "comment remove"
; will get rid of all the semicolons.
;centermenu:
;	ld b,(hl)
;	inc hl
;centermenu_loop1:
;	ex de,hl
;	push bc
;	ld bc,6*256+0
;	add hl,bc
;	ld (pencol),hl
;	ex de,hl
;	call dispcenter
;	pop bc
;	djnz centermenu_loop1
;	ret
;dispcenter:
;	push de
;	ld de,op1+1
;	ld b,-1
;dispcenter_loop1:
;	ld a,(hl)
;	ldi
;	inc b
;	or a
;	jr nz,dispcenter_loop1
;	;hl->first byte of next string
;	;b=number of bytes, not incl. 0
;	push hl
;	ld hl,op1
;	ld (hl),b
;	bcall(_sstringlength)
;	sra b
;	ld a,96/2-1
;	sub b
;	ld (pencol),a
;	inc hl
;	bcall(_vputs)
;	pop hl
;	pop de
;	ret


;----> duh?
;Destroys: hl?
hltimes10:
	push de
	add hl,hl
	ld d,h
	ld e,l
	add hl,hl
	add hl,hl
	add hl,de
	pop de
	ret


;----> Inputs an integer to de
;Inputs: a = max length of number
;		^- must be <= 4
;	 hl = currow location
;	 bit 1,(iy+asm_flag1) = quit?
;
;Outputs: z = 1 if no input
;	  de = integer
;	  a = length of number
;Destroys: All
;Requires: ram locations,keys,hltimes10
inputval:
	ld (maxlength),a
	ld (currow),hl
	ld b,a
	ld a,20h
	bcall(_putc)
inputval_loop3:
	bcall(_putc)
	djnz inputval_loop3
	ld (currow),hl
	ld (firstloc),hl
	ld hl,0
	ld (buffer),hl
	xor a
	ld (length),a
inputval_again:
inputval_loop1:
	bcall(_cursoroff)
	ld a,20h
	ld (curunder),a
	bcall(_putmap)
	bcall(_cursoron)
	call keys
	jr c,inputval_loop1
	cp 10
	jr z,inputval_done
	cp 11
	jr z,inputval_delete
	cp 12
	jr z,inputval_clear
	cp 13
	jr z,quitprog
	ld b,a
	ld a,(length)
	ld hl,maxlength
	cp (hl)
	jr z,inputval_loop1
	ld a,b
	add a,30h
	bcall(_putc)
	ld hl,(buffer)
	call hltimes10
	ld d,0
	ld e,b
	add hl,de
	ld (buffer),hl
	ld hl,length
	inc (hl)
	jr inputval_loop1
inputval_delete:
	ld hl,(currow)
	ld de,(firstloc)
	bcall(_cphlde)
	jr z,inputval_loop1
	ld a,20h
	bcall(_putmap)
	ld hl,curcol
	dec (hl)
	ld hl,(buffer)
	bcall(_divhlby10)
	ld (buffer),hl
	ld hl,length
	dec (hl)
	jr inputval_loop1
inputval_clear:
	ld a,(maxlength)
	ld hl,(firstloc)
	jp inputval
inputval_done:
	bcall(_cursoroff)
	ld de,(buffer)
	ld a,(length)
	or a
	ret
quitprog:
	bit 1,(iy+asm_flag1)
	jp z,inputval_loop1
	bcall(_cursoroff)
	pop hl
	ret
	

;----> direct input of arrow keys
getarrows:
	ld a,0ffh
	out (1),a
	ld a,0feh
	out (1),a
	in a,(1)
	ret


;----> Draws a few words, spaced out
;       across the top of the screen
;Inputs: hl -> table (like menu)
;Outputs: screen/buffer change
;Destroyed: all but a and c
menuacross:
	ld b,(hl)
	inc hl
	ld de,2*256+2
	ld (pencol),de
menuacross2:
	bcall(_vputs)
	push hl
	ld hl,spaces
	bcall(_vputs)
	pop hl
	djnz menuacross2
	ret


;----> Draws the square on the new game
;        screen.
;Inputs: (selected),(selected2)
;Outputs: (selected2), square
square:
	ld a,(selected2)
	call square2
	bcall(_eraserectborder)
	ld a,(selected)
	ld (selected2),a
	call square2
	bcall(_drawrectborder)
	ret
square2:
	ld l,a
	ld h,14
	bcall(_htimesl)
	ld de,9*256+24
	add hl,de	;hl = far side
	push hl
	pop de
	ld bc,-8*256-8
	add hl,bc
	ret


;----> Just like pressing enter.
;      Only with the small font.
;NOTE: it actually inc's (penrow)
;Inputs: (yloc) = place to return to.
;Outputs: (penrow) updated
;Destroyed: a,de
incpencol:
	ld a,(yloc)
	ld e,a
	ld a,(penrow)
	add a,6
	ld d,a
	ld (pencol),de
	ret


;----> Erase to the end of the line
;        with the small font.
;Inputs: (pencol/row)
;Outputs: display/buffer change
erasetoend:
	ld a,20h
	bcall(_vputmap)
	jr nc,erasetoend
	ret


;----> Redraw the right hand side of
;      the screen when choosing a table
;Inputs: (selected)
;Outputs: display/buffer change
;Requires: some ram locations,
;	    tblVariables, erasetoend
RedrawRight:
	ld a,77
	ld (yloc),a
	ld hl,tblVariables-8
	ld de,8
	ld a,(selected)
	ld b,a
RedrawRight_loop1:
	add hl,de
	djnz RedrawRight_loop1
	ld de,9*256+77
	ld (pencol),de
	ld b,5
RedrawRight_loop2:
	push bc
	call RR_Number
	pop bc
	djnz RedrawRight_loop2
	call RR_YesNo
	call RR_YesNo
RR_Number:
	call incpencol
	push hl
	ld l,(hl)
	ld h,0
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	bcall(_ckop1fp0)
	jr z,RR_None
	bcall(_dispop1a)
RR_Finished:
	call erasetoend
	pop hl
	inc hl
	ret
RR_None:
	ld hl,none
	bcall(_vputs)
	jr RR_finished
RR_YesNo:
	call incpencol
	push hl
	ld a,(hl)
	or a
	jr z,RR_No
	ld hl,yes
	bcall(_vputs)
	jr RR_Finished
RR_No:
	ld hl,no
	bcall(_vputs)
	jr RR_Finished


;----> Draws a rectangular border and
;	the text to fill it. Will
;	input a yes/no or inputval
;	entry.
;Inputs: hl -> window
;Outputs: [prompt], text, rectangle
;The window format is in "bj41t.asm"
Window:
	ld d,(hl)
	inc hl
	ld e,(hl)
	inc hl
	ld a,(hl)
	inc hl
	push hl
	ld l,(hl)
	ld h,a
	push hl
	bcall(_drawrectborder)
	pop de
	ld a,96/2-10
	ld (yloc),a
	ld a,d
	sub 5
	ld d,a
	inc e
	inc e
	pop hl
	inc hl
	call menu
	ld a,(hl)
	dec a
	jr z,Window_inputval
	dec a
	ret nz
Window_yesno:
	ld hl,penrow
	inc (hl)
	inc (hl)
	inc (hl)
	xor a
	ld (selected),a
	call incpencol
window_yesno_loop1:
	ld a,(yloc)
	ld (pencol),a
	ld a,(selected)
	ld hl,yes
	or a
	jr nz,window_yesno_skip1
	set textinverse,(iy+textflags)
window_yesno_skip1:
	bcall(_vputs)
	res textinverse,(iy+textflags)
	bcall(_vputs)
	or a
	jr z,window_yesno_skip2
	set textinverse,(iy+textflags)
window_yesno_skip2:
	bcall(_vputs)
	res textinverse,(iy+textflags)
window_yesno_loop2:
	call waitkey
	cp 9
	ret z
	dec a
	dec a
	jr z,window_yesno_left
	dec a
	jr nz,window_yesno_loop2
	ld a,1
	ld (selected),a
	jr window_yesno_loop1
window_yesno_left:
	xor a
	ld (selected),a
	jr window_yesno_loop1
window_inputval:
	inc hl
	ld a,(hl)
	inc hl
	ld l,(hl)
	ld h,a
window_inputval_loop1:
	ld a,4
	push hl
	call inputval
	pop hl
	jr z,window_inputval_loop1
	ret


;----> Compares e to h and l
;destroys a
;returns ca=0 if h<=e<l
;returns ca=1 if e<h or e>=l
between:
	ld a,e
	cp h	;lower limit (a>=h)
	ret c	;returns ca=1 if a<h
	cp l	;upper limit (a<l)
	ccf	;returns ca=o if a<l
		;returns ca=1 if a>=l
	ret


;----> Displays the number in hl
; near the right side of the screen.
;Destroys: ops, all regs
disp_align_right:
	bcall(_setxxxxop2)
	bcall(_op2toop1)
	ld a,8
	bcall(_formereal)
	ld hl,op3-1
	ld (hl),c
	bcall(_sstringlength)
	ld a,94
	sub b
	ld (pencol),a
	inc hl
	bcall(_vputs)
	ret


;----> Displays a string, counts chars.
;I/O: same as bcall(_vputs)
myputs:
	ld b,0
myputs_loop1:
	ld a,(hl)
	inc hl
	or a
	ret z
	inc b
	bcall(_putc)
	jr myputs_loop1

;----> Checks if de is zero
;destroys: a
chkdezero:
	xor a
	or d
	ret nz
	or e
	ret


;---->Redraws the bottom of the screen
;Inputs: a lot of bits:
;		anykey
;		quitonly
;		ddable
;		splitable
;Outputs: display
drawbottom:
	ld a,-1
	ld hl,plotsscreen+(12*55)
	ld b,12
drawbottom_loop1:
	ld (hl),a
	inc hl
	djnz drawbottom_loop1
	set fullscrnDraw,(iy+apiFlg4)
	ld hl,56*256+0
	ld de,63*256+95
	bcall(_clearrect)
	res fullscrnDraw,(iy+apiFlg4)
	bit AnyKey,(iy+asm_flag2)
	jr z,drawbottom_doit
	ld hl,56*256+24
	ld (pencol),hl
	ld hl,strAnyKey
	bcall(_vputs)
	ret
drawbottom_doit:
	set fullscrndraw,(iy+apiflg4)
	ld hl,tblBottomlines
	ld b,4
drawbottom_loop2:
	push bc
	ld b,(hl)
	ld c,0
	ld d,b
	ld e,8
	push hl
	bcall(_darkline)
	pop hl
	inc hl
	pop bc
	djnz drawbottom_loop2
	ld hl,tblBottomText
	ld de,tblBottomLines-1
	ld a,64-8
	ld (penrow),a
	ld b,5
	bit quitonly,(iy+asm_flag1)
	jr z,drawbottom_loop3
	ex de,hl
	dec de	;de->77
	ld hl,strQuit
	ld b,1
drawbottom_loop3:
	ld a,(de)
	inc a
	inc a
	ld (pencol),a
	bcall(_vputs)
	inc de
	djnz drawbottom_loop3
	bit DDAble,(iy+asm_flag1)
	jr z,drawbottom_skip1
	ld a,41
	ld b,13
	call erase18
drawbottom_skip1:
	bit SplitAble,(iy+asm_flag1)
	jr z,drawbottom_skip2
	ld a,57
	ld b,20
	call erase18
drawbottom_skip2:
	call ionFastCopy
	res fullscrndraw,(iy+apiflg4)
	ret
erase18:
	ld (pencol),a
	ld a,20h
erase18_loop1:
	push af
	bcall(_vputmap)
	pop af
	djnz erase18_loop1
	ret


;----> Reset cards list, display text
resettotal:
	call ionFastCopy
	set plotloc,(iy+plotflags)
	ld hl,27*256+(96/2)-(30/2)-6
	ld de,37*256+(96/2)+(30/2)+6
	bcall(_drawrectborderc)
	res 7,(iy+20)
	ld hl,strNewDeal
	ld de,29*256+(96/2)-(30/2)+2
	ld (pencol),de
	bcall(_vputs)
	res plotLoc,(iy+plotflags)
	set anykey,(iy+asm_flag2)
	call drawbottom
	res anyKey,(iy+asm_flag2)
	call waitkey
	set 7,(iy+20)
resetcardslist:
	ld hl,cardslist
	ld de,cardslist+1
	ld bc,51
	ld (hl),0
	ldir
	inc hl
	ld (hl),b    ;reset card total
	inc hl
	ld (hl),b
	ret


;----> Deals a card off the deck
;Outputs: hl = pointer to chars
;	  a = value (2-11)
;	  c = suit (0-3)
getCard:
	ld a,(numdecks)
	ld l,a
	ld h,52
	bcall(_htimesl)
	ld de,8
	or a
	sbc hl,de
	ex de,hl
	ld hl,(cardstotal)
	bcall(_cphlde)
	call z,resettotal
getcard_loop1:
	ld b,52
	call ionRandom
	ld e,a
	ld d,0
	ld hl,cardsList
	add hl,de
	ld b,(hl)
	ld a,(numdecks)
	cp b
	jr z,getCard_loop1
	inc (hl)
	ld hl,(cardstotal)
	inc hl
	ld (cardstotal),hl
	ld a,13
	ld l,e
	ld h,0
	bcall(_divhlbya) ;l=suit
	inc a	;a=value (1-13)
	ld c,l
	ld hl,tblascii-2
	ld d,0
	ld e,a
	sla e
	add hl,de
	ld (mostrecent),hl
	cp 10
	jr c,getcard_skip1
	ld a,10
getcard_skip1:
	cp 1
	jr nz,getcard_skip2
	ld a,11
getcard_skip2:
	push af
	ld a,c
	ld (mostrecent+2),a
	pop af
	ret


;---->Display a card / store it in hand
;Inputs:
;	hl -> chars
;	a  =  value of card
;	c  =  suit (0-3)
;	e  =  player, 1=dealer
;		      2=split
;		      3=player
storeanddisp:
	push ix
	push af
	push de
	push bc
	push hl
	ld d,0
	ld hl,tblDist-1
	add hl,de
	ld a,(hl)
	ld (pencol),a
	ld hl,dealyloc-8
	sla e
	sla e
	sla e
	add hl,de
	ld a,(hl)
	add a,7
	ld (penrow),a
	ld (hl),a
	pop hl
	ld b,2
	bit nodisp,(iy+asm_flag1)
	jr z,storeanddisp_skip1
	ld (dealbup),hl
	ld hl,question
storeanddisp_skip1:
	bcall(_vputsn)
	pop bc
	bit nodisp,(iy+asm_flag1)
	jr nz,storeanddisp_skip2
	ld b,0
	ld a,c
	add a,c
	add a,c
	sla a
	ld c,a
	ld hl,(pencol)
	ld a,l
	ld l,h
	ld ix,suitSprites
	add ix,bc
	ld b,6
	call ionPutSprite
	jr storeanddisp_skip3
storeanddisp_skip2:
	ld a,c
	ld (dealbup+2),a
storeanddisp_skip3:
	ld hl,dealnum-1
	pop bc
	ld b,0
	add hl,bc
	ld e,(hl)  ;e=offset to card
	inc (hl)
	sla c
	sla c
	sla c
	ld hl,dealcards-8
	add hl,bc
	ld d,b	;d=0, b=0
	add hl,de
	pop af
	ld (hl),a
	ld hl,dealtotal-8
	add hl,bc
	add a,(hl)
	ld (hl),a
	pop ix
	ret


;----> Fixes ddable, splitable bits
;Inputs: hands, hass, insplit,ddm2,ddos
setupbottom:
	ld ix,mybits
	ld hl,mycards
	ld a,(hl)
	inc hl
	set splitAble,(iy+asm_flag1)
	cp 1
	jr z,setupbottom_6
	cp (hl)
	jr nz,setupbottom_1
setupbottom_6:
	bit hass,(iy+asm_flag1)
	jr nz,setupbottom_1
	ld a,(mycards+2)
	or a
	jr nz,setupbottom_1
	res splitAble,(iy+asm_flag1)
setupbottom_1:
	ld a,(mytotal)
	ld hl,(doublemin)
	bit insplit,(iy+asm_flag2)
	jr z,setupbottom_5
	ld a,(splittotal)
setupbottom_5:
	set DDAble,(iy+asm_flag1)
	cp l
	jr c,setupbottom_2
	inc h
	cp h
	jr nc,setupbottom_2
	bit ddm2,(ix+00)
	jr nz,setupbottom_3
	ld a,(mycards+2)
	or a
	jr nz,setupbottom_2
setupbottom_3:
	bit ddos,(ix+00)
	jr nz,setupbottom_4
	bit hass,(iy+asm_flag1)
	jr nz,setupbottom_2
setupbottom_4:
	res DDAble,(iy+asm_flag1)
setupbottom_2:
	res quitonly,(iy+asm_flag1)
	ret


;----> Reset hands to zero
initialize:
	ld hl,dealnum
	ld de,dealnum+1
	ld bc,26
	xor a
	ld (hl),a
	ldir
	ld a,2
	ld (myyloc),a
	ld (dealyloc),a
	ld (splityloc),a
	res busted,(iy+asm_flag1)
	res s_busted,(iy+asm_flag1)
	res d_busted,(iy+Asm_flag2)
	ret


;----> Checks for busts
chkmytotal:
	ld a,(mytotal)
	cp 22
	ret
chksplittotal:
	ld a,(splittotal)
	cp 22
	ret


;----> Display totals
dispmytotal:
	ld hl,46*256+86
	ld (pencol),hl
	ld a,(mytotal)
	bcall(_setxxop1)
	ld a,2
	bcall(_dispop1a)
	ret
dispsplitt:
	ld hl,46*256+53
	ld (pencol),hl
	ld a,(splittotal)
	bcall(_setxxop1)
	ld a,2
	bcall(_dispop1a)
	ret


;----> Add money (max=9999)
; de = amount
addmoney:
	ld hl,(totalmoney)
	add hl,de
	ld de,9999
	bcall(_cphlde)
	jr c,addmoney_s1
	ex de,hl
addmoney_s1:
	ld (totalmoney),hl
	ld hl,mybits
	res norestore,(hl)
	ret

;----> Subtract money (adjust bits if broke)
; de = amount
subtractmoney:
	ld hl,(totalmoney)
	ex de,hl
	bcall(_cphlde)
	jr c,subtractmoney_s1
	push hl
	ld hl,mybits
	set norestore,(hl)
	pop hl
subtractmoney_s1:
	ex de,hl
	or a
	sbc hl,de
	ld (totalmoney),hl
	ret



