;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Animation Routines                                                ;
;                                                                   ;
;===================================================================;

;================================================
; clearAnimTable - Clear animTable
;
; Input:    None
; Output:   None
;================================================
clearAnimTable:
        ld      hl,animTable
        ld      de,animTable+1
        ld      bc,8
        ld      (hl),0
        ldir
        ret

;================================================
; newAnimation - Create a new explosion animation
;
; Input:    L = X Coord
;           H = Y Coord
; Output:   None
;================================================
newAnimation:
        push    hl
        ld      hl,animTable
        ld      b,3
        ld      de,3
findEmptyAnimEntry:
        ld      a,(hl)
        or      a
        jr      z,foundEmptyAnimEntry
        add     hl,de
        djnz    findEmptyAnimEntry
        pop     hl
        ret
foundEmptyAnimEntry:
        pop     bc
        ld      (hl),4
        inc     hl
        ld      (hl),c
        inc     hl
        ld      (hl),b
        ret

;================================================
; drawAnims - Draw explosion animations
;
; Input:    None
; Output:   None
;================================================
drawAnims:
        ld      hl,animTable
        ld      b,3
drawAnimsLoop:
        push    hl
        push    bc
        ld      a,(hl)
        or      a
        jr      z,endDrawAnimsLoop
        dec     a
        add     a,a
        add     a,a
        add     a,a
        inc     hl
        ld      b,(hl)
        inc     hl
        ld      c,(hl)
        ld      e,a
        ld      d,0
        ld      hl,sprExplosion1
        add     hl,de
        ex      de,hl
        ld      a,b
        ld      l,c
        call    putSprite
endDrawAnimsLoop:
        pop     bc
        pop     hl
        inc     hl
        inc     hl
        inc     hl
        djnz    drawAnimsLoop
        ret

;================================================
; updateAnims - Update explosion animations
;
; Input:    None
; Output:   None
;================================================
updateAnims:
        ld      hl,frame
        bit     0,(hl)
        ret     nz
        ld      hl,animTable
        ld      b,3
updateAnimsLoop:
        ld      a,(hl)
        or      a
        jr      z,endUpdateAnimsLoop
        dec     (hl)
endUpdateAnimsLoop:
        inc     hl
        inc     hl
        inc     hl
        djnz    updateAnimsLoop
        ret

.end
