;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Bird Routines                                                     ;
;                                                                   ;
;===================================================================;

;================================================
; tryMakeBird - Try to make a bird
;
; Input:    None
; Output:   None
;================================================
tryMakeBird:
        ld      a,(birdOn)
        or      a
        ret     nz
        ld      a,(level)
        cp      4
        ret     c
        cp      15
        jr      nc,makeBird
        sub     15
        neg
        add     a,a
        add     a,a
        add     a,a
        ld      b,a
        call    random
        or      a
        ret     nz
makeBird:
        xor     a
        ld      (birdX),a
        inc     a
        ld      (birdOn),a
        ld      b,BOTTOM_SCREEN-4
        call    random
        and     %11111100
        ld      (birdY),a
        ret

;================================================
; drawBird - Draw bird
;
; Input:    None
; Output:   None
;================================================
drawBird:
        ld      a,(birdOn)
        or      a
        ret     z
        ld      de,sprBird
        ld      hl,(birdY)
        ld      a,(birdX)
        jp      putSprite

;================================================
; moveBird - Move bird
;
; Input:    None
; Output:   None
;================================================
moveBird:
        ld      a,(birdOn)
        or      a
        ret     z
        ld      hl,birdX
        inc     (hl)
        ld      a,(frame)
        and     $0F
        jr      nz,noBirdBlock
        ld      hl,(birdX)
        ld      b,l
        ld      c,h
        call    addBlock
noBirdBlock:
        ld      a,(birdX)
        cp      96-5
        ret     c
        xor     a
        ld      (birdOn),a
        ret

;================================================
; loadBirdToCollide2 - Load bird into (collide2)
;
; Input:    None
; Output:   None
;================================================
loadBirdToCollide2:
        ld      hl,collide2
        ld      a,(birdX)
        ld      (hl),a
        inc     hl
        ld      (hl),5
        inc     hl
        ld      a,(birdY)
        inc     hl
        ld      (hl),a
        inc     hl
        ld      (hl),5
        ret

.end
