;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Block Routines                                                    ;
;                                                                   ;
;===================================================================;

;================================================
; addBlock - Put a block in the blockTable
;
; Input:    B = X Coord
;           C = Y Coord
; Output:   None
;================================================
addBlock:
        ld      a,c
        cp      BOTTOM_SCREEN-4
        ret     nc
        srl     a
        srl     a
        ld      c,a
        ld      l,a
        ld      h,0
        add     hl,hl                           ; x2
        add     hl,hl                           ; x4
        add     hl,hl                           ; x8
        ld      e,l
        ld      d,h
        add     hl,hl                           ; x16
        add     hl,de                           ; x24, HL = Offset to row in blockTable
        ld      de,blockTable
        add     hl,de                           ; HL => Row in blockTable
        ld      a,b
        srl     a
        srl     a
        ld      b,a
        ld      e,a
        ld      d,0
        add     hl,de                           ; HL => Block in blockTable
        ld      a,(hl)
        ld      (hl),3
        or      a
        ret     nz

;================================================
; addToBlocksToDraw - Add a block to blocksToDraw
;
; Input:    B = X Coord
;           C = Y Coord
; Output:   None
;================================================
addToBlocksToDraw:
        ld      hl,(blocksToDrawPtr)
        ld      (hl),b
        inc     hl
        ld      (hl),c
        inc     hl
        ld      (blocksToDrawPtr),hl
        ret

;================================================
; drawBlocksToDraw - Draw blocks in blocksToDraw
;
; Input:    None
; Output:   None
;================================================
drawBlocksToDraw:
        ld      hl,(blocksToDrawPtr)
        ld      de,blocksToDraw
        bcall(_cphlde)
        ret     z
        dec     hl
        ld      c,(hl)
        dec     hl
        ld      b,(hl)
        ld      (blocksToDrawPtr),hl
        ld      a,c
        add     a,a
        add     a,a
        ld      l,a
        ld      a,b
        add     a,a
        add     a,a
        ld      de,sprBlock
        call    putSprite
        jr      drawBlocksToDraw

;================================================
; drawBlocks - Draw blocks
;
; Input:    None
; Output:   None
;================================================
drawBlocks:
        ld      de,blockTable
        ld      bc,BLOCK_TABLE_HEIGHT*BLOCK_TABLE_WIDTH
        ld      hl,$0000
drawBlocksLoop:
        push    bc
        push    de
        push    hl
        ld      a,(de)
        or      a
        jr      z,endDrawBlocksLoop
        ld      a,h
        ld      de,sprBlock
        call    putSprite
endDrawBlocksLoop:
        pop     hl
        inc     h
        inc     h
        inc     h
        inc     h
        ld      a,h
        cp      96
        jr      c,drawBlockNotNextLine
        inc     l
        inc     l
        inc     l
        inc     l
        ld      h,0
drawBlockNotNextLine:
        pop     de
        inc     de
        pop     bc
        dec     bc
        ld      a,c
        or      b
        jr      nz,drawBlocksLoop
        ret

;================================================
; coordsToBlockEntry - Convert X,Y coordinates to the entry of the block at that location
;
; Input:    A = X coord
;           L = Y coord
; Output:   HL => Entry in blockTable
;================================================
coordsToBlockEntry:
        srl     l
        srl     l
        ld      h,0
        add     hl,hl                           ; x2
        add     hl,hl                           ; x4
        add     hl,hl                           ; x8
        ld      e,l
        ld      d,h
        add     hl,hl                           ; x16
        add     hl,de                           ; x24
        srl     a
        srl     a
        ld      e,a
        ld      d,0
        add     hl,de                           ; HL = Offset to entry
        ld      de,blockTable
        add     hl,de                           ; HL => Entry
        ret

.end
