;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Bomb Routines                                                     ;
;                                                                   ;
;===================================================================;

;================================================
; tryMakeBomb - Try to make a bomb
;
; Input:    None
; Output:   None
;================================================
tryMakeBomb:
        ld      a,(bombOn)
        or      a
        ret     nz
        ld      a,(level)
        cp      2
        ret     c
        cp      10
        jr      nc,makeBomb
        sub     10
        neg
        add     a,a
        add     a,a
        add     a,a
        ld      b,a
        call    random
        or      a
        ret     nz
makeBomb:
        xor     a
        ld      (bombY),a
        inc     a
        ld      (bombOn),a
        ld      b,96
        call    random
        and     %11111100
        ld      (bombX),a
        ret

;================================================
; drawBomb - Draw bomb
;
; Input:    None
; Output:   None
;================================================
drawBomb:
        ld      a,(bombOn)
        or      a
        ret     z
        ld      de,sprBomb
        ld      hl,(bombY)
        ld      a,(bombX)
        jp      putSprite

;================================================
; moveBomb - Move bomb
;
; Input:    None
; Output:   None
;================================================
moveBomb:
        ld      a,(bombOn)
        or      a
        ret     z
        ld      a,$07
        ld      (_bombBlock),a
        ld      a,(level)
        cp      5
        jr      nc,doMoveBomb
        ld      hl,frame
        bit     0,(hl)
        ret     nz
        ld      a,$0F
        ld      (_bombBlock),a
doMoveBomb:
        ld      hl,bombY
        inc     (hl)
        ld      a,(hl)
        cp      BOTTOM_SCREEN-(5*4)
        jr      c,noBombBlock
        ld      a,(frame)
        and     $07
_bombBlock                              = $-1
        jr      nz,noBombBlock
        ld      hl,(bombX)
        ld      b,l
        ld      c,h
        call    addBlock
noBombBlock:
        ld      a,(bombY)
        cp      BOTTOM_SCREEN-5
        ret     c
        xor     a
        ld      (bombOn),a
        ld      hl,(bombX)
        jp      newAnimation

;================================================
; loadBombToCollide2 - Load bomb into (collide2)
;
; Input:    None
; Output:   None
;================================================
loadBombToCollide2:
        ld      hl,collide2
        ld      a,(bombX)
        ld      (hl),a
        inc     hl
        ld      (hl),4
        inc     hl
        ld      a,(bombY)
        ld      (hl),a
        inc     hl
        ld      (hl),5
        ret

.end
