;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Bug Routines                                                      ;
;                                                                   ;
;===================================================================;

;================================================
; tryMakeBug - Try making a bug
;
; Input:    None
; Output:   None
;================================================
tryMakeBug:
        ld      a,(bugOn)
        or      a
        ret     nz
        ld      a,(level)
        cp      5
        jr      nc,makeBug
        sub     5
        neg
        add     a,a
        add     a,a
        ld      b,a
        call    random
        or      a
        ret     nz
makeBug:
        ld      a,1
        ld      (bugOn),a
        ld      a,BUG_BOTTOM
        ld      (bugY),a
        ld      b,2
        call    random
        or      a
        jr      nz,newBugAtRightOfScreen
        xor     a
        ld      b,1
        jr      setNewBugXFlags
newBugAtRightOfScreen:
        ld      a,96-6
        ld      b,0
setNewBugXFlags:
        ld      (bugX),a
        ld      a,b
        ld      (bugFlags),a
; Fall thru to setNewBugTop

;================================================
; setNewBugTop - Set a new random value for (_bugTop)
;
; Input:    None
; Output:   None
;================================================
setNewBugTop:
        ld      b,BUG_TOP_MAX-BUG_TOP_MIN
        call    random
        add     a,BUG_TOP_MIN
        ld      (_bugTop),a
        ret
        
;================================================
; drawBug - Draw bug
;
; Input:    None
; Output:   None
;================================================
drawBug:
        ld      a,(bugOn)
        or      a
        ret     z
        ld      hl,(bugX)
        ld      a,(bugFlags)
        bit     1,a
        ld      de,sprBugUp
        jr      z,drawBugUp
        ld      de,sprBugDown
drawBugUp:
        ld      a,l
        ld      l,h
        jp      putSprite

;================================================
; moveBug - Move bug
;
; Input:    None
; Output:   None
;================================================
moveBug:
        ld      a,(bugOn)
        or      a
        ret     z
        ld      a,(level)
        cp      3
        jr      nc,doMoveBug
        ld      hl,frame
        bit     0,(hl)
        ret     nz
doMoveBug:
        ld      a,(bugFlags)
        bit     2,a
        call    z,moveBugHorizontal
        ld      a,(bugFlags)
        call    moveBugVertical
        ret     c
        call    setNewBugTop
        ld      a,(bugFlags)
        xor     %00000110
        and     %00000110
        ld      b,a
        ld      hl,x
        ld      a,(bugX)
        cp      (hl)
        ld      a,b
        adc     a,0
        ld      (bugFlags),a
        ret

;================================================
; moveBugHorizontal - Move the bug horizontally
;
; Input:    A = (bugFlags)
; Output:   None
;================================================
moveBugHorizontal:
        ld      hl,bugX
        bit     0,a
        ld      a,(hl)
        jr      nz,moveBugRight
moveBugLeft:
        or      a
        ret     z
        dec     (hl)
        ret
moveBugRight:
        cp      96-6
        ret     z
        inc     (hl)
        ret

;================================================
; moveBugVertical - Move the bug vertically
;
; Input:    A = (bugFlags)
; Output:   NC = 1 if bug has reached the end of a jump
;================================================
moveBugVertical:
        ld      hl,bugY
        bit     1,a
        ld      a,(hl)
        jr      nz,moveBugDown
moveBugUp:
        cp      $00
_bugTop                                 = $-1
        jr      z,bugAtTopOfJump
        dec     (hl)
        scf
        ret
moveBugDown:
        cp      BUG_BOTTOM
        ret     z
        inc     (hl)
        scf
        ret
bugAtTopOfJump:
        ld      a,(bugFlags)
        xor     %00000010
        ld      (bugFlags),a
        scf
        ret

;================================================
; loadBugToCollide2 - Load bug into (collide2)
;
; Input:    None
; Output:   None
;================================================
loadBugToCollide2:
        ld      hl,collide2
        ld      a,(bugX)
        ld      (hl),a
        inc     hl
        ld      (hl),6
        inc     hl
        ld      a,(bugY)
        ld      (hl),a
        inc     hl
        ld      (hl),4
        ret

.end
