@ECHO OFF

ECHO ----- Assembling Centipede for TI-83 Ion...
SET ERROR=TI-83 Ion
ECHO #define TI83 > temp.asm
TYPE centipde.asm >> temp.asm
TASM -80 -I -B temp.asm centipde.bin
IF ERRORLEVEL 1 GOTO ERRORS
DEVPAC83 centipde

ECHO ----- Assembling Centipede for TI-83+ Ion...
SET ERROR=TI-83+ Ion
ECHO #define TI83P > temp.asm
TYPE centipde.asm >> temp.asm
TASM -80 -I -B temp.asm centipde.bin
IF ERRORLEVEL 1 GOTO ERRORS
DEVPAC8X centipde

ECHO ----- Assembling Centipede for TI-83+ MirageOS...
SET ERROR=TI-83+ MirageOS
ECHO #define MIRAGE > temp.asm
TYPE centipde.asm >> temp.asm
TASM -80 -I -B temp.asm centipdm.bin
IF ERRORLEVEL 1 GOTO ERRORS
DEVPAC8X centipdm

ECHO ----- Assembling Centipede for TI-86...
SET ERROR=TI-86
ECHO #define TI86 > temp.asm
TYPE centipde.asm >> temp.asm
TASM -80 -I -B temp.asm centipde
IF ERRORLEVEL 1 GOTO ERRORS
PRGM86 centipde

ECHO.
ECHO.
ECHO ----- SUCCESS :)
ECHO TI-83 Ion version is centipde.83p
ECHO TI-83+ Ion version is centipde.8xp
ECHO TI-83+ MirageOS version is centipdm.8xp
ECHO TI-86 version is centipde.86p
GOTO DONE

:ERRORS
ECHO ----- There were errors with the %ERROR% version!

:DONE
IF EXIST temp.asm DEL temp.asm > NUL
IF EXIST centipde.bin DEL centipde.bin > NUL
IF EXIST centipde DEL centipde > NUL
IF EXIST centipdm.bin DEL centipdm.bin > NUL
IF EXIST temp.lst DEL temp.lst > NUL
