;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Bullet Routines                                                   ;
;                                                                   ;
;===================================================================;

;================================================
; shoot - Try to shoot a bullet
;
; Input:    None
; Output:   None
;================================================
shoot:
        ld      a,(bulletOn)
        or      a
        ret     nz                              ; Bullet already on-screen, can't shoot
        inc     a
        ld      (bulletOn),a
        ld      a,(y)
        ld      (bulletY),a
        ld      a,(x)
        add     a,2
        ld      (bulletX),a
        ret

;================================================
; drawBullet - Draw the bullet
;
; Input:    None
; Output:   None
;================================================
drawBullet:
        ld      a,(bulletOn)
        or      a
        ret     z
        ld      hl,(bulletX)
        ld      a,l
        ld      l,h
        ld      de,sprBullet
        jp      putSprite

;================================================
; moveBullet - Move the bullet
;
; Input:    None
; Output:   None
;================================================
moveBullet:
        ld      a,(bulletOn)
        or      a
        ret     z
        ld      hl,bulletY
        dec     (hl)
        dec     (hl)
        ld      a,(hl)                          ; Check to make sure bullet hasn't gone off top of screen
        cp      TOP_SCREEN
        ret     p
        xor     a
        ld      (bulletOn),a
        ret

;================================================
; checkBulletHittingBlock - Check to see if the bullet is hitting a block
;
; Input:    None
; Output:   None
;================================================
checkBulletHittingBlock:
        ld      a,(bulletOn)
        or      a
        ret     z
        ld      hl,(bulletX)
        ld      a,l
        ld      l,h
        call    coordsToBlockEntry
        ld      a,(hl)
        or      a
        ret     z
        xor     a
        ld      (bulletOn),a
        dec     (hl)
        ret     nz
        ld      hl,(score)
        inc     hl
        ld      (score),hl
        ld      a,(bulletY)
        and     %11111100
        ld      l,a
        ld      a,(bulletX)
        and     %11111100
        ld      de,sprBlock
        jp      putSprite

;================================================
; loadBulletToCollide1 - Load bullet into (collide1)
;
; Input:    None
; Output:   None
;================================================
loadBulletToCollide1:
        ld      hl,collide1
        ld      a,(bulletX)
        ld      (hl),a
        inc     hl
        ld      (hl),1
        inc     hl
        ld      a,(bulletY)
        ld      (hl),a
        inc     hl
        ld      (hl),4
        ret

.end
