;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Centipede Routines                                                ;
;                                                                   ;
;===================================================================;

;================================================
; clearCentipedeTable - Clear centipedeTable
;
; Input:    None
; Output:   None
;================================================
clearCentipedeTable:
        ld      hl,centipedeTable
        ld      de,centipedeTable+1
        ld      bc,-1+(CENTIPEDE_ENTRY_SIZE*NUM_CENTIPEDES)
        ld      (hl),0
        ldir
        ret

;================================================
; newCentipede - Create a new Centipede piece
;
; Input:    B = XCoord
;           C = YCoord
;           D = Horizontal Direction
;           E = Speed
; Output:   None
;================================================
newCentipede:
        push    bc
        push    de
        ld      hl,centipedeTable
        ld      b,NUM_CENTIPEDES
        ld      de,CENTIPEDE_ENTRY_SIZE
findCentipedeEntry:
        ld      a,(hl)
        or      a
        jr      z,foundCentipedeEntry
        add     hl,de
        djnz    findCentipedeEntry
        pop     de
        pop     bc
        ret
foundCentipedeEntry:
        pop     de
        pop     bc
        ld      (hl),1
        inc     hl
        ld      (hl),b
        inc     hl
        ld      (hl),c
        inc     hl
        ld      (hl),d
        inc     hl
        ld      (hl),1
        inc     hl
        ld      (hl),e
        ret

;================================================
; drawCentipede - Draw all Centipede pieces
;
; Input:    None
; Output:   None
;================================================
drawCentipede:
        ld      ix,centipedeTable
        ld      b,NUM_CENTIPEDES
drawCentipedeLoop:
        ld      a,(ix+C_ON)
        or      a
        jr      z,endDrawCentipedeLoop
        ld      a,(ix+C_X)
        ld      l,(ix+C_Y)
        ld      de,sprCentipede
        push    ix
        push    bc
        call    putSprite
        pop     bc
        pop     ix
endDrawCentipedeLoop:
        ld      de,CENTIPEDE_ENTRY_SIZE
        add     ix,de
        djnz    drawCentipedeLoop
        ret

;================================================
; moveCentipede - Move all Centipede pieces
;
; Input:    None
; Output:   None
;================================================
moveCentipede:
        ld      ix,centipedeTable
        ld      b,NUM_CENTIPEDES
moveCentipedeLoop:
        ld      a,(ix+C_ON)
        or      a
        jr      z,endMoveCentipedeLoop
        ld      a,(frame)
        and     (ix+C_SPEED)
        jr      nz,endMoveCentipedeLoop
        call    checkCentipedeHitBlock
        jr      c,centipedeHitWall
        ld      a,1
        bit     0,(ix+C_H_DIR)
        jr      nz,moveCentipedeX
        neg
moveCentipedeX:
        add     a,(ix+C_X)
        cp      255
        jr      z,centipedeHitWall
        cp      96-3
        jr      z,centipedeHitWall
        ld      (ix+C_X),a
        jr      endMoveCentipedeLoop
centipedeHitWall:
        ld      a,1
        xor     (ix+C_H_DIR)
        ld      (ix+C_H_DIR),a
        ld      a,4
        bit     0,(ix+C_V_DIR)
        jr      nz,moveCentipedeY
        neg
moveCentipedeY:
        ld      h,a
        add     a,(ix+C_Y)
        cp      TOP_SCREEN-4
        jr      z,centipedeHitScreenLimit
        cp      BOTTOM_SCREEN
        jr      z,centipedeHitScreenLimit
        ld      (ix+C_Y),a
        jr      endMoveCentipedeLoop
centipedeHitScreenLimit:
        ld      a,h
        neg
        add     a,(ix+C_Y)
        ld      (ix+C_Y),a
        ld      a,1
        xor     (ix+C_V_DIR)
        ld      (ix+C_V_DIR),a
endMoveCentipedeLoop:
        ld      de,CENTIPEDE_ENTRY_SIZE
        add     ix,de
        djnz    moveCentipedeLoop
        ret

;================================================
; checkCentipedeHitBlock - Check to see if a piece of the Centipede is hitting a block
;
; Input:    IX => Start of entry in centipedeTable
; Output:   CA if Centipede is about to hit a block
;================================================
checkCentipedeHitBlock:
        ld      a,(ix+C_Y)
        srl     a
        srl     a                               ; A = Row to check in blockTable
        ld      l,a
        ld      h,0                             ; HL = Row to check in blockTable
        add     hl,hl                           ; x2
        add     hl,hl                           ; x4
        add     hl,hl                           ; x8
        ld      e,l
        ld      d,h
        add     hl,hl                           ; x16
        add     hl,de                           ; x24, HL = Offset to row in blockTable
        ld      a,-1
        bit     0,(ix+C_H_DIR)
        jr      z,addCentipedeXOffset
        ld      a,4
addCentipedeXOffset:
        add     a,(ix+C_X)                      ; A = XCoord to check for block
        srl     a
        srl     a                               ; A = Column to check in blockTable
        ld      e,a
        ld      d,0
        add     hl,de                           ; HL = Offset to block in blockTable
        ld      de,blockTable
        add     hl,de                           ; HL => Block to check
        ld      a,(hl)                          ; A = Block value
        or      a
        ret     z                               ; If no block, return NC
        scf
        ret                                     ; Otherwise, return CA

;================================================
; loadCentipedeToCollide2 - Load a centipede to (collide2)
;
; Input:    IX => Start of centipede entry
; Output:   IX => Start of centipede entry
;================================================
loadCentipedeToCollide2:
        ld      hl,collide2
        ld      a,(ix+C_X)
        ld      (hl),a
        inc     hl
        ld      (hl),4
        inc     hl
        ld      a,(ix+C_Y)
        ld      (hl),a
        inc     hl
        ld      (hl),4
        ret

.end
