;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
;                                                                   ;
; Copyright (c)2001-2002 TI-Calculator Programming Alliance         ;
; Written and Programmed by James Vernon <james@calc.org>           ;
; ICQ#: 71589304                                                    ;
; http://jamesv.calc.org                                            ;
; http://tcpa.calc.org                                              ;
;                                                                   ;
; You are allowed to use parts of this code as long as you          ;
; give credit where it is due.                                      ;
;                                                                   ;
;===================================================================;

;#define BREAK() ld a,$F7 \ call directIn \ bit 0,a \ jr nz,$+8 \ call waitKey \ call waitKey

;#define INVINCIBLE

#include "centipde.h"                           ; Header info

#include "vars.asm"                             ; Variables

;================================================
; Start of Program
;================================================
start:
#ifdef TI83
        res     statsvalid,(iy+statflags)
#endif
#ifdef TI86
        call    _flushallmenus
        call    _runindicoff
        call    _clrscrnfull
        call    _ram_page_1
#endif
        set     textwrite,(iy+sgrflags)         ; Write text to gbuf
startTitleScreen:
        xor     a
        ld      (frame),a
titleLoop:
;        BREAK()

        ld      hl,frame
        inc     (hl)
        bcall(_grbufclr)
        ld      hl,titleYCoords
        ld      b,NUM_TITLE_SPRITES
moveTitleSprites:
        ld      a,(hl)
        and     $7F                             ; Mask out sign bit
        bit     7,(hl)                          ; Moving up or down?
        jr      z,moveTitleSprDown
        dec     a
        jr      z,setTitleMovingDown
setTitleMovingUp:
        or      $80
        ld      (hl),a
        jr      endMoveTitleSprites
moveTitleSprDown:
        inc     a
        cp      TITLE_MAX
        jr      z,setTitleMovingUp
setTitleMovingDown:
        ld      (hl),a
endMoveTitleSprites:
        inc     hl
        djnz    moveTitleSprites
        ld      hl,titleSprites
        ld      de,titleYCoords
        ld      bc,NUM_TITLE_SPRITES*256+8
drawTitleSprites:
        push    hl
        push    de
        push    bc
        ld      a,(de)                          ; A = YCoord
        and     $7F                             ; Mask out sign bit
        ld      b,a                             ; B = YCoord
        ld      a,c                             ; A = XCoord
        ld      e,(hl)
        inc     hl
        ld      d,(hl)                          ; DE => Sprite
        ld      l,b                             ; L = YCoord
        call    putSprite
        pop     bc
        pop     de
        pop     hl
        inc     hl
        inc     hl
        inc     de
        ld      a,c
        add     a,8
        ld      c,a
        djnz    drawTitleSprites
; Check whether to show main title screen or high score table screen
        ld      hl,frame
        bit     6,(hl)
        jp      nz,showHighScoreTableScreen
; Main Title Screen
        ld      hl,strTitleText
        ld      de,21*256+21
        call    putVText                        ; "By James Vernon"
        ld      de,28*256+11
        call    putVText                        ; "Original for Atari 2600"
        ld      de,57*256+81
        call    putVText                        ; Version number
        ld      a,(frame)
        bit     3,a
        jr      nz,afterShowPress2nd
        ld      de,43*256+17
        call    putVText                        ; "PRESS 2nd TO START"
afterShowPress2nd:
        call    showVideo
        halt
        halt
        halt
        halt
#ifdef TI86
        halt                                    ; TI-86 goes a bit faster than others :P
#endif
        ld      a,KG_TOP
        call    directIn                        ; Check keypresses on top row
        ld      b,a
#ifndef TI86
        bit     DI_MODE,a
#else
        bit     DI_EXIT,a
#endif
        jp      z,quit
        bit     DI_2ND,b
        jp      nz,titleLoop

; New game
        xor     a
        ld      (frame),a
        ld      (level),a
        sbc     hl,hl
        ld      (score),hl
        ld      hl,blocksToDraw
        ld      (blocksToDrawPtr),hl

        ld      a,PLAYER_LIVES
        ld      (lives),a                       ; Set lives
        ld      hl,blockTableStart
        ld      de,blockTable
        ld      bc,BLOCK_TABLE_HEIGHT*BLOCK_TABLE_WIDTH
        ldir
        call    clearAnimTable
newLife:
        xor     a
        ld      (bugOn),a
        ld      (bombOn),a
        ld      (birdOn),a
        ld      (numCentipedes),a
        ld      hl,45*256+PLAYER_BOTTOM
        ld      (y),hl                          ; Set Y & X coords for player
; Draw background
        bcall(_grbufclr)
; Draw line at bottom of playing screen
#ifndef TI86
        ld      hl,gbuf+(BOTTOM_SCREEN*12)
#else
        ld      hl,gbuf+(BOTTOM_SCREEN*16)
#endif
        ld      b,12
drawLineAtBottom:
        ld      (hl),$FF
        inc     hl
        djnz    drawLineAtBottom
        ld      hl,strLives
        ld      de,57*256+2
        call    putVText                        ; "Lives:"
        ld      de,57*256+52
        call    putVText                        ; "Score: "
        call    drawBlocks
        call    saveVideo                       ; Save background
newLevel:
        call    clearCentipedeTable
        ld      a,(level)
        and     $0F
        add     a,a
        ld      e,a
        ld      d,0
        ld      hl,iniCentipedes
        add     hl,de
        ld      b,(hl)
        ld      a,b
        add     a,a
        add     a,a
        ld      c,a
        inc     hl
        ld      a,(hl)
        ld      (_centipedeSpeedCnt),a
createCentipede:
        push    bc
        ld      a,$00
_centipedeSpeedCnt                      = $-1
        ld      e,0
        or      a
        jr      z,$+7
        inc     e
        dec     a
        ld      (_centipedeSpeedCnt),a
        ld      b,c
        ld      c,TOP_SCREEN
        ld      d,1
        call    newCentipede
        ld      hl,numCentipedes
        inc     (hl)
        pop     bc
        dec     c
        dec     c
        dec     c
        dec     c
        djnz    createCentipede

#include "maingame.asm"                         ; Main Game Loop

showHighScoreTableScreen:
; High Score Table Screen
        ld      hl,strHighScoreTable
#ifndef TI86
        ld      de,23*256+19
#else
        ld      de,23*256+20
#endif
        call    putVText                        ; "HIGH SCORE TABLE"
;================================================
; Thanks to Jimmy Mardell/Ahmed ElHelw for this
; routine from ZTetris, slightly modified
        ld      hl,highScoreTable
        ld      b,3
        ld      a,33
showHighScoreTableLoop:
        ld      e,2
        ld      d,a
        add     a,7
        push    af
        push    bc
        call    putVText
        ld      a,75
        ld      (pencol),a
        push    hl
        bcall(_ldhlind)
        call    showHL
        pop     hl
        inc     hl
        inc     hl
        pop     bc
        pop     af
        djnz    showHighScoreTableLoop
; End ZTetris routine
;================================================
        call    showVideo
        halt
        halt
        halt
#ifdef TI86
        halt
#endif
        ld      a,KG_TOP
        call    directIn                         ; Check keypresses on top row
        bit     DI_2ND,a
        jp      nz,titleLoop
        jp      startTitleScreen

quit:
#ifdef TI83
        set     statsvalid,(iy+statflags)
#endif
#ifdef TI86
        call    _clrscrnfull
        call    _homeup
        set     graphdraw,(iy+graphflags)
        ld      hl,this-1
        rst     20h
        rst     10h
        call    _ex_ahl_bde
        ld      de,highScoreTable-_asm_exec_ram+4
        add     hl,de
        adc     a,0
        call    _set_abs_dest_addr
        xor     a
        ld      hl,highScoreTable
        call    _set_abs_src_addr
        ld      hl,HIGH_SCORE_TABLE_SIZE
        call    _set_mm_num_bytes
        call    _mm_ldir
#endif
        res     textwrite,(iy+sgrflags)
        ret

gameOver:
        bcall(_clrscrnfull)
        bcall(_homeup)
;================================================
; Thanks to Jimmy Mardell/Ahmed ElHelw for this
; routine from ZTetris, slightly modified
        ld      hl,highScoreTable+14
        ld      de,(score)
        ld      b,3
checkHighScore:
        push    hl
        bcall(_ldhlind)
        bcall(_cphlde)
        pop     hl
        jr      c,newHighScore
        push    de
        ld      de,16
        add     hl,de
        pop     de
        djnz    checkHighScore
#ifndef TI86
        ld      hl,3*256+3
#else
        ld      hl,6*256+3
#endif
        ld      (currow),hl
        ld      hl,strGameOver
        bcall(_puts)
        call    waitKey
        cp      GK_ENTER
        jr      nz,$-5
        jp      startTitleScreen
newHighScore:
        ld      a,4
        sub     b
        ld      (_highSlot),a
        cp      3
        jr      z,enterHighScore
        ld      hl,highScoreTable+19
moveHighScores:
        ld      d,h
        ld      e,l
        ld      bc,16
        add     hl,bc
        ex      de,hl
        ld      bc,13
        ldir
        ld      hl,highScoreTable+3
        dec     a
        jr      z,moveHighScores
enterHighScore:
        ld      a,$00
_highSlot                               = $-1
        ld      hl,highScoreTable+3
        ld      de,16
        dec     a
        jr      z,enterName
        add     hl,de
        dec     a
        jr      z,enterName
        add     hl,de
enterName:
        push    hl
        ld      b,10
clearOldName:
        ld      (hl),' '
        inc     hl
        djnz    clearOldName
        inc     hl
        ld      de,(score)
        ld      (hl),e
        inc     hl
        ld      (hl),d
; End ZTetris routine
;================================================
        ld      hl,strNewHighScore
        bcall(_puts)                            ; "New High Score!"
        ld      de,0*256+1
        ld      (currow),de
        bcall(_puts)                            ; "Enter your name:"
        ld      hl,2*256+3
        ld      (currow),hl
        pop     hl
        ld      b,10
newHighName:
        push    bc
        push    hl
getChar:
        call    waitKey
        cp      GK_DEL
        jr      z,backspace
        cp      GK_ENTER
        jr      z,nameFinished
        dec     a
        ld      e,a
        ld      d,0
        ld      hl,charTable
        add     hl,de
        ld      a,(hl)
        cp      '.'
        jr      z,getChar
        pop     hl
        ld      (hl),a
        bcall(_putc)
        inc     hl
        pop     bc
        djnz    newHighName
endNewHighScore:
        ld      a,64
        ld      (frame),a
        jp      titleLoop
nameFinished:
        pop     hl
        pop     bc
        jr      endNewHighScore
backspace:
        pop     hl
        pop     bc
        ld      a,b
        cp      10
        jr      z,newHighName
        inc     b
        dec     hl
        ld      a,(curcol)
        dec     a
        ld      (curcol),a
        ld      a,' '
        bcall(_putmap)
        jr      newHighName

;================================================
; Include Files (Code)
;================================================
#include "anim.asm"                             ; Animation Routines
#include "bird.asm"                             ; Bird Routines
#include "block.asm"                            ; Block Routines
#include "bomb.asm"                             ; Bomb Routines
#include "bug.asm"                              ; Bug Routines
#include "bullet.asm"                           ; Bullet Routines
#include "centi.asm"                            ; Centipede Routines
#include "collide.asm"                          ; Collision Detection Routines
#include "misc.asm"                             ; Miscellaneous Routines
#ifdef TI86
#include "misc86.asm"                           ; Routines not on the TI-86
#endif
#include "player.asm"                           ; Player Routines
#include "sprite.asm"                           ; Sprite Routines

;================================================
; Include Files (Data)
;================================================
#include "animspr.asm"                          ; Animation Sprites
#include "gamedat.asm"                          ; Game Data
#include "gamespr.asm"                          ; Game Sprites
#include "gametxt.asm"                          ; Game Text
#include "highdat.asm"                          ; High Score Table Data
#include "hightxt.asm"                          ; High Score Table Text
#include "titledat.asm"                         ; Title Screen Data
#include "titlespr.asm"                         ; Title Sprites
#include "titletxt.asm"                         ; Title Text

.end
