;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Header File                                                       ;
;                                                                   ;
;===================================================================;

;================================================
; TI-83 Ion Header
;================================================
#ifdef TI83
#define ION
#include "ion.inc"

random                                  = ionRandom

videoBuffer                             = saferam1
vars                                    = saferam2

.org    progstart
        ret
        jr      nc,start
.db     "Centipede v1.0 - TCPA",0
#endif

;================================================
; TI-83+ Ion Header
;================================================
#ifdef TI83P
#define ION
#define PLUS
#include "ion.inc"

random                                  = ionRandom

videoBuffer                             = saferam1
vars                                    = appbackupscreen

.org    progstart-2
.db     $BB,$6D
        ret
        jr      nc,start
.db     "Centipede v1.0 - TCPA",0
#endif

;================================================
; TI-83+ MirageOS Header
;================================================
#ifdef MIRAGE
#define PLUS
#include "ti83plus.inc"
#include "mirage.inc"

random                                  = iRandom

videoBuffer                             = saferam1
vars                                    = appbackupscreen

.org    $9D93
.db     $BB,$6D
        ret
.db     1

.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00110011, %00110000
.db %01111111, %11111000
.db %01111111, %11111000
.db %00110011, %00110000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000000, %00000000
.db %00000001, %00000000
.db %00000011, %10000000
.db %00000111, %11000000
.db %00000100, %01000000

.db     "Centipede v1.0 - TCPA",0
#endif

;================================================
; TI-86 Header
;================================================
#ifdef TI86
#define equ .equ
#include "ti86.inc"

gbuf                                    = _plotsscreen
pencol                                  = _pencol
videoMem                                = $FC00
_getcsc                                 = _get_key
curcol                                  = _curcol
currow                                  = _currow
_clrscrnfull                            = _clrscrn
sgrflags                                = new_grf_flgs

randData                                = $8FFE
videoBuffer                             = $9000
vars                                    = $9400

#define bcall(xxxx) call xxxx
#define DIRECTIN_8586
#define GETKEY_8586
#define SPRITE_86

.org    _asm_exec_ram
        nop
        jp      start
.dw     0
.dw     title

title:
.db     "Centipede v1.0 - TCPA",0

this:
.db     8,"centipde"
#endif

;================================================
; Other Generic Defines, Includes, etc.
;================================================
#define PUT_SPRITE
#define PS_XOR
#include "get_key.inc"
#include "directin.inc"

TOP_SCREEN                              = 0
BOTTOM_SCREEN                           = 56
PLAYER_TOP                              = BOTTOM_SCREEN-16
PLAYER_BOTTOM                           = BOTTOM_SCREEN-4
PLAYER_LIVES                            = 2
CENTIPEDE_ENTRY_SIZE                    = 6
NUM_CENTIPEDES                          = 20
BLOCK_TABLE_WIDTH                       = 96/4
BLOCK_TABLE_HEIGHT                      = BOTTOM_SCREEN/4
BUG_TOP_MIN                             = BOTTOM_SCREEN-24
BUG_TOP_MAX                             = BOTTOM_SCREEN-12
BUG_BOTTOM                              = BOTTOM_SCREEN-4

C_ON                                    = 0
C_X                                     = 1
C_Y                                     = 2
C_H_DIR                                 = 3
C_V_DIR                                 = 4
C_SPEED                                 = 5

.end
