;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Collision Detection Routines                                      ;
;                                                                   ;
;===================================================================;

;================================================
; checkCollision - Check for collisions between two objects
;
; Author:   Patrick Davidson (http://pad.calc.org)
;           Modified slightly by James Vernon
; Input:    (collide1) = Object 1 [x, width, y, height]
;           (collide2) = Object 2 [x, width, y, height]
; Output:   CA = 1 if they are colliding
;================================================
checkCollision:
        ld      hl,collide1
        ld      de,(collide2)
        ld      a,(hl)
        sub     e
        jr      c,checkCollision1
        cp      d
        ret     nc
        inc     hl
        jr      checkCollision2
checkCollision1:
        neg
        inc     hl
        cp      (hl)
        ret     nc
checkCollision2:
        ld      de,(collide2+2)
        inc     hl
        ld      a,(hl)
        sub     e
        jr      c,checkCollision3
        cp      d
        ret
checkCollision3:
        neg
        inc     hl
        cp      (hl)
        ret

;================================================
; checkBulletCentipedeCollisions - Check collisions between bullets and centipedes
;
; Input:    None
; Output:   None
;================================================
checkBulletCentipedeCollisions:
        ld      ix,centipedeTable
        ld      b,NUM_CENTIPEDES
checkBCCollisions:
        push    bc
        ld      a,(ix+C_ON)
        or      a
        jr      z,endCheckBCCollisions
        call    loadCentipedeToCollide2
        call    checkCollision
        jr      nc,endCheckBCCollisions
        xor     a
        ld      (ix+C_ON),a
        ld      (bulletOn),a
        ld      b,(ix+C_X)
        ld      c,(ix+C_Y)
        call    addBlock
        ld      hl,numCentipedes
        dec     (hl)
        ld      hl,(score)
        ld      de,100
        add     hl,de
        ld      (score),hl
endCheckBCCollisions:
        pop     bc
        ld      de,CENTIPEDE_ENTRY_SIZE
        add     ix,de
        djnz    checkBCCollisions
        ret

;================================================
; checkPlayerCentipedeCollisions - Check collisions between player and centipedes
;
; Input:    None
; Output:   None
;================================================
checkPlayerCentipedeCollisions:
        ld      ix,centipedeTable
        ld      b,NUM_CENTIPEDES
checkPCCollisions:
        ld      a,(ix+C_ON)
        or      a
        jr      z,endCheckPCCollisions
        call    loadCentipedeToCollide2
        call    checkCollision
        jr      c,playerHitCentipede
endCheckPCCollisions:
        ld      de,CENTIPEDE_ENTRY_SIZE
        add     ix,de
        djnz    checkPCCollisions
        ret
playerHitCentipede:
        pop     hl
        jp      playerDied

.end
