;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Main Game Loop                                                    ;
;                                                                   ;
;===================================================================;

mainGameLoop:
;        BREAK()

        ld      hl,frame
        inc     (hl)
        call    restoreVideo

        ld      a,KG_TOP
        call    directIn
        push    af
        bit     DI_2ND,a
        call    z,shoot
        pop     af
#ifndef TI86
        bit     DI_MODE,a
#else
        bit     DI_EXIT,a
#endif
        jp      z,gameOver

        ld      a,KG_ARROW
        call    directIn
        push    af
        bit     DI_LEFT,a
        call    z,playerLeft
        pop     af
        push    af
        bit     DI_RIGHT,a
        call    z,playerRight
        pop     af
        push    af
        bit     DI_UP,a
        call    z,playerUp
        pop     af
        bit     DI_DOWN,a
        call    z,playerDown

; Move Centipede
        call    moveCentipede
; Move other enemies
        call    moveBug
        call    moveBomb
        call    moveBird
; Move bullet
        call    moveBullet
; Update explosion animations
        call    updateAnims

; All collision detection follows:
        ld      a,(bulletOn)
        or      a
        jr      z,afterCheckBulletCollisions
        call    loadBulletToCollide1
; Check bullet/centipede collisions
        call    checkBulletCentipedeCollisions
; Check bullet/bug collisions
        ld      a,(bugOn)
        or      a
        jr      z,afterCheckBulletBugCollision
        call    loadBugToCollide2
        call    checkCollision
        jr      nc,afterCheckBulletBugCollision
        ld      hl,(score)
        ld      de,50
        add     hl,de
        ld      (score),hl
        xor     a
        ld      (bugOn),a
        ld      hl,(bugX)
        call    newAnimation
        xor     a
        ld      (bulletOn),a
afterCheckBulletBugCollision:
        ld      a,(bombOn)
        or      a
        jr      z,afterCheckBulletBombCollision
        call    loadBombToCollide2
        call    checkCollision
        jr      nc,afterCheckBulletBombCollision
        ld      hl,(score)
        ld      de,150
        add     hl,de
        ld      (score),hl
        xor     a
        ld      (bombOn),a
        ld      hl,(bombX)
        call    newAnimation
        xor     a
        ld      (bulletOn),a
afterCheckBulletBombCollision:
        ld      a,(birdOn)
        or      a
        jr      z,afterCheckBulletCollisions
        call    loadBirdToCollide2
        call    checkCollision
        jr      nc,afterCheckBulletCollisions
        ld      hl,(score)
        ld      de,200
        add     hl,de
        ld      (score),hl
        xor     a
        ld      (birdOn),a
        ld      hl,(birdX)
        call    newAnimation
        xor     a
        ld      (bulletOn),a
afterCheckBulletCollisions:
#ifndef INVINCIBLE
        call    loadPlayerToCollide1
; Check player/centipede collisions
        call    checkPlayerCentipedeCollisions
; Check player/bug collisions
        ld      a,(bugOn)
        or      a
        jr      z,afterCheckPlayerBugCollision
        call    loadBugToCollide2
        call    checkCollision
        jp      c,playerDied
afterCheckPlayerBugCollision:
        ld      a,(bombOn)
        or      a
        jr      z,afterCheckPlayerBombCollision
        call    loadBombToCollide2
        call    checkCollision
        jp      c,playerDied
afterCheckPlayerBombCollision:
        ld      a,(birdOn)
        or      a
        jr      z,afterCheckPlayerBirdCollisions
        call    loadBirdToCollide2
        call    checkCollision
        jp      c,playerDied
afterCheckPlayerBirdCollisions:
#endif

; Draw player
        ld      hl,(y)
        ld      a,h
        ld      de,sprPlayer
        call    putSprite
; Draw enemies
        call    drawCentipede
        call    drawBug
        call    drawBomb
        call    drawBird
; Draw bullet
        call    drawBullet
; Draw explosion animations
        call    drawAnims
; Show lives
        ld      a,(lives)
        or      a
        jr      z,afterShowLives
        ld      b,a
        ld      a,22
showLives:
        ld      c,a
        push    bc
        ld      de,sprPlayer
        ld      l,58
        call    putSprite
        pop     bc
        ld      a,c
        add     a,6
        djnz    showLives
afterShowLives:
; Show score
        ld      hl,(score)
        ld      de,57*256+75
        call    setShowHL

; Copy gbuf to LCD
        call    showVideo

; Try to make a bug
        call    tryMakeBug
; Try to make a bomb
        call    tryMakeBomb
; Try to make a bird
        call    tryMakeBird

; Draw blocks in blocksToDraw and check to see if bullet is hitting a block
        call    restoreVideo
        call    drawBlocksToDraw
        call    checkBulletHittingBlock
        call    saveVideo

        ld      a,(numCentipedes)
        or      a
        jp      nz,mainGameLoop
        ld      hl,level
        inc     (hl)
        ld      hl,(score)
        ld      de,500
        add     hl,de
        ld      (score),hl
        jp      newLevel

.end
