;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Miscellaneous Routines                                            ;
;                                                                   ;
;===================================================================;

;================================================
; saveVideo - Copy gbuf to videoBuffer
;
; Input:    None
; Output:   None
;================================================
saveVideo:
        ld      hl,gbuf
        ld      de,videoBuffer
#ifndef TI86
        ld      bc,768
#else
        ld      bc,1024
#endif
        ldir
        ret

;================================================
; restoreVideo - Copy videoBuffer to gbuf
;
; Input:    None
; Output:   None
;================================================
restoreVideo:
        ld      hl,videoBuffer
        ld      de,gbuf
#ifndef TI86
        ld      bc,768
#else
        ld      bc,1024
#endif
        ldir
        ret

;================================================
; showVideo - Copy gbuf to LCD (or videoMem on TI-86)
;
; Input:    None
; Output:   None
;================================================
showVideo:
#ifndef TI86
#ifdef ION
        call    ionFastCopy
#else
        call    iFastCopy
#endif
        ei
#else
        ld      hl,gbuf+1021
        ld      de,gbuf+1023
        ld      bc,1022
        lddr
        inc     hl
        ld      (hl),0
        inc     hl
        ld      (hl),0
        dec     hl
        ld      de,videoMem
        ld      bc,1023
        ldir
#endif
        ret

;================================================
; putVText - Similar to _vputs, but accepts coords for text
;
; Input:    HL => String to show
;           DE = Coordinates to write to pencol
; Output:   HL => Next string
;================================================
putVText:
        ld      (pencol),de
        bcall(_vputs)
        ret

#ifndef MIRAGE                                  ; MirageOS has it's own version of this function
;================================================
; directIn - Get keypresses from the key port
;
; Input:    A = Port to read keypresses from
; Output:   A = Keypresses from that port
;================================================
directIn:
        ld      b,a                             ; Save mask
        ld      a,$FF                           ; Value used to reset keyport
        out     (1),a                           ; Reset keyport (sort of)
        ld      a,b                             ; Get mask again
        out     (1),a                           ; Open the group we wanna check
        in      a,(1)                           ; Get any keypresses
        ret
#endif

;================================================
; setShowHL - Show HL in small font at specified position
;
; Input:    HL = Value to show
;           DE = penrow, pencol
; Output:   None
;================================================
setShowHL:
        ld      (pencol),de

;================================================
; showHL - Show HL in small font at cursor position
;
; Input:    HL = Value to show
; Output:   None
;================================================
showHL:
        ld      de,stringBuffer+5
        ld      b,5
        xor     a
        ld      (de),a
showHLLoop:
        dec     de
        bcall(_divHLby10)
        add     a,'0'
        ld      (de),a
        djnz    showHLLoop
        ex      de,hl
        bcall(_vputs)
        ret

;================================================
; waitKey - Wait for a key press
;
; Input:    None
; Output:   A = Key pressed (_getcsc style)
;================================================
waitKey:
        ei
wKeyLoop:
        halt
        bcall(GET_KEY)
        or      a
        jr      z,wKeyLoop
        ret

.end
