;===================================================================;
;                                                                   ;
; Centipede                                                         ;
; Version 1.0                                                       ;
; Player Routines                                                   ;
;                                                                   ;
;===================================================================;

;================================================
; playerUp - Try to move player up
;
; Input:    None
; Output:   None
;================================================
playerUp:
        ld      a,(y)
        cp      PLAYER_TOP
        ret     z
        dec     a
        ld      (y),a
        ret

;================================================
; playerDown - Try to move player down
;
; Input:    None
; Output:   None
;================================================
playerDown:
        ld      a,(y)
        cp      PLAYER_BOTTOM
        ret     z
        inc     a
        ld      (y),a
        ret

;================================================
; playerLeft - Try to move player left
;
; Input:    None
; Output:   None
;================================================
playerLeft:
        ld      a,(x)
        or      a
        ret     z
        dec     a
        ld      (x),a
        ret

;================================================
; playerRight - Try to move player Right
;
; Input:    None
; Output:   None
;================================================
playerRight:
        ld      a,(x)
        cp      96-5
        ret     z
        inc     a
        ld      (x),a
        ret

;================================================
; playerDied - Restart level
;
; Input:    None
; Output:   None
;================================================
playerDied:
        ld      hl,(y)
        ld      a,h
        ld      h,l
        ld      l,a
        call    newAnimation
        ld      hl,lives
        dec     (hl)
        bit     7,(hl)
        jp      nz,gameOver
        jp      newLife

;================================================
; loadPlayerToCollide1 - Load player into (collide1)
;
; Input:    None
; Output:   None
;================================================
loadPlayerToCollide1:
        ld      hl,collide1
        ld      a,(x)
        ld      (hl),a
        inc     hl
        ld      (hl),5
        inc     hl
        ld      a,(y)
        ld      (hl),a
        inc     hl
        ld      (hl),4
        ret

.end
