;A Simple Application Example - BOUNCE
;This example just prints the word "BOUNCE" on the display and exits

;Include file needed to access system routines
 include "ti83plus.inc"
paddle_pos	EQU  9872h
score       EQU  9876h
;#######################
;## Direct Input Keys ##
;#######################

;Group 1
KeyRow_Pad	.equ 0feh
KDown   .equ 254
KLeft   .equ 253
KRight  .equ 251
KUp     .equ 247
KIDown  .equ 1
KILeft  .equ 2
KIRight .equ 4
KIUp    .equ 8
;Group 2
KeyRow_5 	.equ 0fdh
KEnter		.equ 254
KIEnter		.equ 1
KPlus		.equ 253
KMinus		.equ 251
KMul		.equ 247
KDiv		.equ 239
KPower		.equ 223
KClear		.equ 191






EXT_APP equ 1   ;This definition is required of all apps
cseg            ;This linker directive is required of all apps.

;This is the application header definition area required for all apps.
 db 080h,0Fh    ;Field: Program length
 db   00h,00h,00h,00h ;Length=0 (N/A for unsigned apps)
 db 080h,012h    ;Field: Program type
 db   01h,04h  ;Type= Shareware, TI-83Plus
 db 080h,021h    ;Field: App ID
 db   01h       ;Id = 1
 db 080h,031h    ;Field: App Build
 db   01h       ;Build = 1
 db 080h,048h    ;Field: App Name
 db 042h,04fh,055h,04eh,043h,045h,020h,020h ;Name = "BOUNCE  " must be 8 characters
 db 080h,081h    ;Field: App Pages
 db 01h         ;App Pages = 1
 db 080h,090h    ;No default splash screen
 db 03h,026h ,09h,04h, 04h,06fh,01bh,80h     ;Field: Date stamp- 5/12/1999
 db 02h,0dh,040h                             ;Dummy encrypted TI date stamp signature
 db 0a1h ,06bh ,099h ,0f6h ,059h ,0bch ,067h 
 db 0f5h ,085h ,09ch ,09h ,06ch ,0fh ,0b4h ,03h ,09bh ,0c9h 
 db 03h ,032h ,02ch ,0e0h ,03h ,020h ,0e3h ,02ch ,0f4h ,02dh 
 db 073h ,0b4h ,027h ,0c4h ,0a0h ,072h ,054h ,0b9h ,0eah ,07ch 
 db 03bh ,0aah ,016h ,0f6h ,077h ,083h ,07ah ,0eeh ,01ah ,0d4h 
 db 042h ,04ch ,06bh ,08bh ,013h ,01fh ,0bbh ,093h ,08bh ,0fch 
 db 019h ,01ch ,03ch ,0ech ,04dh ,0e5h ,075h 
 db 80h,7Fh      ;Field: Program Image length
 db   0,0,0,0    ;Length=0, N/A
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 
;End of header data

StartApp:                 ;The app starts here

  B_CALL ClrLCDFull        ;Clear the screen
  ld a,0
  ld (score),a
  ld a,4
  ld (paddle_pos),a
  push bc 
  call draw_paddle       ; draw paddle 
  pop bc

  ld a,7
  ld b,a                 ;
  ld (curCol),a        ;Will start  in the 8th column
  ld a, 3
  ld c,a
  ld (curRow),a        ;Will start  on the 4th row
  ld a,01h
  ld d,a
  ld e,a
  B_CALL RunIndicOff
  

  
 display_ball:
  di

  push hl
  push bc
  push de
  ld e,KeyRow_5
  call ReadAKey
  pop de
  pop bc
  pop hl
  jr nz,exit_app

  res onInterrupt,(IY+onFlags) ; reset On key flag
    ld a,04Fh
  B_CALL PutMap          ; display ball
  
  call display_score

  ld h,b
  ld l,c

  ld a,b    ; increment new col
  add a,d 
  ld  b,a 
  cp 0Fh 
  jr Z, minuscol
  cp 0h
  jr Z, minuscol
  jr incrow
 minuscol:
  ld a,d
  neg a
  ld d,a

 incrow:
  ld a,c    ; increment new row
  add a,e 
  ld c,a
  cp 07h 
  jr z, minusrow
  cp 0h
  jr z, minusrow
  jr eraseball
 minusrow:
  ld a,e
  neg a
  ld e,a

 eraseball:
  
  push bc
  ld c,01h
delay:
  ld b,0FFh
delay1:
  ld a,0FFh
  dec a
  jr nz,$-1
  dec b
  jr nz,delay1
  dec c
  jr nz,delay 
  pop bc
 
  push hl
  push bc
  push de
  ld e,KeyRow_Pad
  call ReadAKey

;  call readKey
  pop de
  pop bc
  pop hl
  jr Z,read_again
move_paddle:
  cp a,02h 
  jr nz, right_test
  push bc
  call paddle
  pop bc
  jr erase_ball
right_test:
  cp a,04h
  jr nz, erase_ball
  push bc
  call paddle
  pop bc
erase_ball:
  ld a,h
  ld (curCol),a
  ld a,l
  ld (curRow),a
  cp a,07h
  jr nz,use_blank
  ld a,(paddle_pos)
  dec a
  cp a,h
  jp P,dec_score
  add a,04h
  cp a,h
  jp M,dec_score
  ld a,(score)
  inc a
  cp a,064h
  jp m, high_score3
   
  B_CALL ClrLCDFull
  ld a,1
  ld (curCol),a
  ld a,3
  ld (curRow),a
  ld hl,Swin1
  ld de,OP1
  B_CALL StrCopy
  ld hl,OP1
  B_CALL PutS
  ld a,1
  ld (curCol),a
  ld a,4
  ld (curRow),a
  ld hl,Swin2
  ld de,OP1
  B_CALL StrCopy
  ld hl,OP1
  B_CALL PutS
  RES  indicOnly,(IY+indicFlags) ; make sure keys are scanned
  res kbdSCR,(IY+kbdFlags) ; needed for system key scan to work
  di
wait1:
  B_CALL GetKey
  cp a,01h      ; disable arrow keys
  jr z,wait1
  cp a,02h
  jr z,wait1
  cp a,03h
  jr z,wait1
  cp a,04h
  jr z,wait1
  jr exit_app

high_score3:
  ld (score),a
  
  ld a,0E4h
  jr use_paddle_char

dec_score:
   ld a,(score)
  sub a,4h
  cp a,0
  jp m,dec_score2
  jr dec_score3
dec_score2:
  ld a,0
dec_score3:
  ld (score),a
  
use_blank:
  ld a,020h
use_paddle_char:
  b_call PutMap          ; erase ball
    ld a,b
  ld (curCol),a
  ld a,c
  ld (curRow),a
  jr display_ball






read_again:
  push hl
  push bc
  push de
  ld e,KeyRow_Pad
  call ReadAKey
  pop de
  pop bc
  pop hl
  jr Z,erase_ball
  jr move_paddle




exit_app:
  set apdAble,(IY+apdFlags)
  ei
  B_JUMP JForceCmdNoChar   ; Exit the application

readKey:
  RES  indicOnly,(IY+indicFlags) ; make sure keys are scanned
  EI                             ; turn on interrupts
  call GetCSC                    ; local routinue to get scan code
  BIT onInterrupt,(IY+onFlags)   ;on key pressed
  JR z, notOnkey
  ld a,0h                        ;scan code for on key
  RET
  
notOnkey:
  or a
  RET
                         
GetCSC:
  ld hl,kbdScanCode
  DI                       ; interrupts off
  ld a,(hl)                ; get possible scan code
  ld (HL),0                ; clear for next scan
  res kbdSCR,(IY+kbdFlags) ; needed for system key scan to work
  
  
  ei                       ; interrupts on
  ret

ReadAKey:
	ld a,255
	out (1),a
	ld a,e
	out (1),a
	in a,(1)
	cpl
	ld b,a
	or a
	ret

;Read arrows
	ld e,KeyRow_Pad
	call ReadAKey
	and KILeft
	ld (hl),a ;jLeft
	inc hl
	ld a,b
	and KIRight
	ld (hl),a ;jRight
	inc hl
	ld a,b
	and KIUp
	ld (hl),a ;jJump



display_score:
   
	push hl
	push de
   ld a,0bh
   ld (curCol),a
   ld a,0h
   ld (curRow),a
	
   ld hl,(score)
	ld h,0h
   b_call DispHL
	pop de
	pop hl
	ret


 










paddle:
  
  ld c,a  ; save key scan code

  ld b,10h  ;row width
  ld a,7h
  ld (curRow),a
nextcol:	
  ld a,b
  dec a
  ld (curCol),a
  ld a,020h
  b_call PutMap          ; erase paddle
  dec b
  jr nz,nextcol
  ld a,c    ; move paddle
  cp a,02h
  jr z, left
  cp a,04h
  jr z, right
  jr draw_paddle
left:
  ld a,(paddle_pos)
  cp a,0
  jr z,draw_paddle
  sub a,01h
  ld (paddle_pos),a
  jr draw_paddle
right:
  ld a,(paddle_pos)      ; paddle width equals 4
  add a,4
  cp a,010h
  jr z,draw_paddle
  inc a
  sub a,4
  ld (paddle_pos),a
  jr draw_paddle

draw_paddle:
  ld a,07h
  ld (curRow),a
  ld a,4
  ld b,a
  ld a,(paddle_pos)
  ld c,a
nextcol1:
  ld a,c
  ld (curCol),a
  ld a,0E4h
  b_call PutMap          ; draw paddle
  inc c
  dec b
  jr nz,nextcol1
  ret






SScore .asciz "Score"
Swin1 .asciz "MAX SCORE 100"
Swin2 .asciz "  YOU WIN    "
  
