#include "ti83plus.inc"
#include "mirage.inc"
#define	bcall(label)	RST 28h \ .dw label
#define ionPutSprite iSprite
#define ionFastCopy iFastCopy
#define m1 SavesScreen

#define ChopperY m1
#define Height m1+1	;12bytes!
#define RoofPos m1+13
#define ListPos m1+14	;2bytes!
#define RandPos m1+16	;2bytes!
#define Delay m1+18
#define DelayTime m1+19
#define DodgeBlock m1+20
#define DistToBlock m1+21
#define DelayBlock m1+22
#define Score m1+23	;2bytes!
#define MainScreenDelay m1+25	;2bytes!
#define GotNewHi m1+27
#define AniFrame m1+28	;2bytes!
#define LeftProg m1+29
	.org	$9D93
	.db	$BB,$6D			;AsmPrgm

	ret
.db 1
.db %00000000, %00000000
.db %01111111, %11111100
.db %01011111, %11110100
.db %01111111, %11111100
.db %01111111, %11111100
.db %01111000, %00111100
.db %01111110, %11111100
.db %01001100, %00011100
.db %01000000, %00001100
.db %01111100, %00001100
.db %01111111, %11111100
.db %01111111, %11111100
.db %01011111, %11110100
.db %01111111, %11111100
.db %00000000, %00000000

.db "Chopper v1.0",0

InitProg:

	ld hl,65535-5000
	ld (MainScreenDelay),hl

	call LoadSplash	
SplashScreenLoop:	

	ld a,5
	ld hl,Txt_1

	call PutCaption
	cp 3
	jp z,ExitGameFully

	ld a,27
	ld hl,Txt_2
	
	call PutTextOnSplash

	ld hl,(HighScore)
	bcall(_setxxxxop2)
	bcall(_op2toop1)	

	ld a,65
	ld (pencol),a
	ld a,64-8
	ld (penrow),a
	ld a,5

	set textwrite,(iy+sgrflags)
	set textinverse,(iy+textflags)
	bcall(_dispop1a)
	res textinverse,(iy+textflags)
	res textwrite,(iy+sgrflags)

	call ionFastCopy
	call SplashDelay
	cp 2
	jp z,ExitSplash
	cp 3 \ ret z
	

	call LoadSplash	

	ld a,27
	ld hl,Txt_3
	
	call PutCaption
	cp 3
	jp z,ExitGameFully

	jp SplashScreenLoop

PutCaption:
	call PutTextOnSplash

	call ionFastCopy
	call SplashDelay
	cp 2
	jp z,ExitSplash
	cp 3 \ ret z

	call LoadSplash
	ret

ExitGameFully:
	ret

ExitSplash:

	call LoadSplash
	ld hl,Txt_4
	ld a,26
	call PutTextOnSplash
	call ionFastCopy
	call GetNumericKey
	ld b,a
	ld a,5
	sub b
	sla a
	ld (DelayTime),a
	
	

	call LoadSplash
	ld hl,Txt_5
	ld a,23
	call PutTextOnSplash
	call ionFastCopy
	call GetNumericKey
	ld b,a
	ld a,5
	sub b
	sla a
	sla a
	sla a
	add a,12
	ld (DelayBlock),a

	call Start
	ld a,15
	call CoolWipe
	
	;Check 4 hiscore

	ld de,(Score)
	ld hl,(HighScore)
	ld a,h
	cp d
	jr c,NewHiScore
	jp nz,NotNewHiScore
	ld a,l
	cp e
	jr c,NewHiScore
NotNewHiScore:
	jp InitProg
NewHiScore:
	ld hl,(Score)
	ld (HighScore),hl
	jp InitProg


CoolWipe:


IntroFade:
	push af
	ld hl,PlotsScreen
	ld de,PlotsScreen
	ld bc,768
IntroSeq:
	ld a,(hl)
	xor 255
	inc hl
	ld (de),a
	inc de

	dec bc
	ld a,b
	or c
	jr nz,IntroSeq
	
	bcall(_grbufcpy)
	
	halt \ halt \ halt \ halt
	halt \ halt \ halt \ halt
	halt \ halt \ halt \ halt
	pop af
	dec a
	cp 0
	jp nz,IntroFade
	ret

GetNumericKey:
	ld b,0
	bcall(_getcsc)
	cp 0
	jp z,GetNumericKey
	cp sk0
	jr z,n0_Pressed
	cp sk1
	jr z,n1_Pressed
	cp sk2
	jr z,n2_Pressed
	cp sk3
	jr z,n3_Pressed
	cp sk4
	jr z,n4_Pressed
	cp sk5
	jr z,n5_Pressed
	jr GetNumericKey
n5_Pressed:
	inc b
n4_Pressed:
	inc b
n3_Pressed:
	inc b
n2_Pressed:
	inc b
n1_Pressed:
	inc b
n0_Pressed:
	ld a,b
	ret
	
	

LoadSplash:
	ld hl,Splash
	ld de,PlotsScreen
	call DispRLE
	ret


PutTextOnSplash:
	ld (pencol),a
	ld a,64-8
	ld (penrow),a
	set textwrite,(iy+sgrflags)
	set textinverse,(iy+textflags)
	bcall(_vputs)
	res textwrite,(iy+sgrflags)
	res textinverse,(iy+textflags)			
	ret
	
SplashDelay:
	ld a,1
	ld hl,(MainScreenDelay)
	inc hl
	ld (MainScreenDelay),hl
	ld de,0
	bcall(_cphlde)
	jr nz,NotTimedOut
	ld hl,65535-5000
	ld (MainScreenDelay),hl
	ret	
NotTimedOut:
	bcall(_getcsc)	
	cp 0
	jp z,SplashDelay
	cp skClear
	jr nz,NotClear
	ld a,3
	ret
NotClear:
	ld a,2
	ret


Start:
	ld a,15
	ld (ChopperY),a

	ld a,0
	ld (Delay),a
	ld (GotNewHi),a

	
	ld hl,0
	ld (RandPos),hl
	ld (Score),hl

	ld hl,ChopperAnimation
	ld (AniFrame),hl


	ld a,(DelayBlock)
	ld (DistToBlock),a

	ld a,15
	ld hl,Height 
	ld de,Height+12
ClearHeights:
	ld (hl),a
	inc hl
	bcall(_cphlde)
	jp nz,ClearHeights
	

GameLoop:

	

	ld a,%00111110
   	out (1),a
   	in a,(1)
   	ld b,a
	bit 5,b

	jp nz,FallChopper

	ld a,(ChopperY)
	dec a
	jr ChopperSet	
FallChopper:
	ld a,(ChopperY)
	inc a	
ChopperSet:
	ld (ChopperY),a


	bcall(_grbufclr)

	ld hl,(Score)
	bcall(_setxxxxop2)
	bcall(_op2toop1)	

	ld a,1
	ld (pencol),a
	ld a,64-7
	ld (penrow),a
	ld a,5

	set textwrite,(iy+sgrflags)

	bcall(_dispop1a)
	res textwrite,(iy+sgrflags)




	ld ix,Chopper
	ld b,8
	ld a,(ChopperY)
	ld l,a
	ld a,5
	call ionPutSprite

	ld hl,Height 
	ld (ListPos),hl
	ld a,0
	ld (RoofPos),a

NextRoofTile:	
	ld a,(hl)
	ld l,a
	ld a,(RoofPos)
	ld ix,RoofTile
	ld b,8
	call ionPutSprite

	ld hl,(ListPos)
	ld a,(hl)
	add a,35
	ld l,a
	ld a,(RoofPos)
	ld ix,RoofTile
	ld b,8
	call ionPutSprite
	
	
	ld hl,(ListPos)
	inc hl
	ld (ListPos),hl

	ld a,(RoofPos)
	add a,8
	ld (RoofPos),a
	cp 96
	jp nz,NextRoofTile

	ld a,(DistToBlock)
	cp 12
	jp nc,NotYetBlock

	sla a ;*2
	sla a ;*2
	sla a ;*2
	push af
	ld a,(DodgeBlock)
	ld l,a
	ld ix,RoofTile	
	ld b,8
	pop af
	call ionPutSprite
	jp BlockDrawn

NotYetBlock:

	ld a,(Height+11)
	ld b,a

	ld hl,(RandPos)
	ld a,(hl)
	srl a ;/2
	srl a ;/4
	srl a ;/8
	srl a ;/16
	
	add a,b
	add a,10

	ld (DodgeBlock),a

BlockDrawn:

	call ionFastCopy

				;Collision Detect!
	
	ld a,(ChopperY)
	ld b,a
	ld a,(Height)
	cp b
	ret z
	add a,30
	cp b
	ret z

	ld a,(DistToBlock)
	cp 1
	jp nz,BlockNotThere

	ld a,(DodgeBlock)
	add a,10
	ld b,a
	ld a,(ChopperY)
	add a,5
	cp b
	jp nc,SafeFromBlock
	ld c,a
	ld a,b
	sub 11
	ld b,a
	ld a,c
	cp b
	jp c,SafeFromBlock	
	ret

SafeFromBlock:

BlockNotThere:

	bcall(_getcsc)
	cp skClear
	jp z,ExitGame

	ld a,(Delay)
	cp 0
	jp z,MoveScreenOn

	dec a
	ld (Delay),a
	jp GameLoop

MoveScreenOn:

	ld hl,(AniFrame)
	ld a,(hl)
	inc hl
	ld (AniFrame),hl

	ld (Chopper+1),a
	ld hl,(AniFrame)
	ld de,ChopperAnimation+6
	bcall(_cphlde)
	jr nz,NoResetAni

	ld hl,ChopperAnimation
	ld (AniFrame),hl

NoResetAni:


	ld hl,(Score)
	inc hl
	ld (Score),hl

	ld a,(GotNewHi)
	cp 1
	jr z,InGameNo

	ld de,(Score)
	ld hl,(HighScore)
	ld a,h
	cp d
	jr c,NewHiScoreG
	jp nz,InGameNo
	ld a,l
	cp e
	jr c,NewHiScoreG
	jr InGameNo

NewHiScoreG:
	ld a,2
	call CoolWipe
	ld a,1
	ld (GotNewHi),a
	

InGameNo:

	ld a,(DistToBlock)
	dec a
	ld (DistToBlock),a
	cp -1
	jp nz,NotOffScreen

	ld a,(DelayBlock)
	ld (DistToBlock),a

NotOffScreen:	
	

	ld hl,Height+1
	ld de,Height
	ld bc,11
	ldir

	ld hl,(RandPos)
	inc hl
	ld (RandPos),hl

	ld a,(hl)
	cp 127
	jp nc,RandHigh

	ld b,-1
	jp RandSet
RandHigh:
	ld b,1
RandSet:

	ld a,(Height+11)
	add a,b

	cp 1
	jp c,BadSize
	

	cp 64-35-8
	jp nc,BadSize
	
	
	ld (Height+11),a

BadSize:
	ld a,(DelayTime)
	ld (Delay),a


	jp GameLoop

ExitGame:
	ret



Splash:		;RLE: -44%

 .db $91,$FF,$30,$F8,$91,$00,$04,$01,$91,$FF,$1E,$80
 .db $91,$00,$06,$03,$91,$FF,$10,$80,$91,$00,$08,$1F
 .db $91,$FF,$04,$91,$00,$03,$01,$91,$FF,$06,$80,$91
 .db $00,$09,$7F,$F3,$FF,$F0,$91,$00,$05,$7F,$91,$FF
 .db $03,$8F,$80,$91,$00,$07,$80,$00,$04,$7F,$FF,$91
 .db $00,$07,$87,$91,$FF,$03,$80,$91,$00,$07,$40,$00
 .db $E1,$FF,$F8,$91,$00,$07,$40,$3F,$FF,$FF,$80,$91
 .db $00,$07,$60,$18,$00,$7F,$80,$91,$00,$07,$21,$E1
 .db $FF,$FF,$E0,$91,$00,$06,$01,$FE,$20,$00,$3F,$80
 .db $91,$00,$06,$1E,$30,$31,$DF,$FF,$80,$91,$00,$05
 .db $07,$E0,$38,$F0,$A0,$1F,$80,$91,$00,$05,$F8,$00
 .db $19,$7C,$BF,$FF,$80,$91,$00,$07,$1F,$4F,$20,$0F
 .db $80,$0E,$60,$91,$00,$05,$19,$5C,$1F,$FF,$80,$31
 .db $90,$91,$00,$05,$0F,$98,$E8,$07,$80,$61,$90,$91
 .db $00,$05,$07,$E7,$E7,$FF,$80,$47,$90,$91,$00,$05
 .db $07,$FB,$E7,$03,$80,$8F,$9C,$1E,$0F,$07,$83,$C7
 .db $01,$FD,$E7,$FF,$80,$9E,$82,$61,$B0,$D8,$6C,$28
 .db $80,$FE,$F4,$03,$80,$98,$81,$40,$A0,$50,$28,$10
 .db $80,$7F,$7B,$FF,$80,$90,$99,$8C,$46,$23,$11,$13
 .db $80,$6E,$7E,$03,$80,$98,$99,$9E,$4F,$27,$92,$33
 .db $0F,$A4,$7E,$FF,$80,$8E,$99,$9E,$4F,$27,$92,$72
 .db $07,$27,$81,$83,$80,$C7,$99,$8C,$4E,$27,$11,$F2
 .db $02,$5F,$E1,$FF,$80,$61,$99,$C0,$C8,$64,$38,$32
 .db $00,$EF,$E1,$01,$80,$71,$99,$E1,$C8,$E4,$6C,$32
 .db $01,$A3,$FE,$7F,$80,$3F,$F8,$7F,$CF,$E7,$EF,$FE
 .db $00,$68,$01,$01,$80,$0E,$6C,$3E,$4F,$27,$83,$CC
 .db $00,$10,$00,$1F,$80,$00,$0E,$20,$48,$24,$91,$00
 .db $05,$01,$80,$00,$07,$E0,$78,$3C,$91,$00,$05,$0F
 .db $E0,$00,$03,$C0,$30,$18,$91,$00,$05,$01,$80,$91
 .db $00,$0A,$07,$80,$91,$00,$0A,$01,$F8,$91,$00,$0A
 .db $03,$80,$91,$00,$0A,$01,$FF,$91,$00,$0A,$01,$80
 .db $91,$00,$0A,$01,$FF,$F0,$91,$00,$09,$01,$80,$91
 .db $00,$0A,$01,$FF,$FF,$91,$00,$09,$01,$80,$91,$00
 .db $0A,$01,$FF,$FF,$F0,$91,$00,$08,$01,$80,$91,$00
 .db $0A,$01,$91,$FF,$03,$E0,$91,$00,$07,$01,$80,$91
 .db $00,$0A,$01,$91,$FF,$60

Chopper:
.db %00000000
.db %01111111
.db %00001000
.db %10011110
.db %11111111
.db %00011111
.db %00000000
.db %00000000
RoofTile:
.db %11111111
.db %11111111
.db %11111111
.db %11111111
.db %00000000
.db %00000000
.db %00000000
.db %00000000

ChopperAnimation:
.db %01111111
.db %00111110
.db %00011100
.db %00001000
.db %00011100
.db %00111110

Txt_1:
.db "Ben Ryves - Spitfire Prods.",0
Txt_2:
.db "High Score:",0
Txt_3:
.db "Press Any Key",0
Txt_4:
.db "Speed? (0-5)",0
Txt_5:
.db "Difficulty? (0-5)",0
Txt_6:
.db "New High Score!",0

HighScore:
.dw 50
.end
END