/*
 * Decompiled with CFR 0.152.
 */
package AGTEdit;

import AGTEdit.AGEvent;
import AGTEdit.AGObject;
import AGTEdit.AGTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class AGEventEditor
extends JPanel
implements ActionListener {
    private JButton newEvent = new JButton("New");
    private JButton deleteEvent = new JButton("Delete");
    private JButton editEvent = new JButton("Edit");
    private JList eventList = new JList();
    private AGTable table;

    AGEventEditor(AGTable aGTable) {
        super(new BorderLayout());
        this.table = aGTable;
        JPanel jPanel = new JPanel();
        jPanel.add(this.newEvent);
        jPanel.add(this.deleteEvent);
        jPanel.add(this.editEvent);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.eventList), "Center");
        this.setBorder(BorderFactory.createTitledBorder("Events"));
        this.setPreferredSize(new Dimension(200, 200));
        this.newEvent.addActionListener(this);
        this.deleteEvent.addActionListener(this);
        this.editEvent.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        DefaultListModel defaultListModel = (DefaultListModel)this.eventList.getModel();
        if (object.equals(this.newEvent)) {
            AGEvent aGEvent = this.createEvent();
            if (aGEvent.getType() != 0) {
                if (this.eventList.getSelectedIndex() != -1) {
                    defaultListModel.insertElementAt(aGEvent, this.eventList.getSelectedIndex());
                } else {
                    defaultListModel.addElement(aGEvent);
                }
            }
        } else if (object.equals(this.deleteEvent)) {
            while (this.eventList.getSelectedIndex() != -1) {
                defaultListModel.removeElementAt(this.eventList.getSelectedIndex());
            }
        } else if (object.equals(this.editEvent)) {
            if (this.eventList.getSelectedIndex() != -1) {
                this.editEvent((AGEvent)this.eventList.getSelectedValue());
            }
            this.eventList.paint(this.eventList.getGraphics());
        }
    }

    public void setContents(DefaultListModel defaultListModel) {
        this.eventList.setModel(defaultListModel);
    }

    private AGEvent createEvent() {
        AGEvent aGEvent = new AGEvent();
        new AGEventDialog(aGEvent, true);
        return aGEvent;
    }

    private void editEvent(AGEvent aGEvent) {
        new AGEventDialog(aGEvent, false);
    }

    private class AGEventDialog
    extends JDialog
    implements ActionListener {
        private AGEvent event;
        private JButton actionOK = new JButton("OK");
        private JButton actionCancel = new JButton("Cancel");
        private JRadioButton[] typeButtons = new JRadioButton[AGEvent.count()];
        private int objectListType = 0;
        private JComboBox objectList = new JComboBox(AGEventEditor.access$000(AGEventEditor.this).getObjects(this.objectListType));
        private JTextField param1 = new JTextField(5);
        private JTextField param2 = new JTextField(5);
        private boolean isNew;

        AGEventDialog(AGEvent aGEvent, boolean bl) {
            this.event = aGEvent;
            this.isNew = bl;
            if (this.isNew) {
                this.event.setType(1);
            } else {
                this.newList(this.event.getObjectType());
                this.objectList.setSelectedItem(this.event.getObject());
            }
            this.param1.setText(Integer.toString(this.event.getVal()));
            this.param2.setText(Integer.toString(this.event.getBonus()));
            Container container = this.getContentPane();
            this.setModal(true);
            this.setResizable(false);
            this.setLocationRelativeTo(null);
            this.setDefaultCloseOperation(0);
            this.setTitle("Event properties");
            ButtonGroup buttonGroup = new ButtonGroup();
            JPanel jPanel = new JPanel(new GridLayout(this.typeButtons.length / 2 + 1, 2));
            for (int i = 1; i < AGEvent.count(); ++i) {
                this.typeButtons[i] = new JRadioButton(AGEvent.getName(i), i == (this.isNew ? 1 : this.event.getType()));
                buttonGroup.add(this.typeButtons[i]);
                jPanel.add(this.typeButtons[i]);
                this.typeButtons[i].addActionListener(this);
            }
            this.actionOK.addActionListener(this);
            this.actionCancel.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.add(new JLabel("Par1: "));
            jPanel2.add(this.param1);
            jPanel2.add(new JLabel("Par2: "));
            jPanel2.add(this.param2);
            JPanel jPanel3 = new JPanel();
            jPanel3.add(new JLabel("Object: "));
            jPanel3.add(this.objectList);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            jPanel4.add((Component)jPanel2, "North");
            jPanel4.add((Component)this.objectList, "South");
            JPanel jPanel5 = new JPanel();
            jPanel5.add(this.actionOK);
            jPanel5.add(this.actionCancel);
            container.setLayout(new BorderLayout());
            container.add((Component)jPanel, "North");
            container.add((Component)jPanel4, "Center");
            container.add((Component)jPanel5, "South");
            this.pack();
            this.show();
        }

        private int parseInt(String string) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 0;
            }
            return n;
        }

        private void newList(int n) {
            if (n != this.objectListType) {
                this.objectList.setModel(new DefaultComboBoxModel(AGEventEditor.this.table.getObjects(n)));
                this.objectListType = n;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(this.actionOK)) {
                for (int i = 1; i < this.typeButtons.length; ++i) {
                    if (!this.typeButtons[i].isSelected()) continue;
                    this.event.setType(i);
                }
                this.event.setObject((AGObject)this.objectList.getSelectedItem());
                this.event.setVal(this.parseInt(this.param1.getText()));
                this.event.setBonus(this.parseInt(this.param2.getText()));
                this.dispose();
            } else if (object.equals(this.actionCancel)) {
                if (this.isNew) {
                    this.event.setType(0);
                }
                this.dispose();
            } else {
                for (int i = 1; i < this.typeButtons.length; ++i) {
                    if (!object.equals(this.typeButtons[i])) continue;
                    this.newList(AGEvent.getObjectType(i));
                }
            }
        }
    }
}

