/*
 * Decompiled with CFR 0.152.
 */
package AGTEdit;

import AGTEdit.AGBounce;
import AGTEdit.AGBrushBar;
import AGTEdit.AGComment;
import AGTEdit.AGCounter;
import AGTEdit.AGEventEditor;
import AGTEdit.AGFlipper;
import AGTEdit.AGGizmo;
import AGTEdit.AGObject;
import AGTEdit.AGSpriteEditor;
import AGTEdit.AGTable;
import AGTEdit.AGTablePaint;
import AGTEdit.AGTimer;
import AGTEdit.CalcFile;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

class AGTComponents {
    private AGTable doc = new AGTable();
    private BufferedImage tableImage;
    private AGTablePaint imageView;
    private JTextField tableName = new JTextField("Untitled", 17);
    private JList objectList = new JList(this.doc.getObjects());
    private JButton newObject = new JButton("New");
    private JButton deleteObject = new JButton("Delete");
    private JButton objectUp = new JButton("/\\");
    private JButton objectDown = new JButton("\\/");
    private boolean updateEnabled = false;
    private JTextField renameObject = new JTextField(17);
    private JTextField objectParam = new JTextField(5);
    private JTextField objectX = new JTextField(3);
    private JTextField objectY = new JTextField(3);
    private JTextField objectW = new JTextField(3);
    private JTextField objectH = new JTextField(3);
    private JTextField objectVal = new JTextField(3);
    private JTextField objectFX = new JTextField(3);
    private JTextField objectFY = new JTextField(3);
    private JButton objectDir = new JButton();
    private JCheckBox spriteActive = new JCheckBox("Start as active");
    private JCheckBox spritePresent = new JCheckBox("Sprite present");
    private JCheckBox spriteVisible = new JCheckBox("Start as visible");
    private JButton spriteFit = new JButton("Fit size");
    private AGSpriteEditor spriteEditor;
    private AGEventEditor eventEditor = new AGEventEditor(this.doc);
    private JPanel dummyProperty = new JPanel();
    private JPanel renamePanel = new JPanel();
    private JPanel dimensionProperty = new JPanel();
    private JPanel spritePanel = new JPanel(new BorderLayout());
    private JPanel valueProperty = new JPanel();
    private JPanel flipperPanel = new JPanel();
    private JPanel objectPropertyPanel = new JPanel(new CardLayout());
    private JPanel gizmoProperty = new JPanel();
    private JPanel timerProperty = new JPanel();
    private JPanel counterProperty = new JPanel();
    private JPanel bounceProperty = new JPanel();
    private JPanel flipperProperty = new JPanel();
    private JPanel commentProperty = new JPanel();
    private JMenuItem fileNew = new JMenuItem("New");
    private JMenuItem fileOpen = new JMenuItem("Open");
    private JMenuItem fileSave = new JMenuItem("Save");
    private JMenuItem fileExport = new JMenuItem("Export");
    private JMenuItem zoom1x = new JMenuItem("Zoom 100%");
    private JMenuItem zoom15x = new JMenuItem("Zoom 150%");
    private JMenuItem zoom2x = new JMenuItem("Zoom 200%");
    private JMenuItem zoom4x = new JMenuItem("Zoom 400%");
    private JMenuItem tableLayers = new JMenuItem("Deco -> Wall");
    private JMenuItem tableImport = new JMenuItem("Import image");
    private JFileChooser jfc = new JFileChooser("tables");
    private JFileChooser ifc = new JFileChooser(".");

    AGTComponents() {
    }

    public JComponent createComponents() {
        AGObject aGObject = new AGObject();
        aGObject.setName("[NO OBJECT SET]");
        AGObject.setDummy(aGObject);
        this.jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = ".";
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string.equals("xagt");
            }

            public String getDescription() {
                return "Table source files";
            }
        });
        this.ifc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = ".";
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string.equals("jpg") || string.equals("gif") || string.equals("png") || string.equals("bmp");
            }

            public String getDescription() {
                return "Image files";
            }
        });
        byte[] byArray = new byte[]{-1, 0, -1, -96, 0, 0, -1, -96};
        byte[] byArray2 = new byte[]{-1, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray3 = new byte[]{-1, 0, 0, 0, -1, -96, -1, -96};
        int n = 4;
        this.tableImage = new BufferedImage(96, 160, 13, new IndexColorModel(8, 8, byArray, byArray2, byArray3));
        this.imageView = new AGTablePaint(this.tableImage, this.objectList);
        this.imageView.setZoom(n);
        byte[] byArray4 = ((DataBufferByte)this.tableImage.getRaster().getDataBuffer()).getData();
        this.doc.setTable(byArray4);
        this.spriteEditor = new AGSpriteEditor(this.imageView);
        JScrollPane jScrollPane = new JScrollPane(this.objectList);
        jScrollPane.setPreferredSize(new Dimension(200, 250));
        JPanel jPanel = new JPanel();
        jPanel.add(this.newObject);
        jPanel.add(this.deleteObject);
        jPanel.add(this.objectUp);
        jPanel.add(this.objectDown);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setBorder(BorderFactory.createTitledBorder("Objects"));
        this.dummyProperty.add(new JLabel("Table name:"));
        this.dummyProperty.add(this.tableName);
        this.objectPropertyPanel.add((Component)this.dummyProperty, "None");
        this.renamePanel.add(new JLabel("Name:"));
        this.renamePanel.add(this.renameObject);
        Insets insets = new Insets(1, 1, 1, 1);
        this.objectX.setMargin(insets);
        this.objectY.setMargin(insets);
        this.objectW.setMargin(insets);
        this.objectH.setMargin(insets);
        this.dimensionProperty.add(new JLabel("X:"));
        this.dimensionProperty.add(this.objectX);
        this.dimensionProperty.add(new JLabel("Y:"));
        this.dimensionProperty.add(this.objectY);
        this.dimensionProperty.add(new JLabel("W:"));
        this.dimensionProperty.add(this.objectW);
        this.dimensionProperty.add(new JLabel("H:"));
        this.dimensionProperty.add(this.objectH);
        JPanel jPanel3 = new JPanel(new GridLayout(3, 1));
        jPanel3.add(this.spriteActive);
        jPanel3.add(this.spritePresent);
        jPanel3.add(this.spriteVisible);
        this.spritePanel.add((Component)jPanel3, "Center");
        this.spritePanel.add((Component)this.spriteEditor, "East");
        this.spritePanel.add((Component)this.spriteFit, "South");
        this.valueProperty.add(new JLabel("Initial value:"));
        this.valueProperty.add(this.objectVal);
        this.objectDir.setPreferredSize(new Dimension(70, 25));
        this.flipperPanel.add(new JLabel("X:"));
        this.flipperPanel.add(this.objectFX);
        this.flipperPanel.add(new JLabel("Y:"));
        this.flipperPanel.add(this.objectFY);
        this.flipperPanel.add(this.objectDir);
        this.gizmoProperty.setPreferredSize(new Dimension(200, 300));
        this.timerProperty.setPreferredSize(new Dimension(200, 300));
        this.counterProperty.setPreferredSize(new Dimension(200, 300));
        this.bounceProperty.setPreferredSize(new Dimension(200, 300));
        this.flipperProperty.setPreferredSize(new Dimension(200, 300));
        this.commentProperty.setPreferredSize(new Dimension(200, 300));
        this.objectPropertyPanel.add((Component)this.gizmoProperty, "Gizmo");
        this.objectPropertyPanel.add((Component)this.timerProperty, "Timer");
        this.objectPropertyPanel.add((Component)this.counterProperty, "Counter");
        this.objectPropertyPanel.add((Component)this.bounceProperty, "Bounce");
        this.objectPropertyPanel.add((Component)this.flipperProperty, "Flipper");
        this.objectPropertyPanel.add((Component)this.commentProperty, "Comment");
        JSplitPane jSplitPane = new JSplitPane(0, jPanel2, this.objectPropertyPanel);
        jSplitPane.setOneTouchExpandable(true);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)new AGBrushBar(this.imageView), "West");
        jPanel4.add((Component)new JScrollPane(this.imageView), "Center");
        jPanel4.add((Component)jSplitPane, "East");
        return jPanel4;
    }

    public JMenuBar mainMenu() {
        JMenu jMenu = new JMenu("File");
        jMenu.add(this.fileNew);
        jMenu.add(this.fileOpen);
        jMenu.add(this.fileSave);
        jMenu.add(this.fileExport);
        JMenu jMenu2 = new JMenu("Zoom");
        jMenu2.add(this.zoom1x);
        jMenu2.add(this.zoom15x);
        jMenu2.add(this.zoom2x);
        jMenu2.add(this.zoom4x);
        JMenu jMenu3 = new JMenu("Table");
        jMenu3.add(this.tableLayers);
        jMenu3.add(this.tableImport);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        return jMenuBar;
    }

    public void addActions() {
        AGObjectActions aGObjectActions = new AGObjectActions();
        AGMenuActions aGMenuActions = new AGMenuActions();
        this.fileNew.addActionListener(aGMenuActions);
        this.fileOpen.addActionListener(aGMenuActions);
        this.fileSave.addActionListener(aGMenuActions);
        this.fileExport.addActionListener(aGMenuActions);
        this.zoom1x.addActionListener(aGMenuActions);
        this.zoom15x.addActionListener(aGMenuActions);
        this.zoom2x.addActionListener(aGMenuActions);
        this.zoom4x.addActionListener(aGMenuActions);
        this.tableLayers.addActionListener(aGMenuActions);
        this.tableImport.addActionListener(aGMenuActions);
        this.newObject.addActionListener(aGObjectActions);
        this.deleteObject.addActionListener(aGObjectActions);
        this.objectUp.addActionListener(aGObjectActions);
        this.objectDown.addActionListener(aGObjectActions);
        this.renameObject.addActionListener(aGObjectActions);
        this.spriteFit.addActionListener(aGObjectActions);
        this.spriteActive.addActionListener(aGObjectActions);
        this.spritePresent.addActionListener(aGObjectActions);
        this.spriteVisible.addActionListener(aGObjectActions);
        this.objectDir.addActionListener(aGObjectActions);
        ListSelectionModel listSelectionModel = this.objectList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AGObjectListSelectionHandler());
        this.objectX.getDocument().addDocumentListener(new AGDocumentListener(0));
        this.objectY.getDocument().addDocumentListener(new AGDocumentListener(1));
        this.objectW.getDocument().addDocumentListener(new AGDocumentListener(2));
        this.objectH.getDocument().addDocumentListener(new AGDocumentListener(3));
        this.objectVal.getDocument().addDocumentListener(new AGDocumentListener(4));
        this.objectFX.getDocument().addDocumentListener(new AGDocumentListener(5));
        this.objectFY.getDocument().addDocumentListener(new AGDocumentListener(6));
    }

    private class AGDocumentListener
    implements DocumentListener {
        public static final int X = 0;
        public static final int Y = 1;
        public static final int W = 2;
        public static final int H = 3;
        public static final int VAL = 4;
        public static final int FX = 5;
        public static final int FY = 6;
        private int obj;

        AGDocumentListener(int n) {
            this.obj = n;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (AGTComponents.this.updateEnabled) {
                this.performUpdate();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (AGTComponents.this.updateEnabled) {
                this.performUpdate();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private int parseInt(String string) {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 0;
            }
            return n;
        }

        private void performUpdate() {
            AGObject aGObject = (AGObject)AGTComponents.this.objectList.getSelectedValue();
            switch (this.obj) {
                case 0: {
                    if (aGObject.getType() == 1) {
                        ((AGGizmo)aGObject).setX(this.parseInt(AGTComponents.this.objectX.getText()));
                    }
                    if (aGObject.getType() != 4) break;
                    ((AGBounce)aGObject).setX(this.parseInt(AGTComponents.this.objectX.getText()));
                    break;
                }
                case 1: {
                    if (aGObject.getType() == 1) {
                        ((AGGizmo)aGObject).setY(this.parseInt(AGTComponents.this.objectY.getText()));
                    }
                    if (aGObject.getType() != 4) break;
                    ((AGBounce)aGObject).setY(this.parseInt(AGTComponents.this.objectY.getText()));
                    break;
                }
                case 2: {
                    if (aGObject.getType() == 1) {
                        ((AGGizmo)aGObject).setW(this.parseInt(AGTComponents.this.objectW.getText()));
                    }
                    if (aGObject.getType() != 4) break;
                    ((AGBounce)aGObject).setW(this.parseInt(AGTComponents.this.objectW.getText()));
                    break;
                }
                case 3: {
                    if (aGObject.getType() == 1) {
                        ((AGGizmo)aGObject).setH(this.parseInt(AGTComponents.this.objectH.getText()));
                    }
                    if (aGObject.getType() != 4) break;
                    ((AGBounce)aGObject).setH(this.parseInt(AGTComponents.this.objectH.getText()));
                    break;
                }
                case 4: {
                    if (aGObject.getType() == 2) {
                        ((AGTimer)aGObject).setVal(this.parseInt(AGTComponents.this.objectVal.getText()));
                    }
                    if (aGObject.getType() != 3) break;
                    ((AGCounter)aGObject).setVal(this.parseInt(AGTComponents.this.objectVal.getText()));
                    break;
                }
                case 5: {
                    ((AGFlipper)aGObject).setX(this.parseInt(AGTComponents.this.objectFX.getText()));
                    break;
                }
                case 6: {
                    ((AGFlipper)aGObject).setY(this.parseInt(AGTComponents.this.objectFY.getText()));
                }
            }
            AGTComponents.this.imageView.repaint();
        }
    }

    private class AGObjectListSelectionHandler
    implements ListSelectionListener {
        private AGObjectListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                AGTComponents.this.updateEnabled = false;
                CardLayout cardLayout = (CardLayout)AGTComponents.this.objectPropertyPanel.getLayout();
                if (AGTComponents.this.objectList.getSelectedIndices().length == 1) {
                    AGObject aGObject = (AGObject)AGTComponents.this.objectList.getSelectedValue();
                    AGTComponents.this.renameObject.setText(aGObject.getName());
                    switch (aGObject.getType()) {
                        case 1: {
                            AGGizmo aGGizmo = (AGGizmo)aGObject;
                            AGTComponents.this.objectX.setText(Integer.toString(aGGizmo.getX()));
                            AGTComponents.this.objectY.setText(Integer.toString(aGGizmo.getY()));
                            AGTComponents.this.objectW.setText(Integer.toString(aGGizmo.getW()));
                            AGTComponents.this.objectH.setText(Integer.toString(aGGizmo.getH()));
                            AGTComponents.this.spriteEditor.setSprite(aGGizmo.getSprite());
                            AGTComponents.this.eventEditor.setContents(aGGizmo.getEvents());
                            AGTComponents.this.spriteActive.setSelected(aGGizmo.getActiveFlag());
                            AGTComponents.this.spritePresent.setSelected(aGGizmo.getSpriteFlag());
                            AGTComponents.this.spriteVisible.setSelected(aGGizmo.getVisibleFlag());
                            AGTComponents.this.gizmoProperty.add(AGTComponents.this.renamePanel);
                            AGTComponents.this.gizmoProperty.add(AGTComponents.this.dimensionProperty);
                            AGTComponents.this.gizmoProperty.add(AGTComponents.this.spritePanel);
                            AGTComponents.this.gizmoProperty.add(AGTComponents.this.eventEditor);
                            cardLayout.show(AGTComponents.this.objectPropertyPanel, "Gizmo");
                            break;
                        }
                        case 2: {
                            AGTimer aGTimer = (AGTimer)aGObject;
                            AGTComponents.this.objectVal.setText(Integer.toString(aGTimer.getVal()));
                            AGTComponents.this.eventEditor.setContents(aGTimer.getEvents());
                            AGTComponents.this.timerProperty.add(AGTComponents.this.renamePanel);
                            AGTComponents.this.timerProperty.add(AGTComponents.this.valueProperty);
                            AGTComponents.this.timerProperty.add(AGTComponents.this.eventEditor);
                            cardLayout.show(AGTComponents.this.objectPropertyPanel, "Timer");
                            break;
                        }
                        case 3: {
                            AGCounter aGCounter = (AGCounter)aGObject;
                            AGTComponents.this.objectVal.setText(Integer.toString(aGCounter.getVal()));
                            AGTComponents.this.eventEditor.setContents(aGCounter.getEvents());
                            AGTComponents.this.counterProperty.add(AGTComponents.this.renamePanel);
                            AGTComponents.this.counterProperty.add(AGTComponents.this.valueProperty);
                            AGTComponents.this.counterProperty.add(AGTComponents.this.eventEditor);
                            cardLayout.show(AGTComponents.this.objectPropertyPanel, "Counter");
                            break;
                        }
                        case 4: {
                            AGBounce aGBounce = (AGBounce)aGObject;
                            AGTComponents.this.objectX.setText(Integer.toString(aGBounce.getX()));
                            AGTComponents.this.objectY.setText(Integer.toString(aGBounce.getY()));
                            AGTComponents.this.objectW.setText(Integer.toString(aGBounce.getW()));
                            AGTComponents.this.objectH.setText(Integer.toString(aGBounce.getH()));
                            AGTComponents.this.bounceProperty.add(AGTComponents.this.renamePanel);
                            AGTComponents.this.bounceProperty.add(AGTComponents.this.dimensionProperty);
                            cardLayout.show(AGTComponents.this.objectPropertyPanel, "Bounce");
                            break;
                        }
                        case 5: {
                            AGFlipper aGFlipper = (AGFlipper)aGObject;
                            AGTComponents.this.objectFX.setText(Integer.toString(aGFlipper.getX()));
                            AGTComponents.this.objectFY.setText(Integer.toString(aGFlipper.getY()));
                            AGTComponents.this.objectDir.setText(aGFlipper.getDirString());
                            AGTComponents.this.flipperProperty.add(AGTComponents.this.renamePanel);
                            AGTComponents.this.flipperProperty.add(AGTComponents.this.flipperPanel);
                            cardLayout.show(AGTComponents.this.objectPropertyPanel, "Flipper");
                            break;
                        }
                        case 6: {
                            AGTComponents.this.commentProperty.add(AGTComponents.this.renamePanel);
                            cardLayout.show(AGTComponents.this.objectPropertyPanel, "Comment");
                        }
                    }
                    AGTComponents.this.updateEnabled = true;
                } else {
                    cardLayout.show(AGTComponents.this.objectPropertyPanel, "None");
                }
                AGTComponents.this.imageView.repaint();
            }
        }
    }

    private class AGMenuActions
    implements ActionListener {
        private AGMenuActions() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(AGTComponents.this.fileNew)) {
                AGTComponents.this.tableName.setText("Untitled");
                AGTComponents.this.doc.setName("Untitled");
                AGTComponents.this.doc.removeAllObjects();
                Arrays.fill(AGTComponents.this.doc.getTable(), (byte)0);
            } else if (object.equals(AGTComponents.this.fileOpen)) {
                if (AGTComponents.this.jfc.showOpenDialog(null) == 0 && !AGTComponents.this.doc.open(AGTComponents.this.jfc.getSelectedFile().getPath())) {
                    JOptionPane.showMessageDialog(null, "The file could not be opened", "Error!", 0);
                }
                AGTComponents.this.tableName.setText(AGTComponents.this.doc.getName());
            } else if (object.equals(AGTComponents.this.fileSave)) {
                AGTComponents.this.doc.setName(AGTComponents.this.tableName.getText());
                if (AGTComponents.this.jfc.showSaveDialog(null) == 0 && !AGTComponents.this.doc.save(AGTComponents.this.jfc.getSelectedFile().getPath())) {
                    JOptionPane.showMessageDialog(null, "The file could not be saved", "Error!", 0);
                }
            } else if (object.equals(AGTComponents.this.fileExport)) {
                AGTComponents.this.doc.setName(AGTComponents.this.tableName.getText());
                byte[] byArray = AGTComponents.this.doc.export();
                if (byArray[0] == 0) {
                    JOptionPane.showMessageDialog(null, "There are too many objects on the table", "Error!", 0);
                } else if (AGTComponents.this.jfc.showSaveDialog(null) == 0) {
                    String string = AGTComponents.this.jfc.getSelectedFile().getPath();
                    if (string.endsWith(".xagt")) {
                        string = string.substring(0, string.length() - 5);
                    }
                    String string2 = CalcFile.convertName("ag" + AGTComponents.this.doc.getName());
                    if (!CalcFile.save(byArray, 0, string + ".82p", string2)) {
                        JOptionPane.showMessageDialog(null, "The TI-82 binary could not be saved", "Error!", 0);
                    }
                    if (!CalcFile.save(byArray, 1, string + ".83p", string2)) {
                        JOptionPane.showMessageDialog(null, "The TI-83 binary could not be saved", "Error!", 0);
                    }
                    if (!CalcFile.save(byArray, 2, string + ".8xp", string2)) {
                        JOptionPane.showMessageDialog(null, "The TI-83+ binary could not be saved", "Error!", 0);
                    }
                }
            } else if (object.equals(AGTComponents.this.zoom1x)) {
                AGTComponents.this.imageView.setZoom(2);
                AGTComponents.this.imageView.repaint();
            } else if (object.equals(AGTComponents.this.zoom15x)) {
                AGTComponents.this.imageView.setZoom(3);
                AGTComponents.this.imageView.repaint();
            } else if (object.equals(AGTComponents.this.zoom2x)) {
                AGTComponents.this.imageView.setZoom(4);
                AGTComponents.this.imageView.repaint();
            } else if (object.equals(AGTComponents.this.zoom4x)) {
                AGTComponents.this.imageView.setZoom(8);
                AGTComponents.this.imageView.repaint();
            } else if (object.equals(AGTComponents.this.tableLayers)) {
                AGTComponents.this.doc.copyDeco();
                AGTComponents.this.imageView.repaint();
            } else if (object.equals(AGTComponents.this.tableImport) && AGTComponents.this.ifc.showOpenDialog(null) == 0) {
                try {
                    BufferedImage bufferedImage = ImageIO.read(AGTComponents.this.ifc.getSelectedFile());
                    int n = bufferedImage.getWidth();
                    int n2 = bufferedImage.getHeight();
                    if (n != 96 || n2 != 160) {
                        JOptionPane.showMessageDialog(null, "The image dimensions must be 96x160 pixels.", "Error!", 0);
                    } else {
                        BufferedImage bufferedImage2 = new BufferedImage(96, 160, 10);
                        Graphics2D graphics2D = bufferedImage2.createGraphics();
                        graphics2D.drawRenderedImage(bufferedImage, new AffineTransform());
                        byte[] byArray = ((DataBufferByte)bufferedImage2.getRaster().getDataBuffer()).getData();
                        byte[] byArray2 = AGTComponents.this.doc.getTable();
                        for (int i = 0; i < byArray.length; ++i) {
                            byArray2[i] = (byte)(byArray[i] >= 0 ? 1 : 0);
                        }
                        AGTComponents.this.imageView.repaint();
                    }
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "An error occurred while trying to read the image.", "Error!", 0);
                }
            }
        }
    }

    private class AGObjectActions
    implements ActionListener {
        private AGObjectActions() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(AGTComponents.this.newObject)) {
                int n = AGTComponents.this.objectList.getSelectedIndex();
                AGObject aGObject = null;
                AGObjectChooser aGObjectChooser = new AGObjectChooser();
                switch (aGObjectChooser.getType()) {
                    case 1: {
                        aGObject = new AGGizmo();
                        break;
                    }
                    case 2: {
                        aGObject = new AGTimer();
                        break;
                    }
                    case 3: {
                        aGObject = new AGCounter();
                        break;
                    }
                    case 4: {
                        aGObject = new AGBounce();
                        break;
                    }
                    case 5: {
                        aGObject = new AGFlipper();
                        break;
                    }
                    case 6: {
                        aGObject = new AGComment();
                    }
                }
                if (aGObject != null) {
                    AGTComponents.this.objectList.clearSelection();
                    if (n != -1) {
                        AGTComponents.this.doc.insert(aGObject, n);
                    } else {
                        AGTComponents.this.doc.add(aGObject);
                    }
                    AGTComponents.this.objectList.setSelectedValue(aGObject, true);
                }
            } else if (object.equals(AGTComponents.this.deleteObject)) {
                while (AGTComponents.this.objectList.getSelectedIndex() != -1) {
                    AGTComponents.this.doc.remove(AGTComponents.this.objectList.getSelectedIndex());
                }
            } else if (object.equals(AGTComponents.this.objectUp)) {
                int n;
                if (AGTComponents.this.objectList.getSelectedIndices().length == 1 && (n = AGTComponents.this.objectList.getSelectedIndex()) > 0) {
                    AGObject aGObject = AGTComponents.this.doc.get(n);
                    AGTComponents.this.doc.remove(n);
                    AGTComponents.this.doc.insert(aGObject, n - 1);
                    AGTComponents.this.objectList.setSelectedValue(aGObject, true);
                }
            } else if (object.equals(AGTComponents.this.objectDown)) {
                int n;
                if (AGTComponents.this.objectList.getSelectedIndices().length == 1 && (n = AGTComponents.this.objectList.getSelectedIndex()) < AGTComponents.this.doc.getCount() - 1) {
                    AGObject aGObject = AGTComponents.this.doc.get(n);
                    AGTComponents.this.doc.remove(n);
                    AGTComponents.this.doc.insert(aGObject, n + 1);
                    AGTComponents.this.objectList.setSelectedValue(aGObject, true);
                }
            } else if (object.equals(AGTComponents.this.renameObject)) {
                ((AGObject)AGTComponents.this.objectList.getSelectedValue()).setName(AGTComponents.this.renameObject.getText());
                AGTComponents.this.objectList.paint(AGTComponents.this.objectList.getGraphics());
            } else if (object.equals(AGTComponents.this.spriteActive)) {
                ((AGGizmo)AGTComponents.this.objectList.getSelectedValue()).toggleActiveFlag();
            } else if (object.equals(AGTComponents.this.spritePresent)) {
                ((AGGizmo)AGTComponents.this.objectList.getSelectedValue()).toggleSpriteFlag();
            } else if (object.equals(AGTComponents.this.spriteVisible)) {
                ((AGGizmo)AGTComponents.this.objectList.getSelectedValue()).toggleVisibleFlag();
            } else if (object.equals(AGTComponents.this.spriteFit)) {
                AGGizmo aGGizmo = (AGGizmo)AGTComponents.this.objectList.getSelectedValue();
                aGGizmo.reFit();
                AGTComponents.this.objectW.setText(Integer.toString(aGGizmo.getW()));
                AGTComponents.this.objectH.setText(Integer.toString(aGGizmo.getH()));
            }
            if (object.equals(AGTComponents.this.objectDir)) {
                AGFlipper aGFlipper = (AGFlipper)AGTComponents.this.objectList.getSelectedValue();
                aGFlipper.toggleDir();
                AGTComponents.this.objectDir.setText(aGFlipper.getDirString());
            }
            AGTComponents.this.imageView.repaint();
        }

        private class AGObjectChooser
        extends JDialog
        implements ActionListener {
            private JButton actionOK = new JButton("OK");
            private JButton actionCancel = new JButton("Cancel");
            private JRadioButton[] typeButtons = new JRadioButton[7];
            private String[] typeNames = new String[]{"[NONE]", "Gizmo", "Timer", "Counter", "Bounce", "Flipper", "Comment"};
            private int type = 0;

            AGObjectChooser() {
                Container container = this.getContentPane();
                this.setModal(true);
                this.setResizable(false);
                this.setLocationRelativeTo(null);
                this.setDefaultCloseOperation(0);
                this.setTitle("Object type");
                ButtonGroup buttonGroup = new ButtonGroup();
                JPanel jPanel = new JPanel(new GridLayout(this.typeButtons.length, 1));
                for (int i = 1; i < this.typeButtons.length; ++i) {
                    this.typeButtons[i] = new JRadioButton(this.typeNames[i]);
                    buttonGroup.add(this.typeButtons[i]);
                    jPanel.add(this.typeButtons[i]);
                }
                this.actionOK.addActionListener(this);
                this.actionCancel.addActionListener(this);
                JPanel jPanel2 = new JPanel();
                jPanel2.add(this.actionOK);
                jPanel2.add(this.actionCancel);
                container.setLayout(new BorderLayout());
                container.add((Component)jPanel, "Center");
                container.add((Component)jPanel2, "South");
                this.pack();
                this.show();
            }

            public int getType() {
                return this.type;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object.equals(this.actionOK)) {
                    for (int i = 1; i < this.typeButtons.length; ++i) {
                        if (!this.typeButtons[i].isSelected()) continue;
                        this.type = i;
                    }
                    this.dispose();
                } else if (object.equals(this.actionCancel)) {
                    this.type = 0;
                    this.dispose();
                }
            }
        }
    }
}

