/*
 * Decompiled with CFR 0.152.
 */
package AGTEdit;

import AGTEdit.AGObject;

public class AGEvent {
    public static final int INVALID = 0;
    public static final int SCORE = 1;
    public static final int BONUS = 2;
    public static final int SETFLAGS = 3;
    public static final int RESETFLAGS = 4;
    public static final int ACTIVATE = 5;
    public static final int HIDE = 6;
    public static final int SETCOUNTER = 7;
    public static final int DECREASE = 8;
    public static final int SETTIMER = 9;
    private static final String[] names = new String[]{"[NONE]", "Score ", "Bonus", "SetFlags ", "ResetFlags ", "Activate ", "Hide ", "SetCounter ", "Decrease ", "SetTimer "};
    private static final int[] types = new int[]{0, 0, 0, 1, 1, 1, 1, 3, 3, 2};
    private int type = 0;
    private int val1;
    private int val2;
    private AGObject obj;

    public void setType(int n) {
        this.type = n;
        if (this.type != 1) {
            this.val1 &= 0xFF;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setVal(int n) {
        this.val1 = n & (this.type == 1 ? 65535 : 255);
    }

    public int getVal() {
        return this.val1;
    }

    public void setBonus(int n) {
        this.val2 = n & 0xFFFF;
    }

    public int getBonus() {
        return this.val2;
    }

    public void setObject(AGObject aGObject) {
        this.obj = aGObject;
    }

    public AGObject getObject() {
        return this.obj;
    }

    public int getObjectType() {
        return types[this.type];
    }

    public static int getObjectType(int n) {
        return types[n];
    }

    public String getName() {
        return names[this.type];
    }

    public String toString() {
        String string = "[NO OBJECT SET]";
        if (this.obj != null) {
            string = this.obj.getName();
        }
        switch (this.type) {
            case 1: {
                return names[this.type] + this.val1 + ", " + this.val2;
            }
            case 2: {
                return names[this.type];
            }
            case 5: 
            case 6: 
            case 8: {
                return names[this.type] + string;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                return names[this.type] + string + ", " + this.val1;
            }
        }
        return "[PLEASE EDIT OR DELETE]";
    }

    public static String getName(int n) {
        return names[n];
    }

    public static int getType(String string) {
        int n = 0;
        for (int i = 1; i < names.length; ++i) {
            if (!string.trim().equals(names[i].trim())) continue;
            n = i;
        }
        return n;
    }

    public static int count() {
        return names.length;
    }
}

