/*
 * Decompiled with CFR 0.152.
 */
package AGTEdit;

import AGTEdit.AGSprite;
import AGTEdit.AGTablePaint;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public class AGSpriteEditor
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final int zoom = 8;
    private BufferedImage spriteImage = new BufferedImage(8, 8, 10);
    private byte[] spriteData = ((DataBufferByte)this.spriteImage.getRaster().getDataBuffer()).getData();
    private int mousebut;
    private AGSprite sprite;
    private AGTablePaint painter;

    AGSpriteEditor(AGTablePaint aGTablePaint) {
        this.setPreferredSize(new Dimension(68, 68));
        this.setBorder(new EtchedBorder());
        this.painter = aGTablePaint;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawRenderedImage(this.spriteImage, new AffineTransform(8.0f, 0.0f, 0.0f, 8.0f, 2.0f, 2.0f));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / 8;
        int n2 = mouseEvent.getY() / 8;
        if (n >= 0 && n < 8 && n2 >= 0 && n2 < 8) {
            this.spriteData[n2 * 8 + n] = (byte)(this.mousebut == 1 ? 0 : -1);
        }
        this.paintImmediately(2, 2, 64, 64);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / 8;
        int n2 = mouseEvent.getY() / 8;
        this.mousebut = mouseEvent.getButton();
        if (n >= 0 && n < 8 && n2 >= 0 && n2 < 8) {
            this.spriteData[n2 * 8 + n] = (byte)(this.mousebut == 1 ? 0 : -1);
        }
        this.paintImmediately(2, 2, 64, 64);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        byte[] byArray = this.sprite.get();
        for (int i = 0; i < 64; ++i) {
            byArray[i] = (byte)(this.spriteData[i] + 1);
        }
        this.painter.repaint();
    }

    public void setSprite(AGSprite aGSprite) {
        this.sprite = aGSprite;
        byte[] byArray = this.sprite.get();
        for (int i = 0; i < 64; ++i) {
            this.spriteData[i] = (byte)(byArray[i] - 1);
        }
        this.paintImmediately(2, 2, 64, 64);
    }
}

