/*
 * Decompiled with CFR 0.152.
 */
package AGTEdit;

import AGTEdit.AGBounce;
import AGTEdit.AGComment;
import AGTEdit.AGCounter;
import AGTEdit.AGEvent;
import AGTEdit.AGFlipper;
import AGTEdit.AGGizmo;
import AGTEdit.AGObject;
import AGTEdit.AGTimer;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AGTable {
    public static final int XSIZE = 96;
    public static final int YSIZE = 160;
    private String name;
    private byte[] table;
    private DefaultListModel objects = new DefaultListModel();

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void add(AGObject aGObject) {
        this.objects.addElement(aGObject);
    }

    public void remove(AGObject aGObject) {
        this.objects.removeElement(aGObject);
    }

    public void remove(int n) {
        this.objects.removeElementAt(n);
    }

    public void removeAllObjects() {
        this.objects.removeAllElements();
    }

    public void insert(AGObject aGObject, int n) {
        this.objects.insertElementAt(aGObject, n);
    }

    public int getCount() {
        return this.objects.size();
    }

    public AGObject get(int n) {
        return (AGObject)this.objects.elementAt(n);
    }

    public DefaultListModel getObjects() {
        return this.objects;
    }

    public Vector getObjects(int n) {
        Vector<AGObject> vector = new Vector<AGObject>(10, 10);
        vector.add(AGObject.getDummy());
        for (int i = 0; i < this.objects.size(); ++i) {
            if (((AGObject)this.objects.elementAt(i)).getType() != n) continue;
            vector.add((AGObject)this.objects.elementAt(i));
        }
        return vector;
    }

    public Vector getCleanObjects(int n) {
        Vector vector = new Vector(10, 10);
        for (int i = 0; i < this.objects.size(); ++i) {
            if (((AGObject)this.objects.elementAt(i)).getType() != n) continue;
            vector.add(this.objects.elementAt(i));
        }
        return vector;
    }

    public String[] getNames() {
        AGObject[] aGObjectArray = (AGObject[])this.objects.toArray();
        String[] stringArray = new String[aGObjectArray.length];
        for (int i = 0; i < aGObjectArray.length; ++i) {
            stringArray[i] = aGObjectArray[i].getName();
        }
        return stringArray;
    }

    public void setTable(byte[] byArray) {
        this.table = byArray;
    }

    public byte[] getTable() {
        return this.table;
    }

    public boolean open(String string) {
        try {
            Object object;
            Object object2;
            Object object3;
            int n;
            Vector<Object> vector = new Vector<Object>(10, 10);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Element element = documentBuilderFactory.newDocumentBuilder().parse(string).getDocumentElement();
            if (!element.getTagName().equals("AGTable")) {
                return false;
            }
            String string2 = element.getElementsByTagName("Name").item(0).getFirstChild().getNodeValue();
            String string3 = element.getElementsByTagName("TableData").item(0).getFirstChild().getNodeValue();
            NodeList nodeList = element.getElementsByTagName("ObjectData").item(0).getChildNodes();
            class ObjectIDPair {
                public int id = 0;
                public AGObject o = AGObject.getDummy();
                public Element e = null;

                ObjectIDPair() {
                }
            }
            vector.add(new ObjectIDPair());
            for (n = 0; n < nodeList.getLength(); ++n) {
                AGObject aGObject;
                if (!(nodeList.item(n) instanceof Element)) continue;
                object3 = (Element)nodeList.item(n);
                object2 = object3.getNodeName();
                object = new ObjectIDPair();
                ((ObjectIDPair)object).id = Integer.parseInt(object3.getAttributeNode("id").getValue());
                if (((String)object2).equals("Gizmo")) {
                    ((ObjectIDPair)object).o = aGObject = new AGGizmo();
                    aGObject.setName(object3.getAttributeNode("name").getValue());
                    ((AGGizmo)aGObject).setX(Integer.parseInt(object3.getAttributeNode("x").getValue()));
                    ((AGGizmo)aGObject).setY(Integer.parseInt(object3.getAttributeNode("y").getValue()));
                    ((AGGizmo)aGObject).setW(Integer.parseInt(object3.getAttributeNode("w").getValue()));
                    ((AGGizmo)aGObject).setH(Integer.parseInt(object3.getAttributeNode("h").getValue()));
                    ((AGGizmo)aGObject).setFlags(Integer.parseInt(object3.getAttributeNode("flags").getValue()));
                    ((AGGizmo)aGObject).getSprite().set(this.stringArray(object3.getElementsByTagName("Sprite").item(0).getFirstChild().getNodeValue()));
                    ((AGGizmo)aGObject).getEvents().removeAllElements();
                    ((ObjectIDPair)object).e = (Element)object3.getElementsByTagName("Events").item(0);
                    vector.add(object);
                } else if (((String)object2).equals("Timer")) {
                    ((ObjectIDPair)object).o = aGObject = new AGTimer();
                    aGObject.setName(object3.getAttributeNode("name").getValue());
                    ((AGTimer)aGObject).setVal(Integer.parseInt(object3.getAttributeNode("value").getValue()));
                    ((AGTimer)aGObject).getEvents().removeAllElements();
                    ((ObjectIDPair)object).e = (Element)object3.getElementsByTagName("Events").item(0);
                    vector.add(object);
                } else if (((String)object2).equals("Counter")) {
                    ((ObjectIDPair)object).o = aGObject = new AGCounter();
                    aGObject.setName(object3.getAttributeNode("name").getValue());
                    ((AGCounter)aGObject).setVal(Integer.parseInt(object3.getAttributeNode("value").getValue()));
                    ((AGCounter)aGObject).getEvents().removeAllElements();
                    ((ObjectIDPair)object).e = (Element)object3.getElementsByTagName("Events").item(0);
                    vector.add(object);
                } else if (((String)object2).equals("Bounce")) {
                    ((ObjectIDPair)object).o = aGObject = new AGBounce();
                    aGObject.setName(object3.getAttributeNode("name").getValue());
                    ((AGBounce)aGObject).setX(Integer.parseInt(object3.getAttributeNode("x").getValue()));
                    ((AGBounce)aGObject).setY(Integer.parseInt(object3.getAttributeNode("y").getValue()));
                    ((AGBounce)aGObject).setW(Integer.parseInt(object3.getAttributeNode("w").getValue()));
                    ((AGBounce)aGObject).setH(Integer.parseInt(object3.getAttributeNode("h").getValue()));
                    vector.add(object);
                } else if (((String)object2).equals("Flipper")) {
                    ((ObjectIDPair)object).o = aGObject = new AGFlipper();
                    aGObject.setName(object3.getAttributeNode("name").getValue());
                    ((AGFlipper)aGObject).setX(Integer.parseInt(object3.getAttributeNode("x").getValue()));
                    ((AGFlipper)aGObject).setY(Integer.parseInt(object3.getAttributeNode("y").getValue()));
                    ((AGFlipper)aGObject).setDir(Integer.parseInt(object3.getAttributeNode("dir").getValue()));
                    vector.add(object);
                }
                if (!((String)object2).equals("Comment")) continue;
                ((ObjectIDPair)object).o = aGObject = new AGComment();
                aGObject.setName(object3.getAttributeNode("name").getValue());
                vector.add(object);
            }
            for (n = 0; n < vector.size(); ++n) {
                object3 = (ObjectIDPair)vector.elementAt(n);
                object2 = null;
                switch (((ObjectIDPair)object3).o.getType()) {
                    case 1: {
                        object2 = ((AGGizmo)((ObjectIDPair)object3).o).getEvents();
                        break;
                    }
                    case 2: {
                        object2 = ((AGTimer)((ObjectIDPair)object3).o).getEvents();
                        break;
                    }
                    case 3: {
                        object2 = ((AGCounter)((ObjectIDPair)object3).o).getEvents();
                    }
                }
                if (object2 == null || !((ObjectIDPair)object3).e.hasChildNodes()) continue;
                object = ((ObjectIDPair)object3).e.getElementsByTagName("Event");
                for (int i = 0; i < object.getLength(); ++i) {
                    Element element2 = (Element)object.item(i);
                    AGEvent aGEvent = new AGEvent();
                    aGEvent.setType(AGEvent.getType(element2.getAttributeNode("type").getValue()));
                    aGEvent.setVal(Integer.parseInt(element2.getAttributeNode("val").getValue()));
                    aGEvent.setBonus(Integer.parseInt(element2.getAttributeNode("bonus").getValue()));
                    aGEvent.setObject(AGObject.getDummy());
                    for (int j = 0; j < vector.size(); ++j) {
                        ObjectIDPair objectIDPair = (ObjectIDPair)vector.elementAt(j);
                        if (objectIDPair.id != Integer.parseInt(element2.getAttributeNode("object").getValue())) continue;
                        aGEvent.setObject(objectIDPair.o);
                    }
                    ((DefaultListModel)object2).addElement(aGEvent);
                }
            }
            this.name = string2;
            this.stringArray(string3, this.table);
            this.objects.removeAllElements();
            for (n = 1; n < vector.size(); ++n) {
                this.objects.addElement(((ObjectIDPair)vector.elementAt((int)n)).o);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean save(String string) {
        try {
            int n;
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fileOutputStream), "UTF-8");
            outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            outputStreamWriter.write("<AGTable>\r\n");
            outputStreamWriter.write("<Name>" + this.name + "</Name>\r\n");
            outputStreamWriter.write("<ObjectData>\r\n");
            block10: for (n = 0; n < this.getCount(); ++n) {
                AGObject aGObject = this.get(n);
                switch (aGObject.getType()) {
                    case 1: {
                        AGObject aGObject2 = (AGGizmo)aGObject;
                        outputStreamWriter.write("<Gizmo id=\"" + aGObject.getID() + "\" name=\"" + aGObject.getName() + "\"" + " x=\"" + ((AGGizmo)aGObject2).getX() + "\" y=\"" + ((AGGizmo)aGObject2).getY() + "\" w=\"" + ((AGGizmo)aGObject2).getW() + "\" h=\"" + ((AGGizmo)aGObject2).getH() + "\"" + " flags=\"" + ((AGGizmo)aGObject2).getFlags() + "\">\r\n");
                        outputStreamWriter.write("<Sprite>");
                        byte[] byArray = ((AGGizmo)aGObject2).getSprite().get();
                        for (int i = 0; i < byArray.length; ++i) {
                            outputStreamWriter.write(byArray[i] + 48);
                        }
                        outputStreamWriter.write("</Sprite>\r\n");
                        this.writeEventList(outputStreamWriter, ((AGGizmo)aGObject2).getEvents());
                        outputStreamWriter.write("</Gizmo>\r\n");
                        continue block10;
                    }
                    case 2: {
                        AGObject aGObject2 = (AGTimer)aGObject;
                        outputStreamWriter.write("<Timer id=\"" + aGObject.getID() + "\" name=\"" + aGObject.getName() + "\" value=\"" + ((AGTimer)aGObject2).getVal() + "\">\r\n");
                        this.writeEventList(outputStreamWriter, ((AGTimer)aGObject2).getEvents());
                        outputStreamWriter.write("</Timer>\r\n");
                        continue block10;
                    }
                    case 3: {
                        AGObject aGObject2 = (AGCounter)aGObject;
                        outputStreamWriter.write("<Counter id=\"" + aGObject.getID() + "\" name=\"" + aGObject.getName() + "\" value=\"" + ((AGCounter)aGObject2).getVal() + "\">\r\n");
                        this.writeEventList(outputStreamWriter, ((AGCounter)aGObject2).getEvents());
                        outputStreamWriter.write("</Counter>\r\n");
                        continue block10;
                    }
                    case 4: {
                        AGObject aGObject2 = (AGBounce)aGObject;
                        outputStreamWriter.write("<Bounce id=\"" + aGObject.getID() + "\" name=\"" + aGObject.getName() + "\"" + " x=\"" + ((AGBounce)aGObject2).getX() + "\" y=\"" + ((AGBounce)aGObject2).getY() + "\" w=\"" + ((AGBounce)aGObject2).getW() + "\" h=\"" + ((AGBounce)aGObject2).getH() + "\"/>\r\n");
                        continue block10;
                    }
                    case 5: {
                        AGObject aGObject2 = (AGFlipper)aGObject;
                        outputStreamWriter.write("<Flipper id=\"" + aGObject.getID() + "\" name=\"" + aGObject.getName() + "\"" + " x=\"" + ((AGFlipper)aGObject2).getX() + "\" y=\"" + ((AGFlipper)aGObject2).getY() + "\" dir=\"" + ((AGFlipper)aGObject2).getDir() + "\"/>\r\n");
                        continue block10;
                    }
                    case 6: {
                        AGObject aGObject2 = (AGComment)aGObject;
                        outputStreamWriter.write("<Comment id=\"" + aGObject.getID() + "\" name=\"" + aGObject.getName() + "\"/>\r\n");
                    }
                }
            }
            outputStreamWriter.write("</ObjectData>\r\n");
            outputStreamWriter.write("<TableData>");
            for (n = 0; n < this.table.length; ++n) {
                outputStreamWriter.write(this.table[n] + 48);
            }
            outputStreamWriter.write("</TableData>\r\n");
            outputStreamWriter.write("</AGTable>\r\n");
            outputStreamWriter.flush();
            outputStreamWriter.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void writeEventList(OutputStreamWriter outputStreamWriter, DefaultListModel defaultListModel) throws IOException {
        if (defaultListModel.size() > 0) {
            outputStreamWriter.write("<Events>\r\n");
            for (int i = 0; i < defaultListModel.size(); ++i) {
                AGEvent aGEvent = (AGEvent)defaultListModel.elementAt(i);
                outputStreamWriter.write("<Event type=\"" + aGEvent.getName().trim() + "\" " + "val=\"" + aGEvent.getVal() + "\" bonus=\"" + aGEvent.getBonus() + "\" " + "object=\"" + aGEvent.getObject().getID() + "\"/>\r\n");
            }
            outputStreamWriter.write("</Events>\r\n");
        } else {
            outputStreamWriter.write("<Events/>\r\n");
        }
    }

    private byte[] stringArray(String string) {
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)Character.digit(string.charAt(i), 10);
        }
        return byArray;
    }

    private void stringArray(String string, byte[] byArray) {
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = (byte)Character.digit(string.charAt(i), 10);
        }
    }

    public byte[] export() {
        byte[] byArray;
        AGObject aGObject;
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        byte[] byArray2 = new byte[8192];
        Vector vector = this.getCleanObjects(1);
        Vector vector2 = this.getCleanObjects(2);
        Vector vector3 = this.getCleanObjects(3);
        Vector vector4 = this.getCleanObjects(4);
        Vector vector5 = this.getCleanObjects(5);
        this.fillBinID(vector);
        this.fillBinID(vector2);
        this.fillBinID(vector3);
        byArray2[0] = 83;
        byArray2[1] = 12;
        byArray2[2] = -39;
        byArray2[3] = -102;
        byte[] byArray3 = new byte[1];
        try {
            byArray3 = this.name.getBytes("iso-8859-1");
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (n4 = 0; n4 < byArray3.length; ++n4) {
            byArray2[n4 + 6] = byArray3[n4];
        }
        int n5 = byArray3.length + 11;
        byArray2[n5++] = (byte)vector.size();
        byArray2[n5++] = (byte)vector2.size();
        byArray2[n5++] = (byte)vector3.size();
        byArray2[n5++] = (byte)vector4.size();
        byArray2[n5++] = (byte)vector5.size();
        for (n4 = 0; n4 < vector5.size(); ++n4) {
            object = (AGFlipper)vector5.elementAt(n4);
            byArray2[n5++] = (byte)(((AGFlipper)object).getX() + (((AGFlipper)object).getDir() == 1 ? 128 : 0));
            byArray2[n5++] = (byte)((AGFlipper)object).getY();
        }
        for (n4 = 0; n4 < 160; ++n4) {
            for (n3 = 0; n3 < 12; ++n3) {
                n2 = 0;
                for (n = 0; n < 8; ++n) {
                    n2 |= (this.table[n4 * 96 + (n3 << 3) + n] & 1) << 7 - n;
                }
                byArray2[n5++] = (byte)n2;
            }
        }
        object = this.generateSlopes();
        byte[] byArray4 = this.compressSlopes((int[])object);
        byArray2[n5++] = (byte)byArray4.length;
        byArray2[n5++] = (byte)(byArray4.length >> 8);
        for (n4 = 0; n4 < byArray4.length; ++n4) {
            byArray2[n5++] = byArray4[n4];
        }
        n2 = n5;
        n5 += 2;
        for (n4 = 0; n4 < vector.size(); ++n4) {
            aGObject = (AGGizmo)vector.elementAt(n4);
            byArray2[n5++] = (byte)((AGGizmo)aGObject).getFlags();
            byArray2[n5++] = (byte)((AGGizmo)aGObject).getX();
            byArray2[n5++] = (byte)((AGGizmo)aGObject).getY();
            byArray2[n5++] = (byte)(((AGGizmo)aGObject).getX() + ((AGGizmo)aGObject).getW());
            byArray2[n5++] = (byte)(((AGGizmo)aGObject).getY() + ((AGGizmo)aGObject).getH());
            if (((AGGizmo)aGObject).getSpriteFlag()) {
                byArray = ((AGGizmo)aGObject).getSprite().get();
                for (n3 = 0; n3 < 8; ++n3) {
                    int n6 = 0;
                    for (n = 0; n < 8; ++n) {
                        n6 += byArray[n3 * 8 + n] << 7 - n;
                    }
                    byArray2[n5++] = (byte)n6;
                }
            }
            byArray = this.generateBinEvents(((AGGizmo)aGObject).getEvents());
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray2[n5++] = byArray[n3];
            }
            byArray2[n5++] = 0;
        }
        for (n4 = 0; n4 < vector2.size(); ++n4) {
            aGObject = (AGTimer)vector2.elementAt(n4);
            byArray2[n5++] = (byte)((AGTimer)aGObject).getVal();
            byArray = this.generateBinEvents(((AGTimer)aGObject).getEvents());
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray2[n5++] = byArray[n3];
            }
            byArray2[n5++] = 0;
        }
        for (n4 = 0; n4 < vector3.size(); ++n4) {
            aGObject = (AGCounter)vector3.elementAt(n4);
            byArray2[n5++] = (byte)((AGCounter)aGObject).getVal();
            byArray = this.generateBinEvents(((AGCounter)aGObject).getEvents());
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray2[n5++] = byArray[n3];
            }
            byArray2[n5++] = 0;
        }
        for (n4 = 0; n4 < vector4.size(); ++n4) {
            aGObject = (AGBounce)vector4.elementAt(n4);
            byArray2[n5++] = (byte)((AGBounce)aGObject).getX();
            byArray2[n5++] = (byte)((AGBounce)aGObject).getY();
            byArray2[n5++] = (byte)(((AGBounce)aGObject).getX() + ((AGBounce)aGObject).getW());
            byArray2[n5++] = (byte)(((AGBounce)aGObject).getY() + ((AGBounce)aGObject).getH());
        }
        n = n5 - n2 - 2;
        byArray2[n2++] = (byte)n;
        byArray2[n2] = (byte)(n >> 8);
        if (n + vector.size() * 2 + 1 + vector2.size() * 2 + 1 + vector3.size() * 2 + 1 > 1000) {
            byArray2[0] = 0;
        }
        n = n5 - 6;
        byArray2[4] = (byte)n;
        byArray2[5] = (byte)(n >> 8);
        n = 0;
        for (n4 = 6; n4 < n5; ++n4) {
            if (byArray2[n4] >= 0) {
                n += byArray2[n4];
                continue;
            }
            n += byArray2[n4] + 256;
        }
        byArray2[n5++] = (byte)n;
        byArray2[n5++] = (byte)(n >> 8);
        byte[] byArray5 = new byte[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            byArray5[n4] = byArray2[n4];
        }
        return byArray5;
    }

    private int[] generateSlopes() {
        int n;
        int n2;
        double d;
        double d2;
        int n3;
        int n4;
        int[] nArray = new int[15360];
        int[] nArray2 = new int[15360];
        double[] dArray = new double[256];
        for (n4 = 0; n4 < 256; ++n4) {
            dArray[n4] = Math.sin(Math.PI * (double)n4 / 128.0) * 256.0;
        }
        for (n4 = 0; n4 < 160; ++n4) {
            for (n3 = 0; n3 < 96; ++n3) {
                if ((this.table[n4 * 96 + n3] & 2) != 0) {
                    d2 = 0.0;
                    d = 0.0;
                    for (n2 = n4 - 1; n2 <= n4 + 1; ++n2) {
                        for (n = n3 - 1; n <= n3 + 1; ++n) {
                            if ((this.tableByte(n, n2) & 2) != 0) continue;
                            d += (double)(n - n3);
                            d2 += (double)(n2 - n4);
                        }
                    }
                    nArray[n4 * 96 + n3] = this.vectorAngle(d, d2);
                    continue;
                }
                nArray[n4 * 96 + n3] = 0;
            }
        }
        System.out.println();
        for (n4 = 0; n4 < 160; ++n4) {
            for (n3 = 0; n3 < 96; ++n3) {
                if ((this.tableByte(n3, n4) & 2) == 0 || (this.tableByte(n3, n4) & 4) == 4 || (this.tableByte(n3 - 1, n4 - 1) & 2) + (this.tableByte(n3, n4 - 1) & 2) + (this.tableByte(n3 + 1, n4 - 1) & 2) + (this.tableByte(n3 - 1, n4) & 2) + (this.tableByte(n3 + 1, n4) & 2) + (this.tableByte(n3 - 1, n4 + 1) & 2) + (this.tableByte(n3, n4 + 1) & 2) + (this.tableByte(n3 + 1, n4 + 1) & 2) == 16) {
                    nArray2[n4 * 96 + n3] = 0;
                    continue;
                }
                d2 = 0.0;
                d = 0.0;
                for (n2 = n4 - 1; n2 <= n4 + 1; ++n2) {
                    for (n = n3 - 1; n <= n3 + 1; ++n) {
                        if (this.slopeByte(n, n2, nArray) == 0) continue;
                        d += dArray[this.slopeByte(n, n2, nArray)];
                        d2 += dArray[this.slopeByte(n, n2, nArray) - 64 & 0xFF];
                    }
                }
                nArray2[n4 * 96 + n3] = this.vectorAngle(d, d2);
            }
        }
        return nArray2;
    }

    private int vectorAngle(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return 0;
        }
        int n = (int)(Math.atan2(d, -d2) * 128.0 / Math.PI) & 0xFF;
        return n == 0 ? 1 : n;
    }

    private byte tableByte(int n, int n2) {
        if (n >= 0 && n < 96 && n2 >= 0 && n2 < 160) {
            return this.table[n2 * 96 + n];
        }
        return 3;
    }

    private int slopeByte(int n, int n2, int[] nArray) {
        if (n >= 0 && n < 96 && n2 >= 0 && n2 < 160) {
            return nArray[n2 * 96 + n];
        }
        return 0;
    }

    private byte[] compressSlopes(int[] nArray) {
        int n;
        int n2;
        int n3;
        int[] nArray2 = new int[7680];
        int[] nArray3 = new int[7680];
        for (n3 = 0; n3 < 80; ++n3) {
            for (n2 = 0; n2 < 48; ++n2) {
                n = nArray[(n3 << 1) * 96 + (n2 << 1)];
                if (n == 0) {
                    n = nArray[(n3 << 1) * 96 + (n2 << 1) + 1];
                }
                if (n == 0) {
                    n = nArray[((n3 << 1) + 1) * 96 + (n2 << 1)];
                }
                if (n == 0) {
                    n = nArray[((n3 << 1) + 1) * 96 + (n2 << 1) + 1];
                }
                nArray2[n3 * 48 + n2] = n;
            }
        }
        n2 = 3840;
        int n4 = 0;
        n3 = 0;
        while (n2 > 0) {
            if (nArray2[n3] == 0) {
                ++n3;
                nArray3[n4++] = 0;
                for (n = 0; n < 255 && n2 > 0; ++n, --n2) {
                    if (nArray2[n3++] == 0) continue;
                    nArray3[n4++] = n;
                    nArray3[n4++] = nArray2[n3 - 1];
                    n = 256;
                }
                if (n == 255) {
                    nArray3[n4++] = 255;
                }
                if (n2 <= 0) {
                    nArray3[n4++] = n - 1;
                }
            }
            if (nArray2[n3] == 0) continue;
            nArray3[n4++] = nArray2[n3++];
            --n2;
        }
        byte[] byArray = new byte[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            byArray[n3] = (byte)nArray3[n3];
        }
        return byArray;
    }

    private byte[] generateBinEvents(DefaultListModel defaultListModel) {
        int n;
        byte[] byArray = new byte[2048];
        int n2 = 0;
        block7: for (n = 0; n < defaultListModel.size(); ++n) {
            AGEvent aGEvent = (AGEvent)defaultListModel.elementAt(n);
            byArray[n2++] = (byte)aGEvent.getType();
            switch (aGEvent.getType()) {
                case 1: {
                    byArray[n2++] = (byte)aGEvent.getVal();
                    byArray[n2++] = (byte)(aGEvent.getVal() >> 8);
                    byArray[n2++] = (byte)aGEvent.getBonus();
                    byArray[n2++] = (byte)(aGEvent.getBonus() >> 8);
                    continue block7;
                }
                case 3: {
                    byArray[n2++] = (byte)aGEvent.getObject().getBinID();
                    byArray[n2++] = (byte)(aGEvent.getVal() & 0xFE);
                    continue block7;
                }
                case 4: {
                    byArray[n2++] = (byte)aGEvent.getObject().getBinID();
                    byArray[n2++] = (byte)(aGEvent.getVal() | 1);
                    continue block7;
                }
                case 7: 
                case 9: {
                    byArray[n2++] = (byte)aGEvent.getObject().getBinID();
                    byArray[n2++] = (byte)aGEvent.getVal();
                    continue block7;
                }
                case 5: 
                case 6: 
                case 8: {
                    byArray[n2++] = (byte)aGEvent.getObject().getBinID();
                }
            }
        }
        byte[] byArray2 = new byte[n2];
        for (n = 0; n < n2; ++n) {
            byArray2[n] = byArray[n];
        }
        return byArray2;
    }

    private void fillBinID(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            ((AGObject)vector.elementAt(i)).setBinID(i);
        }
    }

    public void copyDeco() {
        for (int i = 0; i < this.table.length; ++i) {
            if ((this.table[i] & 1) == 1) {
                int n = i;
                this.table[n] = (byte)(this.table[n] | 2);
                continue;
            }
            int n = i;
            this.table[n] = (byte)(this.table[n] & 0xFFFFFFFD);
        }
    }
}

