;SOURCE CODE FOR ZRUN 1.1
;(C) David Lindstrm 2002
;E-mail: okvin@tiscali.se homepage: http://cirrus.tigalaxy.com

;Runs Ti-BASIC and asm programs both from RAM and archive.
;Str0=name of program to run

.nolist			
	#include "ti83plus.inc"
.org userMem-2
.db $BB,$6D
.list
		
#define prog_executing 1
#define minne appbackupscreen+600
#define variabel keytostrram
#define flash_adress keytostrram+2
#define programstorlek keytostrram+4

 ld hl,str0
 rst 20h
 rst 10h
 ret c
 bcall(_zeroop1)
 ex de,hl
 ld c,(hl)
 inc hl
 ld b,(hl)
 inc hl
 ld de,op1
 ld a,progobj
 ld (de),a
 inc de
 ldir
 bcall(_chkfindsym)
 ret c

	
exekvera:
 ld a,b
 or a				;Is program archived?
 jr nz,readflash	;Then read the size and the two first bytes from archived prog.
 ex de,hl
 push AF		;Flash page=0	
 ld c,(hl)
 inc hl
 ld b,(hl)
 push bc		;save size
 push HL		;And address
 inc hl


 bcall(_ldhlind)
 ld de,$6DBB	 ;See if the first 2 bytes of the program=AsmPrgm token
 bcall(_cpHLDE)  ;Compare with de
 jr z,asmprogram ;If asm program, jump and run it
 pop HL
 pop HL
 pop HL
runbasic:
 set prog_executing,(iy+newdispf)	;Needs to be set when running basic programs
 bcall(_parseinp)					;Run IT
 bcall(_cleanall)		;Delete temporary vars generated by the program
 jp deltempprog		;Delete prgmN141.


readflash:

 push af	;Save the flash page
 ex de,hl	;HL=pointer to archived program
 inc hl					;Skip the data valid flag
 push hl				;Save the flash address

 bcall(_loaddeindpaged) ;This will load DE with program size
;Calculate Name length... 
 ex de,hl			;DE=program size, now in HL
 ld d,a

 push hl
 ld hl,op1
 bcall(_strlength)
 ld a,c
 add a,8
 ld c,a
 pop hl

  
 scf
 sbc hl,bc	;Subtract bc from hl
 ld a,d		;A=flash page
 pop DE		;Address->DE
 inc hl
 push HL	;Save new size

 ex de,hl	;Address->HL
 add HL,BC	
 	;
 ld b,a
 inc hl
 push HL	;Save new address
 inc hl
 bcall(_loaddeindpaged)	

 ld hl,$6DBB
 bcall(_cphlde)	;IF Z=1, then it's an asm program
 jr z,asmprogram
;Archived basic program...
 call deltempprog

 pop de
 pop HL		;Size
 push de
 push HL	;Save size
 bcall(_createprog)
 inc de
 inc de		;Skip size bytes

 pop bc
 pop HL
 inc hl
 pop af
 bcall(_flashtoram)
 ld hl,tempprog
 rst 20h	
 jr runbasic
 


asmprogram:
 ld hl,insertmem
 rst 20h		;Copy memory insert routine to OP1
;Set up the Regs for _insertmem
 pop bc	;Address
 pop HL	;Size
 push BC
;Save amount
 bcall(_enoughmem)
 ex de,hl
 jp c,memerror
 push HL
 ld de,usermem
 jp OP1			;Jump to our mem insert routine in op1

;BC=Size
;Stack entry #1=Address
;#2=Flash page
installer:
 pop HL
 inc hl
 inc hl
 inc hl
 ld de,usermem
 pop AF
 push BC	
 or a
 jr nz,copyz80
 Add hl,bc	;Get the right pointer to the program if in RAM

copyz80:
 bcall(_flashtoram)	;Copy from FLASH->RAM
 							;psst! If a=0, flashtoram will copy from RAM to RAM :)
runZ80:
 call usermem		;Run the program
cleanupprog:
 pop bc
 ld hl,delmem
 add hl,bc
 push BC
 rst 20h	;Copy our clean up routine to OP1
 pop DE	;Size
 jp OP1 	;Delete the program from usermem and redraw GUI

insertmem:
 bcall(_insertmem)
 pop bc
 ld hl,installer
 add hl,bc
 jp (hl)

delmem:
 ld hl,usermem
 bcall(_delmem)
m2:
 ret


memerror:;Come here if not enough RAM
 pop HL	;Address
 pop HL	;Flash page
 ret

tempprog:
.db progobj,"N141",0
str0
.db StrngObj,tvarstrng,tstr0,0

deltempprog:		;Delete prgmN141 generated when running archived programs
 ld hl,tempprog	
 rst 20h
 bcall(_chkfindsym)
 bcallnc(_delvararc)	;Delete N141 if already present
 ret

 .end
