;Fifteen v1.1
;(c)2007 Robbie McElrath
;
;This game is based on the classing 15 game
;Arrange the slide puzzle from 1 to 15
;
.binarymode TI8X

.include "../ti83plus.inc"
.include "../mirage.inc"

.define	m1	AppBackUpScreen

.define	buf		m1+0
.define	zero		m1+16
.define	temp		m1+17

.org $9D93
.db $BB,$6D,$C9,$01
.db $00,$00,$00,$00,$39,$F8,$39,$F8,$39,$F8,$39,$C0,$39,$F8,$39
.db $F8,$39,$F8,$38,$38,$39,$F8,$39,$F8,$39,$F8,$00,$00,$00,$00

Descript:
.db "Fifteen v1.1",0

Start:
	set	textwrite,(iy+sgrflags)
	res	indicrun,(iy+indicflags)

	;setup board
	ld	hl,temp_board
	ld	de,buf
	ld	bc,17
	ldir

mix:
	ld	b,32
	push	bc
	call	getrand
	ex	de,hl
	push	de
	call	getrand
	pop	de
	ld	c,(hl)
	ld	a,(de)
	ld	(hl),a
	ld	a,c
	ld	(de),a
	pop	bc
	djnz	mix+2

	;check if the puzzle is solvable
	ld	hl,buf
	ld	de,smc2
	xor	a
	ld	(smc2),a
	ld	a,14
	ld	(smc1),a
chk_loop:
	push	hl
	ld	a,(hl)
	ld	b,14 \ smc1 = $-1
-:	inc	hl
	cp	(hl)
	jr	c,$+5
	ex	de,hl
	inc	(hl)
	ex	de,hl
	djnz	{-}
	pop	hl
	inc	hl
	ld	a,(smc1)
	dec	a
	ld	(smc1),a
	ld	bc,buf+16-2
	call	cphlbc
	jr	c,chk_loop
	ld	a,0 \ smc2 = $-1
	rrca
	jr	c,mix

	call	disp_all

Main_Loop:
	ei
	halt
	bcall(_getcsc)
	cp	skGraph 	\ ret z
	cp	skTrace 	\ jr z,Start
	cp	skLeft		\ jr z,Left
	cp	skRight		\ jr z,Right
	cp	skUp		\ jr z,Up
	cp	skDown		\ jr z,Down
	jr	Main_Loop+1

Left:
	ld	a,(zero)
	and	3
	cp	3 \ jr z,Main_Loop
	ld	hl,buf
	call	getxcoord
	jr	move

Right:
	ld	a,(zero)
	and	3
	or	a \ jr z,Main_Loop
	ld	hl,buf-1
	call	getxcoord
	ex	de,hl
	jr	move

Down:
	ld	a,(zero)
	and	12
	or	a \ jr z,Main_Loop
	ld	hl,buf-4
	call	getycoord
	ex	de,hl
	jr	move

Up:
	ld	a,(zero)
	and	12
	cp	12 \ jr z,Main_Loop
	ld	hl,buf
	call	getycoord

move:
	;de = move, hl = zero
	ld	a,(de)
	ld	(hl),a
	xor	a
	ld	(de),a
	ex	de,hl
	ld	de,buf \ or a
	sbc	hl,de
	ld	a,l
	ld	(zero),a
	call	disp_all

	;check if won
	ld	hl,buf
	ld	bc,$0F00
check_won:
	ld	a,(hl)
	inc	c
	sub	c \ jp nz,Main_Loop
	inc	hl
	djnz	check_won

	call	disp_all
	ld	hl,plotsscreen+(28*12)
	ld	bc,7*12
	ld	a,$FF
	bcall(_memset)
	set	3,(iy+5)
	ld	hl,txt_won
	ld	a,28
	call	centertext
	res	3,(iy+5)
	call	fastcopy
pause:
	bcall(_getcsc)
	or	a \ jr z,pause
	cp	skGraph \ ret z
	jp	Start

getxcoord:
	ld	a,(zero)
	ld	e,a
	ld	d,0
	add	hl,de
	push	hl
	pop	de
	inc	de
	ret
getycoord:
	call	getxcoord
	ld	a,e
	add	a,3
	ld	e,a
	ret

getrand:
	ld	b,15
	call	irandom
	ld	e,a \ ld d,0
	ld	hl,buf
	add	hl,de
	ret

disp_all:
	bcall(_grbufclr)
	ld	hl,plotsscreen+(7*12)
	ld	bc,12
	ld	a,$FF
	bcall(_memset)
	ld	hl,plotsscreen+(57*12)
	ld	bc,12
	ld	a,$FF
	bcall(_memset)
	ld	hl,Descript
	xor	a
	call	centertext
	ld	hl,opts
	ld	de,$3A3F
	call	setvputs

	ld	hl,$1607
	ld	de,$4839
	ld	a,1
	call	fastrectangle

	ld	hl,buf
	ld	b,16
disp:
	ld	a,(hl)
	or	a \ jr z,disp_djnz
	push	hl \ push bc
	ld	(temp),a
	ld	a,16
	sub	b
	rlca \ rlca
	ld	e,a \ ld d,0
	ld	hl,locs
	add	hl,de
	push	hl
	bcall(_ldhlind)
	ld	(PenCol),hl
	ld	a,(temp)
	cp	10 \ jr nc,disp_centered
	inc	l \ inc l
	ld	(PenCol),hl
disp_centered:
	bcall(_setxxop1)
	ld	a,2
	bcall(_dispop1a)
	pop	hl \ push	hl
	bcall(_ldhlind)
	ld	a,h \ ld h,l \ ld l,a
	ex	de,hl
	pop	hl
	inc	hl \ inc hl
	bcall(_ldhlind)
	dec	d \ dec d
	dec	e \ dec e
	ld	a,1
	call	fastrectangle
	pop	bc \ pop hl
disp_djnz:
	inc	hl
	djnz	disp
	jp	fastcopy

temp_board:
 .db 15,14,13,12,11,10,9,8,7,6,5,4,3,2,1,0,15
opts:
 .db "New  | Quit",0
txt_won:
 .db "You Won!",0
locs: 
 .dw $0B1A,$2213,$0B26,$2E13,$0B32,$3A13,$0B3E,$4613
 .dw $171A,$221F,$1726,$2E1F,$1732,$3A1F,$173E,$461F
 .dw $231A,$222B,$2326,$2E2B,$2332,$3A2B,$233E,$462B
 .dw $2F1A,$2237,$2F26,$2E37,$2F32,$3A37,$2F3E,$4637

.end
