
; ------------------------
; Ascii-Table 83
; By Kaid [kaid@excite.fr]
; ------------------------

#DEFINE TITRE "AT-83 by Kaid"
.INCLUDE ZSHELL83.INC


; - Initialisation -

        bcall(CLEARLCD)         ;Clear LCD

        LD B,7                  ;Number of strings to display
        LD HL,Data              ;Points to the strings
        LD DE,0001              ;We start at (0,1)

Show_Str:
        LD (CURSOR_ROW),DE      ;Set cursor position
        bcall(D_ZT_STR)         ;Display the string
        INC DE                  ;Next cursor position
        DJNZ Show_Str           ;Loop until B!=0



; - Main -

        LD B,0                  ;B=0. B contain the character

Loop:

        LD HL,$0501             ;
        LD (CURSOR_ROW),HL      ;
        LD L,B \ LD H,0         ;HL=B
        bcall(D_HL_DECI)        ;Show the ASCII Code


        LD HL,$0803             ;
        LD (CURSOR_ROW),HL      ;
        LD A,B                  ;
        bcall(TX_CHARPUT)       ;Show the character

        bcall(_getkey)          ;Wait for keypress

        CP K_MODE               ;[MODE] pressed ?
        RET Z                   ; Bye ...

        LD C,0                  ;C=Upper bound

        CP K_UP                 ;[UP] pressed ?
        JR Z,IncCar 

        CP K_RIGHT              ;[RIGHT] pressed ?
        JR Z,I10Car 

        LD C,242                ;C=Lower bound

        CP K_DOWN               ;[DOWN] pressed ?
        JR Z,DecCar  

        CP K_LEFT               ;[LEFT] not pressed ?
        JR NZ,Loop              ; We return to 'Loop'


; - Sub 10 to the code -
D10Car:
        
        LD A,B \ SUB 10 \ LD B,A
        JR Test_ASCII_Code         ;Go to 'Test_ASCII_Code'

; - Add 10 to the code -
I10Car:
        LD A,B \ ADD A,10 \ LD B,A
        JR Test_ASCII_Code         ;Go to 'Test_ASCII_Code'

                      
; - Decrement the code -
DecCar:
        DEC B                   
        JR Test_ASCII_Code         ;Go to 'Test_ASCII_Code'

; - Increment the code -
IncCar:
        INC B                     



; - Test if the code is lower than 0 or upper than 243 and put in B a good
;   code -    

Test_ASCII_Code:

        LD A,B \ CP 243         ;A=Code                
        JR C,Loop               

        LD B,C                          
        JR Loop                 


; - Strings -
Data .DB "Code",0
     .DB 0   
     .DB "Char",0
     .DB 0  
     .DB "   ",7,  " -1  +1 ",6,0
     .DB "  ",207," -10  +10 ",223,0
     .DB " ",193,"MODE] to quit",0   

.END
