	.nolist		
	#include "ion.inc"
	.list		
#ifdef TI83P		
	.org progstart-2
	.db $BB,$6D
MUL_HL = $4276
#else		
	.org progstart
MUL_HL = $4382

#endif		
	xor a	
	jr nc,Start
	.db "Cal 2.6 by Ahmed & Jonah",0


Start:
NewCal:
 ld hl,$0101
 ld (day),hl				;day and week=1
 ld a,(spos)
 ld (pos),a				;starting position
 call LeapCheck				;update length of february
 set 7,(iy+20)			;text goes to graph screen
 bcall(_cleargbuf)
 call invert

;display month/year
 ld hl,Months
 ld a,(month)

;---------= Point hl to string a =---------
; by: Joe Wingerbermuhle
; Input: a=string number (0 to 255)
;	 hl->string data
; Output: hl->string

getString:
 ld b,a
 xor a
getStringL1:
 push bc
 ld c,-1
 cpir
 pop bc
 djnz getStringL1
;hl points to month

 set 3,(iy+$05)
 ld bc,57*256+10
 ld (pencol),bc
 bcall(_vputs)
 ld c,70					;just change column
 ld hl,(year)
 call DispHL

;display S, M, T, W, T, F, S
 ld bc,$0006
 ld hl,Days
PutLoop:
 ld (penCol),bc
 ld a,(hl)
 inc hl
 bcall(_vputmap)
 ld a,c
 add a,13
 ld c,a
 cp 91
 jr c,PutLoop

 res 3,(iy+$05) 

PutCalendar:
 ld a,(pos)				;position*19 = column
 dec a
 ld h,a
 ld l,13
 bcall(MUL_HL)
 ld a,l
 add a,6
 ld c,a					;we have column in c

 ld a,(week)				;week*8 = row
 add a,a
 add a,a
 add a,a
 ld b,a					;and row in b

 ld a,(day)				;we want to display (day)
 call DispA				;disp a loads bc in pencol and displays day

 ld a,(pos)
 inc a
 cp 8					;if Saturday is done, we need new week
 jr nz,same_week
 ld hl,week
 inc (hl)
 ld a,1
same_week:
 ld (pos),a				;update the position [either inc or reset]

 ld a,(month)
 call GetOffset				;get the days in a month

 ld hl,day
 inc (hl)				;advance day.
 sub (hl)				;if we reached all days, then we're done
 inc a
 jr nz,PutCalendar
 res 7,(iy+20)
 bcall(_copygbuf)

DoneDisp:				;basic checking for keys and jump to routines.
 bcall(_getk)
 dec a
 jr z,PastYear
 dec a
 jr z,PrevMonth
 dec a
 jr z,NextMonth
 dec a
 jr z,NextYear
 cp $33
 jr nz,DoneDisp
exit:
 ret

NextYear:
 ld a,(month)
 cp 3
 call nc,new_year
 ld a,(Feb)
 call c,new_year
 sub 27				;if 28 days, then we add 1. if 29 days, then we add 2.
 jr ChangeYear

PastYear:
 ld a,(month)
 cp 3
 call c,last_year
 ld a,(Feb)
 call nc,last_year
 sub 35				;2 day shift if a leap year, 1 day if not.  extra week for reusable comparison
 cpl					;we're going the opposite direction

ChangeYear:
 ld hl,spos			;start position of the month + 1 = start position in a year., 2 days if a leap year
 add a,(hl)					;ie if Jan 99 starts on Friday, Jan 2000 = Sat.
 cp 8					;some checks on the day [if after saturday, make sunday]
 jr c,store_spos
 sub 7				;back a week
store_spos:
 ld (spos),a
 jp NewCal				;draw new calendar

NextMonth:
 ld a,(pos)
 cp 8					;again deal with if it is after saturday, reset to sunday
 jr nz,JumpCheck
 ld a,1
JumpCheck:
 ld (spos),a
 ld hl,month
 inc (hl)				;next month
 ld a,13
 cp (hl)				;if month = 13, make new year
 jp nz,NewCal			;else, continue...
 ld (hl),1
 call new_year			;increase the year
 jp NewCal

PrevMonth:					;goes back a month
 ld a,(month)
 dec a
 jr nz,MonthDone			;when you subtract a month, if not 0, then set month-1
 call last_year				;else decrement year
 ld a,12					;and set month to december
MonthDone:
 ld (month),a
 call GetOffset				;find offset of the new month
 ld b,a
 ld a,(spos)
 sub b
 dec a
add_loop:
 add a,7					;get into a normal 0-6 range
 jr nc,add_loop
 inc a					;put into 1-7 range
 jr store_spos				;finished adding

new_year:
 ld hl,(year)			;increase the year
 inc hl
 jr save_year

last_year:
 ld hl,(year)			;essentially the same as NextYear
 dec hl
save_year:
 ld (year),hl
;now update february's length with LeapCheck


LeapCheck:
 push af
 ld a,28
 ld (Feb),a				;start off with feb's length=28
 pop af

 ld de,4			;check if year is divisible by 4
 call isDivisible
 ret nz

 ld de,100
 call isDivisible
 jr nz,LeapYear				;check if divisible by 100.. if not, then leap year.

 ld de,400					;if it is.. one final check.. is it divisible by 400?
 call isDivisible
 ret nz					;no leap

LeapYear:
 ld hl,Feb
 inc (hl)					;29 days
 ret

isDivisible:				;z flag if year is divisible by de
 ld hl,(year)			;get year
sub_loop:
 or a
 sbc hl,de				;c flag cleared from previous comparisons
 ret z					;divisible
 ret c					;not divisible
 jr sub_loop			;we're not done yet

GetOffset:					;finds # of days in month a
 ld e,a
 ld d,0
 ld hl,Diam
 add hl,de
 ld a,(hl)
 ret

invert:
 ld hl,grbuf
 call StartInvLoop
 ld hl,grbuf+(57*12)
StartInvLoop:
 ld b,12*7
InvLoop:
 ld a,(hl)
 cpl
 ld (hl),a
 inc hl
 djnz InvLoop
 ret


;---------= Display A or HL =------------
DispA:
 ld l,a
 ld h,0
DispHL:
 ld (penCol),bc
 bcall(_setxxxxop2)
 bcall(_op2toop1)
 bcall(_dispop1a)
 ret

;-----------=  Text  =------------
Days:	    .db     "SMTWTFS"

Months:	    .db     0
	    .db     "January",0
	    .db     "February",0
	    .db     "March",0
	    .db     "April",0
	    .db     "May",0
	    .db     "June",0
	    .db     "July",0
	    .db     "August",0
	    .db     "September",0
	    .db     "October",0
	    .db     "November",0
	    .db     "December"


Feb = $+2
Diam: .db 0,31,28,31,30,31,30,31,31,30,31,30,31			;# of days in each month

;saved vars
year:
	.dw 1999
month:
	.db 1
spos:					;starting day of month
	.db 6

;not saved
pos: .db 0
day: .db 0
week: .db 0

.end
END