
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <io.h>
#include <string.h>

#define UINT  unsigned int
#define UCHAR unsigned char

/* Prototypes */
UINT LitFichier(char *fichier,char *buf_dest,UINT buf_taille);
void EcritFichier(char *fichier,char *buf_src,UINT buf_taille);
void GenErreur(char *message,UCHAR code);
void cpstr(char *destination, char *source);
void genheader(char *buffer,UINT taille,char *nom_prog);
void CreeFichier(char *fichier);
void TransBMP(UCHAR *Source);
UINT GetComment(UCHAR *comment);

/* Une petite union pour ne pas s'emmerder avec des masques et des dcalages*/
union nb
{
 char valc[2];
 short vals;
};



/* Lit un fichier binaire */
UINT LitFichier(char *fichier,char *buf_dest,UINT buf_taille)
{
  unsigned int Taille;
  int handle;

  if ((handle=open(fichier,O_RDONLY|O_BINARY))==-1)
    GenErreur("Error on file opening",1);

 /* Lecture du fichier */
 Taille=read(handle,buf_dest,buf_taille);

 if (Taille==-1)
   GenErreur("Error on file reading",1);

 close(handle);

 return Taille;
}


/* Ecrit un fichier binaire */
void EcritFichier(char *fichier,char *buf_src,UINT buf_taille)
{
  FILE *handle;

  if ((handle=fopen(fichier,"wb+"))==NULL)
    GenErreur("Error on file creating",1);

 /* Ecriture du fichier */
 if (fwrite(buf_src,sizeof(char),buf_taille,handle)==-1)
  GenErreur("Error on file writing",1);

 fclose(handle);
}


/* Gnre une erreur */
void GenErreur(char *message,unsigned char code)
{
   printf("%s.\n",message);
   exit(code);
}


/* Copie la chaine <source> vers <destination> avec ajout de '\0' */
void cpstr(char *destination, char *source)
{
 int i=7;

 while(*destination++=*source++)
  i--;

 for(i;i=0;i--)
  *destination++=0;
}


/* Gnre un header 83P */
void genheader(char *buffer,UINT taille,char *nom_prog)
{
 unsigned int i;
 union nb nombre;

 /* Header 1 */
 memcpy(buffer,"**TI83**",8); buffer+=8;
 *buffer++=0x1A;
 *buffer++=0x0A;
 *buffer++=0;

 /* Commentaire */
 memcpy(buffer,"PictView file. By Kaid [kaid@excite.fr]   ",42); buffer+=42;

 /* Header 2 */
 nombre.vals=taille+17;
 *buffer++=nombre.valc[0]; *buffer++=nombre.valc[1];

 nombre.vals=0x000B;
 *buffer++=nombre.valc[0]; *buffer++=nombre.valc[1];

 nombre.vals=taille+2;
 *buffer++=nombre.valc[0]; *buffer++=nombre.valc[1];

 *buffer++=0x06;        /* Programme non ditable */

 /* Copie du nom du programme */
  *buffer++=197;
  cpstr(buffer,nom_prog);
  buffer+=7;

 /* Header 3 */
 *buffer++=nombre.valc[0]; *buffer++=nombre.valc[1];

 nombre.vals=taille;
 *buffer++=nombre.valc[0]; *buffer++=nombre.valc[1];

 /* Permet de reconnaitre les fichiers produits par IVC */
 *buffer++='P';
 *buffer++='V';
 *buffer++='1';
 *buffer++='0';

}


/* Cre le fichier .83P  crire */
void CreeFichier(char fichier[])
{

 unsigned char Destination[2048],Source[2048];
 unsigned char comment[42];
 unsigned char nom_fich[16];

 unsigned short checksum=0;
 unsigned int i,j,TailleImg;

 /* On lit le fichier d'entre */
 TailleImg=LitFichier(fichier,Source,sizeof(Source));

 /* Met dans 'nom_fich' le nom du fichier */
 i=0;
 while(*fichier!='.' && *fichier)
  nom_fich[i++]=*fichier++;
 nom_fich[i]=0;



                        /* On teste le type de fichier */
 if (strcasecmp(fichier,".83I")==0)
 {
   printf("o Format: 83I\n");

   /* Prend le commentaire */
   j=GetComment(comment);
   /* On compresse l'image */
   TailleImg=CompZCP(Source+0x48,Destination+0x48+j+4,756);
 }
 else
  if (strcasecmp(fichier,".BMP")==0)
  {
    printf("o Format: BMP\n");
    /* Prend le commentaire */
    j=GetComment(comment);
    /* Transforme le BMP */
    TransBMP(Source);
    /* On compresse l'image */
    TailleImg=CompZCP(Source+0x3E,Destination+0x48+j+4,768);
  }
  else
   GenErreur("Invalid format",9);

 /* Taille des donnes (Identificateur+Commentaire+Taille de l'image) */
 i=4+j+TailleImg;

 /* Gnre le Header*/
 genheader(Destination,i,nom_fich);

 /* Copie le commentaire */
 cpstr(Destination+0x48+4,comment);

 /* Calcule le checksum*/
 for(j=0x37;j<i+0x48;j++)
  checksum+=Destination[j];

 /* Et l'crit */
 Destination[j++]=checksum&0xFF;
 Destination[j++]=checksum>>8;


 strcat(nom_fich,".83P");
 EcritFichier(nom_fich,Destination,j);

 printf("o %s written\n",nom_fich);
}


/* Transforme le BMP (Rotation 180+Mirroir+Negatif) */
void TransBMP(UCHAR *Source)
{
 unsigned int i,j;
 unsigned char c;

 for(i=0;i<32;i++)
 {
  for(j=0;j<12;j++)
  {
   c=Source[i*12+j+0x3E]^0xFF;
   Source[i*12+j+0x3E]=Source[(63-i)*12+j+0x3E]^0xFF;
   Source[(63-i)*12+j+0x3E]=c;
  }
 }
}

/* Demande un commentaire pour l'image et retourne la taille */
UINT GetComment(UCHAR *comment)
{
  unsigned int j;

 printf("o Your comment [26 chars max]:");
 gets(comment);

 j=strlen(comment);

 /* On teste si le commentaire n'est pas trop grand */
 if (j>26)
  j=26;

 /* Ajoute le 0 final */
 comment[j++]=0;

 return j;
}
