

; PictView v1.0
; By Kaid [kaid@excite.fr]




#DEFINE TITRE "PictView",0
.INCLUDE ZSHELL83.INC

POS_MENU     = saferam3         ;Position dans le menu
NB_FICHIERS  = saferam3+1       ;Nombre de fichiers trouvs
TAB_FICHIERS = saferam3+2       ;Tableau d'adresses des fichiers

; * Recherche des fichiers dans la VAT * 

        XOR A                   ;
        LD (NB_FICHIERS),A      ;On met  zro le nombre de fichiers trouvs

        LD IX,TAB_FICHIERS      ;Tableau o vont tre stock les adresses
        LD HL,(vat)             ;Recherche dans la VAT


Cherche_Boucle:

        PUSH IX
        LD IX,Str_Dct           ;IX pointe sur la chaine de dtection
        CALL ionDetect          ;Fonction de recherche
        POP IX
        JR NZ,Cherche_Fin       ;Si !ZF, plus de fichiers

        LD (IX),L               ;
        INC IX                  ;
        LD (IX),H               ;
        INC IX                  ;Stocke l'adresse du programme

        LD HL,NB_FICHIERS       ;
        INC (HL)                ;Incrmente le nombre de fichiers trouvs

        EX DE,HL                ;Echange DE et HL. 
        JR Cherche_Boucle


Cherche_Fin:

; * Fin de la recherche *
        
        SET 7,(IY+$14)          ;Pour crire aussi dans la mmoire vido
        CALL IniEcran           ;Initialise l'cran
     
        XOR A
        LD HL,NB_FICHIERS

        CP (HL)                 ;Si (HL) est diffrent de 0, alors il y a des
        JR NZ,ImagesPresentes   ; fichiers pour PictView

; * Pas de fichiers *

        bcall(_copygbuf)        ;On affiche le buffer graphique

        LD HL,$0403             ;
        LD (CURSOR_ROW),HL      ;
        LD HL,Str_P_I           ;                        
        bcall(D_ZT_STR)         ;Affiche "No files"

        CALL AttendTouche       ;Attend la pression d'une touche

Quitte:
        RES 7,(IY+$14)
        RET                     ;Retourne au shell

; * Il y a des images *
ImagesPresentes:

        LD A,7                  ;8 est le nombre maxi d'images gres par PictView
        CP (HL)                 
        JR NC,NbOk              ;Si (HL)<=7, pas de problmes

        LD (HL),A               ;On traite seulement 8 images

NbOk:

        XOR A                   ;
        LD (POS_MENU),A         ;Initialise la position dans le menu


; * Menu *
DessineMenu:

        CALL IniEcran           ;Initialise l'cran
        CALL AffFichiers        ;Affiche les images
        LD DE,POS_MENU          ;DE pointe sur POS_MENU 

; * Boucle du menu *
BoucleMenu:
        CALL Inv_Barre          ;Inverse la barre de menu
        PUSH DE
        bcall(_copygbuf)        ;On affiche le buffer graphique
        POP DE

BoucleKey:
        PUSH DE                 ;
        CALL AttendTouche       ;Attend la pression d'une touche
        POP DE                  ;

        CALL Inv_Barre          ;Inverse la barre de menu
                
        CP G_MODE               ;Si [MODE]
        JR Z,Quitte             ;On quitte PictView

        CP G_UP                 ;Si [UP]
        JR Z,MenuMonte          ;Monte d'un choix 

        CP G_DOWN               ;Si [DOWN]
        JR Z,MenuDescend        ;Descend d'un choix 

        CP G_ENTER              ;Si pas [ENTER]
        JR NZ,BoucleMenu        ;On attend la prochaine touche


AfficheImg:
;* [ENTER] presse => Affichage *

        LD A,(DE)               ;A=Position dans le menu
        LD HL,TAB_FICHIERS      ;HL pointe sur le tableau d'adresses

AjustImg:
        OR A                    ;Si A=0, HL pointe sur la bonne image
        JR Z,AjustImg_Fin

        INC HL \ INC HL         ;Pointe sur la prochaine adresse
        DEC A                   ;Dcrmente notre compteur
        JR AjustImg

AjustImg_Fin:

        PUSH HL                 ;
        bcall(_cleargbuf)       ;
        POP HL                  ;Efface le buffer cran

        bcall(LD_HL_MHL)        ;HL Pointe sur le commentaire de l'image
        XOR A
        CPIR                    ;Il pointe maintenant aprs ce commentaire

        LD DE,GRAPH_MEM 
                                ;DE Pointe sur l'image
        EX DE,HL                ;HL=GRAPH_MEM (Destination)

        CALL DecodeZCP          ;On dcompresse l'image
        bcall(_copygbuf)        ;On affiche le buffer graphique

        CALL AttendTouche       ;Attend la pression d'une touche
        bcall(_cleargbuf)       ;Efface le buffer cran
        JR DessineMenu          ;On retourne au menu


; * Monte d'un choix dans le menu *
MenuMonte:
        LD A,(DE)

        OR A                    ;Si nous sommes sur le premier choix, 
        JR Z,BoucleMenu         ; on ne peux aller plus haut

        DEC A
        JR Maj_Pos_Menu         

; * Descend d'un choix dans le menu *
MenuDescend:
        LD A,(NB_FICHIERS)
        LD B,A
        LD A,(DE)
        
        INC A

        CP B                    ;Si nous sommes aprs le dernier choix,
        JR Z,BoucleMenu         ; dplacement impossible
Maj_Pos_Menu:

        LD (DE),A               ;Mise  jour de la nouvelle position

        PUSH DE
        bcall(_copygbuf)        ;On affiche le buffer graphique
        POP DE
        JR BoucleMenu           ;Boucle sur le menu
        
        



; * Inverse la barre du menu *
Inv_Barre:
        PUSH AF
        PUSH DE

        LD A,(POS_MENU)         ;
        LD L,A \ LD H,96        ;
        bcall(MUL_HL)           ;HL=POS_MENU*96

        LD DE,GRAPH_MEM+96      ;On dcale  cause du titre 
        ADD HL,DE               
        LD B,7*12               ;Nombre d'octets  "inverser"

Inv_Barre_Boucle:
        LD A,(HL)               ;
        XOR $FF                 ;
        LD (HL),A               ;On "inverse" un octect
        INC HL
        DJNZ Inv_Barre_Boucle

        POP DE
        POP AF

        RET
        
; * Initialise l'cran *
IniEcran:

        LD HL,$0018             ;
        LD (CURSOR_X),HL        ;
        LD HL,Str_Tit           ;
        bcall(D_ZM_STR)         ;Affiche le titre

        RET

; * Affiche les fichiers PictView *
AffFichiers:
        LD HL,TAB_FICHIERS      ;Pointe sur le tableau d'adresses
        LD DE,$0802             ;Position initiale du curseur
        LD A,(NB_FICHIERS)      ;
        LD B,A                  ;B=Nombre de fichiers

AffFichiers_Boucle:
        PUSH HL

        bcall(LD_HL_MHL)        ;HL pointe sur le commentaire de l'image
        PUSH DE                 ;On sauve DE (Pos. du curseur)
        LD (CURSOR_X),DE                
        bcall(D_ZM_STR)         ;On affiche le commentaire
        POP DE

        LD A,D \ ADD A,8 \ LD D,A ;Passe le curseur  la ligne suivante

        POP HL
        INC HL \ INC HL         ;HL pointe sur la prochaine adresse
        DJNZ AffFichiers_Boucle
        RET


; * Attend la pression d'une touche *
AttendTouche:
        bcall(GET_KEY)

        OR A
        JR Z,AttendTouche
        RET

Str_Tit .DB "PictView - Kaid",0
Str_P_I .DB "No files",0
Str_Dct .DB "PV10",0

.INCLUDE ZCPDECOD.ASM
.END
