;
;               ZCP decoding routine v2.0 for Ash 3.0/CrASH
;                    Wouter Demuynck (kadem@unicall.be)
;                       Read ZCP.TXT for more info
;
; Revision history :
; - 12/16/1995 (ZShell 4.0)
;     original by Stephane Jantzen(Stephane.Jantzen@scinfo.u-nancy.fr)
; - 02/11/96 (Zshell 4.0)
;     later version by Pascal Bouron(Bouron@YOKO.ENS-cachan.fr) 
; - 26/02/98 (Ash 3.0/Crash 1.x)
;     this version by Wouter Demuynck(kadem@unicall.be)
;     ported to TI-82
;
;
; usage : use '#include "ZCPDECOD.ASM"'
;         or cut and paste this routine in your source
; use 'call DecodeZCP' to decode the data pointed to by DE
; to the address pointed to by HL
; NOTE : if you use #include, be sure to put it at the END of your program,
;        bu before the .end directive
;
;
; DecodeZCP decodes data from address DE to address HL 
; routine size : <80 bytes
;
DecodeZCP: 
        ld      B,$80               ; %1000000 (selection mask)
        Push    DE
_ZCP_Loop:                               
        Pop     DE
        ld      A,(DE)              ; get next byte of compressed data
        or      A                   ; check if A is zero (last data byte)
        ret     Z                   ; quit routine if last byte reached
        inc     DE                  ; put pointer to next byte
        Push    DE
        ld      D,A                 ; save A in D (think Data)
        rlca                        ; rotate left throug carry => bit 7 -> CY
        jr      c,_ZCP_Copy         ; if bit 7 set, we need to copy,
_ZCP_Stream:                        ; otherwise it is a stream
        ld      A,D                 ; load the Data again
        and     $3F                 ; and %00111111 to get the count
        ld      C,A                 ; the count is saved in C
        ld      A,D                 ; load the data again
        and     $40                 ; and %01000000 (mask out the bit that 
_ZCP_StreamLoop:                    ; tells us wether to draw a pixel or not)
        or      A                   ; if no pixel needs to be drawn, loop
        jr      Z,_ZCP_SLSuite
        ld      E,A                 ; save A in E (DE is pushed)
        ld      A,B                 ; load mask in A
        or      (HL)                ; load update to mem in A
        ld      (HL),A              ; load update to mem to the mem
        ld      A,E                 ; restore A from E 
_ZCP_SLSuite:
        srl     B                   ; shift left through carry
        jr      NC,_ZCP_DjnzSL      ; CY set => go on to next byte
        inc     HL
        ld      B,$80               ; load %10000000 in B (necessary ?) 
_ZCP_DjnzSL:
        dec     C                   ; decrease count
        jr      nz,_ZCP_StreamLoop  ; keep looping while not zero
        jr      _ZCP_Loop
_ZCP_Copy:
        ld      C,$07               ; set count to 7 (7 bits to copy)
_ZCP_CopyLoop:                      ; 1 rotate left was already done
        rlca                        ; rotate left through carry
        jr      NC,_ZCP_CLSuite     ; if no pixel to draw, go to next
        ld      E,A
        ld      A,B
        or      (HL)                
        ld      (HL),A              ; set bit
        ld      A,E
_ZCP_CLSuite:
        srl     B
        jr      nc,_ZCP_DjnzCL
        inc     HL
        ld      B,$80
_ZCP_DjnzCL:
        dec     c  
        jr      nz,_ZCP_CopyLoop
        jr      _ZCP_Loop

