VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "RIG Converter"
   ClientHeight    =   5085
   ClientLeft      =   150
   ClientTop       =   720
   ClientWidth     =   6885
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   339
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   459
   StartUpPosition =   3  'Windows Default
   Begin VB.PictureBox picBuffer 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H00FFFFFF&
      BorderStyle     =   0  'None
      ForeColor       =   &H80000008&
      Height          =   960
      Left            =   5040
      ScaleHeight     =   64
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   96
      TabIndex        =   18
      TabStop         =   0   'False
      Top             =   1080
      Visible         =   0   'False
      Width           =   1440
   End
   Begin VB.CommandButton cmdPaste 
      Height          =   360
      Left            =   105
      Picture         =   "frmMain.frx":014A
      Style           =   1  'Graphical
      TabIndex        =   1
      ToolTipText     =   "Paste from clipboard"
      Top             =   600
      UseMaskColor    =   -1  'True
      Width           =   360
   End
   Begin VB.CommandButton cmdOpen 
      Height          =   360
      Left            =   105
      Picture         =   "frmMain.frx":024C
      Style           =   1  'Graphical
      TabIndex        =   0
      ToolTipText     =   "Open from file"
      Top             =   240
      UseMaskColor    =   -1  'True
      Width           =   360
   End
   Begin VB.CommandButton cmdAutoGray 
      Caption         =   "&Auto"
      Height          =   495
      Left            =   5520
      TabIndex        =   6
      ToolTipText     =   "Automatically calculate grayscale thresholds"
      Top             =   3000
      Width           =   1095
   End
   Begin VB.CommandButton cmdResetGray 
      Caption         =   "&Reset"
      Height          =   495
      Left            =   5520
      TabIndex        =   5
      ToolTipText     =   "Reset thresholds to equal proportions"
      Top             =   2400
      Width           =   1095
   End
   Begin VB.HScrollBar hsbGraySplit 
      Height          =   120
      Index           =   2
      LargeChange     =   5
      Left            =   240
      Max             =   200
      TabIndex        =   4
      Top             =   2640
      Value           =   150
      Width           =   5175
   End
   Begin VB.HScrollBar hsbGraySplit 
      Height          =   120
      Index           =   1
      LargeChange     =   5
      Left            =   240
      Max             =   200
      TabIndex        =   3
      Top             =   2520
      Value           =   100
      Width           =   5175
   End
   Begin VB.HScrollBar hsbGraySplit 
      Height          =   120
      Index           =   0
      LargeChange     =   5
      Left            =   240
      Max             =   200
      TabIndex        =   2
      Top             =   2400
      Value           =   50
      Width           =   5175
   End
   Begin VB.PictureBox picSrc 
      AutoRedraw      =   -1  'True
      Height          =   1980
      Left            =   480
      ScaleHeight     =   128
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   192
      TabIndex        =   16
      TabStop         =   0   'False
      ToolTipText     =   "Source Image (200%)"
      Top             =   240
      Width           =   2940
   End
   Begin VB.PictureBox picGray 
      AutoRedraw      =   -1  'True
      Height          =   1980
      Left            =   3720
      ScaleHeight     =   128
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   192
      TabIndex        =   15
      TabStop         =   0   'False
      ToolTipText     =   "Grayscale Preview (200%)"
      Top             =   240
      Width           =   2940
   End
   Begin VB.Frame Frame1 
      Height          =   1125
      Left            =   240
      TabIndex        =   14
      Top             =   3720
      Width           =   6375
      Begin VB.CommandButton cmdSaveImage 
         Default         =   -1  'True
         Enabled         =   0   'False
         Height          =   765
         Left            =   5760
         Picture         =   "frmMain.frx":034E
         Style           =   1  'Graphical
         TabIndex        =   19
         ToolTipText     =   "Save as RIGView Image (.8XP)"
         Top             =   240
         UseMaskColor    =   -1  'True
         Width           =   480
      End
      Begin VB.CommandButton cmdFolder 
         Caption         =   ">"
         Height          =   285
         Left            =   5400
         TabIndex        =   13
         ToolTipText     =   "Change current folder"
         Top             =   720
         Width           =   255
      End
      Begin VB.TextBox txtPath 
         Height          =   285
         Left            =   720
         Locked          =   -1  'True
         TabIndex        =   12
         TabStop         =   0   'False
         ToolTipText     =   "Location where output file will be saved"
         Top             =   720
         Width           =   4680
      End
      Begin VB.TextBox txtFile 
         Height          =   285
         Left            =   720
         MaxLength       =   8
         TabIndex        =   8
         ToolTipText     =   "The file name on the calculator"
         Top             =   240
         Width           =   1335
      End
      Begin VB.TextBox txtDesc 
         Height          =   285
         Left            =   3120
         MaxLength       =   24
         TabIndex        =   10
         ToolTipText     =   "This text appears in RIGView (optional)"
         Top             =   240
         Width           =   2535
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "Folder:"
         Height          =   195
         Left            =   120
         TabIndex        =   11
         Top             =   735
         Width           =   480
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "&Name:"
         Height          =   195
         Left            =   120
         TabIndex        =   7
         Top             =   270
         Width           =   465
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         BackStyle       =   0  'Transparent
         Caption         =   "&Description:"
         Height          =   195
         Left            =   2160
         TabIndex        =   9
         Top             =   285
         Width           =   840
      End
   End
   Begin VB.PictureBox picHistogram 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      ForeColor       =   &H80000008&
      Height          =   255
      Left            =   480
      ScaleHeight     =   15
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   311
      TabIndex        =   17
      TabStop         =   0   'False
      ToolTipText     =   "Histogram of the current image"
      Top             =   3240
      Width           =   4695
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   ""
      BeginProperty Font 
         Name            =   "Wingdings"
         Size            =   9.75
         Charset         =   2
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   225
      Left            =   3465
      TabIndex        =   20
      Top             =   1155
      Width           =   210
   End
   Begin VB.Shape shpGraySplit 
      BackColor       =   &H00000000&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00FFFFFF&
      FillColor       =   &H00FFFFFF&
      Height          =   255
      Index           =   0
      Left            =   480
      Top             =   2880
      Width           =   1215
   End
   Begin VB.Shape shpGraySplit 
      BackColor       =   &H00546963&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00FFFFFF&
      FillColor       =   &H00FFFFFF&
      Height          =   255
      Index           =   1
      Left            =   480
      Top             =   2880
      Width           =   2415
   End
   Begin VB.Shape shpGraySplit 
      BackColor       =   &H0088A29A&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00FFFFFF&
      FillColor       =   &H00FFFFFF&
      Height          =   255
      Index           =   2
      Left            =   480
      Top             =   2880
      Width           =   3495
   End
   Begin VB.Shape shpGraySplit 
      BackColor       =   &H00CCD7D3&
      BackStyle       =   1  'Opaque
      BorderColor     =   &H00FFFFFF&
      FillColor       =   &H00FFFFFF&
      Height          =   255
      Index           =   3
      Left            =   480
      Top             =   2880
      Width           =   4695
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Input Image"
         Begin VB.Menu mnuFileOpenFile 
            Caption         =   "From File..."
            Shortcut        =   ^O
         End
         Begin VB.Menu mnuOpenClip 
            Caption         =   "From Clipboard"
         End
      End
      Begin VB.Menu mnuFileOut 
         Caption         =   "&Output Image"
         Begin VB.Menu mnuFileOutRIG 
            Caption         =   "RIGView Image (.8XP)"
            Shortcut        =   ^S
         End
         Begin VB.Menu mnuFileOutAlone 
            Caption         =   "Stand-Alone Program (.8XP)"
         End
         Begin VB.Menu mnuFileOutClip 
            Caption         =   "Export to Clipboard (Z80)"
         End
      End
      Begin VB.Menu Hyphen1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileFolder 
         Caption         =   "Change Folder..."
         Shortcut        =   ^F
      End
      Begin VB.Menu Hyphen2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelpAbout 
         Caption         =   "&About"
         Shortcut        =   ^A
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim lngBitmap(0 To 95, 0 To 63) As Long
Dim bytGrayImg(0 To 95, 0 To 63) As Byte

Private Sub cmdAutoGray_Click()
    Dim x As Byte, y As Byte
    Dim i As Integer
    
    Dim intVals(0 To 2) As Integer
    Dim lngAvg(0 To 1) As Long
    Dim intAvg(0 To 1) As Integer
    
    Dim lngRGB As Long
    Dim intSum As Integer

    For y = 0 To 63
        For x = 0 To 95
            Add lngAvg(0), GetRGBSum(lngBitmap(x, y))
        Next x
    Next y

    intVals(1) = ((lngAvg(0) / 6144) / 765) * 200
    If intVals(1) = 0 Then intVals(1) = 1
    If intVals(1) = 200 Then intVals(1) = 199

    lngAvg(0) = 0
    For y = 0 To 63
        For x = 0 To 95
            intSum = (GetRGBSum(lngBitmap(x, y)) / 765) * 200
            i = -(intSum > intVals(1))
            Add intAvg(i)
            Add lngAvg(i), intSum
        Next x
    Next y
    
    For i = 0 To 1
        If intAvg(i) = 0 Then intAvg(i) = 1
        intVals(i * 2) = (lngAvg(i) / intAvg(i))
        If intVals(i * 2) = 0 Then intVals(i * 2) = 1
        If intVals(i * 2) = 200 Then intVals(i * 2) = 199
    Next i
    
    For i = 0 To 2
        hsbGraySplit(i).Value = intVals(i)
    Next i

End Sub

Private Sub cmdFolder_Click()
    Call mnuFileFolder_Click
End Sub

Private Sub cmdOpen_Click()
    mnuFileOpenFile_Click
End Sub

Private Sub cmdPaste_Click()
    mnuOpenClip_Click
End Sub

Private Sub cmdResetGray_Click()
    With hsbGraySplit
        .Item(0).Value = 50
        .Item(1).Value = 100
        .Item(2).Value = 150
    End With
End Sub


Private Sub cmdSaveImage_Click()
    SaveASMFile 1
End Sub

Private Sub Form_Load()
    Dim x As Byte, y As Byte
    
    strSaveTo = CurDir
    txtPath.Text = strSaveTo
    mnuFileOut.Enabled = False
    GraySplit
    
    For y = 0 To 63
        For x = 0 To 95
            bytGrayImg(x, y) = 4
        Next x
    Next y
End Sub

Sub GraySplit()
    Dim intWidth As Integer
    Dim i As Integer, intTemp As Integer
    Dim intVals(0 To 2) As Integer
    
    intWidth = hsbGraySplit(0).Width - 32

    ReadGrayValues intVals()
    
    For i = 0 To 2
        intTemp = (intVals(i) / 200) * intWidth
        If shpGraySplit(i).Width <> intTemp Then shpGraySplit(i).Width = intTemp
    Next i
    
    DrawGray
End Sub

Sub DrawHistogram()
    Dim intWidth As Integer, intMax As Integer
    Dim lngAvg As Long
    Dim i As Integer
    Dim x As Byte, y As Byte
    Dim lngRGB As Long
    
    intWidth = picHistogram.ScaleWidth - 1
    ReDim intLines(0 To intWidth) As Integer
    
    intMax = 0: lngAvg = 0
    For y = 0 To 63
        For x = 0 To 95
            lngRGB = lngBitmap(x, y)
            i = (GetRGBSum(lngRGB) / 765) * intWidth
            Add lngAvg, i
            Add intLines(i)
            If intMax < intLines(i) Then intMax = intLines(i)
        Next x
    Next y
    
    lngAvg = lngAvg / 6144
    If intMax > lngAvg * 3 Then intMax = lngAvg * 3
    
    For i = 0 To intWidth
        If intLines(i) > intMax Then intLines(i) = intMax
        intLines(i) = (1 - (intLines(i) / intMax)) * 511
        If intLines(i) <= 255 Then
            lngRGB = RGB(0, 0, intLines(i))
        ElseIf intLines(i) > 511 Then
            lngRGB = 0
        Else
            lngRGB = RGB(intLines(i) - 256, intLines(i) - 256, 255)
        End If
        picHistogram.Line (i, 0)-(i, picHistogram.ScaleHeight), lngRGB
    Next i
End Sub

Sub DrawGray()
    Dim x As Byte
    Dim y As Byte
    Dim intColorSum As Integer
    Dim lngColor As Long
    Dim intRGB As Integer
    
    If blnImgLoaded = False Then Exit Sub
    
    For y = 0 To 63
        For x = 0 To 95
            intRGB = ToGray(lngBitmap(x, y))
            If bytGrayImg(x, y) <> intRGB Then
                bytGrayImg(x, y) = intRGB
                intRGB = intRGB * (255 / 3)
                Call SetPixelV(picBuffer.hdc, x, y, RGB(intRGB, intRGB, intRGB))
            End If
        Next x
    Next y
    Call StretchBlt(picGray.hdc, 0, 0, 192, 128, picBuffer.hdc, 0, 0, 96, 64, SRCCOPY)
    picGray.Refresh
End Sub

Private Sub hsbGraySplit_Change(Index As Integer)
    GraySplit
End Sub

Sub ReadGrayValues(ByRef intVals() As Integer)
    Dim blnFlag As Boolean
    Dim intTemp As Integer
    Dim i As Integer
    
    For i = 0 To 2
        intVals(i) = hsbGraySplit(i).Value
    Next i
    
    Do
        blnFlag = False
        For i = 0 To 1
            If intVals(i) > intVals(i + 1) Then
                intTemp = intVals(i)
                intVals(i) = intVals(i + 1)
                intVals(i + 1) = intTemp
                blnFlag = True
            End If
        Next i
    Loop While blnFlag
End Sub

Private Sub hsbGraySplit_Scroll(Index As Integer)
    GraySplit
End Sub

Sub InitPicture()
    Dim x As Byte
    Dim y As Byte
    Dim intYesNo As Integer

    With picBuffer
        .AutoSize = True
        
        If (.Width <> 96 Or .Height <> 64) Then
            intYesNo = MsgBox("Do you want to stretch this image to fit the calculator screen?" & vbCrLf & "Note: Resizing the image in a photo editor will usually result in a clearer image.", vbYesNo + vbQuestion, "Image is not 96x64 pixels")
        Else
            intYesNo = vbNo
        End If
        
        If intYesNo = vbYes Then
            Call StretchBlt(picSrc.hdc, 0, 0, 96, 64, picBuffer.hdc, 0, 0, .Width, .Height, SRCCOPY)
            .AutoSize = False
            .Width = 96
            .Height = 64
        Else
            .AutoSize = False
            .Width = 96
            .Height = 64
            Call BitBlt(picSrc.hdc, 0, 0, 96, 64, picBuffer.hdc, 0, 0, SRCCOPY)
        End If
        
        .Picture = LoadPicture()
    End With

    For y = 0 To 63
        For x = 0 To 95
            lngBitmap(x, y) = GetPixel(picSrc.hdc, x, y)
            bytGrayImg(x, y) = 4
        Next x
    Next y
    Call StretchBlt(picSrc.hdc, 0, 0, 192, 128, picSrc.hdc, 0, 0, 96, 64, SRCCOPY)
    picSrc.Refresh

    blnImgLoaded = True
    
    Call DrawHistogram
    Call DrawGray
    Call EnableCheck
End Sub

Private Sub mnuFileExit_Click()
    End
End Sub

Private Sub mnuFileOpenFile_Click()
    With CmDlg
        .Flags = OFN_HIDEREADONLY
        .Filter = "All Picture Files|*.bmp;*.dib;*.gif;*.jpg;*.wmf;*.emf;*.ico;*.cur|Bitmaps (*.bmp;*.dib)|*.bmp;*.dib|GIF Images (*.gif)|*.gif|JPEG Images (*.jpg)|*.jpg|Metafiles (*.wmf;*.emf)|*.wmf;*.emf|Icons (*.ico;*.cur)|*.ico;*.cur|All Files (*.*)|*.*"

        .ShowOpen
        If blnCancelled Then Exit Sub

        On Error GoTo ErrorHandler
        picBuffer.Picture = LoadPicture(.FileName)
        On Error GoTo 0
    End With
    
    Call InitPicture

    Exit Sub
ErrorHandler:
    If Err = 481 Then
        MsgBox "Unable to open image file.", vbExclamation, "Error"
    End If
End Sub

Private Sub mnuFileOutClip_Click()
    SaveASMFile 3
End Sub

Private Sub mnuFileOutRIG_Click()
    SaveASMFile 1
End Sub
Private Sub mnuFileOutAlone_Click()
    SaveASMFile 2
End Sub

Sub SaveASMFile(intHead As Integer)
    Dim x As Integer
    Dim y As Integer
    Dim bit As Integer
    Dim intLayer As Integer
    Dim strLayer(0 To 1) As String
    
    Dim strData As String
    Dim strClip As String
    Dim strFullPath As String
    Dim lngDataLen As Long
    Dim strFile As String
    Dim strDesc As String
    
    For intLayer = 0 To 1
        ASM_Reset
        For x = 0 To 95 Step 8
            For y = 0 To 63
                For bit = 0 To 7
                    ASM_AddPix ((3 - ToGray(lngBitmap(x + bit, y))) And (2 ^ intLayer))
                Next bit
            Next y
        Next x
        strLayer(intLayer) = strASM
    Next intLayer
    
    strFile = txtFile.Text
    strFullPath = FixPath(strSaveTo) & strFile & ".8XP"
    
    Select Case intHead
        Case 1
            strDesc = Trim(txtDesc.Text)
            If strDesc = "" Then strDesc = strFile
            strData = Chr(&HC9) & "RIGv2" & strDesc & Chr(0) & RLE(strLayer(0)) & RLE(strLayer(1))
        Case 2
            frmSync.Show 1
            strData = Hex2Bin("BB6DF321369E114093CD1D9E11EC86CD1D9ECDD99D01FE073EFFD30179D301DB013C2017CB0110F00E") & _
                Chr(frmSync.hsbSync) & _
                Hex2Bin("060A10FE0D20F90134010B78B120FB18D7FBEF4045EF5845EF1840C93E80D310ED73189E31540C21FA9D35F2ED9D360211EC863E20D31032109E06400E010D626BF21B9EB70E02397ED3111310F07932FA9D3E003CFE2CC2F29D310000C918E80100037EFE912805EDA0E018F623237E2B3DEDA020FA2318F1") & _
                RLE(strLayer(0)) & RLE(strLayer(1))
            strDesc = frmSync.lblSync.Caption
        Case 3
            bit = MsgBox("Do you want to RLE Compress the data?", vbYesNo + vbQuestion, "RLE Compression")
            lngDataLen = 0
            strClip = ""
            For intLayer = 0 To 1
                strClip = strClip & vbCrLf & "Layer" & intLayer + 1 & ":"
                strData = IIf(bit = vbYes, RLE(strLayer(intLayer)), strLayer(intLayer))
                lngDataLen = lngDataLen + Len(strData)
                For x = 1 To Len(strData)
                    If (((x - 1) / 16) = Int((x - 1) / 16)) Then strClip = strClip & vbCrLf & vbTab & ".db" & vbTab
                    strClip = strClip & "$" & MyHex(Mid(strData, x, 1))
                    If ((x < Len(strData)) And ((x / 16) <> Int(x / 16))) Then strClip = strClip & ","
                Next x
            Next intLayer
            strClip = "; " & lngDataLen & " bytes" & strClip
            Clipboard.Clear
            Clipboard.SetText strClip
            strDesc = "Z80 data exported to clipboard.  Note that the bytes are in Top-Bottom,Left-Right order."
            frmSuccess.Disp strFile, lngDataLen, strDesc, "<Clipboard>", picGray.hdc
            Exit Sub
    End Select

    lngDataLen = Len(strData)
    On Error GoTo ErrorHandler
    
    Open strFullPath For Output As #1: Close 1
    Open strFullPath For Binary Access Write As #1
       lngChkSum = -1
       WriteAtPos (&H0), "**TI83F*"
       WriteAtPos (&H8), Chr(&H1A) & Chr(&HA) & Chr(&H0)
       WriteAtPos (&HB), "Generated With RIGConverter" & Chr(&H0)
       WriteAtPos (&H35), NumToWord(lngDataLen + 19)

       lngChkSum = 0
       WriteAtPos (&H37), Chr(&HD)
       WriteAtPos (&H39), NumToWord(lngDataLen + 2)
       WriteAtPos (&H3B), Chr(&H6)
       WriteAtPos (&H3C), strFile
       WriteAtPos (&H46), NumToWord(lngDataLen + 2)
       WriteAtPos (&H48), NumToWord(lngDataLen)
       WriteAtPos (&H4A), strData
       WriteAtPos (&H4A + lngDataLen), NumToWord(lngChkSum And &HFFFF&)
    Close 1
    
    On Error GoTo 0
    
    frmSuccess.Disp strFile & ".8XP", lngDataLen + 13, strDesc, strSaveTo, picGray.hdc
    Exit Sub
ErrorHandler:
    MsgBox "Unable to write " & strFullPath & "!", vbExclamation, "Error"

End Sub

Private Sub mnuFileFolder_Click()
    Dim strPath As String
    strPath = BrowseForFolder(frmMain.hwnd, "Select New Folder:")
    If blnCancelled Then Exit Sub
    txtPath.Text = strPath
    strSaveTo = strPath
End Sub

Private Sub mnuHelpAbout_Click()
    frmAbout.Show 1
End Sub

Private Sub mnuOpenClip_Click()
    If Clipboard.GetData <> 0 Then
        picBuffer.Picture = Clipboard.GetData
        InitPicture
    Else
        MsgBox "An image was not found in the clipboard.", vbExclamation, "Error"
    End If
End Sub


Private Sub txtDesc_GotFocus()
    SelectAll txtDesc
End Sub

Private Sub txtFile_Change()
    EnableCheck
End Sub

Sub EnableCheck()
    Dim strFile As String
    Dim i As Integer
    Dim strChr As String
    
    strFile = txtFile.Text
    
    If blnImgLoaded = False Then GoTo ExitFalse
    
    If Len(strFile) = 0 Then GoTo ExitFalse
    strChr = Left(strFile, 1)
    If strChr >= "0" And strChr <= "9" Then GoTo ExitFalse
    For i = 2 To Len(strFile)
        strChr = Mid(strFile, i, 1)
        If Not ((strChr >= "0" And strChr <= "9") Or (strChr >= "A" And strChr <= "Z")) Then GoTo ExitFalse
    Next i

    mnuFileOut.Enabled = True
    cmdSaveImage.Enabled = True
    Exit Sub
ExitFalse:
    mnuFileOut.Enabled = False
    cmdSaveImage.Enabled = False
End Sub

Private Sub txtFile_GotFocus()
    SelectAll txtFile
End Sub

Private Sub txtFile_KeyPress(KeyAscii As Integer)
    Select Case KeyAscii
        Case Asc("0") To Asc("9")
            If txtFile.SelStart = 0 Then KeyAscii = 0
        Case Asc("a") To Asc("z")
            KeyAscii = KeyAscii + Asc("A") - Asc("a")
        Case 8, Asc("A") To Asc("Z")
        Case Else
            KeyAscii = 0
    End Select
End Sub

