Attribute VB_Name = "modCode"
Option Explicit
Declare Function GetPixel Lib "gdi32.dll" (ByVal hdc As Long, ByVal nXPos As Long, ByVal nYPos As Long) As Long
Declare Function SetPixelV Lib "gdi32.dll" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal crColor As Long) As Long
Declare Function StretchBlt Lib "gdi32.dll" (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal hSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long
Declare Function BitBlt Lib "gdi32.dll" (ByVal hdcDest As Long, ByVal nXDest As Long, ByVal nYDest As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hdcSrc As Long, ByVal nXSrc As Long, ByVal nYSrc As Long, ByVal dwRop As Long) As Long

Public Const SRCCOPY = &HCC0020

Public CmDlg As New clsOpenSave
Public strSaveTo As String

Type ImageStruc
    Width As Long
    Height As Long
End Type

Public blnCancelled As Boolean

Public blnImgLoaded As Boolean
Public lngChkSum As Long

Dim intByte As Integer
Dim intBitNum As Integer
Public strASM As String

Sub Main()
    blnImgLoaded = False
    ASM_Reset
    frmMain.Show
End Sub

Sub ASM_AddPix(intBit As Integer)
    If intBit <> 0 Then intByte = intByte + (2 ^ intBitNum)
    If intBitNum = 0 Then
        strASM = strASM + Chr(intByte)
        intBitNum = 7
        intByte = 0
    Else
        intBitNum = intBitNum - 1
    End If
End Sub

Sub ASM_Reset()
    intBitNum = 7
    intByte = 0
    strASM = ""
End Sub

Function ToGray(lngRGB As Long) As Integer 'returns 0-3
    Dim intSum As Integer
    Dim intVals(0 To 2) As Integer
    
    intSum = (GetRGBSum(lngRGB) / 765) * 200
    frmMain.ReadGrayValues intVals()
    
    If intSum < intVals(0) Then
        ToGray = 0
    ElseIf intSum < intVals(1) Then
        ToGray = 1
    ElseIf intSum < intVals(2) Then
        ToGray = 2
    Else
        ToGray = 3
    End If

End Function

Function FixPath(strPath As String) As String
    If Right(strPath, 1) <> "\" Then strPath = strPath & "\"
    FixPath = strPath
End Function

Function RLE(strData As String) As String
    Const RLE_KEY = &H91
    Dim strRLE As String
    Dim lngDatLen As Long
    Dim lngPos As Long
    Dim intStartChr As Integer
    Dim intTestChr As Integer
    Dim intRunLen As Integer

    If strData <> "" Then
        lngDatLen = Len(strData)
        lngPos = 1
        Do
            intStartChr = Asc(Mid(strData, lngPos, 1))
            intRunLen = 0
            
            Do
                intRunLen = intRunLen + 1
                If lngPos + intRunLen > lngDatLen Then
                    intTestChr = 300    'will never match
                Else
                    intTestChr = Asc(Mid(strData, lngPos + intRunLen, 1))
                End If
            Loop While (intRunLen < 256) And (intTestChr = intStartChr)
            
            If (intRunLen > 3) Or (intStartChr = RLE_KEY) Then
                strRLE = strRLE & Chr(RLE_KEY) & Chr(intStartChr) & Chr(IIf(intRunLen = 256, 0, intRunLen))
            Else
                strRLE = strRLE & String(intRunLen, intStartChr)
            End If
            
            lngPos = lngPos + intRunLen
        Loop Until lngPos > lngDatLen
    End If
    RLE = strRLE
End Function

Sub Center(objNew As Object, objParent As Object)
    objNew.Left = ((objParent.Width - objNew.Width) / 2) + objParent.Left
    objNew.Top = ((objParent.Height - objNew.Height) / 2) + objParent.Top
End Sub

Function NumToWord(lngNum As Long) As String
    NumToWord = Chr(lngNum And &HFF) & Chr((lngNum And &HFF00&) / &H100)
End Function

Sub WriteAtPos(lngByte As Long, strData As String)
   If lngChkSum <> -1 Then
      Dim i As Integer
      For i = 1 To Len(strData)
         lngChkSum = lngChkSum + Asc(Mid(strData, i, 1))
      Next i
   End If
   Put 1, lngByte + 1, strData
End Sub

Sub SelectAll(objText As Object)
    objText.SelStart = 0
    objText.SelLength = Len(objText.Text)
End Sub

Function Hex2Bin(strHex As String) As String
    Dim i As Long
    Dim strBin As String
    
    For i = 1 To Len(strHex) Step 2
        strBin = strBin & Chr(Val("&H" & Mid(strHex, i, 2)))
    Next i
    
    Hex2Bin = strBin
End Function

Function MyHex(strHex As String)
    Dim strOut As String
    strOut = Hex(Asc(strHex))
    If Len(strOut) = 1 Then strOut = "0" & strOut
    MyHex = strOut
End Function

Function GetRGBSum(lngRGB As Long) As Integer
    GetRGBSum = (lngRGB And &HFF&) + ((lngRGB And &HFF00&) / &H100&) + ((lngRGB And &HFF0000) / &H10000)
End Function

Sub Add(ByRef Var1 As Variant, Optional ByVal Var2 As Variant = 1)
    Var1 = Var1 + Var2
End Sub
