; RPG Demo - by Harper Maddox

; 10/29/01 - converted into an app

 include "ti83plus.inc"

; ---
; equates
;------

diDown		.equ 254 
diLeft		.equ 253 
diRight		.equ 251 
diUp		.equ 247 
diY		.equ 239
diGraph .equ 254
di2nd		.equ 223
diMode		.equ 191
diAlpha		.equ 127

;----
; Variables
;------------

itemOffset .equ savesscreen
itemSelect .equ itemOffset+1
drawMenu .equ itemSelect+1
cursorPos .equ itemSelect+3
cursorCount .equ cursorPos+1
cursorScroll .equ cursorCount+1
cursorMax .equ cursorScroll+1
cursorState .equ cursorMax+1
cursorVideo .equ cursorState+1
cursorTable .equ cursorVideo+1	; 20 bytes

itemSelection .equ cursorTable+20
itemID .equ itemSelection+2
charSelect .equ itemID+2
itemXPos .equ charSelect+1
itemUseClass .equ itemXPos+1

; battle used

attackState .equ itemSelection
currentChar .equ itemUseClass+1
victimChar .equ currentChar
inAttack .equ currentChar+1
victimHPlost .equ inAttack+1
victimHPx .equ victimHPlost+2
victimHPy .equ victimHPx+1
enemiesKilled .equ victimHPy+1
attackerChar .equ enemiesKilled+1
battleTable .equ attackerChar+1
; format: 4 byte entry
; db <state>,<gauge_position>,<AP>,<DP>

enemyTable .equ battleTable+12
; format: 10 byte tag

; db <sprite ID>,<state>,<xPos>,<yPos>
; db <atkPwr>,<defPwr>
; dw <currentHP>,<maxHP>

attackQueue .equ enemyTable+60	; room for 6 enemies
; 4 byte entry format.
; db <state>,<charID>,<victimChar>,<special>
; attacks may occur every 8 cycles
;  everything freezes during an attack or spell
;  residual effects take longer (hp lost bouncing)
; states:
;  fight, magic, item, specials
; special:
;  tag reserved for a spell and/or item
; charID:
;  char1,2,3,enemy1,2,3...
; victimChar: same as charID

temp .equ attackQueue+30

;------------------------
;--      HEADER        --
;------------------------

EXT_APP equ 1   ;This definition is required of all apps
cseg            ;This linker directive is required of all apps.

;This is the application header definition area required for all apps.
 db 080h,0Fh    ;Field: Program length
 db   00h,00h,00h,00h ;Length=0 (N/A for unsigned apps)
 db 080h,012h    ;Field: Program type
 db   01h,04h    ;Type= Shareware, TI-83Plus
 db 080h,021h    ;Field: App ID
 db   01h        ;Id = 1
 db 080h,031h    ;Field: App Build
 db   01h        ;Build = 1
 db 080h,048h    ;Field: App Name
 db "RPG Demo"   ;Name = "Hello   " must be 8 characters
 db 080h,081h    ;Field: App Pages
 db 01h          ;App Pages = 1
 db 080h,090h    ;No default splash screen
 db 03h,026h ,09h,04h, 04h,06fh,01bh,80h     ;Field: Date stamp- 5/12/1999
 db 02h,0dh,040h                             ;Dummy encrypted TI date stamp signature
 db 0a1h ,06bh ,099h ,0f6h ,059h ,0bch ,067h 
 db 0f5h ,085h ,09ch ,09h ,06ch ,0fh ,0b4h ,03h ,09bh ,0c9h 
 db 03h ,032h ,02ch ,0e0h ,03h ,020h ,0e3h ,02ch ,0f4h ,02dh 
 db 073h ,0b4h ,027h ,0c4h ,0a0h ,072h ,054h ,0b9h ,0eah ,07ch 
 db 03bh ,0aah ,016h ,0f6h ,077h ,083h ,07ah ,0eeh ,01ah ,0d4h 
 db 042h ,04ch ,06bh ,08bh ,013h ,01fh ,0bbh ,093h ,08bh ,0fch 
 db 019h ,01ch ,03ch ,0ech ,04dh ,0e5h ,075h 
 db 80h,7Fh      ;Field: Program Image length
 db   0,0,0,0    ;Length=0, N/A
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 db   0,0,0,0    ;Reserved
 
;End of header data

;------------------------
;-- START PROGRAM CODE --
;------------------------

prog_start:
 set appTextSave,(iy+appFlags)
 set textwrite,(iy+sGrFlags)    ; _vputs writes directly to graph

 ld hl,savesscreen
 ld (hl),0
 ld de,savesscreen+1
 ld bc,256
 ldir

 call initBattle

 jp setupMenuScreen

 include "equip.asm"

setupItemScreen:
 ; set up the cursor table

 ld a,8
 ld (itemXPos),a
 ld a,3
 ld (cursorState),a

 ld a,7
 ld (cursorMax),a

 ld a,10
 ld (cursorScroll),a

 ld de,plotsscreen+108
 ld hl,cursorTable

 ld b,8
setupItemTableLoop:
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl

 push hl
  ld hl,7*12
  add hl,de
  ex de,hl
 pop hl
 djnz setupItemTableLoop

 ld hl,itemMenu
 ld (drawMenu),hl

redraw:
 call _grbufclr

 ld hl,(drawMenu)
 jp (hl)

returnToRedraw:

 ; draw the hand

 call displayCursor

 ld a,(itemSelect)
 cp 0FFh
 jr z,skipMoveCursor

 ld a,(cursorPos)
 push af

 ld a,(itemOffset)
 ld c,a
 ld a,(cursorState)
 cp 3
 jr z,cursorItemOKstate
 ld c,0
cursorItemOKstate:
 ld a,(itemSelect)
 sub c
 ld (cursorPos),a
 xor a
 call showCursor

 pop af
 ld (cursorPos),a

skipMoveCursor:

 B_CALL GrBufCpy

 ld a,0ffh 			;resets the keypad.
 out (1),a			;'Required syntax' :)
 ld a,0feh 			;Enable group 1.
 out (1),a 			
 in a,(1) 			;'Required Syntax'
 cp diDown
 jp z,CursorDOWN
 cp diUp
 jp z,CursorUP

 ld a,0ffh 			;Reset keypad again.
 out (1),a
 ld a,0bfh			;Enable group 2.
 out (1),a 
 in a,(1)
 cp di2nd
 jp z,selectCursor
 cp diGraph
 jp z,showDebugScreen
 cp diMode 
 jp nz,redraw

exitMenu:
 ; exit the current menu

 call delay

 ld a,(cursorState)
 cp 2
 jr z,skipDeselectItem
 cp 6
 jp z,setupEquipScreen

 ld a,(itemSelect)
 cp 0FFh
 jr z,skipDeselectItem

 ld a,0FFh
 ld (itemSelect),a
 jp redraw

skipDeselectItem:

 ; always reset these values
 ld a,0FFh
 ld (itemSelect),a

 xor a
 ld (itemOffset),a
 ld (cursorCount),a
 ld (cursorPos),a
 ld (cursorScroll),a

 ld a,(cursorState)
 cp 1
 ret z
 cp 2
 jp z,setupMenuScreen
 cp 3
 jp z,setupMenuScreen
 cp 4
 jp z,setupItemScreen
 cp 5
 jp z,setupMenuScreen
 cp 6
 jp z,setupEquipScreen
 cp 9
 jp z,setupMenuScreen
 cp 10
 jp z,setupBattleScreen
			
 jp redraw

CursorDOWN:
 ld a,(cursorMax)
 ld b,a
 ld a,(cursorPos)
 cp b
 jr z,scrollCursorDown
 inc a
 ld (cursorPos),a
 jp redraw

scrollCursorDown:
 ld a,(cursorScroll)
 ld b,a
 ld a,(itemOffset)
 cp b
 jp z,redraw
 inc a
 ld (itemOffset),a
 jp redraw 

CursorUP:
 ld a,(cursorPos)
 or a
 jr z,scrollCursorUp
 dec a
 ld (cursorPos),a
 jp redraw

scrollCursorUp:
 ld a,(itemOffset)
 or a
 jp z,redraw
 dec a
 ld (itemOffset),a
 jp redraw



selectCursor:
 call waitUntilKEYup

 ld a,(cursorState)
 cp 4
 jp z,useItem
 cp 2
 jp z,AfterCharSelect
 cp 1
 jp z,activateMenuChoice
 cp 5
 jp z,setupEquipNewItemScreen
 cp 6
 jp z,equipNewItem
 cp 9
 jp z,setupSelectCharToAttack

 cp 10
 jp z,fightSelected

 cp 3
 jp nz,redraw

 ; this is only for the item menu

 ld a,(cursorPos)
 ld b,a
 ld a,(itemOffset)
 add a,b
 ld b,a
 ld a,(itemSelect)
 cp 0FFh
 jr nz,moveItem

 ld a,b
 ld (itemSelect),a
 jp redraw

moveItem:
 ld c,a
 ld a,b
 cp c
 jr z,executeItemSelection

 ; switch the two items

 ; hl - previous, de - new

 call getItemPosition
 push hl
  ld a,c
  call getItemPosition
 pop de

 ld b,3
itemMoveLoop:
 ld a,(de)
 ld c,(hl)
 ld (hl),a
 ld a,c
 ld (de),a
 inc hl
 inc de
 djnz itemMoveLoop


resetItemSelection:
 ld a,0FFh
 ld (itemSelect),a
 jp redraw

executeItemSelection:
 
 ; check to see if it is a potion or equipment
 call getItemPosition

 ld a,(hl)	; 1st byte is Item Type ID

 cp 1
 jp nz,redraw

 ld (itemSelection),hl		; save the item...

 ld a,2
 ld (cursorMax),a
 xor a
 ld (cursorPos),a
 ld (cursorScroll),a

 ld de,plotsscreen+128
 ld hl,cursorTable

 ld (hl),e
 inc hl
 ld (hl),d
 inc hl
 ld de,plotsscreen+308
 ld (hl),e
 inc hl
 ld (hl),d
 inc hl
 ld de,plotsscreen+476
 ld (hl),e
 inc hl
 ld (hl),d

 ld a,4
 ld (cursorState),a
 jr resetItemSelection


useItem:
 ; character is pointed to by cursorPos

 ld a,(cursorPos)
 call findChar
 ex de,hl		; char is in de

 ld hl,(itemSelection)

 inc hl			; we dont need to know the first byte

 ld a,(hl)
 ld (itemID),a
 cp 3
 jr c,usePotion

 jr removeItem

usePotion:
 push hl

  ld hl,6
  add hl,de

  call isHPfull
  jr c,dontUsePotion

  ld bc,100

  ld a,(itemID)
  cp 1
  jr z,dontUseXPotion

  ld bc,250

dontUseXPotion:
  ex de,hl
  add hl,bc  
  ex de,hl

  dec hl
  dec hl
  
  ld (hl),d
  dec hl
  ld (hl),e 
  call fixHP

 call removeItem

dontUsePotion:
 pop hl
 ; display error

 jp exitMenu

removeItem:
 inc hl
 ld a,(hl)
 dec a
 ld (hl),a
 ret nz

 dec hl
 ld (hl),0
 dec hl
 ld (hl),0
 ret


AfterCharSelect:
 ld a,(cursorPos)
 ld (charSelect),a

 ld a,(itemSelect)
 sub 4
; jp z,setupMagicScreen

 cp 1
 jp z,setupEquipScreen

 cp 2
 jp z,showStatusScreen

 jp redraw


;--------
; execute current battle selection
;--------
;  cursor pos: 1= fight, 2=special, 3=magic, 4=item
;--------
execBattleSelection:
 ld a,(cursorPos)
 or a
 jr z,fightSelected

 jp redraw

fightSelected:
 ld hl,battleTable	; reset their gauge and turn on the fight state
 ld d,0
 ld a,(charSelect)
 dec a
 sla a
 sla a
 ld e,a
 add hl,de		; at correct entry (gauge,state)
 ld (hl),2
 inc hl
 ld (hl),0

 call addAttack

 ld a,0FFh
 ld (itemSelect),a
 xor a
 ld (charSelect),a
 jp battleLoop

; ---
; within Menu
; ---
activateMenuChoice:
 ld a,(cursorPos)
 or a
 jp z,setupItemScreen

 cp 4
 jp c,setupSelectChar

 jp redraw


;-------------
; fix hp - make sure that cur hp <= max hp
;-------------
fixHP:
 call isHPfull
 ret nc

 ld (hl),c
 inc hl
 ld (hl),b
 ret

;--------------
; is hp full
;--------------
; input:
;  hl = cur hp, hl+2 = max hp
; output:
;  carry set if cur >= max
;--------------
isHPfull:
 ld e,(hl)
 inc hl
 ld d,(hl)
 inc hl
 ld c,(hl)
 inc hl
 ld b,(hl)

 ld a,e
 cp c
 ret nc

 ld a,d
 cp b
 ret nc
 
 scf
 ret


;--------------
; find char
;--------------
; input:
;  a - char #.  begins with 0
;--------------
findChar:
 ld hl,char1
 or a 
 ret z
 ld b,a
 ld de,31
findCharLoop:
 add hl,de
 djnz findCharLoop
 ret

;--------------
; Get Item Position
;--------------
; input:
;  a - item #, 0 is first
; destroys b,de
;--------------
getItemPosition:
 ld hl,items
 or a 
 ret z
 ld b,a
 ld de,3
getItemLoop:
 add hl,de
 djnz getItemLoop
 ret


;---------------
; animated cursor
;  5 sprites, 8 stages
;---------------
;
displayCursor:
 ld a,(cursorCount)
 inc a
 ld (cursorCount),a
 srl a
 and 111b
 
 cp 4
 jr c,showCursor

 xor 111b
 inc a

showCursor:
 ld hl,animCursor
 or a
 jr z,drawCursorNOW


 ld de,6
 ld b,a
cursorSpriteLoop:
 add hl,de
 djnz cursorSpriteLoop

drawCursorNOW:

 push hl

 ld a,(cursorPos)
 ld hl,cursorTable
 sla a

 ld d,0
 ld e,a

 add hl,de

 ld e,(hl)
 inc hl
 ld d,(hl)		; location is in de

 pop hl

 ld a,(cursorVideo)
 or a
 jr z,cursorNormVideo

 push de
  ld de,temp
  ld c,6
reverseVideoByte:
  ld a,(hl)
  push de
  ld e,8
  ld d,0
revBYTEloop:
  srl a		; destroy a bit // set carry if it was a ONE
  rl d		; place the bit ONTO a new byte
  dec e
  jr nz,revBYTEloop

  ld a,d
  pop de
  ld (de),a
  inc hl
  inc de
  dec c
  jr nz,reverseVideoByte
  ld hl,temp
 pop de
cursorNormVideo:

 ; display aligned sprite

 jp align6

delay:
 ei
 ld b,7
delayLoop:
 halt
 djnz delayLoop
 ret


;-------------
; Menu 1
;-------------
;  item selection menu
;---------------------

itemMenu:
 ld hl,0
 ld (pencol),hl
 ld hl,itemText
 call _vputs

 ld de,plotsscreen+85		; 7*12+1
 ld hl,plotsscreen+84
 ld (hl),255
 ld bc,11
 ldir				; black line

 ld hl,plotsscreen+103		; 8*12+7
 ld b,55
 ld de,12
execItemLine2:
 ld (hl),1
 add hl,de
 djnz execItemLine2

 ; show the names

 ld hl,256*10+74
 ld (pencol),hl
 ld hl,char1
 call _vputs

 ld hl,256*24+74
 ld (pencol),hl
 ld hl,char2
 call _vputs

 ld hl,256*38+74
 ld (pencol),hl
 ld hl,char3
 call _vputs

 ld hl,256*17+66
 ld (pencol),hl
 ld hl,hp1
 call showHL

 ld hl,256*31+66
 ld (pencol),hl
 ld hl,hp2
 call showHL

 ld hl,256*45+66
 ld (pencol),hl
 ld hl,hp3
 call showHL

 ld hl,items

 ld a,(itemOffset)
 or a
 jr z,noItemOffset
 ld b,a
itemOffsetLoop:
 ld de,3
 add hl,de
 djnz itemOffsetLoop

noItemOffset:
 call showAllItems
 jp returnToRedraw

;-------------
; Menu 2
;-------------
;  Menu Screen - mode from map
;---------------------

menuScreen:

 ; black line at 21 and 42

 ld b,6
 ld de,plotsscreen+265
 ld hl,plotsscreen+517
menuLineLoop1:
 ld (hl),255
 ld a,255
 ld (de),a
 inc hl
 inc de
 djnz menuLineLoop1


 ; character pic, name, and hp/hpmax

 xor a
 ld e,4
 ld hl,royalPic
 call align16

 xor a
 ld e,26
 ld hl,dknightPic
 call align16

 xor a
 ld e,46
 ld hl,sagePic
 call align16

 ld hl,256*2+22
 ld (pencol),hl
 ld hl,char1
 call _vputs

 ld hl,256*8+22
 ld (pencol),hl
 ld hl,lvText
 call _vputs

 ld a,(level1)
 call _setxxop1
 call _dispop1a

 ld hl,256*14+22
 ld (pencol),hl
 ld hl,hp1
 call showHL

 ld a,Lslash
 call _vputmap

 ld hl,hp1+2
 call showHL

 ; char 2

 ld hl,256*23+22
 ld (pencol),hl
 ld hl,char2
 call _vputs

 ld hl,256*29+22
 ld (pencol),hl
 ld hl,lvText
 call _vputs

 ld a,(level2)
 call _setxxop1
 call _dispop1a

 ld hl,256*35+22
 ld (pencol),hl
 ld hl,hp2
 call showHL

 ld a,Lslash
 call _vputmap

 ld hl,hp2+2
 call showHL

 ; char 3

 ld hl,256*44+22
 ld (pencol),hl
 ld hl,char3
 call _vputs

 ld hl,256*50+22
 ld (pencol),hl
 ld hl,lvText
 call _vputs

 ld a,(level3)
 call _setxxop1
 call _dispop1a
 ld hl,256*56+22
 ld (pencol),hl
 ld hl,hp3
 call showHL

 ld a,Lslash
 call _vputmap

 ld hl,hp3+2
 call showHL

 ; actual window for the menu

 ld hl,plotsscreen+139
 ld (hl),11b
 inc hl
 ld (hl),255
 inc hl
 ld (hl),255
 inc hl
 ld (hl),255
 inc hl
 ld (hl),255

 ld hl,plotsscreen+151
 ld b,42
 ld de,8
menuLine2:
 ld a,(hl)
 or 10
 ld (hl),a
 inc hl
 inc hl
 inc hl
 inc hl
 ld (hl),11b
 add hl,de
 djnz menuLine2

 ld (hl),11b
 inc hl
 ld (hl),255
 inc hl
 ld (hl),255
 inc hl
 ld (hl),255
 inc hl
 ld (hl),255

 ld hl,256*14+73
 ld (pencol),hl
 ld hl,menuText1
 call _vputs

 ld hl,256*22+73
 ld (pencol),hl
 ld hl,menuText2
 call _vputs

 ld hl,256*30+73
 ld (pencol),hl
 ld hl,menuText3
 call _vputs

 ld hl,256*38+73
 ld (pencol),hl
 ld hl,menuText4
 call _vputs

 ld hl,256*46+73
 ld (pencol),hl
 ld hl,menuText5
 call _vputs

 ld hl,256*56+68
 ld (pencol),hl
 ld hl,gold
 call showHL

 ld a,Lg
 call _vputmap

 call delay

 jp returnToRedraw

 include "equipmenu.asm"

;-------------
; status screen
;-------------
; cursor pos = char number. 0 being char1
;------------

showStatusScreen:
 call _grbufclr

 ld a,(charSelect)
 call findChar		; hl = start of character

 push hl
 ld de,20
 add hl,de
 ld a,(hl)
 call findCharPic
 xor a
 ld e,0
 call align16
 pop hl

 push hl
 ld hl,22
 ld (pencol),hl
 pop hl

 push hl
 call _vputs

 ld hl,256*6+22
 ld (pencol),hl
 ld hl,lvText
 call _vputs

 pop hl

 push hl
 ld de,12
 add hl,de
 ld a,(hl)
 call _setxxop1
 call _dispop1a

 ld hl,256*12+22
 ld (pencol),hl
 pop hl

 push hl
 ld de,6
 add hl,de
 call showHL

 ld a,Lslash
 call _vputmap
 pop hl

 push hl
 ld de,8
 add hl,de
 call showHL

 ld hl,256*20
 ld (pencol),hl
 ld hl,statusText1
 call _vputs

 ld hl,56
 ld (pencol),hl
 ld hl,statusText0
 call _vputs

 ld hl,256*8+64
 ld (pencol),hl
 pop hl

 push hl
 ld de,10
 add hl,de
 call showHL
 pop hl


 ld de,13
 add hl,de

 ld b,6
 ld c,20
statusLoop1:
 push bc
 push hl
 ld a,c
 ld (penrow),a
 ld a,34
 ld (pencol),a

 ld a,(hl)
 call _setxxop1
 ld a,2
 call _dispop1a

 pop hl
 inc hl
 pop bc
 ld a,c
 add a,6
 ld c,a
 djnz statusLoop1

 ld hl,256*26
 ld (pencol),hl
 ld hl,statusText2
 call _vputs

 ld hl,256*32
 ld (pencol),hl
 ld hl,statusText3
 call _vputs

 ld hl,256*38
 ld (pencol),hl
 ld hl,statusText4
 call _vputs

 ld hl,256*44
 ld (pencol),hl
 ld hl,statusText5
 call _vputs

 ld hl,256*50
 ld (pencol),hl
 ld hl,statusText6
 call _vputs

 B_CALL GrBufCpy

statusLoop:
 call delay

 ld a,0FFh 			;Reset keypad again.
 out (1),a
 ld a,0bfh			;Enable group 2.
 out (1),a 
 in a,(1)
 cp diMode			; any key works
 jp nz,statusLoop

 ld a,0FFh
 ld (itemSelect),a

 jp setupMenuScreen


; show all of the items
showAllItems:
 ld a,9
showAllItemsLoop:
 push af
  call displayItem
  inc hl
 pop af
 
 add a,7
 cp 59
 jr c,showAllItemsLoop
 ret


findCharPic:
 ld hl,dknightPic
 dec a
 ret z

 ld de,32
 ld b,a
findCharPicLoop:
 add hl,de
 djnz findCharPicLoop
 ret

;**********
;* display item
;*  input:
;*   a - y location for item
;*   hl - item
;**********

displayItem:
 ld (penrow),a

 push af
 ld a,(itemXPos)
 srl a
 srl a
 srl a
 ld e,a
 ld d,0
 pop af

 push hl
  ld hl,plotsscreen
  add hl,de
  or a
  jr z,skipDispItemLoop

  ld b,a

  ld de,12
rowMULTloop:
  add hl,de
  djnz rowMULTloop

skipDispItemLoop:
  ex de,hl		; de contains location to display at
 pop hl


 ld a,(itemXPos)
 add a,8
 ld (pencol),a

 ld a,(hl)
 or a
 jr z,showNONEforITEM
 ld b,a
 inc hl
 ld a,(hl)
 or a
 jr z,showNONEforITEM2
 ld a,b
 push hl

  ld hl,itemSprites
  dec a
  jr z,displayItemNow

  ld b,a
findItemSpriteLoop:
  push bc
   ld bc,6
   add hl,bc
  pop bc
  djnz findItemSpriteLoop

displayItemNow:

  call align6

 pop hl

 push hl

  ld e,(hl)
  dec e
  sla e
  ld hl,itemNameVectors
  ld d,0
  add hl,de

  ld e,(hl)
  inc hl
  ld d,(hl)

  ex de,hl

  call _vputs		; display item name

 pop hl

 inc hl

 ld a,(itemXPos)
 cp 48
 ret nc

 push hl
  ld hl,itemSeperator
  call _vputs
 pop hl

 push hl
  ld a,(hl)
  call _setxxop1
  call _dispop1a
 pop hl
 ret

showNONEforITEM:
 inc hl
showNONEforITEM2
 inc hl
 ret



showGaugeFrame:
 push af
 push de
  ld hl,gaugeSprite1
  call sprite
 pop de
 pop af
 add a,8
 push af
 push de
  ld hl,gaugeSprite2
  call sprite
 pop de
 pop af
 add a,8
 ld hl,gaugeSprite3
 jp sprite

;--------------------
;--------------------
; PAINT BATTLE SCREEN
;--------------------
;--------------------
paintBattle:
 ; ready gauge should be 16x3

 ld a,72
 ld e,47
 call showGaugeFrame

 ld a,72
 ld e,53
 call showGaugeFrame

 ld a,72
 ld e,59
 call showGaugeFrame

 ; loop through enemies
 ;  display action if necessary

; db <sprite ID>,<state>,<xPos>,<yPos>
; db <atkPwr>,<defPwr>
; dw <currentHP>,<maxHP>

 ld hl,enemyTable
 ld a,(hl)


showEnemiesLoop:
 ld b,a
 push hl
  ld hl,bird
  dec b
  jr z,skipIncEnemySprite
  ld de,32
findEnemySpriteLoop:
  add hl,de
  djnz findEnemySpriteLoop

skipIncEnemySprite:
  ex de,hl
 pop hl

 inc hl		; state
 inc hl		; xpos
 ld a,(hl)
 inc hl
 ld b,(hl)
 push hl
 ex de,hl
 ld e,b		; ypos
  call align16
 pop hl
 
 ld de,7
 add hl,de
 ld a,(hl)
 or a
 jr nz,showEnemiesLoop

 ; characters blink when hit or ready to attack (menu pops up too)
 ;  enemies blink when hit or attacking

 ; loop through chars
 ;  display action if necessary

 ld hl,battleTable
 ld b,3
 ld c,0
showCharsBattleLoop:
 push bc
 push hl
  call displayChar
 ; display the gauge

 pop hl
 pop bc
 push bc
 push hl
  ld c,48

  ld a,3
  sub b
  ld b,a
  add a,a
  add a,b
  add a,a
  add a,c
  ld c,a
 inc hl
 ld a,(hl)
 srl a
 srl a
 srl a		; a / 8
 ld b,a
 or a
 jr z,skipDispGauge
 ld a,79
dispGaugeLoop:
 push bc
 push af
 ld e,c
 call bar_sprite
 pop af
 inc a
 pop bc
 djnz dispGaugeLoop

skipDispGauge:
 pop hl
 inc hl
 inc hl
 inc hl
 inc hl
 pop bc
 ld a,15
 add a,c
 ld c,a
 djnz showCharsBattleLoop




 ; bottom bar

 ; show the names

 ld hl,256*46+40
 ld (pencol),hl
 ld hl,char1
 call _vputs

 ld hl,256*52+40
 ld (pencol),hl
 ld hl,char2
 call _vputs

 ld hl,256*58+40
 ld (pencol),hl
 ld hl,char3
 call _vputs

 ; show the hp

 ld hl,256*46+60
 ld (pencol),hl
 ld hl,hp1
 call showHL

 ld hl,256*52+60
 ld (pencol),hl
 ld hl,hp2
 call showHL

 ld hl,256*58+60
 ld (pencol),hl
 ld hl,hp3
 call showHL
 ret



showBattleOptions:
 call paintBattle


 ld hl,plotsscreen+481

 ld b,24
boxBattleOps:
 ld (hl),255
 inc hl
 ld (hl),255
 inc hl
 ld (hl),11111000b
 ld de,10
 add hl,de
 djnz boxBattleOps

 set textInverse, (iy+textflags) ; sets inverse.

 ld hl,256*40+10
 ld (pencol),hl
 ld hl,battleText0
 call _vputs

 ld hl,256*46+10
 ld (pencol),hl
 ld hl,battleText1
 call _vputs

 ld hl,256*52+10
 ld (pencol),hl
 ld hl,battleText2
 call _vputs

 ld hl,256*58+10
 ld (pencol),hl
 ld hl,battleText3
 call _vputs

 res textInverse, (iy+textflags) ; resets inverse.

 jp returnToRedraw


showDebugScreen:
 call _grbufclr
 ld hl,savesscreen
 call examine
 call _grbufclr

 ld hl,charSelect
 call examine
 jp redraw

examine:
 ld b,10
 ld c,0
debugLoop:
 push bc
 push hl
 xor a
 ld (pencol),a
 ld a,c
 ld (penrow),a
 ld a,(hl)
 ld l,a
 ld h,0
 call _setxxxxop2
 call _op2toop1
 ld a,3
 call _dispop1a

 pop hl
 pop bc

 inc hl
 push bc
 push hl
 ld a,50
 ld (pencol),a
 ld a,c
 ld (penrow),a
 ld a,(hl)
 ld l,a
 ld h,0
 call _setxxxxop2
 call _op2toop1
 ld a,3
 call _dispop1a

 pop hl
 pop bc
 inc hl
 ld a,6
 add a,c
 ld c,a
 djnz debugLoop

 B_CALL GrBufCpy
 call _getkey
 ret

align6:
 ld b,6
display6Loop:
 push bc
 ldi
 push hl
  ld hl,11
  add hl,de
  ex de,hl
 pop hl
 pop bc
 djnz display6Loop
 ret

align16:
         push    hl              ; Save sprite address

; Calculate the address in graphbuf

         ld      hl,0            ; Do y*12
         ld      d,0
         add     hl,de
         add     hl,de
         add     hl,de
         add     hl,hl
         add     hl,hl

         ld      d,0             ; Do x/8
         ld      e,a
         srl     e
         srl     e
         srl     e
         add     hl,de

         ld      de,plotsscreen
         add     hl,de           ; Add address to graphbuf

	ld b,16    
	pop de

ALOP1:
	ld      a,(de)
        or      (hl)            ; or=erase/blit
        ld      (hl),a

        inc     de
	inc	hl
	ld      a,(de)
        or      (hl)            ; or=erase/blit
        ld      (hl),a

	inc	de
        push    bc
        ld      bc,11
        add     hl,bc
        pop     bc

        djnz    ALOP1    
	ret

; 4x4 sprite
;  in: a=x, e=y, hl= ptr to sprite
sprite:
 push hl		; store Sprite Pointer
 ld d,0
 ld hl,0
 add hl,de
 add hl,de
 add hl,de
 add hl,hl
 add hl,hl		; de * 12
 
 push af
 srl a
 srl a
 srl a			; x/8
 ld e,a
 add hl,de
 ex de,hl
 ld hl,plotsscreen	; 8e29h on 83
 add hl,de		; hl = location we want to paint at
 pop af
 
 and 111b
 or a
 jr z,aligned_sprite

 pop ix
 ld e,a

 ld c,5			; loop 'c' times, for vertical sprite size
spriteNAloop:

 ld b,e			; 'e' - the remainder of a, determines the offset
 ld d,(ix+0)
 xor a
shlop:
 srl d			; right piece
 rr a			; left piece
 djnz shlop

 ld (hl),d		; load the two pieces of the sprite
 inc hl
 ld (hl),a

 push de		; go to next line
  ld de,11
  add hl,de
 pop de

 inc ix

 dec c
 jr nz,spriteNAloop

 ret 
 
aligned_sprite:
 			; hl - pointer to buffer
 pop de			; de - pointer to sprite

 ld b,5			; loops = vertical size of sprite
alop:
 ld a,(de)
 ld (hl),a

 push de
  ld de,12
  add hl,de
 pop de
 inc de
 djnz alop
 ret



bar_sprite:
	ld hl,bar
        push    hl              ; Save sprite address

;   Calculate the address in graphbuf   
 ld d,0
 ld hl,0
 add hl,de
 add hl,de
 add hl,de
 add hl,hl
 add hl,hl		; de * 12


        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,8e29h
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp      0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN3


;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,3             ; Line loop
LILOP3:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP3:  srl     b
        rr      c
        dec     d
        jp      nz,SHLOP3
        pop     de

        ld      a,b             ; Write line to graphbuf
        or     (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        or      (hl)
        ld      (hl),a

        ld      bc,11           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP3        ; Next line

        jp      DONE3


;   Aligned sprite blit starts here   

ALIGN3:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,3
ALOP3:  ld      a,(de)
        or      (hl)            ; xor=erase/blit
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,12
        add     hl,bc
        pop     bc
        djnz    ALOP3

DONE3:
        ret


; 8x8
sprite8:
 push hl		; store Sprite Pointer
 ld d,0
 ld hl,0
 add hl,de
 add hl,de
 add hl,de
 add hl,hl
 add hl,hl		; de * 12
 
 push af
 srl a
 srl a
 srl a			; x/8
 ld e,a
 add hl,de
 ex de,hl
 ld hl,plotsscreen	; 8e29h on 83
 add hl,de		; hl = location we want to paint at
 pop af
 
 and 111b
 or a
 jr z,aligned_sprite2

 pop ix
 ld e,a

 ld c,8			; loop 'c' times, for vertical sprite size
spriteNAloop2:

 ld b,e			; 'e' - the remainder of a, determines the offset
 ld d,(ix+0)
 xor a
shlop2:
 srl d			; right piece
 rr a			; left piece
 djnz shlop2

 push af
 ld a,(hl)
 or d
 ld (hl),d		; load the two pieces of the sprite
 inc hl
 ld b,(hl)
 pop af
 or b
 ld (hl),a

 push de		; go to next line
  ld de,11
  add hl,de
 pop de

 inc ix

 dec c
 jr nz,spriteNAloop2

 ret 
aligned_sprite2:	; hl - pointer to buffer
 pop de			; de - pointer to sprite

 ld b,8			; loops = vertical size of sprite
alop2:
 ld a,(de)
 ld (hl),a

 push de
  ld de,12
  add hl,de
 pop de
 inc de
 djnz alop2
 ret


bar:
 db 10000000b
 db 10000000b
 db 10000000b


items:

; format
;  db <item Type ID>,<item name pointer>,<item quantity>

 db 1,1,1
 db 1,2,4
 db 1,3,4
 db 7,4,2

 db 0,0,0
 db 1,5,1
 db 2,6,1
 db 2,7,2

 db 9,13,3

 db 3,8,3
 db 4,9,1
 db 5,10,7
 db 6,11,5

 db 8,12,2
 db 0,0,0
 db 0,0,0
 db 0,0,0

 db 0,0,0
 db 0,0,0
 db 0,0,0
 db 0,0,0

itemSprites:		; all 6x6

; 1 - potion

 db 01111000b
 db 00110000b
 db 00110000b
 db 01001000b
 db 01001000b
 db 00110000b

; 2 - sword

 db 00001100b
 db 00010100b
 db 00101000b
 db 11010000b
 db 01100000b
 db 10100000b

; 3 - cloth armor

 db 11001100b
 db 11111100b
 db 11111100b
 db 10000100b
 db 01111000b
 db 01111000b

; 4 - big armor

 db 01010000b
 db 10101000b
 db 10101000b
 db 11011000b
 db 10101000b
 db 01010000b

; 5 - shield

 db 11111000b
 db 11011000b
 db 10001000b
 db 11011000b
 db 11011000b
 db 01110000b

; 6 - relic

 db 00111100b
 db 01101100b
 db 10110100b
 db 10111100b
 db 01001000b
 db 00110000b

; 7 - tent

 db 00100000b
 db 00100000b
 db 01110000b
 db 01110000b
 db 11111000b
 db 11011000b

; 8 - helmet

 db 00110000b
 db 01111000b
 db 11001100b
 db 11111100b
 db 10110100b
 db 10000100b

; 9 - rod

 db 00001100b
 db 00001100b
 db 00010000b
 db 00100000b
 db 01000000b
 db 10000000b

animCursor:
 db 11000000b
 db 11110000b
 db 11111100b
 db 11111100b
 db 11110000b
 db 11000000b

 db 0
 db 11100000b
 db 11111100b
 db 11111100b
 db 11100000b
 db 0

 db 0
 db 0
 db 11111100b
 db 11111100b
 db 0
 db 0

 db 0
 db 11100000b
 db 10011100b
 db 10011100b
 db 11100000b
 db 0

 db 11000000b
 db 10110000b
 db 10001100b
 db 10001100b
 db 10110000b
 db 11000000b


itemNameVectors:

;format
; dw <2 byte address>

 dw itemName1
 dw itemName2
 dw itemName3
 dw itemName4
 dw itemName5
 dw itemName10
 dw itemName11
 dw itemName20
 dw itemName30
 dw itemName40
 dw itemName50
 dw itemName60
 dw itemName70

itemSeperator: db ":  ",0

itemName1: db "Potion",0
itemName2: db "X-Potion",0
itemName3: db "Tincture",0
itemName4: db "Tent",0
itemName5: db "Fenix Down",0

itemName10: db "Broadswrd",0
itemName11: db "Katana",0

itemName20: db "Cloth",0

itemName30: db "Plate",0

itemName40: db "Buckler",0

itemName50: db "Iron Ring",0

itemName60: db "Cap",0

itemName70: db "Rod",0

itemText: db "double click to use",0

battleText0: db "Fight",0
battleText1: db "Blitz",0

statusText4:
menuText2:
battleText2: db "Magic",0

menuText1:
battleText3: db "Item",0

menuText3: db "Equip",0
menuText4: db "Status",0
menuText5: db "Save",0

equipText1: db "RHand",0
equipText2: db "LHand",0
equipText3: db "Head",0
equipText4: db "Body",0
equipText5: db "Relic",0

statusText0: db "Next Level",0
statusText1: db "Strength",0
statusText2: db "Speed",0
statusText3: db "Vitality",0

statusText5: db "Hit ",0
statusText6: db "Evade ",0

lvText: db "Lv ",0


; DATA STRUCTURE FOR EACH PARTY MEMBER
;  20 bytes

; 6 byte string
; db <name>,0

; 4 byte hit points
; dw <current HP>,<max HP>

; 3 bytes for total exp, for level up, and level

; dw <exp for level up>
; db <level>

; 1 byte for each attribute

; order:
;  strength, speed, vitality, magic, hit , evade 

; picture, 1 byte

; equipment, 10 bytes (2 bytes for each item)
;  rhand, lhand, head, body, relic

char1: db "Trais",0
hp1: dw 1066,1100
exp1: dw 15255
level1: db 17
attrib1: db 29,14,22,14,77,3,0
pic1: db 3
equip1: db 2,0,5,10,8,0,4,0,6,11

char2: db "Hiro",0,0
hp2: dw 928,1124
exp2: dw 9035
level2: db 19
attrib2: db 24,22,25,19,90,11,0
pic2: db 1
equip2: db 2,7,5,0,8,12,4,9,6,0

char3: db "Zeke",0,0
hp3: dw 722,900
exp3: dw 1033
level3: db 16
attrib3: db 14,26,15,37,65,9,0
pic3: db 2
equip3: db 9,13,0,0,8,12,3,8,6,0

; entry format
; db <atkPwr>,<defPwr>
; dw <maxHP>
enemyStatsTable:

;1 = cockatrice

 db 20,20
 dw 200


gold: dw 9999

weaponSprites:
 db 11000000b
 db 10100000b
 db 01010000b
 db 00101000b
 db 00010110b
 db 00001110b
 db 00001110b
 db 00000001b

swordSprite:
 db 11000000b
 db 10100000b
 db 01010000b
 db 00101000b
 db 00010110b
 db 00001110b
 db 00001110b
 db 00000001b

rodSprite:
 db 11000000b
 db 10100000b
 db 01100000b
 db 00010000b
 db 00001000b
 db 00000100b
 db 00000010b
 db 00000001b

 include "chargrfx.asm"

gaugeSprite1:
 db 1
 db 10
 db 10
 db 10
 db 1

gaugeSprite2:
 db 255
 db 0
 db 0
 db 0
 db 255

gaugeSprite3:
 db 11111110b
 db 00000001b
 db 00000001b
 db 00000001b
 db 11111110b

 include "battle.asm"
 include "battle_utility.asm"
 include "setup.asm"
 include "utility.asm"

.end
END






