waitUntilKEYup:
 ei
 halt

 ld a,0ffh 			;resets the keypad.
 out (1),a			;'Required syntax' :)
 ld a,0bfh 			;Enable group 1.
 out (1),a 			
 in a,(1) 			;'Required Syntax'

 cp 255
 jr nz,waitUntilKEYup
 ret

putsApp:
 ld a,(hl)
 inc hl
 or a
 ret z
 B_CALL PutC
 jr putsApp

vputsApp:
 ld a,(hl)
 inc hl
 or a
 ret z
 push hl
 B_CALL VPutMap
 pop hl
 jr vputsApp

showHL:
 ld e,(hl)
 inc hl
 ld d,(hl)
 ex de,hl
 B_CALL setxxxxop2
 B_CALL op2toop1 
 ld a,5
 B_CALL dispop1a
 ret

getrand:
	 push hl
	 push bc
    push de
     ld hl,(randseed)
     ld   a,l
     ld   e,h
     add  a,h
     ld   h,a
     adc  a,e
     sub  h
     
     ld   de,4476
     add  hl,de
     adc  a,0
     
     ex   de,hl
     ld   l,d
     ld   h,a
     xor  a
     
     add  hl,hl
     adc  a,a
     add  hl,hl
     adc  a,a
     add  hl,hl
     adc  a,a
     
     ld   l,a
     ld   a,h
     add  a,e
     ld   e,a
     ld   a,l
     adc  a,d
     and  01Fh
     
     ld   l,e
     ld   h,a
     ld   (randseed),hl
     pop  de
	  pop bc
	  pop hl
     ret

align16:
         push    hl              ; Save sprite address

; Calculate the address in graphbuf

         ld      hl,0            ; Do y*12
         ld      d,0
         add     hl,de
         add     hl,de
         add     hl,de
         add     hl,hl
         add     hl,hl

         ld      d,0             ; Do x/8
         ld      e,a
         srl     e
         srl     e
         srl     e
         add     hl,de

         ld      de,plotsscreen
         add     hl,de           ; Add address to graphbuf

	ld b,16    
	pop de

ALOP1:
	ld      a,(de)
        or      (hl)            ; or=erase/blit
        ld      (hl),a

        inc     de
	inc	hl
	ld      a,(de)
        or      (hl)            ; or=erase/blit
        ld      (hl),a

	inc	de
        push    bc
        ld      bc,11
        add     hl,bc
        pop     bc

        djnz    ALOP1    
	ret

; 4x4 sprite
;  in: a=x, e=y, hl= ptr to sprite
sprite:
 push hl		; store Sprite Pointer
 ld d,0
 ld hl,0
 add hl,de
 add hl,de
 add hl,de
 add hl,hl
 add hl,hl		; de * 12
 
 push af
 srl a
 srl a
 srl a			; x/8
 ld e,a
 add hl,de
 ex de,hl
 ld hl,plotsscreen	; 8e29h on 83
 add hl,de		; hl = location we want to paint at
 pop af
 
 and 111b
 or a
 jr z,aligned_sprite

 pop ix
 ld e,a

 ld c,5			; loop 'c' times, for vertical sprite size
spriteNAloop:

 ld b,e			; 'e' - the remainder of a, determines the offset
 ld d,(ix+0)
 xor a
shlop:
 srl d			; right piece
 rr a			; left piece
 djnz shlop

 ld (hl),d		; load the two pieces of the sprite
 inc hl
 ld (hl),a

 push de		; go to next line
  ld de,11
  add hl,de
 pop de

 inc ix

 dec c
 jr nz,spriteNAloop

 ret 
 
aligned_sprite:
 			; hl - pointer to buffer
 pop de			; de - pointer to sprite

 ld b,5			; loops = vertical size of sprite
alop:
 ld a,(de)
 ld (hl),a

 push de
  ld de,12
  add hl,de
 pop de
 inc de
 djnz alop
 ret



bar_sprite:
	ld hl,bar
        push    hl              ; Save sprite address

;   Calculate the address in graphbuf   
 ld d,0
 ld hl,0
 add hl,de
 add hl,de
 add hl,de
 add hl,hl
 add hl,hl		; de * 12


        ld      d,0             ; Do x/8
        ld      e,a
        srl     e
        srl     e
        srl     e
        add     hl,de

        ld      de,plotsscreen
        add     hl,de           ; Add address to graphbuf

        ld      b,00000111b     ; Get the remainder of x/8
        and     b
        cp      0               ; Is this sprite aligned to 8*n,y?
        jp      z,ALIGN3


;   Non aligned sprite blit starts here   

        pop     ix              ; ix->sprite
        ld      d,a             ; d=how many bits to shift each line

        ld      e,3             ; Line loop
LILOP3:  ld      b,(ix+0)        ; Get sprite data

        ld      c,0             ; Shift loop
        push    de
SHLOP3:  srl     b
        rr      c
        dec     d
        jp      nz,SHLOP3
        pop     de

        ld      a,b             ; Write line to graphbuf
        or     (hl)
        ld      (hl),a
        inc     hl
        ld      a,c
        or      (hl)
        ld      (hl),a

        ld      bc,11           ; Calculate next line address
        add     hl,bc
        inc     ix              ; Inc spritepointer

        dec     e
        jp      nz,LILOP3        ; Next line

        jp      DONE3


;   Aligned sprite blit starts here   

ALIGN3:                          ; Blit an aligned sprite to graphbuf
        pop     de              ; de->sprite
        ld      b,3
ALOP3:  ld      a,(de)
        or      (hl)            ; xor=erase/blit
        ld      (hl),a
        inc     de
        push    bc
        ld      bc,12
        add     hl,bc
        pop     bc
        djnz    ALOP3

DONE3:
        ret


; 8x8
sprite8:
 push hl		; store Sprite Pointer
 ld d,0
 ld hl,0
 add hl,de
 add hl,de
 add hl,de
 add hl,hl
 add hl,hl		; de * 12
 
 push af
 srl a
 srl a
 srl a			; x/8
 ld e,a
 add hl,de
 ex de,hl
 ld hl,plotsscreen	; 8e29h on 83
 add hl,de		; hl = location we want to paint at
 pop af
 
 and 111b
 or a
 jr z,aligned_sprite2

 pop ix
 ld e,a

 ld c,8			; loop 'c' times, for vertical sprite size
spriteNAloop2:

 ld b,e			; 'e' - the remainder of a, determines the offset
 ld d,(ix+0)
 xor a
shlop2:
 srl d			; right piece
 rr a			; left piece
 djnz shlop2

 push af
 ld a,(hl)
 or d
 ld (hl),d		; load the two pieces of the sprite
 inc hl
 ld b,(hl)
 pop af
 or b
 ld (hl),a

 push de		; go to next line
  ld de,11
  add hl,de
 pop de

 inc ix

 dec c
 jr nz,spriteNAloop2

 ret 
aligned_sprite2:	; hl - pointer to buffer
 pop de			; de - pointer to sprite

 ld b,8			; loops = vertical size of sprite
alop2:
 ld a,(de)
 ld (hl),a

 push de
  ld de,12
  add hl,de
 pop de
 inc de
 djnz alop2
 ret
