; order:
;------------
;------------
; WIN BATTLE
;------------
;------------
winBattle:

 ; paint a cheering animation
 ;  WHEN: ??? 

 call paintBattle

 ; show experience, gold won, etc.
 ;  WHEN: ???


 ld hl,56*256+10
 ld (pencol),hl
 ld hl,winBattle_str1
 call vputsApp

 B_CALL GrBufCpy

 B_CALL GetKey
 jp exit

winBattle_str1: .asciz "You won the battle!"

;  strength, speed, vitality, magic, hit %, evade %
; picture, 1 byte
; equipment, 10 bytes (2 bytes for each item)
;  rhand, lhand, head, body, relic
setupAP:
 ld a,(hl)
 ld de,12
 add hl,de
 ld b,(hl)
 add a,b
 ret

;-------------------
; Battle - SELECTION
;-------------------
;  F I G H T
;---------------
fightSelected:
 ld hl,battleTable	; reset their gauge and turn on the fight state
 ld d,0
 ld a,(charSelect)
 dec a
 sla a
 sla a
 ld e,a
 add hl,de		; at correct entry (gauge,state)
 ld (hl),2
 inc hl
 ld (hl),0

 call addAttack

 ; reset selection
 ld a,0FFh
 ld (itemSelect),a
 xor a
 ld (charSelect),a
 jp battleLoop

addAttack:
 ld hl,attackQueue

 ; go to end of queue
addAttackLoop:
 ld a,(HL)
 or a
 jr z,exitAddAttackLoop
 INC HL
 INC HL
 INC HL
 INC HL
 jr addAttackLoop

exitAddAttackLoop:
 ld a,(attackState)	; itemSelection
 ld (hl),a
 inc hl
 ld a,(charSelect)
 ld (hl),a
 inc hl
 ld a,(cursorPos)	; currentChar
 ld (hl),a
 ld a,(itemUseClass)
 ld (hl),a
 inc hl
 ret

; entry format
; .db <sprite ID>,<state>,<xPos>,<yPos>
; .db <atkPwr>,<defPwr>
; .dw <curHP>,<maxHP>

;--------------
; add an enemy to the battle
;--------------
; in: d = x-coord
;     e = y-coord
;     b = enemy id
;    hl = table start
;--------------
addEnemy:
 ld (hl),b
 inc hl
 ld (hl),0
 inc hl
 ld (hl),d
 inc hl
 ld (hl),e
 inc hl

 push hl
  ld hl,enemyStatsTable
  dec b
  jr z,skipEnemyLookupTableLoop

  ld de,4
enemyLookupTableLoop:
  add hl,de
  djnz enemyLookupTableLoop

skipEnemyLookupTableLoop:
  ex de,hl
 pop hl				; de is location to read from
 ex de,hl
 ld bc,4
 ldir
 dec hl
 dec hl
 ld bc,2
 ldir
 ret

dequeueAttack:
 ld hl,attackQueue+4
 ld de,attackQueue
 ld bc,60
 ldir
 ret

setupAttack:
; this is where the hit occurs on the enemy!

 push bc
  ld a,(attackQueue+2)

  ; now we access that enemy's data
  call getEnemyNumberA
;  call inspectENEMY

; .db <sprite ID>,<state>,<xPos>,<yPos>
; .db <atkPwr>,<defPwr>
; .dw <currentHP>,<maxHP>
  inc hl
  inc hl
  ld a,(hl)
  add a,6
  ld (victimHPx),a
  inc hl
  ld a,(hl)
  ld (victimHPy),a
  inc hl
  inc hl

  ld a,3		; for finding your character
  sub b

  ld b,(hl)

  push af
  push hl
   ld (attackerChar),a
   sla a
   sla a
   ld h,0
   ld l,a
   ld de,battleTable
   add hl,de
   inc hl
   inc hl
   ld a,(hl)

   call findHPlost		; (a= your AP, b= enemy DP) => bc = enemy HP lost
  pop hl
  pop af

  inc hl
  ld e,(hl)
  inc hl
  ld d,(hl)	; load current Hit Points

  push hl
   xor a
   ex de,hl

   sbc hl,bc
   jr nc,enemyNotDead


   ; enemy dies
   ; remove him from table

  pop hl

  dec de
  dec de
  dec de
  dec de
  dec de
  dec de
  dec de
  inc hl
  inc hl
  inc hl
  ld bc,50
  ldir

  ld hl,enemiesKilled
  inc (hl)
  jr cleanUpAttack

enemyNotDead:
   ex de,hl
  pop hl
  ld (hl),d
  dec hl
  ld (hl),e
cleanUpAttack:
  call dequeueAttack
 pop bc
 ret

findHPlost:
 ; a = attack, b=defense

 ; hp inflicted = f(a,b)
 ; f(255,10) <= 65000
 ; f(255,255) = 9999
 ; f(100,100) = 999
 ; f(25,25) = 99
 ; f(10,255) >= 10

 ;-------
 ; f(a,b) = C*(a^2/b)
 ;-------
 ; c = 4
 ;------

 push bc
  ld b,a
  ld hl,0
  ld d,0
  ld e,a
squareItLoop:
  add hl,de
  djnz squareItLoop
 pop bc

 
 ld e,b
 ld d,0
 call DIV_HL_DE_S

 ld c,70
 call getrand
 and 111b
 add a,c
 ld c,a
 ld b,0
 add hl,bc
 ld (victimHPlost),hl
 ld b,h
 ld c,l
 ret

getEnemyNumberA:
 ld hl,0
 ld e,a
 ld d,0
 add hl,de
 add hl,hl
 add hl,hl
 add hl,de
 add hl,hl
 ld de,enemyTable
 add hl,de
 ret

inspectENEMY:
 push hl
  xor a
  ld (curcol),a
  ld (currow),a
 pop hl
 push hl
  ld de,6
  add hl,de
  ld e,(hl)
  inc hl
  ld d,(hl)
  ex de,hl
  call _disphl
 pop hl
 push hl
  ld de,8
  add hl,de
  ld e,(hl)
  inc hl
  ld d,(hl)
  ex de,hl
  call _disphl
  call _getkey
 pop hl
 ret

;----------------------------------------------------------------------------
;[ DIV_HL_DE_S ] by Hideaki Omuro
; optimized for size
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;system:
; standard z80
;version:
; 2000.Jan.22.t
;size:
; 44 bytes
;time:
; 968-1128 clocks
;comments:
; This routine is actually pretty big, but it'll be bigger if i unroll it :P
; If I come up with a better design, then i'll redo this one too...
;
; Divides Int/Int -> Int, Fix/Fix -> Int, or Fix/Int -> Fix
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;parameters:
; HL = 16-bit dividend, DE = 16-bit divisor
;returns:
; HL = 16-bit quotient, DE = 16-bit remainder
;modifies:
; ABCDEFHL
;----------------------------------------------------------------------------
DIV_HL_DE_S:
   XOR   A                             ; negate divisor
   SUB   E
   LD    E, A
   SBC   A, A
   SUB   D
   LD    D, A

   LD    A, H                          ; A = top 8-bits of dividend
   LD    C, L                          ; C = low 8-bits of dividend
   LD    HL, 0                         ; DE = divisor, quotient = 0

   LD    B, 8                          ; 8 loops (half of 16 bits)
   RLA                                 ; 24-bit shift
_CDHLDE_divloop1:
   ADC   HL, HL
   ADD   HL, DE                        ; compare with divisor
   JR    C, _CDHLDE_noadd1             ; if divisor is smaller
   SBC   HL, DE                        ; restore result
_CDHLDE_noadd1:
   RLA                                 ; 24-bit shift
   DJNZ  _CDHLDE_divloop1

   LD    B, A                          ; C = top 8-bits of current result
   LD    A, C                          ; A = low 8-bits of dividend
   LD    C, B

   LD    B, 8                          ; 8 loops (half of 16 bits)
   RLA                                 ; 24-bit shift
_CDHLDE_divloop2:
   ADC   HL, HL
   ADD   HL, DE                        ; compare with divisor
   JR    C, _CDHLDE_noadd2             ; if divisor is smaller
   SBC   HL, DE                        ; restore result
_CDHLDE_noadd2:
   RLA                                 ; 24-bit shift
   DJNZ  _CDHLDE_divloop2

   EX    DE, HL                        ; DE = remainder
   LD    H, C                          ; HL = quotient
   LD    L, A

   RET
