;--------------------
;--------------------
; PAINT BATTLE SCREEN
;--------------------
;--------------------
paintBattle:

 ; show the outline on the ready gauge for each party member
 ; inside of gauge is 16x3

 ld a,72
 ld e,47
 call showGaugeOutline

 ld a,72
 ld e,53
 call showGaugeOutline

 ld a,72
 ld e,59
 call showGaugeOutline

 ; loop through enemies
 ;  display action if necessary

; db <sprite ID>,<state>,<xPos>,<yPos>
; db <atkPwr>,<defPwr>
; dw <currentHP>,<maxHP>

 ld hl,enemyTable
 ld a,(hl)


showEnemiesLoop:
 ld b,a
 push hl
  ld hl,bird
  dec b
  jr z,skipIncEnemySprite
  ld de,32
findEnemySpriteLoop:
  add hl,de
  djnz findEnemySpriteLoop

skipIncEnemySprite:
  ex de,hl
 pop hl

 inc hl		; state
 inc hl		; xpos
 ld a,(hl)
 inc hl
 ld b,(hl)
 push hl
 ex de,hl
 ld e,b		; ypos
  call align16
 pop hl
 
 ld de,7
 add hl,de
 ld a,(hl)
 or a
 jr nz,showEnemiesLoop

 ; characters blink when hit or ready to attack (menu pops up too)
 ;  enemies blink when hit or attacking

 ; loop through chars
 ;  display action if necessary

 ld hl,battleTable
 ld b,3
 ld c,0
showCharsBattleLoop:
 push bc
 push hl
  call displayChar
 pop hl
 pop bc

  ; display the gauge
 push bc
 push hl
  ld c,48

  ld a,3
  sub b
  ld b,a
  add a,a
  add a,b
  add a,a
  add a,c
  ld c,a
 inc hl

 ld a,(hl)
 srl a
 srl a
 srl a
 ld b,a
 or a
 jr z,skipDispGauge

 ld a,79
dispGaugeLoop:
 push bc
 push af
 ld e,c
 call bar_sprite
 pop af
 inc a
 pop bc
 djnz dispGaugeLoop

skipDispGauge:
 pop hl
 inc hl
 inc hl
 inc hl
 inc hl
 pop bc	; end display gauge


 ld a,15
 add a,c
 ld c,a
 djnz showCharsBattleLoop

 ; bottom bar

 ; show the names

 ld hl,256*46+40
 ld (pencol),hl
 ld hl,char1
 call vputsApp

 ld hl,256*52+40
 ld (pencol),hl
 ld hl,char2
 call vputsApp

 ld hl,256*58+40
 ld (pencol),hl
 ld hl,char3
 call vputsApp

 ; show the hp

 ld hl,256*46+60
 ld (pencol),hl
 ld hl,hp1
 call showHL

 ld hl,256*52+60
 ld (pencol),hl
 ld hl,hp2
 call showHL

 ld hl,256*58+60
 ld (pencol),hl
 ld hl,hp3
 call showHL
 ret



showBattleOptions:
 call paintBattle

 ld hl,plotsscreen+481

 ld b,24
boxBattleOps:
 ld (hl),255
 inc hl
 ld (hl),255
 inc hl
 ld (hl),11111000b
 ld de,10
 add hl,de
 djnz boxBattleOps

 set textInverse, (iy+textflags) ; sets inverse.

 ld hl,256*40+10
 ld (pencol),hl
 ld hl,battleText0
 call vputsApp

 ld hl,256*46+10
 ld (pencol),hl
 ld hl,battleText1
 call vputsApp

 ld hl,256*52+10
 ld (pencol),hl
 ld hl,battleText2
 call vputsApp

 ld hl,256*58+10
 ld (pencol),hl
 ld hl,battleText3
 call vputsApp

 res textInverse, (iy+textflags) ; resets inverse.

 jp returnToRedraw

 
findCharPic:
 ld hl,dknightPic
 dec a
 ret z

 ld de,32
 ld b,a
findCharPicLoop:
 add hl,de
 djnz findCharPicLoop
 ret


showGaugeOutline:
 push af
 push de
  ld hl,gaugeSprite1
  call sprite
 pop de
 pop af
 add a,8
 push af
 push de
  ld hl,gaugeSprite2
  call sprite
 pop de
 pop af
 add a,8
 ld hl,gaugeSprite3
 jp sprite
