; terry peng gave me this idea a long time ago.
;  a long time ago being 1998, when i started zelda 83

collide_up:
 call getYourPosition
 call collide_detect
 ret c
collide_vert:
 push hl
 ld a,(x)
 call divby12
 ld a,h
 pop hl
 or a
 ret z			; aligned?
 inc hl
 call collide_detect
 ret

collide_down:
 ld a,(y)
 add a,10
 ld (y),a
 jr collide_up

collide_left:
 call getYourPosition
 call collide_detect
 ret c
collide_horiz:
 push hl
 ld a,(y)
 dec a
 dec a
 call divby12
 ld a,h
 pop hl
 or a
 ret z			; aligned?

 call addNextColumn
 call collide_detect
 ret

collide_right:
 ld a,(x)
 add a,10
 ld (x),a
 jr collide_left

collide_detect:
 ld a,(hl)
 cp 9
 jr z,mapActionDOOR
 cp 17
 jr z,mapActionDOOR
 cp 2
 jr c,no_collision

 scf
 ret

no_collision:
 xor a
 ret

mapActionDOOR:

 ld ix,switchMapTable
scanSwitchMapTable:
 ld a,(ix)
 or a
 jr z,noMapMatch
 ld e,a

 inc ix
 ld d,(ix)
 inc ix

 B_CALL cphlde
 jr z,switchMapMatch

 inc ix
 inc ix
 inc ix
 inc ix
 inc ix
 inc ix
 inc ix
 jr scanSwitchMapTable

switchMapMatch:
 ld e,(ix)
 ld d,(ix+1)
 ld a,(ix+2)
 ld (mapX),a
 ld a,(ix+3)
 ld (mapY),a
 ld a,(ix+4)
 ld (charX),a
 ld a,(ix+5)
 ld (charY),a
 ld a,(ix+6)
 ld (mapWidth),a
 ex de,hl
 ld (mapStart),hl
noMapMatch:
 scf
 ret

getYourPosition:
 call adjustMap
 push hl
  call mapPosDE
 pop hl
 add hl,de
 ret

addNextColumn:
 ld a,(mapWidth)
 ld e,a
 ld d,0
 add hl,de
 ret

; UTILITY

mapPosDE:
 ld de,0

 ld a,(y)
 sub 2					; offset by 2
 ; divide by 12
 call divby12
 or a
 jr z,skipMapPosDE

  ; multiply it by (# columns)
 ld b,a
 ld a,(mapWidth)
 ld e,a
 ld d,0
 ld hl,0
mapPosDELoop:
 add hl,de
 djnz mapPosDELoop

 ex de,hl

skipMapPosDE:
 push de
  ld a,(x)
  ; divide it by 12
  call divby12
  ld d,0
  ex de,hl
 pop de
 add hl,de
 ex de,hl
 ret

divby12:
 ld h,a
 ld l,12
 call divhbyl
 ld a,e
 ret

; h is the bigger number
; output: E = quotient, H = remainder

divhbyl:
 ld b,7
 ld c,10000000b
 ld e,0
divide_bit_loop:
 push bc

 ld d,h
shift_H:
  sra d
  djnz shift_H

  ld a,d
  sub l
  jr c,skip_Quotient_Add

  ; shift it back to norm

 pop bc
 push bc

  ld d,l
shift_H_back:
  sla d
  djnz shift_H_back

  ld a,h
  sub d
  ld h,a

  ld a,e
  add a,c
  ld e,a

skip_Quotient_Add:
 pop bc
; call showProgress

 xor a
 rr c
 djnz divide_bit_loop

 ld a,h
 sub l
 ret c

 ld h,a
 inc e
 ret


