;-------------
; Menu 3
;-------------
; equip screen
;-------------
equipScreen:
 call drawEquipScreen
 call delay
 jp returnToRedraw


;-------------
; Menu 4
;-------------
; equip new item
;-------------
equipNewItemScreen:
 call drawEquipScreen

 ; draw list of items.
 ;     ident those that are unusable.

 ld a,(itemOffset)
 call getItemPosition

 ld a,32
EquipNewItemLoop:
 push af
  ld a,8
  ld (itemXPos),a
  ld a,(hl)
  ld b,a
  ld a,(itemUseClass)
  cp b
  jr z,skipIdentEquipItem

  ld a,24
  ld (itemXPos),a

skipIdentEquipItem:
 pop af
 push af
  call displayItem
  inc hl
 pop af
 
 add a,6
 cp 57
 jr c,EquipNewItemLoop

 call delay
 jp returnToRedraw

;------------
; draw the equip screen
;------------
; equipment top
;------------
drawEquipScreen:
 ld a,(charSelect)
 call findChar		; hl = start of character

 push hl
 ld de,20
 add hl,de
 ld a,(hl)
 call findCharPic
 xor a
 ld e,0
 call align16

 ld hl,256*22
 ld (pencol),hl
 pop hl

 push hl
  call vputsApp
 pop hl

 ld a,48
 ld (itemXPos),a

 ld de,21
 add hl,de
 xor a
 ld b,5
showEquippedItems:
 push bc
  push af
   call displayItem
returnFromNoEquippedItem:
  pop af
  add a,6
 pop bc
 djnz showEquippedItems

 ld hl,25
 ld (pencol),hl
 ld hl,equipText1
 call vputsApp

 ld hl,256*6+25
 ld (pencol),hl
 ld hl,equipText2
 call vputsApp

 ld hl,256*12+25
 ld (pencol),hl
 ld hl,equipText3
 call vputsApp

 ld hl,256*18+25
 ld (pencol),hl
 ld hl,equipText4
 call vputsApp

 ld hl,256*24+25
 ld (pencol),hl
 ld hl,equipText5
 call vputsApp

 ld b,12
 ld hl,plotsscreen+372
equipMidLine:
 ld (hl),255
 inc hl
 djnz equipMidLine
 ret